/*************************************************************************
 *
 *  $RCSfile: imapmbox.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/01/31 15:32:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTWIDS_HRC
#include <svtools/cntwids.hrc>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif

#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTMMITM_HXX
#include <cntmmitm.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef CHAOS_FLSTITEM_HXX
#include <flstitem.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CHAOS_IMAP_HXX
#include <imap.hxx>
#endif
#ifndef CHAOS_IMAPMITM_HXX
#include <imapmitm.hxx>
#endif
#ifndef _LAYITEM_HXX
#include <layitem.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _CHAOS_STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _THRDITEM_HXX
#include <thrditem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif

#ifndef CHAOS_IMAPACNT_HXX
#include <imapacnt.hxx>
#endif
#ifndef CHAOS_IMAPMBOX_HXX
#include <imapmbox.hxx>
#endif
#ifndef CHAOS_IMAPMBXT_HXX
#include <imapmbxt.hxx>
#endif
#ifndef CHAOS_IMAPMESG_HXX
#include <imapmesg.hxx>
#endif
#ifndef CHAOS_IMAPSTOR_HXX
#include <imapstor.hxx>
#endif
#ifndef CHAOS_IMAPURL_HXX
#include <imapurl.hxx>
#endif

namespace unnamed_chaos_imapmbox {} using namespace unnamed_chaos_imapmbox;
	// unnamed namespaces don't work well yet...

using namespace chaos;

SV_IMPL_REF(CntStoreItemSet)

//============================================================================
namespace unnamed_chaos_imapmbox {

enum { UNKNOWN_S_MESG_COUNT = 0xFFFFFFFF };

//============================================================================
USHORT const aCntIMAPMboxNodeRanges[]
	= { WID_TITLE, WID_TITLE,
		WID_DEFAULT, WID_COPY,
		WID_RENAME, WID_UPDATE,
		WID_THREADING, WID_IMAP_READ_MESG_COUNT,
			// i.e., ..., WID_SEENCONTENTCOUNT
		WID_AUTOUPDATE_INTERVAL, WID_UPDATE_ENABLED,
		WID_NEWS_GROUPLIST, WID_MESSAGE_STOREMODE,
		WID_UNDELETE, WID_UNDELETE,
		WID_SHOW_MSGS_HAS_TIMELIMIT, WID_SHOW_MSGS_TIMELIMIT,
		WID_PROPERTYLIST, WID_PROPERTYLIST,
		WID_SEARCH, WID_SEARCH,
		WID_TRANSFER, WID_TRANSFER,
		WID_IMAP_MARKED_MESG_COUNT, WID_IMAP_MBOX_COUNT,
			// i.e., WID_MARKED_DOCUMENT_COUNT, WID_FOLDER_COUNT
		WID_VIEW_START, WID_VIEW_END,
		WID_FLAG_UPDATE_ON_OPEN, WID_FLAG_UPDATE_ON_OPEN,
		WID_SET_AS_DEFAULT, WID_CHILD_DEFAULTS,
		WID_FOLDER_START2, WID_FOLDER_END2,
		WID_VIEW3_START, WID_VIEW3_END, 0 };

//============================================================================
USHORT const aCntIMAPMboxDirSetRanges[]
	= { WID_IMAP_L_MESG_COUNT, WID_IMAP_L_MESG_COUNT,
			// i.e., WID_FACTORY_HELP_ID, WID_FACTORY_HELP_ID
		WID_IMAP_SSCRBD_MBOX_COUNT, WID_IMAP_SSCRBD_MBOX_COUNT,
			// i.e., WID_SUBSCRNEWSGROUPCOUNT, WID_SUBSCRNEWSGROUPCOUNT
		WID_IMAP_S_MESG_COUNT, WID_IMAP_LS_MESG_COUNT,
			// i.e., WID_NEWSGROUPCOUNT, WID_ARTICLECOUNT
		WID_IMAPFOLDERINFO, WID_IMAPFOLDERINFO,
		WID_IMAP_READ_MESG_COUNT, WID_IMAP_READ_MESG_COUNT,
			// i.e., WID_SEENCONTENTCOUNT, WID_SEENCONTENTCOUNT
		WID_IMAP_LSD_MESG_COUNT, WID_IMAP_LSD_MESG_COUNT,
			// i.e., WID_DOCUMENT_SIZE, WID_DOCUMENT_SIZE
		WID_IMAP_MARKED_MESG_COUNT, WID_IMAP_MBOX_COUNT, 0 };
			// i.e., WID_MARKED_DOCUMENT_COUNT, WID_FOLDER_COUNT

}

//============================================================================
//
//  CntIMAPMboxNode
//
//============================================================================

CNT_NODE_SUBCLASS_IMPL(CntIMAPMboxNode)
{
	InsertFactory(new CntNodeFactory(
		                  String::CreateFromAscii(
							  RTL_CONSTASCII_STRINGPARAM(
								  ";" CNT_IMAP_URL_UIDVALIDITY_PREFIX "*/;"
								      CNT_IMAP_URL_UID_PREFIX "*")),
						  String(), TYPE(CntIMAPMesgNode),
						  CONTENT_TYPE_X_CNT_MESSAGE,
						  CNT_CREATION_FLAG_MESSAGEDOC
						      | CNT_CREATION_FLAG_SENDMESSAGE
							  | CNT_CREATION_FLAG_KIND_DOCUMENT,
						  HID_CHAOS_NEW_IMAP_MSG));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM(
											 ";" CNT_IMAP_URL_UID_PREFIX
											     "*")),
									 String(), TYPE(CntIMAPMesgNode),
									 CONTENT_TYPE_X_CNT_MESSAGE,
									 CNT_CREATION_FLAG_MESSAGEDOC
									     | CNT_CREATION_FLAG_HIDDEN
										 | CNT_CREATION_FLAG_KIND_DOCUMENT,
									 HID_CHAOS_NEW_IMAP_MSG));
	InsertFactory(new CntNodeFactory(String::CreateFromAscii(
		                                 RTL_CONSTASCII_STRINGPARAM("/*")),
									 String::CreateFromAscii(
										 RTL_CONSTASCII_STRINGPARAM("/;")),
									 TYPE(CntIMAPMboxNode),
									 CONTENT_TYPE_X_CNT_IMAPFOLDER,
									 CNT_CREATION_FLAG_TITLE
										| CNT_CREATION_FLAG_KIND_FOLDER,
									 HID_CHAOS_NEW_IMAP_FLD));
}

//============================================================================
CntIMAPMboxNode::CntIMAPMboxNode():
	CntIMAPFldrNode(aCntIMAPMboxNodeRanges, new CntIMAPMbox(*this))
{
	CntDefaults * pDefaults = GetDefaults();
	if (!pDefaults)
	{
		pDefaults = new CntDefaults(*this, aCntIMAPMboxNodeRanges);

		pDefaults->Put(CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT, 0));

		pDefaults->Put(CntContentTypeItem(WID_CONTENT_TYPE,
										  CONTENT_TYPE_X_CNT_IMAPFOLDER));

		pDefaults->Put(CntBoolItem(WID_FLAG_IS_FOLDER, true));
		pDefaults->Put(CntBoolItem(WID_FLAG_HAS_FOLDER, true));
		pDefaults->Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, true));

		pDefaults->Put(CntUShortListItem(WID_RENAME, WID_TITLE, 0));

		CntViewColumnsListItem aColumns(WID_VIEW_COLS_BEAMER,
								   WID_FROM, DEF_WIDTH_FROM,
								   WID_TITLE, DEF_WIDTH_TITLE_MAIL,
								   WID_DATE_CREATED, DEF_WIDTH_DATE_CREATED,
								   WID_DOCUMENT_SIZE, DEF_WIDTH_DOCUMENT_SIZE,
								   WID_IS_MARKED, DEF_WIDTH_IS_MARKED,
								   WID_IS_READ, DEF_WIDTH_IS_READ, 0);
		pDefaults->Put(aColumns);
		aColumns.SetWhich(WID_VIEW_COLS_FILEDLG);
		pDefaults->Put(aColumns);
		aColumns.SetWhich(WID_VIEW_COLS_FLDWIN);
		pDefaults->Put(aColumns);

		CntSortingItem aSorting(WID_SORTING);
		aSorting.Append(CntSortingInfo(WID_DATE_CREATED, false));
		aSorting.Append(CntSortingInfo(WID_TITLE, true));
		aSorting.Append(CntSortingInfo(WID_FROM, true));
		aSorting.Append(CntSortingInfo(WID_DOCUMENT_SIZE, true));
		aSorting.Append(CntSortingInfo(WID_IS_MARKED, true));
		aSorting.Append(CntSortingInfo(WID_IS_READ, false));
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_BEAMER);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FILEDLG);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FLDWIN_DETAILS);
		pDefaults->Put(aSorting);
		aSorting.SetWhich(WID_VIEW_SORT_FLDWIN_ICON);
		pDefaults->Put(aSorting);

		CntThreadingItem aThreading(WID_THREADING);
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PARENTCHAIN,
										   WID_FLAG_IS_MESSAGE,
										   WID_IN_REPLY_TO, WID_MESSAGE_ID,
										   '<', WID_TITLE));
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PARENTCHAIN,
										   WID_FLAG_IS_MESSAGE,
										   WID_REFERENCES, WID_MESSAGE_ID,
										   '<', WID_TITLE));
		aThreading.Append(CntThreadingInfo(CNT_THREADING_BY_PROPVALUE,
										   WID_FLAG_IS_MESSAGE, WID_TITLE,
										   WID_TITLE));
		pDefaults->Put(aThreading);

		pDefaults->Put(CntLayoutItem(WID_VIEW_LAYOUT_FLDWIN,
									 LAYOUT_MAILNEWS));

		pDefaults->Put(CntIdentifierListItem(WID_PROPERTYLIST,
										 CNT_TABPAGE_GENERAL,
										 CNT_TABPAGE_RULES,
										 CNT_TABPAGE_SUBSCRIBE,
										 CNT_TABPAGE_VIEW_PROPERTIES,
										 CNT_TABPAGE_HEADER,
										 CNT_TABPAGE_CONTENT_PROPERTIES,
										 CNT_TABPAGE_BACKGROUND,
										 CNT_TABPAGE_FONT, 0));
	}
	CntInterface::SetParent(pDefaults);
}

//============================================================================
TYPEINIT1_AUTOFACTORY(CntIMAPMboxNode, CntIMAPFldrNode)

//============================================================================
// virtual
FASTBOOL CntIMAPMboxNode::IsItemFlag(USHORT nWhich, USHORT nFlag) const
{
	if (nFlag == CNT_ITEM_SYNCHRON)
		switch (nWhich)
		{
			case WID_TITLE:
				return false;
		}
	return CntIMAPFldrNode::IsItemFlag(nWhich, nFlag);
}

//============================================================================
// virtual
void CntIMAPMboxNode::GetOwnURL(String & rURL)
{
	// Skip the parent folder URL prefix and a possibly following "/", and cut
	// before the first following "/" or ";", or at the end:
	xub_StrLen nPos = 0;
	CntNode * pParentFldrNode = GetParent();
	if (pParentFldrNode)
	{
		String aParentFldrURL(OWN_URL(pParentFldrNode));
		if (aParentFldrURL.Len() != 0
			&& aParentFldrURL.Match(rURL) == STRING_MATCH)
		{
			static sal_Unicode const aDelimiters[] = { '/', ';', '\0' };
			nPos = rURL.SearchChar(aDelimiters,
								   rURL.Len() > aParentFldrURL.Len()
								   && rURL.GetChar(aParentFldrURL.Len())
								          == '/' ?
								       aParentFldrURL.Len() + 1 :
								       aParentFldrURL.Len());
			if (nPos == STRING_NOTFOUND)
				nPos = rURL.Len();
		}
	}
	rURL.Erase(nPos);
}

//============================================================================
// virtual
const SfxPoolItem * CntIMAPMboxNode::InsertJob(CntNodeJob * pJob)
{
	getMbox().initialize(*pJob);
	if (pJob->GetSubject() == this)
		switch (pJob->GetRequest()->Which())
		{
			case WID_PUTDATA:
			{
				CntNodeJobRef xTheJob(pJob);
				const CntItemListItem & rList
					= *static_cast< const CntItemListItem * >(
						   pJob->GetRequest());

				{for (USHORT i = 0; i < rList.Count();)
				{
					const SfxPoolItem & rItem = rList[i];
					if (rItem.Which() == WID_TITLE)
					{
						CntNodeJob * pSubJob
							= new CntNodeJob(pJob, pJob->GetClient(), this,
											 rItem);
						const_cast< CntItemListItem & >(rList).Remove(i);
						InsertJob(pSubJob);
						if (pJob->IsCanceled() || pJob->IsDone())
							return 0;
					}
					else
						++i;
				}}

				for (USHORT i = 0; i < rList.Count();)
				{
					const SfxPoolItem & rItem = rList[i];
					if (rItem.Which() == WID_NEWS_GROUPLIST)
					{
						InsertJob(new CntNodeJob(pJob, pJob->GetClient(),
												 this, rItem));
						const_cast< CntItemListItem & >(rList).Remove(i);
					}
					else
						++i;
				}

				return CntIMAPFldrNode::InsertJob(pJob);
			}

			case WID_TITLE:
			case WID_OPEN:
			case WID_SEARCH:
			case WID_UPDATE:
			case WID_SYNCHRONIZE:
			case WID_NEWS_GROUPLIST:
			case WID_CREATE_NEW:
			case WID_INSERT:
			case WID_TRANSFER:
			case WID_DELETE:
			case WID_UNDELETE:
			case WID_IS_READ:
			case WID_IS_MARKED:
			case WID_FLAG_SUBSCRIBED:
			case WID_MESSAGEVIEW_MODE:
			case WID_FOLDERVIEW_MODE:
			case WID_FLAG_UPDATE_ON_OPEN:
				return GetRootNode()->InsertJob(pJob);

			case WID_MESSAGE_STOREMODE:
				if (ITEM_VALUE(CntMsgStoreModeItem, *pJob->GetRequest())
					    == THIS_ITEM_VALUE(CntMsgStoreModeItem,
										   WID_MESSAGE_STOREMODE))
				{
					pJob->Done();
					return 0;
				}
				if (pJob->IsMakePersist())
					getMbox().storeProperty(*pJob, *pJob->GetRequest());
				else
					Put(*pJob->GetRequest());
				return (new CntIMAPMboxStoreMesgBodiesTask(
					            *pJob,
								static_cast< CntIMAPAcntNode * >(
									    GetRootNode())->
								    getAcnt()))->
					       run();
		}
	else
	{
		DBG_ASSERT(pJob->GetSubject()->ISA(CntIMAPMesgNode),
				   "CntIMAPMboxNode::InsertJob(): Bad subject");
		CntIMAPMesgNode * pMesgNode
			= static_cast< CntIMAPMesgNode * >(pJob->GetSubject());
		pMesgNode->initialize(*pJob);
		switch (pJob->GetRequest()->Which())
		{
			case WID_OPEN:
				if (pMesgNode->getBody(*pJob))
				{
					if ( pMesgNode->isDeleted() )
						pJob->Cancel();
					else
						pJob->Done();
					return 0;
				}
				else
					return GetRootNode()->InsertJob(pJob);

			case WID_EXPORT:
			case WID_DELETE:
			case WID_UNDELETE:
			case WID_IS_READ:
			case WID_IS_MARKED:
				return GetRootNode()->InsertJob(pJob);

			case WID_MESSAGE_STOREMODE:
				pMesgNode->setKeepBodyFlag(*pJob, true);
				pJob->Done();
				return 0;

			case WID_ACTION_LIST:
				pMesgNode->storeProperty(*pJob, *pJob->GetRequest());
				pJob->Done();
				return 0;
		}
	}
	return CntIMAPFldrNode::InsertJob(pJob);
}

//============================================================================
// virtual
const SfxPoolItem * CntIMAPMboxNode::ExecuteJob(CntNodeJob * pJob)
{
	if (pJob->GetRequestData())
		return (static_cast< CntIMAPTask * >(pJob->GetRequestData()))->run();
	return CntIMAPFldrNode::ExecuteJob(pJob);
}

//============================================================================
//
//  CntIMAPMbox
//
//============================================================================

CntIMAPMbox & CntIMAPMbox::getRootMbox()
{
	for (CntIMAPMbox * pMbox = this;;)
	{
		CntIMAPFldr & rParentFldr = pMbox->getParentFldr();
		if (rParentFldr.ISA(CntIMAPAcnt))
			return *pMbox;
		pMbox = static_cast< CntIMAPMbox * >(&rParentFldr);
	}
}

//============================================================================
void CntIMAPMbox::setInferiors(bool bOn)
{
	const SfxPoolItem * pMboxCount;
	getNode().Put(CntBoolItem(WID_FLAG_HAS_FOLDER,
							  bOn
							  && (getNode().GetItemState(WID_IMAP_MBOX_COUNT,
														 false, &pMboxCount)
								   != SFX_ITEM_SET
								  || ITEM_VALUE(CntUInt32Item, *pMboxCount)
								      > 0)));
	if (bOn)
	{
		getNode().Put(CntIdentifierListItem(WID_PROPERTYLIST,
										CNT_TABPAGE_GENERAL,
										CNT_TABPAGE_RULES,
										CNT_TABPAGE_SUBSCRIBE,
										CNT_TABPAGE_VIEW_PROPERTIES,
										CNT_TABPAGE_HEADER,
										CNT_TABPAGE_CONTENT_PROPERTIES,
										CNT_TABPAGE_BACKGROUND,
										CNT_TABPAGE_FONT, 0));
		getNode().ClearItem(WID_CREATE_NEW);
	}
	else
	{
		getNode().Put(CntIdentifierListItem(WID_PROPERTYLIST,
										CNT_TABPAGE_GENERAL,
										CNT_TABPAGE_RULES,
										CNT_TABPAGE_VIEW_PROPERTIES,
										CNT_TABPAGE_HEADER,
										CNT_TABPAGE_CONTENT_PROPERTIES,
										CNT_TABPAGE_BACKGROUND,
										CNT_TABPAGE_FONT, 0));
		getNode().
		 Put(getAcnt().
			  getMboxNoInferiorsFactoryList(*getNode().GetDefaults()));
	}
}

//============================================================================
void CntIMAPMbox::setSelect(CntNodeJob & rJob, bool bOn)
{
	getNode().Put(CntBoolItem(WID_FLAG_HAS_MESSAGES, bOn));
	if (bOn)
		setReadMarkedFlags(rJob, true, true);
	else
	{
		getNode().DisableItem(WID_IS_READ);
		getNode().DisableItem(WID_IS_MARKED);
	}
}

//============================================================================
void CntIMAPMbox::setReadMarkedFlags(CntNodeJob & rJob, bool bReadFlag,
									 bool bMarkedFlag)
{
	if (!(bReadFlag || bMarkedFlag))
		return;

	const SfxPoolItem * pMesgCount;
	sal_uInt32 nMesgCount;
	if (getNode().GetItemState(WID_IMAP_MESG_COUNT, false, &pMesgCount)
		 == SFX_ITEM_SET)
		nMesgCount = ITEM_VALUE(CntUInt32Item, *pMesgCount);
	else
		pMesgCount = 0;

	bool bStoreZeroReadMesgCount = false;
	bool bStoreZeroMarkedMesgCount = false;

	if (bReadFlag)
	{
		bool bHasReadMesgCount = false;
		sal_uInt32 nReadMesgCount;
		if (pMesgCount)
		{
			const SfxPoolItem * pItem;
			if (getNode().GetItemState(WID_IMAP_READ_MESG_COUNT, false,
									   &pItem)
			     == SFX_ITEM_SET)
			{
				bHasReadMesgCount = true;
				nReadMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			}
			else if (!nMesgCount)
			{
				bHasReadMesgCount = true;
				nReadMesgCount = 0;
				bStoreZeroReadMesgCount = true;
				getNode().Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT, 0));
			}
		}
		if (bHasReadMesgCount)
			getNode().Put(CntBoolItem(WID_IS_READ,
									  nReadMesgCount >= nMesgCount));
		else
			getNode().ClearItem(WID_IS_READ);
	}

	if (bMarkedFlag)
	{
		bool bHasMarkedMesgCount = false;
		sal_uInt32 nMarkedMesgCount;
		if (pMesgCount)
		{
			const SfxPoolItem * pItem;
			if (getNode().GetItemState(WID_IMAP_MARKED_MESG_COUNT, false,
									   &pItem)
			     == SFX_ITEM_SET)
			{
				bHasMarkedMesgCount = true;
				nMarkedMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			}
			else if (!nMesgCount)
			{
				bHasMarkedMesgCount = true;
				nMarkedMesgCount = 0;
				bStoreZeroMarkedMesgCount = true;
				getNode().Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT, 0));
			}
		}
		if (bHasMarkedMesgCount)
			getNode().Put(CntBoolItem(WID_IS_MARKED,
									  nMesgCount
									  && nMarkedMesgCount >= nMesgCount));
		else
			getNode().ClearItem(WID_IS_MARKED);
	}

	if (bStoreZeroReadMesgCount || bStoreZeroMarkedMesgCount)
	{
		CntNodeRef xParentDirNode(getParentFldr().getDirNode(rJob));
		if (xParentDirNode.Is())
		{
			CntStoreItemSetRef xMboxDirSet
				= static_cast< CntStorageNode * >(&xParentDirNode)->
				      openItemSet(aCntIMAPMboxDirSetRanges,
								  OWN_URL(&getNode()),
								  STREAM_STD_WRITE | STREAM_NOCREATE);
			if (xMboxDirSet.Is())
			{
				if (bStoreZeroReadMesgCount)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT,
												   0));
				if (bStoreZeroMarkedMesgCount)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
												   0));
			}
		}

	}
}

//============================================================================
TYPEINIT1(CntIMAPMbox, CntIMAPFldr)

//============================================================================
CntIMAPMbox::CntIMAPMbox(CntIMAPMboxNode & rMboxNode):
	CntIMAPFldr(rMboxNode),
	m_nLMesgCount(0),
	m_nSMesgCount(UNKNOWN_S_MESG_COUNT),
	m_nLSMesgCount(0),
	m_nLSDMesgCount(0),
	m_bDeleted(false),
	m_bInheritedKeepBodiesFlag(false)
{}

//============================================================================
// virtual
CntIMAPMbox::~CntIMAPMbox()
{
	getAcnt().notifyMboxDestruction(*this);
}

//============================================================================
const CntIMAPMboxNode & CntIMAPMbox::getNode() const
{
	return *static_cast< const CntIMAPMboxNode * >(&CntIMAPFldr::getNode());
}

//============================================================================
CntIMAPMboxNode & CntIMAPMbox::getNode()
{
	return *static_cast< CntIMAPMboxNode * >(&CntIMAPFldr::getNode());
}

//============================================================================
CntIMAPFldr & CntIMAPMbox::getParentFldr()
{
	return static_cast< CntIMAPFldrNode * >(getNode().GetParent())->getFldr();
}

//============================================================================
CntIMAPAcnt & CntIMAPMbox::getAcnt()
{
	return *static_cast< CntIMAPAcnt * >(&getRootMbox().getParentFldr());
}

//============================================================================
bool CntIMAPMbox::initialize(CntNodeJob & rJob, bool bCreate,
							 const INetIMAPListResponseMailbox * pData,
							 bool bSubscribed, bool bFlagNew,
							 bool * pSubscribedChanged)
{
	if (isInitialized() && !bCreate)
		return false;
	bool bWasInitialized;
	{
		vos::OGuard aGuard(getMutex());
		bWasInitialized = isInitialized();
		if (bWasInitialized && !bCreate)
			return false;
		setInitialized();
	}

	String aMboxURL(OWN_URL(&getNode()));

	// Hack to get rid of trailing slash not removed by
	// CntIMAPURL::makeCanonicURL() (see there):
	if (!bWasInitialized && aMboxURL.Len() != 0
		&& aMboxURL.GetChar(aMboxURL.Len() - 1) == '/')
	{
		aMboxURL.Erase(aMboxURL.Len() - 1);
		getNode().Put(CntStringItem(WID_OWN_URL, aMboxURL));
	}

	if (!bWasInitialized)
		getNode().Put(CntStringItem(WID_TITLE,
									CntIMAPUTF7::translateFromUTF7(
										CntIMAPURL::getMboxLiteralLastName(
											aMboxURL),
										false)));

	CntNodeRef xParentDirNode = getParentFldr().getDirNode(rJob);

	sal_uInt32 nMboxDirAttribs = 0;
	sal_uInt32 nMboxDirAttribsSet = 0;
	sal_uInt32 nMboxDirAttribsClear = 0;
	bool bMboxDirSetPresent
		= xParentDirNode.Is()
		  && static_cast< CntStorageNode * >(&xParentDirNode)->
		             attrib(aMboxURL, 0, 0, nMboxDirAttribs)
		         != ERRCODE_IO_NOTEXISTS;

	if (!bMboxDirSetPresent)
	{
		if (!bCreate)
			return false;

		nMboxDirAttribsSet |= CNTDIRENTRY_ATTRIB_IMAP_MBOX;
	}

	CntNode * pParentNode = getNode().GetParent();
	if (pParentNode->ISA(CntIMAPMboxNode))
		static_cast< CntIMAPMboxNode * >(pParentNode)->
			getMbox().initialize(rJob, !bMboxDirSetPresent && bCreate, 0,
								 false, bFlagNew);
	else
		static_cast< CntIMAPAcntNode * >(pParentNode)->
			getAcnt().initialize(rJob);

	m_bDeleted = (nMboxDirAttribs & CNTDIRENTRY_ATTRIB_MARKEDFORDELETE) != 0;

	// Renaming a mailbox can cause subscribed sub mailboxes to have
	// subscribed nodes but no storage.  Once storages are no longer deleted
	// across a rename, the first part of the following disjunction can go:
	bool bAlreadySubscribed
		= !bMboxDirSetPresent
		      && ITEMSET_VALUE(&getNode(), CntBoolItem, WID_FLAG_SUBSCRIBED)
		  || nMboxDirAttribs & CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD;
	bSubscribed = bAlreadySubscribed
		          || bCreate && !isDeleted() && bSubscribed;
	if (bSubscribed)
		nMboxDirAttribsSet |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD;
	getNode().Put(CntBoolItem(WID_FLAG_SUBSCRIBED, bSubscribed));
	if (pSubscribedChanged)
		*pSubscribedChanged = bAlreadySubscribed != bSubscribed;

	if (bCreate && !isDeleted())
	{
		if (!bMboxDirSetPresent && bFlagNew)
			nMboxDirAttribsSet |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_NEW;
		nMboxDirAttribsClear |= CNTDIRENTRY_ATTRIB_IMAP_MBOX_REMOVED;
	}

	if (bCreate && !isDeleted() && !bMboxDirSetPresent)
		getParentFldr().changeMboxCounts(rJob, COUNT_INC,
										 bSubscribed ? COUNT_INC :
										               COUNT_STAY);

	CntStoreItemSetRef xMboxDirSet;
	if (xParentDirNode.Is())
		xMboxDirSet = static_cast< CntStorageNode * >(&xParentDirNode)->
			              openItemSet(aCntIMAPMboxDirSetRanges, aMboxURL,
									  bCreate ? STREAM_STD_READWRITE :
									            STREAM_STD_READ);

	if (xParentDirNode.Is()
		&& (nMboxDirAttribs & ~nMboxDirAttribsClear | nMboxDirAttribsSet)
		       != nMboxDirAttribs)
		static_cast< CntStorageNode * >(&xParentDirNode)->
			attrib(aMboxURL, nMboxDirAttribsClear, nMboxDirAttribsSet);

	const SfxPoolItem * pMboxData;
	if (!xMboxDirSet.Is()
		|| xMboxDirSet->GetItemState(WID_IMAPFOLDERINFO, false, &pMboxData)
		       != SFX_ITEM_SET)
		pMboxData = 0;
	if (bCreate && !isDeleted() && pData)
	{
		CntIMAPMboxDataItem aNewMboxData = WID_IMAPFOLDERINFO;
		if (pMboxData)
			aNewMboxData = *pMboxData;
		aNewMboxData.
			setData(!(pData->getFlags()
					      & INetIMAPListResponseMailbox::FLAG_NOINFERIORS),
					!(pData->getFlags()
					      & INetIMAPListResponseMailbox::FLAG_NOSELECT),
					pData->getHierarchySeparator());
		getNode().Put(aNewMboxData);
		if (xMboxDirSet.Is())
			xMboxDirSet->Put(aNewMboxData);
		pMboxData = &getNode().Get(WID_IMAPFOLDERINFO);
	}
	else if (pMboxData)
		getNode().Put(*pMboxData);

	if (xMboxDirSet.Is())
	{
		if (bMboxDirSetPresent)
		{
			const SfxPoolItem * pItem;
			if (xMboxDirSet->GetItemState(WID_IMAP_MBOX_COUNT, false, &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_SSCRBD_MBOX_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_L_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				m_nLMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_S_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				m_nSMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_LS_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				m_nLSMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_LSD_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				m_nLSDMesgCount = ITEM_VALUE(CntUInt32Item, *pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_READ_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
			if (xMboxDirSet->GetItemState(WID_IMAP_MARKED_MESG_COUNT, false,
										  &pItem)
				    == SFX_ITEM_SET)
				getNode().Put(*pItem);
		}
		else
		{
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_L_MESG_COUNT,
										   m_nLMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LS_MESG_COUNT,
										   m_nLSMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LSD_MESG_COUNT,
										   m_nLSDMesgCount));
		}

		xMboxDirSet = 0;
	}

	CntNodeRef xMboxDirNode = getDirNode(rJob);
	if (xMboxDirNode.Is())
		getNode().Put(xMboxDirNode->Get(WID_DELETE_ON_SERVER));

	const SfxPoolItem * pStoreMode;
	if (xMboxDirNode.Is()
		&& xMboxDirNode->GetItemState(WID_MESSAGE_STOREMODE, false,
									  &pStoreMode)
		       == SFX_ITEM_SET)
	{
		getNode().Put(*pStoreMode);
		m_bInheritedKeepBodiesFlag = false;
	}
	else
	{
		getNode().Put(getNode().GetParent()->Get(WID_MESSAGE_STOREMODE));
		m_bInheritedKeepBodiesFlag = true;
	}

	sal_uInt32 nMesgCount = m_nLMesgCount + m_nLSMesgCount;
	if (m_nSMesgCount == UNKNOWN_S_MESG_COUNT)
		getNode().ClearItem(WID_IMAP_MESG_COUNT);
	else
	{
		nMesgCount += m_nSMesgCount;
		getNode().Put(CntUInt32Item(WID_IMAP_MESG_COUNT, nMesgCount));
	}

	if (!bWasInitialized || pData)
	{
		bool bHasMboxData
			= pMboxData
			  && static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
			         hasData();
		const SfxPoolItem * pMboxCount;
		setInferiors(!bHasMboxData
					 || static_cast< const CntIMAPMboxDataItem * >(
						        pMboxData)->
					        getFlagInferiors()
					 || getNode().GetItemState(WID_IMAP_MBOX_COUNT, false,
											   &pMboxCount)
					        == SFX_ITEM_SET
					    && ITEM_VALUE(CntUInt32Item, *pMboxCount) != 0);
		setSelect(rJob,
				  !bHasMboxData
				  || static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
				         getFlagSelect()
				  || nMesgCount != 0);
	}

	if (!bWasInitialized)
	{
		if (CntIMAPURL::isInboxURL(aMboxURL))
		{
			getNode().Put(CntUShortListItem(WID_RENAME));
			getNode().DisableItem(WID_DELETE);
			getNode().DisableItem(WID_UNDELETE);
		}

		getAcnt().notifyMboxConstruction(*this);
	}

	return !bMboxDirSetPresent;
}

//============================================================================
bool CntIMAPMbox::getInferiors() const
{
	const SfxPoolItem * pMboxData;
	return getNode().GetItemState(WID_IMAPFOLDERINFO, false, &pMboxData)
		       != SFX_ITEM_SET
	       || !static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
		           hasData()
	       || static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
		          getFlagInferiors();
}

//============================================================================
bool CntIMAPMbox::getSelect() const
{
	const SfxPoolItem * pMboxData;
	return getNode().GetItemState(WID_IMAPFOLDERINFO, false, &pMboxData)
		       != SFX_ITEM_SET
	       || !static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
		           hasData()
	       || static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
		          getFlagSelect();
}

//============================================================================
bool CntIMAPMbox::hasDeterminedHierarchySeparator(sal_Char &
												      rHierarchySeparator)
{
	CntIMAPMbox & rRootMbox = getRootMbox();
	const SfxPoolItem * pMboxData;
	if (rRootMbox.getNode().GetItemState(WID_IMAPFOLDERINFO, false,
										 &pMboxData)
		    == SFX_ITEM_SET
		&& static_cast< const CntIMAPMboxDataItem * >(pMboxData)->hasData())
	{
		rHierarchySeparator
			= static_cast< const CntIMAPMboxDataItem * >(pMboxData)->
		          getHierarchySeparator();
		return true;
	}
	else
		return false;
}

//============================================================================
void CntIMAPMbox::setHierarchySeparator(CntNodeJob & rJob,
										bool bRootMboxFlagInferiors,
										bool bRootMboxFlagSelect,
										sal_Char cHierarchySeparator)
{
	CntIMAPMbox & rRootMbox = getRootMbox();
	CntIMAPMboxDataItem aMboxData
		= static_cast< const CntIMAPMboxDataItem & >(
			  rRootMbox.getNode().Get(WID_IMAPFOLDERINFO));
	aMboxData.setData(bRootMboxFlagInferiors, bRootMboxFlagSelect,
					  cHierarchySeparator);
	rRootMbox.storeProperty(rJob, aMboxData);
}

//============================================================================
void CntIMAPMbox::storeProperty(CntNodeJob & rJob, const SfxPoolItem & rItem)
{
	switch (rItem.Which())
	{
		case WID_MESSAGE_STOREMODE:
		{
			getNode().Put(rItem);

			CntNodeRef xMboxDirNode(getDirNode(rJob));
			if (xMboxDirNode.Is())
				xMboxDirNode->Put(rItem);

			m_bInheritedKeepBodiesFlag = false;
			break;
		}

		case WID_IMAP_MBOX_COUNT:
			if (ITEM_VALUE(CntUInt32Item, rItem) == 0)
				getNode().Put(CntBoolItem(WID_FLAG_HAS_FOLDER, false));
		case WID_IMAPFOLDERINFO:
		case WID_IMAP_SSCRBD_MBOX_COUNT:
		{
			getNode().Put(rItem);

			CntNodeRef xParentDirNode(getParentFldr().getDirNode(rJob));
			if (xParentDirNode.Is())
			{
				CntStoreItemSetRef xMboxDirSet
					= static_cast< CntStorageNode * >(&xParentDirNode)->
					      openItemSet(aCntIMAPMboxDirSetRanges,
									  OWN_URL(&getNode()),
									  STREAM_STD_WRITE | STREAM_NOCREATE);
				if (xMboxDirSet.Is())
					xMboxDirSet->Put(rItem);
			}
			break;
		}

		case WID_IMAP_READ_MESG_COUNT:
		case WID_IMAP_MARKED_MESG_COUNT:
		{
			getNode().Put(rItem);

			CntNodeRef xParentDirNode(getParentFldr().getDirNode(rJob));
			if (xParentDirNode.Is())
			{
				CntStoreItemSetRef xMboxDirSet
					= static_cast< CntStorageNode * >(&xParentDirNode)->
					      openItemSet(aCntIMAPMboxDirSetRanges,
									  OWN_URL(&getNode()),
									  STREAM_STD_WRITE | STREAM_NOCREATE);
				if (xMboxDirSet.Is())
					xMboxDirSet->Put(rItem);
			}

			setReadMarkedFlags(rJob,
							   rItem.Which() == WID_IMAP_READ_MESG_COUNT,
							   rItem.Which() == WID_IMAP_MARKED_MESG_COUNT);
			break;
		}

		case WID_FLAG_SUBSCRIBED:
		{
			bool bSubscribe = ITEM_VALUE(CntBoolItem, rItem) != false;

			DBG_ASSERT(bSubscribe
					       != (ITEMSET_VALUE(&getNode(), CntBoolItem,
											 WID_FLAG_SUBSCRIBED)
							       != false),
					   "CntIMAPMbox::storeProperty(): Invalid item");

			getNode().Put(rItem);

			CntNodeRef xParentDirNode(getParentFldr().getDirNode(rJob));
			if (xParentDirNode.Is())
				static_cast< CntStorageNode * >(&xParentDirNode)->
					attrib(OWN_URL(&getNode()),
						   bSubscribe ? 0 :
						                CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD,
						   bSubscribe ? CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD :
						                0);

			getParentFldr().changeMboxCounts(rJob, CntIMAPFldr::COUNT_STAY,
											 bSubscribe ?
											  CntIMAPFldr::COUNT_INC :
											  CntIMAPFldr::COUNT_DEC);

			if (bSubscribe)
				getParentFldr().getNode().
				 Broadcast(CntNodeHint(&getNode(), CNT_ACTION_INSERTED, &rJob));
			break;
		}

		default:
			DBG_ERROR("CntIMAPMbox::store(): Invalid item");
			break;
	}
}

//============================================================================
// virtual
CntStorageNode * CntIMAPMbox::getDirNode(CntNodeJob & rJob)
{
	return rJob.GetSubject() == &getNode()
		   && (!rJob.GetClient()->ISA(CntAnchor)
			   || static_cast< CntAnchor * >(rJob.GetClient())->
			              GetNode()->GetMostReferedNode()
			          == rJob.GetSubject()) ?
		       rJob.GetDirectoryNode() : getDirNode(OWN_URL(&getNode()));
}

//============================================================================
// static
CntStorageNode * CntIMAPMbox::getDirNode(const String & rMboxURL)
{
	String aMboxDirURL(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(
		                                           STG_PROTOCOL_CACHE)));
	aMboxDirURL += rMboxURL;
	return CntStorageNode::StorageFileExists(aMboxDirURL) ?
		       static_cast< CntStorageNode * >(CntRootNodeMgr::Get()->
											       Query(aMboxDirURL)) :
		       0;
}

//============================================================================
// virtual
void CntIMAPMbox::changeMboxCounts(CntNodeJob & rJob,
								   CountChange eMboxCountChange,
								   CountChange eSubscribedMboxCountChange)
{
	if (eMboxCountChange == COUNT_STAY
		&& eSubscribedMboxCountChange == COUNT_STAY)
		return;

	sal_uInt32 nMboxCount;
	if (eMboxCountChange != COUNT_STAY)
		nMboxCount = ITEMSET_VALUE(&getNode(), CntUInt32Item,
								   WID_IMAP_MBOX_COUNT);
	sal_uInt32 nSubscribedMboxCount;
	if (eSubscribedMboxCountChange != COUNT_STAY)
		nSubscribedMboxCount = ITEMSET_VALUE(&getNode(), CntUInt32Item,
											 WID_IMAP_SSCRBD_MBOX_COUNT);

	bool bMboxCountChanged;
	switch (eMboxCountChange)
	{
		case COUNT_DEC:
			bMboxCountChanged = nMboxCount != 0;
			if (bMboxCountChanged)
				--nMboxCount;
			break;

		case COUNT_STAY:
			bMboxCountChanged = false;
			break;

		case COUNT_INC:
			bMboxCountChanged = true;
			++nMboxCount;
	}
	bool bSubscribedMboxCountChanged;
	switch (eSubscribedMboxCountChange)
	{
		case COUNT_DEC:
			bSubscribedMboxCountChanged = nSubscribedMboxCount != 0;
			if (bSubscribedMboxCountChanged)
				--nSubscribedMboxCount;
			break;

		case COUNT_STAY:
			bSubscribedMboxCountChanged = false;
			break;

		case COUNT_INC:
			bSubscribedMboxCountChanged = true;
			++nSubscribedMboxCount;
	}

	if (bMboxCountChanged)
		storeProperty(rJob, CntUInt32Item(WID_IMAP_MBOX_COUNT, nMboxCount));
	if (bSubscribedMboxCountChanged)
		storeProperty(rJob, CntUInt32Item(WID_IMAP_SSCRBD_MBOX_COUNT,
										  nSubscribedMboxCount));

	if (bMboxCountChanged)
		switch (nMboxCount)
		{
			case 0:
				if (!getInferiors())
					setInferiors(false);
				break;

			case 1:
				setInferiors(true);
				break;
		}
}

//============================================================================
sal_uInt32 CntIMAPMbox::setServerMesgCount(CntNodeJob & rJob,
										   sal_uInt32 nServerMesgCount)
{
	sal_uInt32 nLocalAndServerMesgCount = m_nLSMesgCount + m_nLSDMesgCount;
	if (m_nSMesgCount != UNKNOWN_S_MESG_COUNT
		&& nServerMesgCount == m_nSMesgCount + nLocalAndServerMesgCount)
		return 0;

	sal_uInt32 nOldSMesgCount = m_nSMesgCount;
	m_nSMesgCount = nServerMesgCount > nLocalAndServerMesgCount ?
		                nServerMesgCount - nLocalAndServerMesgCount : 0;

	CntNodeRef xParentDirNode = getParentFldr().getDirNode(rJob);
	if (xParentDirNode.Is())
	{
		String aMboxDirID = OWN_URL(&getNode());
		static_cast< CntStorageNode * >(&xParentDirNode)->
			attrib(aMboxDirID, CNTDIRENTRY_ATTRIB_IMAP_MBOX_MESGS, 0);
		CntStoreItemSetRef xMboxDirSet
			= static_cast< CntStorageNode * >(&xParentDirNode)->
			      openItemSet(aCntIMAPMboxDirSetRanges, aMboxDirID,
							  STREAM_STD_WRITE | STREAM_NOCREATE);
		if (xMboxDirSet.Is())
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_S_MESG_COUNT,
										   m_nSMesgCount));
	}
	getNode().Put(CntUInt32Item(WID_IMAP_MESG_COUNT,
								m_nLMesgCount + m_nSMesgCount
								    + m_nLSMesgCount));
	setReadMarkedFlags(rJob, true, true);

	return m_nSMesgCount >= nOldSMesgCount ? m_nSMesgCount - nOldSMesgCount :
		   nOldSMesgCount == UNKNOWN_S_MESG_COUNT ? UNKNOWN_S_MESG_COUNT : 0;
}

//============================================================================
void CntIMAPMbox::setMesgCounts(CntNodeJob & rJob, sal_uInt32 nTheLMesgCount,
								sal_uInt32 nTheSMesgCount,
								sal_uInt32 nTheLSMesgCount,
								sal_uInt32 nTheLSDMesgCount,
								sal_uInt32 nReadMesgCount,
								sal_uInt32 nMarkedMesgCount)
{
	m_nLMesgCount = nTheLMesgCount;
	m_nSMesgCount = nTheSMesgCount;
	m_nLSMesgCount = nTheLSMesgCount;
	m_nLSDMesgCount = nTheLSDMesgCount;

	sal_uInt32 nMesgCount = m_nLMesgCount + m_nSMesgCount + m_nLSMesgCount;
	getNode().Put(CntUInt32Item(WID_IMAP_MESG_COUNT, nMesgCount));
	getNode().Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT, nReadMesgCount));
	getNode().Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
								nMarkedMesgCount));

	getNode().Put(CntBoolItem(WID_IS_READ, nReadMesgCount >= nMesgCount));
	getNode().Put(CntBoolItem(WID_IS_MARKED,
							  nMesgCount && nMarkedMesgCount >= nMesgCount));

	CntNodeRef xParentDirNode(getParentFldr().getDirNode(rJob));
	if (xParentDirNode.Is())
	{
		CntStoreItemSetRef xMboxDirSet
			= static_cast< CntStorageNode * >(&xParentDirNode)->
			      openItemSet(aCntIMAPMboxDirSetRanges, OWN_URL(&getNode()),
							  STREAM_STD_WRITE | STREAM_NOCREATE);
		if (xMboxDirSet.Is())
		{
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_L_MESG_COUNT,
										   m_nLMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_S_MESG_COUNT,
										   m_nSMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LS_MESG_COUNT,
										   m_nLSMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LSD_MESG_COUNT,
										   m_nLSDMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT,
										   nReadMesgCount));
			xMboxDirSet->Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
										   nMarkedMesgCount));
		}
	}
}

//============================================================================
void CntIMAPMbox::changeMesgCounts(CntNodeJob & rJob,
								   CountChange eLMesgCountChange,
								   CountChange eSMesgCountChange,
								   CountChange eLSMesgCountChange,
								   CountChange eLSDMesgCountChange,
								   CountChange eReadMesgCountChange,
								   CountChange eMarkedMesgCountChange)
{
	bool bMesgCountChange
		= eLMesgCountChange != COUNT_STAY || eSMesgCountChange != COUNT_STAY
		  || eLSMesgCountChange != COUNT_STAY;

	if (!bMesgCountChange && eLSDMesgCountChange == COUNT_STAY
		&& eReadMesgCountChange == COUNT_STAY
		&& eMarkedMesgCountChange == COUNT_STAY)
		return;

	switch (eLMesgCountChange)
	{
		case COUNT_DEC:
			if (m_nLMesgCount != 0)
				--m_nLMesgCount;
			break;

		case COUNT_INC:
			++m_nLMesgCount;
			break;
	}

	sal_uInt32 nTheSMesgCount
		= m_nSMesgCount == UNKNOWN_S_MESG_COUNT ? 0 : m_nSMesgCount;
	switch (eSMesgCountChange)
	{
		case COUNT_DEC:
			if (nTheSMesgCount != 0)
				--nTheSMesgCount;
			m_nSMesgCount = nTheSMesgCount;
			break;

		case COUNT_INC:
			++nTheSMesgCount;
			m_nSMesgCount = nTheSMesgCount;
			break;
	}

	switch (eLSMesgCountChange)
	{
		case COUNT_DEC:
			if (m_nLSMesgCount != 0)
				--m_nLSMesgCount;
			break;

		case COUNT_INC:
			++m_nLSMesgCount;
			break;
	}

	sal_uInt32 nMesgCount = m_nLMesgCount + nTheSMesgCount + m_nLSMesgCount;
	if (m_nSMesgCount != UNKNOWN_S_MESG_COUNT)
		getNode().Put(CntUInt32Item(WID_IMAP_MESG_COUNT, nMesgCount));

	switch (eLSDMesgCountChange)
	{
		case COUNT_DEC:
			if (m_nLSDMesgCount != 0)
				--m_nLSDMesgCount;
			break;

		case COUNT_INC:
			++m_nLSDMesgCount;
			break;
	}

	sal_uInt32 nReadMesgCount;
	if (bMesgCountChange || eReadMesgCountChange != COUNT_STAY)
	{
		nReadMesgCount = ITEMSET_VALUE(&getNode(), CntUInt32Item,
									   WID_IMAP_READ_MESG_COUNT);
		switch (eReadMesgCountChange)
		{
			case COUNT_DEC:
				if (nReadMesgCount != 0)
					--nReadMesgCount;
				getNode().Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT,
											nReadMesgCount));
				break;

			case COUNT_INC:
				getNode().Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT,
											++nReadMesgCount));
				break;
		}

		getNode().Put(CntBoolItem(WID_IS_READ, nReadMesgCount >= nMesgCount));
	}

	sal_uInt32 nMarkedMesgCount;
	if (bMesgCountChange || eMarkedMesgCountChange != COUNT_STAY)
	{
		nMarkedMesgCount = ITEMSET_VALUE(&getNode(), CntUInt32Item,
										 WID_IMAP_MARKED_MESG_COUNT);
		switch (eMarkedMesgCountChange)
		{
			case COUNT_DEC:
				if (nMarkedMesgCount != 0)
					--nMarkedMesgCount;
				getNode().Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
											nMarkedMesgCount));
				break;

			case COUNT_INC:
				getNode().Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
											++nMarkedMesgCount));
				break;
		}

		getNode().Put(CntBoolItem(WID_IS_MARKED,
								  nMesgCount != 0
								  && nMarkedMesgCount >= nMesgCount));
	}

	if (bMesgCountChange || eLSDMesgCountChange != COUNT_STAY
		|| eReadMesgCountChange != COUNT_STAY
		|| eMarkedMesgCountChange != COUNT_STAY)
	{
		CntNodeRef xParentDirNode = getParentFldr().getDirNode(rJob);
		if (xParentDirNode.Is())
		{
			CntStoreItemSetRef xMboxDirSet
				= static_cast< CntStorageNode * >(&xParentDirNode)->
				      openItemSet(aCntIMAPMboxDirSetRanges,
								  OWN_URL(&getNode()),
								  STREAM_STD_WRITE | STREAM_NOCREATE);
			if (xMboxDirSet.Is())
			{
				if (eLMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_L_MESG_COUNT,
												   m_nLMesgCount));
				if (eSMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_S_MESG_COUNT,
												   m_nSMesgCount));
				if (eLSMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LS_MESG_COUNT,
												   m_nLSMesgCount));
				if (eLSDMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_LSD_MESG_COUNT,
												   m_nLSDMesgCount));
				if (eReadMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_READ_MESG_COUNT,
												   nReadMesgCount));
				if (eMarkedMesgCountChange != COUNT_STAY)
					xMboxDirSet->Put(CntUInt32Item(WID_IMAP_MARKED_MESG_COUNT,
												   nMarkedMesgCount));
			}
		}
	}
}

//============================================================================
void CntIMAPMbox::renameStorage(CntNodeJob & rJob, const String & rNewMboxURL)
{
	// The sub storage nodes are not copied across a rename, so we lose almost
	// all information about the renamed node:
	String aOldMboxURL = OWN_URL(&getNode());
	CntNodeRef xParentDirNode = getParentFldr().getDirNode(rJob);
	if (xParentDirNode.Is())
	{
		static_cast< CntStorageNode * >(&xParentDirNode)->remove(aOldMboxURL);

		CntStoreItemSetRef xNewMboxDirSet
			= static_cast< CntStorageNode * >(&xParentDirNode)->
			      openItemSet(aCntIMAPMboxDirSetRanges, rNewMboxURL,
							  STREAM_STD_WRITE);
		if (xNewMboxDirSet.Is())
		{
			static_cast< CntStorageNode * >(&xParentDirNode)->
				attrib(rNewMboxURL, 0,
					   ITEMSET_VALUE(&getNode(), CntBoolItem,
									 WID_FLAG_SUBSCRIBED) ?
					       CNTDIRENTRY_ATTRIB_IMAP_MBOX
					           | CNTDIRENTRY_ATTRIB_IMAP_MBOX_SSCRBD :
					       CNTDIRENTRY_ATTRIB_IMAP_MBOX);
			const SfxPoolItem * pItem;
			if (getNode().GetItemState(WID_IMAPFOLDERINFO, false, &pItem)
				    == SFX_ITEM_SET)
				xNewMboxDirSet->Put(*pItem);
		}
	}

	// But the cached mesg bodies can be reused:
	CntStorageNode * pCacheNode = rJob.GetCacheNode();
	if (pCacheNode)
	{
		CntStorageIterator aCacheIter(CNTDIRENTRY_ATTRIB_HIDDEN,
									  CNTDIRENTRY_ATTRIB_SUBDIR
									   | CNTDIRENTRY_ATTRIB_MARKEDFORDELETE
									   | CNTSTORE_ATTRIB_ISDIR);
		for (;;)
		{
			String aID(pCacheNode->iter(aCacheIter));
			if (aCacheIter.eof())
				break;

			if (aID.Len() > aOldMboxURL.Len()
				&& (aID.GetChar(aOldMboxURL.Len()) == '/'
					|| aID.GetChar(aOldMboxURL.Len()) == ';')
				&& aOldMboxURL.Match(aID) == STRING_MATCH)
			{
				String aNewID(rNewMboxURL);
				aNewID += aID.Copy(aOldMboxURL.Len());
				pCacheNode->rename(aID, aNewID);
			}
		}
	}
}

//============================================================================
void CntIMAPMbox::clearRenamed(bool bClearThis)
{
	if (bClearThis)
	{
		m_nLMesgCount = 0;
		m_nSMesgCount = UNKNOWN_S_MESG_COUNT;
		m_nLSMesgCount = 0;
		m_nLSDMesgCount = 0;
		getNode().ClearItem(WID_IMAP_MESG_COUNT);
		getNode().ClearItem(WID_IMAP_READ_MESG_COUNT);
		getNode().ClearItem(WID_IMAP_MARKED_MESG_COUNT);
		getNode().ClearItem(WID_IS_READ);
		getNode().ClearItem(WID_IS_MARKED);

		getNode().ClearItem(WID_IMAP_MBOX_COUNT);
		getNode().ClearItem(WID_IMAP_SSCRBD_MBOX_COUNT);

		getNode().ClearItem(WID_FLAG_HAS_MESSAGES);
		getNode().ClearItem(WID_FLAG_HAS_FOLDER);
		getNode().Put(CntIdentifierListItem(WID_PROPERTYLIST,
											CNT_TABPAGE_GENERAL,
											CNT_TABPAGE_RULES,
											CNT_TABPAGE_SUBSCRIBE,
											CNT_TABPAGE_VIEW_PROPERTIES,
											CNT_TABPAGE_HEADER,
											CNT_TABPAGE_CONTENT_PROPERTIES,
											CNT_TABPAGE_BACKGROUND,
											CNT_TABPAGE_FONT, 0));
		getNode().ClearItem(WID_CREATE_NEW);

		getNode().ClearItem(WID_IMAPFOLDERINFO);
		getNode().ClearItem(WID_DELETE_ON_SERVER);

		m_bDeleted = false;

		m_bInheritedKeepBodiesFlag = true;
		getNode().Put(getNode().GetParent()->Get(WID_MESSAGE_STOREMODE));
	}

	for (ULONG i = 0; i < getNode().SubNodeCount(); ++i)
		if (CntIMAPMboxNode * pSubMboxNode
			    = PTR_CAST(CntIMAPMboxNode, getNode().GetSubNode(i)))
			pSubMboxNode->getMbox().clearRenamed(true);
}

//============================================================================
// static
bool CntIMAPMbox::isSubMbox(ByteString const & rParentLiteralFullName,
							sal_Char cParentHierarchyDelimiter,
							ByteString const & rChildLiteralFullName)
{
	return rParentLiteralFullName.Match(rChildLiteralFullName) == STRING_MATCH
		   && (rChildLiteralFullName.Len() == rParentLiteralFullName.Len()
			   || cParentHierarchyDelimiter != '\0'
			      && rChildLiteralFullName.GetChar(rParentLiteralFullName.
												       Len())
			             == cParentHierarchyDelimiter);
}

