/*************************************************************************
 *
 *  $RCSfile: imaplist.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPLIST_HXX
#define CHAOS_IMAPLIST_HXX

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

namespace chaos {

class CntIMAPMboxNode;

//============================================================================
class CntIMAPMboxList
{
	struct Entry
	{
		String m_aMboxURL;
		bool m_bHidden;

		Entry(String const & rTheMboxURL, bool bTheHidden = false):
			m_aMboxURL(rTheMboxURL), m_bHidden(bTheHidden) {}
	};

	List m_aList;

public:
	~CntIMAPMboxList();

	ULONG getCount() const { return m_aList.Count(); }

	void add(String const & rMboxURL, bool bHidden = false);

	void remove(String const & rMboxURL);

	bool iter(String & rMboxURL);
};

//============================================================================
class CntIMAPMboxHierList
{
	struct Entry
	{
		ByteString m_aLiteralLastName;
		Entry * m_pParent;
		Entry * m_pChildren;
		Entry * m_pLeft;
		Entry * m_pRight;
		Entry * m_pPrev;
		Entry * m_pNext;
		sal_uInt32 m_nChildCount;
		sal_Char m_cHierarchySeparator;
		bool m_bSubscribed;
		bool m_bDeleted;

		inline Entry();

		inline ~Entry();
	};

	Entry * m_pRoot;
	Entry * m_pChain[2];
	Entry * m_pSubscribed;
	sal_uInt32 m_nUnsubscribed;

	Entry & insert(Entry ** pEntry, ByteString const & rLiteralLastName);

	void chain(Entry & rEntry);

	void unchain(Entry & rEntry);

	void remove(Entry * pEntry);

public:
	inline CntIMAPMboxHierList();

	~CntIMAPMboxHierList() { delete m_pRoot; }

	bool hasEntries() const { return m_nUnsubscribed != 0; }

	void add(CntNodeJob & rJob, CntNode & rFldrNode,
			 ByteString const & rFldrLiteralFullName,
			 ByteString const & rSubMboxLiteralFullName,
			 sal_Char cHierarchySeparator, bool bSubscribed);

	bool iter(bool bSubscribed, ByteString const & rFldrLiteralFullName,
			  ByteString & rSubMboxLiteralFullName,
			  sal_Char & rHierarchySeparator);

	void removeSubscribed();
};

inline CntIMAPMboxHierList::Entry::Entry():
	m_pParent(0),
	m_pChildren(0),
	m_pLeft(0),
	m_pRight(0),
	m_pPrev(0),
	m_pNext(0),
	m_nChildCount(0),
	m_cHierarchySeparator('\0'),
	m_bSubscribed(false),
	m_bDeleted(false)
{}

inline CntIMAPMboxHierList::Entry::~Entry()
{
	delete m_pChildren;
	delete m_pLeft;
	delete m_pRight;
}

inline CntIMAPMboxHierList::CntIMAPMboxHierList()
{
	m_pRoot = 0;
	m_pChain[false] = 0;
	m_pChain[true] = 0;
	m_pSubscribed = 0;
	m_nUnsubscribed = 0;
}

//============================================================================
class CntIMAPMboxNodeListEntry
{
	CntNodeRef m_xMboxNode;
	bool m_bFresh;

public:
	CntIMAPMboxNodeListEntry(CntIMAPMboxNode & rTheMboxNode);

	CntIMAPMboxNode & getMboxNode();

	inline bool wasFresh();
};

inline bool CntIMAPMboxNodeListEntry::wasFresh()
{
	bool bWasFresh = m_bFresh;
	m_bFresh = false;
	return bWasFresh;
}

//============================================================================
class CntIMAPMboxNodeList
{
	List m_aList;

public:
	~CntIMAPMboxNodeList();

	void push(CntIMAPMboxNode & rMboxNode);

	inline CntIMAPMboxNodeListEntry * getTop();

	inline void pop();
};

inline CntIMAPMboxNodeListEntry * CntIMAPMboxNodeList::getTop()
{
	return m_aList.Count() == 0 ? 0 :
		                          static_cast< CntIMAPMboxNodeListEntry * >(
									  m_aList.GetObject(m_aList.Count() - 1));
}

inline void CntIMAPMboxNodeList::pop()
{
	DBG_ASSERT(m_aList.Count() != 0, "CntIMAPMboxNodeList::pop(): Empty");

	delete static_cast< CntIMAPMboxNodeListEntry * >(
		       m_aList.Remove(m_aList.Count() - 1));
}

//============================================================================
class CntIMAPMesgList
{
	struct Entry
	{
		sal_uInt32 m_nUIDValidity;
		sal_uInt32 m_nMesgUID;

		Entry(sal_uInt32 nTheUIDValidity, sal_uInt32 nTheMesgUID):
			m_nUIDValidity(nTheUIDValidity), m_nMesgUID(nTheMesgUID) {}
	};

	List m_aList;

public:
	~CntIMAPMesgList();

	ULONG getCount() const { return m_aList.Count(); }

	void add(sal_uInt32 nUIDValidity, sal_uInt32 nMesgUID);

	bool iter(sal_uInt32 & rUIDValidity, sal_uInt32 & rMesgUID);
};

//============================================================================
class CntIMAPMesgNodeList
{
	List m_aList;

public:
	~CntIMAPMesgNodeList();

	ULONG getCount() const { return m_aList.Count(); }

	void add(CntNodeRef & rMesgNode);

	bool iter(CntNodeRef & rMesgNode);
};

//============================================================================
class CntIMAPMesgURLList
{
	List m_aList;

public:
	~CntIMAPMesgURLList();

	ULONG getCount() const { return m_aList.Count(); }

	void add(String const & rMesgURL)
	{ m_aList.Insert(new String(rMesgURL), LIST_APPEND); }

	void remove(String const & rMesgURL);

	bool iter(String & rMesgURL);
};

//============================================================================
class CntIMAPMesgUIDList
{
	List m_aList;

public:
	ULONG getCount() const { return m_aList.Count(); }

	void add(sal_uInt32 nMesgUID);

	sal_uInt32 iter();
};

//============================================================================
class CntIMAPSubJobListEntry
{
	CntNodeJobRef m_xSubJob;
	bool m_bForwardResults;

public:
	CntIMAPSubJobListEntry(CntNodeJob * pTheSubJob, bool bTheForwardResults):
		m_xSubJob(pTheSubJob), m_bForwardResults(bTheForwardResults) {}

	CntNodeJob & getSubJob() { return *m_xSubJob; }

	bool doForwardResults() const { return m_bForwardResults; }
};

//============================================================================
class CntIMAPSubJobList
{
	List m_aList;

public:
	~CntIMAPSubJobList();

	inline void append(CntNodeJob * pSubJob, bool bForwardResults);

	inline CntIMAPSubJobListEntry * getFirst();

	inline void removeFirst();
};

inline void CntIMAPSubJobList::append(CntNodeJob * pSubJob,
									  bool bForwardResults)
{
	m_aList.Insert(new CntIMAPSubJobListEntry(pSubJob, bForwardResults),
				   LIST_APPEND);
}

inline CntIMAPSubJobListEntry * CntIMAPSubJobList::getFirst()
{
	return
		m_aList.Count() == 0 ?
		    0 : static_cast< CntIMAPSubJobListEntry * >(m_aList.GetObject(0));
}

inline void CntIMAPSubJobList::removeFirst()
{
	if (m_aList.Count() != 0)
		delete
			static_cast< CntIMAPSubJobListEntry * >(m_aList.Remove(ULONG(0)));
}

}

#endif // CHAOS_IMAPLIST_HXX

