/*************************************************************************
 *
 *  $RCSfile: imapactt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CHAOS_IMAPACTT_HXX
#define CHAOS_IMAPACTT_HXX

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif

#ifndef CHAOS_IMAPTASK_HXX
#include <imaptask.hxx>
#endif

namespace chaos {

class CntExport;
class CntFolderList;
class CntIMAPAcntMesgCachingPolicy;
class CntImport;

//============================================================================
class CntIMAPAcntOpenTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_NAMESPACE = STATE_START_ONLINE, STATE_RECV_NAMESPACE,
		   STATE_SEND_LSUB, STATE_RECV_LSUB, STATE_UNSUBSCRIBE,
		   STATE_SEND_LIST, STATE_RECV_LIST, STATE_SEND_SELECT,
		   STATE_RECV_SELECT, STATE_SYNC, STATE_SEND_CHECK_LIST,
		   STATE_RECV_CHECK_LIST, STATE_ASK_AUTO_SUBSCRIBE,
		   STATE_SEND_SUBSCRIBE, STATE_RECV_SUBSCRIBE, STATE_DONE,
		   STATE_GO_ONLINE };

	String m_aAcntURL;
	CntNodeRef m_xAcntDirNode;
	CntIMAPMboxList m_aSelectMboxList;
	CntIMAPMboxList m_aSscrbdMboxList;
	CntIMAPMboxList m_aSyncMboxList;
	CntIMAPMboxHierList m_aAutoSscrbMboxList;
	String m_aMboxURL;
	ByteString m_aMboxLiteralFullName;
	CntStorageIterator * m_pAcntDirIter;
	ULONG m_nProgress;
	sal_uInt32 m_nMboxMesgCount;
	sal_uInt32 m_nMboxCount;
	sal_uInt32 m_nSscrbdMboxCount;
	sal_uInt32 m_nNewMboxCount;
	sal_uInt32 m_nRemovedMboxCount;
	CntFolderViewMode m_eListMboxsMode;
	bool m_bInboxOnly;
	bool m_bCompleteSubscribedMboxs;
	bool m_bCompleteMboxs;
	bool m_bUpdate;
	bool m_bOfflineDone;
	bool m_bMboxHasMesgCount;
	bool m_bAutoSubscribeChecked;
	bool m_bAutoSubscribe;
	bool m_bModifiedSubscribed;
	bool m_bFound;

	bool listMbox(CntNode & rMboxNode);

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	inline CntIMAPAcntOpenTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt,
							   bool bTheINBOXOnly = false);
};

inline CntIMAPAcntOpenTask::CntIMAPAcntOpenTask(CntNodeJob & rJob,
												CntIMAPAcnt & rAcnt,
												bool bTheINBOXOnly):
	CntIMAPOnlineTask(rJob, rAcnt),
	m_pAcntDirIter(0),
	m_bInboxOnly(bTheINBOXOnly)
{}

//============================================================================
class CntIMAPAcntGetMboxsTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_LSUB = STATE_START_ONLINE, STATE_RECV_LSUB,
		   STATE_SEND_LIST, STATE_RECV_LIST, STATE_GO_ONLINE };

	String m_aAcntURL;
	CntNodeRef m_xAcntDirNode;
	CntStorageIterator * m_pAcntDirIter;
	CntFolderList * m_pMboxList;
	ULONG m_nProgress;
	bool m_bSubscribedMboxsOnly;
	bool m_bCompleteSubscribedMboxs;
	bool m_bCompleteMboxs;
	bool m_bOfflineDone;

	void finish();

	virtual void beingCanceled();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPAcntGetMboxsTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt):
		CntIMAPOnlineTask(rJob, rAcnt), m_pAcntDirIter(0), m_pMboxList(0) {}
};

//============================================================================
class CntIMAPAcntSetMboxsTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_SUBSCRIBE = STATE_START_ONLINE, STATE_RECV_SUBSCRIBE };

	String m_aAcntURL;
	CntNodeRef m_xAcntDirNode;
	String m_aMboxURL;
	CntNodeRef m_xMboxNode;
	CntFolderList * m_pMboxList;
	ULONG m_nProgress;
	bool m_bOnlineProlog;
	bool m_bGoOnline;
	bool m_bSubscribe;

	virtual void end();

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPAcntSetMboxsTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt):
		CntIMAPOnlineTask(rJob, rAcnt), m_pMboxList(0) {}
};

//============================================================================
class CntIMAPAcntImportTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	String m_aFileName;
	SvStream * m_pStream;
	CntImport * m_pImport;
	CntIMAPAcntMesgCachingPolicy * m_pPolicy;
	bool m_bMessageFound;

	virtual void end();

	virtual bool executeTimeSlice(bool bFirst);

public:
	CntIMAPAcntImportTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt);
};

//============================================================================
class CntIMAPAcntExportTask: public CntIMAPOfflineTask
{
	typedef CntIMAPOfflineTask super;

	struct Entry
	{
		String m_aFldrURL;
		Entry * m_pNext;
	};

	String m_aFldrURL;
	CntNodeRef m_xFldrDirNode;
	String m_aFldrDirID;
	CntNodeRef m_xMesgNode;
	CntNodeJobRef m_xOpenJob;
	SvStream * m_pStream;
	CntExport * m_pExport;
	Entry * m_pFldrListHead;
	Entry * m_pFldrListTail;
	CntStorageIterator * m_pFldrDirIter;
	bool m_bAcnt;
	bool m_bIgnoreOffline;

	void append(String const & rTheFldrURL);

	DECL_LINK(errorHandler, CntErrorData *);

	virtual void notification(SfxBroadcaster & rBroadcaster,
							  SfxHint const & rHint);

	virtual void beingCanceled();

	virtual void end();

	virtual bool executeTimeSlice(bool bFirst);

public:
	CntIMAPAcntExportTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt);
};

//============================================================================
class CntIMAPAcntCloseTask: public CntIMAPOnlineTask
{
	typedef CntIMAPOnlineTask super;

	enum { STATE_SEND_LOGOUT = STATE_START_ONLINE, STATE_RECV_LOGOUT };

	virtual bool initialize();

	virtual Execution executeState(INetIMAPResponse const * pResponse);

public:
	CntIMAPAcntCloseTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt):
		CntIMAPOnlineTask(rJob, rAcnt, true) {}
};

//============================================================================
class CntIMAPBaseOpenTask: public CntIMAPForwardTask
{
	typedef CntIMAPForwardTask super;

public:
	CntIMAPBaseOpenTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt);
};

//============================================================================
class CntIMAPBaseGetMboxsTask: public CntIMAPForwardTask
{
	typedef CntIMAPForwardTask super;

	CntNodeRef m_xBaseMboxNode;

	virtual void finish();

public:
	CntIMAPBaseGetMboxsTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt);
};

//============================================================================
class CntIMAPBaseForwardTask: public CntIMAPForwardTask
{
	typedef CntIMAPForwardTask super;

public:
	CntIMAPBaseForwardTask(CntNodeJob & rJob, CntIMAPAcnt & rAcnt);
};

}

#endif // CHAOS_IMAPACTT_HXX

