/*************************************************************************
 *
 *  $RCSfile: thrdtask.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:19:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef CHAOS_THRDTASK_HXX
#include <thrdtask.hxx>
#endif

using namespace chaos;

//============================================================================
//
//  class ThreadTask
//
//============================================================================

bool ThreadTask::wakeUp(bool bStarting)
{
	vos::OClearableGuard aGuard(m_aMutex);
	DBG_ASSERT(m_nState == INITIAL && bStarting && !m_bPendingCancel
			       && !m_bPendingDone && !m_bPendingReschedule
			       && !m_bAwaitingReschedule
			   || m_nState == SLEEPING && !m_bPendingCancel && !m_bPendingDone
			      && !m_bPendingReschedule
			   || m_nState > SLEEPING && m_nState < AWAKE_FOREVER - 1
			   || m_nState == FINISHED,
			   "chaos::ThreadTask::wakeUp(): Bad state");
	if (m_nState == INITIAL)
	{
		acquire();
		getJob().SetRequestData(this);
#if !defined USE_JOB_DISPATCHER
		getJob()._bAlwaysReschedule = true;
#endif // USE_JOB_DISPATCHER
		StartListening(getJob());
		if (getJob().IsDone() || getJob().IsCanceled())
		{
			m_nState = FINISHED;
			aGuard.clear();
			EndListening(getJob());
			finished(getJob().IsCanceled() != false);
			release();
			return false;
		}
		m_nState = SLEEPING;
	}
	else if (bStarting && m_bAwaitingReschedule)
	{
		m_bAwaitingReschedule = false;
		if (m_nState == FINISHED)
		{
			aGuard.clear();
			release();
			return false;
		}
	}
	if (m_bPendingCancel || m_bPendingDone)
		return false;
	if (m_nState < AWAKE_FOREVER)
		++m_nState;
	return m_nState != FINISHED;
}

//============================================================================
// virtual
void ThreadTask::Notify(SfxBroadcaster & rBroadcaster, const SfxHint & rHint)
{
	vos::ORef< ThreadTask > xThis(this);
	if (&rBroadcaster == &getJob())
	{
		if (const CntStatusHint * pStatusHint = PTR_CAST(CntStatusHint,
														 &rHint))
		{
			bool bCanceled = false;
			switch (pStatusHint->GetStatus())
			{
				case CNT_STATUS_ERROR:
					if (pStatusHint->GetError() != ERRCODE_ABORT)
						break;
					bCanceled = true;
				case CNT_STATUS_DONE:
					bool bRelease;
					{
						vos::OGuard aGuard(m_aMutex);
						DBG_ASSERT(m_nState == SLEEPING
								       && !(m_bPendingCancel || m_bPendingDone
											|| m_bPendingReschedule)
								   || m_nState > SLEEPING
								      && m_nState < AWAKE_FOREVER
								   || m_nState == FINISHED,
								   "chaos::ThreadTask::Notify(): Bad state");
						if (m_nState == FINISHED)
							break;
						EndListening(getJob());
						if (m_nState > SLEEPING && m_nState <= AWAKE_FOREVER)
						{
							(bCanceled ? m_bPendingCancel : m_bPendingDone)
								= true;
							break;
						}
						bRelease = !m_bAwaitingReschedule;
						m_nState = FINISHED;
					}

					finished(bCanceled);
					if (bRelease)
						release();
					break;
			}
		}
	}
	else if (wakeUp())
	{
		notification(rBroadcaster, rHint);
		sleep();
	}
}

//============================================================================
bool ThreadTask::sleep()
{
	vos::OClearableGuard aGuard(m_aMutex);
	DBG_ASSERT(m_nState > SLEEPING && m_nState < AWAKE_FOREVER
			   || m_nState == FINISHED
			   && !(m_bPendingReschedule && m_bAwaitingReschedule),
			   "chaos::ThreadTask::sleep(): Bad state");
	if (m_nState >= AWAKE_FOREVER)
		return false;
	else if (m_nState > SLEEPING && --m_nState == SLEEPING)
		if (m_bPendingCancel || m_bPendingDone)
		{
			bool bRelease = !m_bAwaitingReschedule;
			m_nState = FINISHED;
			aGuard.clear();
			finished(m_bPendingCancel);
			if (bRelease)
				release();
			return false;
		}
		else if (m_bPendingReschedule)
		{
			m_bPendingReschedule = false;
			m_bAwaitingReschedule = true;
			aGuard.clear();
			getExecNode().RescheduleJob(&getJob());
		}
	return true;
}

//============================================================================
void ThreadTask::startTimeSlice()
{
	m_nTicks = Time::GetSystemTicks();
}

//============================================================================
bool ThreadTask::checkTimeSliceExhausted()
{
	return Time::GetSystemTicks() - m_nTicks > TICKS;
}

//============================================================================
void ThreadTask::reschedule()
{
	vos::OGuard aGuard(m_aMutex);
	DBG_ASSERT(m_nState > SLEEPING && m_nState < AWAKE_FOREVER
			   && !m_bPendingReschedule,
			   "chaos::ThreadTask::reschedule(): Bad state");
	if (!m_bAwaitingReschedule)
		m_bPendingReschedule = true;
}

//============================================================================
ThreadTask::Response ThreadTask::handleError(ErrCode nError,
											 const String * pText,
											 void * pData, bool bCancelJob)
{
	if (!sleep())
		return RESPONSE_CANCELED;
	USHORT nButton = CntRootNodeMgr::Get()->HandleError(nError, &getJob(),
														pText, pData,
														bCancelJob);
	if (!wakeUp())
		return RESPONSE_CANCELED;
	switch (nButton)
	{
		case ERRCODE_BUTTON_OK:
		case ERRCODE_BUTTON_NO: //@@@ is this ok?
			return RESPONSE_IGNORE;

		case ERRCODE_BUTTON_RETRY:
		case ERRCODE_BUTTON_YES: //@@@ is this ok?
			return RESPONSE_RETRY;

		default:
			DBG_ERROR("chaos::ThreadTask::HandleError(): Bad button");
		case ERRCODE_BUTTON_CANCEL:
			return RESPONSE_ABORT;
	}
}

//============================================================================
// virtual
void ThreadTask::notification(SfxBroadcaster &, const SfxHint &)
{}

//============================================================================
// virtual
void ThreadTask::finished(bool)
{}

//============================================================================
const SfxPoolItem * ThreadTask::run()
{
	vos::ORef< ThreadTask > xThis = this;
	const SfxPoolItem * pItem = 0;
	if (wakeUp(true))
	{
		pItem = execute();
		sleep();
	}
	return pItem;
}

