/*************************************************************************
 *
 *  $RCSfile: inimgr.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/20 12:04:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inet/inetcfg.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif
#ifndef _SVTOOLS_INETOPTIONS_HXX_
#include <svtools/inetoptions.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif

using namespace chaos;
using namespace com::sun::star;

//============================================================================
namespace chaos {

class CntIniManager_Impl: public cppu::OWeakObject,
						  public beans::XPropertiesChangeListener
{
	SvtInetOptions m_aInetOptions;
	SvtPathOptions m_aPathOptions;
	SvtUserOptions m_aUserOptions;
	SfxBroadcaster & m_rBroadcaster;
    IntlWrapper * m_pIntlWrapper;

	static String createRFC822Mailbox(String const & rFirstName,
									  String const & rSurname,
									  String const & rAddrSpec);

public:
	CntIniManager_Impl(SfxBroadcaster & rTheBroadcaster);

    virtual ~CntIniManager_Impl() { delete m_pIntlWrapper; }

	XINTERFACE_DECL()

    virtual void SAL_CALL disposing(lang::EventObject const &)
		throw (uno::RuntimeException)
	{}

    virtual void SAL_CALL
	propertiesChange(uno::Sequence< beans::PropertyChangeEvent > const & rEvt)
		throw (uno::RuntimeException);

	String getEntry(CntSettingKey eKey) const;

	void startSettingsChangeListener();

	void stopSettingsChangeListener();

    IntlWrapper const & getIntlWrapper() const
    { return *m_pIntlWrapper; }
};

}

//============================================================================
//
//  CntIniManager
//
//============================================================================

CntIniManager::CntIniManager()
{
	m_xImpl = new CntIniManager_Impl(*this);
}

//============================================================================
// virtual
CntIniManager::~CntIniManager()
{
	m_xImpl->stopSettingsChangeListener();
}

//============================================================================
String CntIniManager::getEntry(CntSettingKey eKey) const
{
	return m_xImpl->getEntry(eKey);
};

//============================================================================
void CntIniManager::startSettingsChangeListener()
{
	m_xImpl->startSettingsChangeListener();
}

//============================================================================
void CntIniManager::stopSettingsChangeListener()
{
	m_xImpl->stopSettingsChangeListener();
}

//============================================================================
IntlWrapper const & CntIniManager::getIntlWrapper() const
{
    return m_xImpl->getIntlWrapper();
}

//============================================================================
//
//  CntIniManager_Impl
//
//============================================================================

// static
String CntIniManager_Impl::createRFC822Mailbox(String const & rFirstName,
											   String const & rSurname,
											   String const & rAddrSpec)
{
	String aPhrase(rFirstName);
	if (rFirstName.Len() > 0 && rSurname.Len() > 0)
		aPhrase += ' ';
	aPhrase += rSurname;
	String aMailbox;
	SvAddressParser::createRFC822Mailbox(aPhrase, rAddrSpec, aMailbox);
	return aMailbox;
}

//============================================================================
CntIniManager_Impl::CntIniManager_Impl(SfxBroadcaster & rTheBroadcaster):
	m_rBroadcaster(rTheBroadcaster)
{
    m_pIntlWrapper = new IntlWrapper( ::comphelper::getProcessServiceFactory(),
        LanguageType(getEntry(CNT_KEY_USER_LANGUAGE).ToInt32()) );
}

//============================================================================
XINTERFACE_COMMON_IMPL(CntIniManager_Impl)

//============================================================================
// virtual
uno::Any SAL_CALL CntIniManager_Impl::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any
		aRet(cppu::queryInterface(
			     rType,
				 static_cast< lang::XEventListener * >(this),
				 static_cast< beans::XPropertiesChangeListener * >(this)));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL
CntIniManager_Impl::propertiesChange(
	uno::Sequence< beans::PropertyChangeEvent > const & rEvt)
	throw (uno::RuntimeException)
{
	for (sal_Int32 i = 0; i < rEvt.getLength(); ++i)
	{
		rtl::OUString aKey(rEvt[i].PropertyName);
		if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                      SVT_INET_OPTION_DNS_IP_ADDRESS)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
					xConfig->setDomainNameServer(getEntry(CNT_KEY_INET_DNS));
			}
		}
		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                           SVT_INET_OPTION_PROXY_NO_PROXY)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper && getEntry(CNT_KEY_INET_PROXYTYPE).ToInt32() != 0)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
				{
					inet::INetProxyConfig
						aProxyConfig(xConfig->getProxyConfig());
					aProxyConfig.
						setNoProxyList(getEntry(CNT_KEY_INET_NOPROXY));
					xConfig->setProxyConfig(aProxyConfig);
				}
			}
		}
		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                           SVT_INET_OPTION_PROXY_TYPE)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
				{
					inet::INetProxyConfig
						aProxyConfig(xConfig->getProxyConfig());
					if (getEntry(CNT_KEY_INET_PROXYTYPE).ToInt32() == 0)
						aProxyConfig.
							setNoProxyList(rtl::OUString::createFromAscii(
								               "*:*"));
					else
						aProxyConfig.
							setNoProxyList(getEntry(CNT_KEY_INET_NOPROXY));
					xConfig->setProxyConfig(aProxyConfig);
				}
			}
		}
		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                      SVT_INET_OPTION_PROXY_FTP_NAME))
			|| aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
				                     SVT_INET_OPTION_PROXY_FTP_PORT)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
				{
					inet::INetProxyConfig
						aProxyConfig(xConfig->getProxyConfig());
					aProxyConfig.
						setFtpProxy(getEntry(CNT_KEY_INET_FTPPROXYNAME),
									sal_uInt16(
										getEntry(CNT_KEY_INET_FTPPROXYPORT).
										    ToInt32()));
					xConfig->setProxyConfig(aProxyConfig);
				}
			}
		}
		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                           SVT_INET_OPTION_PROXY_HTTP_NAME))
				 || aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
					                      SVT_INET_OPTION_PROXY_HTTP_PORT)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
				{
					inet::INetProxyConfig
						aProxyConfig(xConfig->getProxyConfig());
					aProxyConfig.
						setHttpProxy(getEntry(CNT_KEY_INET_HTTPPROXYNAME),
									 sal_uInt16(
										 getEntry(CNT_KEY_INET_HTTPPROXYPORT).
										     ToInt32()));
					xConfig->setProxyConfig(aProxyConfig);
				}
			}
		}
		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
			                           SVT_INET_OPTION_PROXY_SOCKS_NAME))
				 || aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
					                      SVT_INET_OPTION_PROXY_SOCKS_PORT)))
		{
			inet::INetWrapper * pWrapper
				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
			if (pWrapper)
			{
				vos::ORef< inet::INetConfig > xConfig;
				if (pWrapper->getINetConfig(xConfig))
				{
					inet::INetProxyConfig
						aProxyConfig(xConfig->getProxyConfig());
					aProxyConfig.
						setSocksProxy(
							getEntry(CNT_KEY_INET_SOCKSPROXYNAME),
							sal_uInt16(getEntry(CNT_KEY_INET_SOCKSPROXYPORT).
									       ToInt32()));
					xConfig->setProxyConfig(aProxyConfig);
				}
			}
		}
		//@@@ missing:
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_SMTP_SERVER_NAME)))
//		{
//			CntSendInfoListItem const * pOldItem
//				= static_cast< CntSendInfoListItem const * >(
//					  CntItemPool::Get()->
//					      GetPoolDefaultItem(WID_SEND_SERVERNAME));
//			if (pOldItem)
//			{
//				CntSendInfoListItem aNewItem(*pOldItem);
//				aNewItem[CNT_OUTMSG_PROTOCOL_SMTP]
//					= getEntry(CNT_KEY_INET_SMTPSERVER);
//				CntItemPool::Get()->SetPoolDefaultItem(aNewItem);
//			}
//		}
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_NNTP_SERVER_NAME)))
//		{
//			CntSendInfoListItem const * pOldItem
//				= static_cast< CntSendInfoListItem const * >(
//					  CntItemPool::Get()->
//					      GetPoolDefaultItem(WID_SEND_SERVERNAME));
//			if (pOldItem)
//			{
//				CntSendInfoListItem aNewItem(*pOldItem);
//				aNewItem[CNT_OUTMSG_PROTOCOL_NNTP]
//					= getEntry(CNT_KEY_INET_NNTPSERVER);
//				CntItemPool::Get()->SetPoolDefaultItem(aNewItem);
//			}
//		}
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_POP_SERVER_NAME)))
//			CntItemPool::Get()->
//				SetPoolDefaultItem(CntStringItem(
//					                   WID_SERVERNAME,
//									   getEntry(CNT_KEY_INET_POPSERVER)));
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_PROXY_SECURITY_NAME))
//			     || aKey.equalsAsciiL(
//					         RTL_CONSTASCII_STRINGPARAM(
//								 SVT_INET_OPTION_PROXY_SECURITY_PORT)))
//		{
//			inet::INetWrapper * pWrapper
//				= CntRootNodeMgr::GetSystemData()->_pINetWrapper;
//			if (pWrapper)
//			{
//				vos::ORef< inet::INetConfig > xConfig;
//				if (pWrapper->getINetConfig(xConfig))
//				{
//					inet::INetProxyConfig
//						aProxyConfig(xConfig->getProxyConfig());
//					aProxyConfig.
//						setSecureSocketProxy(
//							getEntry(CNT_KEY_INET_SECURITYPROXYNAME),
//							sal_uInt16(
//								getEntry(CNT_KEY_INET_SECURITYPROXYPORT).
//								    ToInt32()));
//					xConfig->setProxyConfig(aProxyConfig);
//				}
//			}
//		}
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_MAIL_TEXT_FORMAT)))
//			CntRootNodeMgr::setSendFormats(
//				USHORT(getEntry(CNT_KEY_INET_MAILTEXTFORMAT).ToInt32()));
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_MAIL_USER_NAME)))
//		{
//			rtl::OUString aValue(getEntry(CNT_KEY_INET_MAILUSERNAME));
//			CntItemPool::Get()->SetPoolDefaultItem(CntStringItem(WID_USERNAME,
//																 aValue));
//			const CntSendInfoListItem * pOldItem
//				= SAL_STATIC_CAST(const CntSendInfoListItem *,
//							  	CntItemPool::Get()->
//							      	GetPoolDefaultItem(WID_SEND_USERNAME));
//			if (pOldItem)
//			{
//				CntSendInfoListItem aNewItem(*pOldItem);
//				aNewItem[CNT_OUTMSG_PROTOCOL_NNTP] = UniString(aValue);
//				CntItemPool::Get()->SetPoolDefaultItem(aNewItem);
//			}
//		}
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_INET_OPTION_MAIL_PASSWORD)))
//		{
//			String
//				aPassword(CntStringDecode(true,
//										  ByteString(
//											  getEntry(
//												  CNT_KEY_INET_MAILPASSWORD),
//											  RTL_TEXTENCODING_ASCII_US)),
//						  RTL_TEXTENCODING_ASCII_US);
//			CntItemPool::Get()->SetPoolDefaultItem(CntStringItem(WID_PASSWORD,
//																 aPassword));
//			CntSendInfoListItem const * pOldItem
//				= static_cast< CntSendInfoListItem const * >(
//					  CntItemPool::Get()->
//					      GetPoolDefaultItem(WID_SEND_PASSWORD));
//			if (pOldItem)
//			{
//				CntSendInfoListItem aNewItem(*pOldItem);
//				aNewItem[CNT_OUTMSG_PROTOCOL_NNTP] = aPassword;
//				CntItemPool::Get()->SetPoolDefaultItem(aNewItem);
//			}
//		}
//		else if (aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                           SVT_USER_OPTION_DATA_EMAIL))
//				 || aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//			                              SVT_USER_OPTION_DATA_FIRST_NAME))
//				 || aKey.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
//				                          SVT_USER_OPTION_DATA_LAST_NAME)))
//		{
//			CntSendInfoListItem const * pOldItem
//				= static_cast< CntSendInfoListItem const * >(
//					  CntItemPool::Get()->
//					      GetPoolDefaultItem(WID_SEND_FROM_DEFAULT));
//			if (pOldItem)
//			{
//				String aMailbox(createRFC822Mailbox(
//				                	getEntry(CNT_KEY_USER_FIRSTNAME),
//									getEntry(CNT_KEY_USER_NAME),
//									getEntry(CNT_KEY_ADDRESS_EMAIL)));
//				CntSendInfoListItem aNewItem(*pOldItem);
//				aNewItem[CNT_OUTMSG_PROTOCOL_SMTP] = aMailbox;
//				aNewItem[CNT_OUTMSG_PROTOCOL_NNTP] = aMailbox;
//				CntItemPool::Get()->SetPoolDefaultItem(aNewItem);
//			}
//		}
	}
}

//============================================================================
String CntIniManager_Impl::getEntry(CntSettingKey eKey) const
{
	switch (eKey)
	{
		case CNT_KEY_ADDRESS_EMAIL:
			return m_aUserOptions.GetEmail();

		case CNT_KEY_INET_DNS:
			return m_aInetOptions.GetDnsIpAddress();

		case CNT_KEY_INET_FTPPROXYNAME:
			return m_aInetOptions.GetProxyFtpName();

		case CNT_KEY_INET_FTPPROXYPORT:
			return String::CreateFromInt32(m_aInetOptions.GetProxyFtpPort());

		case CNT_KEY_INET_HTTPPROXYNAME:
			return m_aInetOptions.GetProxyHttpName();

		case CNT_KEY_INET_HTTPPROXYPORT:
			return String::CreateFromInt32(m_aInetOptions.GetProxyHttpPort());

		case CNT_KEY_INET_MAILPASSWORD:
			return String(); //@@@

		case CNT_KEY_INET_MAILTEXTFORMAT:
			return String(); //@@@

		case CNT_KEY_INET_MAILUSERNAME:
			return String(); //@@@

		case CNT_KEY_INET_NNTPSERVER:
			return String(); //@@@

		case CNT_KEY_INET_NOPROXY:
			return m_aInetOptions.GetProxyNoProxy();

		case CNT_KEY_INET_POPSERVER:
			return String(); //@@@

		case CNT_KEY_INET_PROXYTYPE:
			return String::CreateFromInt32(m_aInetOptions.GetProxyType());

		case CNT_KEY_INET_SECURITYPROXYNAME:
			return String(); //@@@

		case CNT_KEY_INET_SECURITYPROXYPORT:
			return String(); //@@@

		case CNT_KEY_INET_SOCKSPROXYNAME:
			return m_aInetOptions.GetProxySocksName();

		case CNT_KEY_INET_SOCKSPROXYPORT:
			return
				String::CreateFromInt32(m_aInetOptions.GetProxySocksPort());

		case CNT_KEY_INET_SMTPSERVER:
			return String(); //@@@

		case CNT_KEY_INET_SSL:
			return String(); //@@@

		case CNT_KEY_STORAGE_DIR:
			return m_aPathOptions.GetStoragePath();

		case CNT_KEY_USER_FIRSTNAME:
			return m_aUserOptions.GetFirstName();

		case CNT_KEY_USER_NAME:
			return m_aUserOptions.GetLastName();

		case CNT_KEY_USER_LANGUAGE:
			return String::CreateFromInt32(ConvertIsoStringToLanguage(
				                               m_aUserOptions.GetLocale(),
											   '-'));

		default:
			DBG_ERROR("CntIniManager_Impl::getEntry(): Bad key");
			return String();
	}
}

//============================================================================
void CntIniManager_Impl::startSettingsChangeListener()
{
	uno::Sequence< rtl::OUString > aPropertyNames(9);
	aPropertyNames[0] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_DNS_IP_ADDRESS);
	aPropertyNames[1] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_NO_PROXY);
	aPropertyNames[2] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_TYPE);
	aPropertyNames[3] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_FTP_NAME);
	aPropertyNames[4] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_FTP_PORT);
	aPropertyNames[5] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_HTTP_NAME);
	aPropertyNames[6] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_HTTP_PORT);
	aPropertyNames[7] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_SOCKS_NAME);
	aPropertyNames[8] = rtl::OUString::createFromAscii(
		                    SVT_INET_OPTION_PROXY_SOCKS_PORT);
	m_aInetOptions.addPropertiesChangeListener(aPropertyNames, this);
	//@@@ missing:
    //  SVT_INET_OPTION_SMTP_SERVER_NAME
	//  SVT_INET_OPTION_NNTP_SERVER_NAME
	//  SVT_INET_OPTION_POP_SERVER_NAME
	//  SVT_INET_OPTION_PROXY_SECURITY_NAME
	//  SVT_INET_OPTION_PROXY_SECURITY_PORT
	//  SVT_INET_OPTION_MAIL_TEXT_FORMAT
	//  SVT_INET_OPTION_MAIL_USER_NAME
	//  SVT_INET_OPTION_MAIL_PASSWORD
	//  SVT_USER_OPTION_DATA_EMAIL
	//  SVT_USER_OPTION_DATA_FIRST_NAME
	//  SVT_USER_OPTION_DATA_LAST_NAME
}

//============================================================================
void CntIniManager_Impl::stopSettingsChangeListener()
{
	uno::Sequence< rtl::OUString > aPropertyNames(9);
	aPropertyNames[0] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_DNS_IP_ADDRESS);
	aPropertyNames[1] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_NO_PROXY);
	aPropertyNames[2] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_TYPE);
	aPropertyNames[3] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_FTP_NAME);
	aPropertyNames[4] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_FTP_PORT);
	aPropertyNames[5] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_HTTP_NAME);
	aPropertyNames[6] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_HTTP_PORT);
	aPropertyNames[7] = rtl::OUString::createFromAscii(
			                SVT_INET_OPTION_PROXY_SOCKS_NAME);
	aPropertyNames[8] = rtl::OUString::createFromAscii(
		                    SVT_INET_OPTION_PROXY_SOCKS_PORT);
	m_aInetOptions.removePropertiesChangeListener(aPropertyNames, this);
	//@@@ missing:
    //  SVT_INET_OPTION_SMTP_SERVER_NAME
	//  SVT_INET_OPTION_NNTP_SERVER_NAME
	//  SVT_INET_OPTION_POP_SERVER_NAME
	//  SVT_INET_OPTION_PROXY_SECURITY_NAME
	//  SVT_INET_OPTION_PROXY_SECURITY_PORT
	//  SVT_INET_OPTION_MAIL_TEXT_FORMAT
	//  SVT_INET_OPTION_MAIL_USER_NAME
	//  SVT_INET_OPTION_MAIL_PASSWORD
	//  SVT_USER_OPTION_DATA_EMAIL
	//  SVT_USER_OPTION_DATA_FIRST_NAME
	//  SVT_USER_OPTION_DATA_LAST_NAME
}
