/*************************************************************************
 *
 *  $RCSfile: cntnode.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _DATETIME_HXX //autogen
#include <tools/datetime.hxx>
#endif
#ifndef _FSYS_HXX //autogen
#include <tools/fsys.hxx>
#endif
#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _INETTYPE_HXX
#include <svtools/inettype.hxx>
#endif
#ifndef _UNOTOOLS_INTLWRAPPER_HXX
#include <unotools/intlwrapper.hxx>
#endif

#include <cntnode.hxx>

#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _RCPNITEM_HXX
#include <rcpnitem.hxx>
#endif
#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif
#ifndef _STORITEM_HXX
#include <storitem.hxx>
#endif
#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

#ifndef USE_JOB_DISPATCHER
#ifndef CHAOS_TASKBASE_HXX
#include <taskbase.hxx>
#endif
#endif

using namespace chaos;

//============================================================================

#ifdef _CHAOS_STORITEM_REF
SV_IMPL_REF( CntStoreItemSet );
#endif

#define CNT_FSYS_ROOT_URL   "file:///"

//============================================================================
//
// CntNodeFactory Implementation.
//
//============================================================================

CntNodeFactory::CntNodeFactory( const String& rURLPattern,
                                const String& rChildDelims,
                                TypeId        aTypeId,
                                const INetContentType eType,
                                USHORT        nFlags,
                                ULONG         nHelpId,
                                CntNodeFactory* pParent )
: _aURLPattern( WildCard( rURLPattern ) ),
  _aChildDelims( rChildDelims ),
  _aTypeId( aTypeId ),
  _eType( eType ),
  _nFlags( nFlags ),
  _nHelpId( nHelpId ),
  _pParent( pParent ),
  _pInternalScheme( NULL ),
  _pExternalScheme( NULL )
{
    if ( _eType != CONTENT_TYPE_UNKNOWN )
        _aName = INetContentTypes::GetPresentation
		          (_eType,
				   CntRootNodeMgr::GetIniManager()->
                    getIntlWrapper().getLanguage());
}

//----------------------------------------------------------------------------
CntNodeFactory::~CntNodeFactory()
{
	delete _pInternalScheme;
	delete _pExternalScheme;
}

//----------------------------------------------------------------------------
CntNode* CntNodeFactory::CreateInstance( CntNode *pParent, const String& rURL )
{
	// Create new node.
    CntNode* pNewNode = (CntNode *)( _aTypeId() );

	// Initialize new node
    pNewNode->DoInitialize( this, pParent, rURL );

	return pNewNode;
}

//----------------------------------------------------------------------------
BOOL CntNodeFactory::Matches( const String& rURL, CntNodeFactory* pParent )
{
    if ( _aURLPattern.Matches( rURL ) )
    {
        // Recursion?
        if ( pParent == this )
            return TRUE;

        // Matches parent factory the given parent?
        if ( _pParent && ( _pParent != pParent ) )
            return FALSE;

        return TRUE;
    }

    return FALSE;
}

//----------------------------------------------------------------------------
const String& CntNodeFactory::GetInternalScheme() const
{
	if ( !_pInternalScheme )
	{
		String aInternalScheme;
		const String aWild = _aURLPattern.GetWildCard();

		// Special case: HTTP Cache
		if ( aWild.CompareToAscii( "private:httpcache*" ) == COMPARE_EQUAL )
		{
			aInternalScheme.AssignAscii(
					RTL_CONSTASCII_STRINGPARAM( "private:httpcache#" ) );
		}
		else
		{
			xub_StrLen nPos = aWild.Search( ':' );

			if ( nPos != STRING_NOTFOUND )
			{
				INetProtocol eProt
					= INetURLObject::CompareProtocolScheme( aWild );

				switch ( eProt )
				{
					case INET_PROT_PRIVATE:
						nPos++;
						nPos = aWild.Search( ':', nPos );

						if ( nPos == STRING_NOTFOUND )
						{
							xub_StrLen nLast = aWild.Len() - 1;
							if ( aWild.GetChar( nLast ) == '*' )
								nPos = nLast - 1;
						}
						break;

					case INET_PROT_COMPONENT:
						nPos++;
						nPos = aWild.Search( '/', nPos );
						break;

					default:
						break;
				}

				aInternalScheme = aWild.Copy( 0, nPos + 1 );
			}
		}

    	CntNodeFactory* pThis = CONST_CAST( CntNodeFactory*, this );
		pThis->_pInternalScheme = new String( aInternalScheme );
	}

	return *_pInternalScheme;
}

//----------------------------------------------------------------------------
const String& CntNodeFactory::GetExternalScheme() const
{
	if ( !_pExternalScheme )
	{
		String aExternalScheme( GetInternalScheme() );
		if ( aExternalScheme.Len() )
		{
			INetProtocol eProt = INetURLObject::CompareProtocolScheme(
												_aURLPattern.GetWildCard() );
			switch ( eProt )
			{
				case INET_PROT_PRIVATE:
					// Special case: HTTP Cache
					if ( aExternalScheme.CompareToAscii(
									"private:httpcache#" ) == COMPARE_EQUAL )
					{
						aExternalScheme.Erase();
					}
					else
					{
						aExternalScheme.SearchAndReplace(
							UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM(
									INET_PRIVATE_SCHEME ) ),
							UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM(
									INET_VENDOR_SCHEME_PREFIX ) ) );
					}
					break;

				case INET_PROT_COMPONENT:
					aExternalScheme.SearchAndReplace(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								INET_COMPONENT_SCHEME ) ),
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
 								INET_VENDOR_SCHEME_PREFIX ) ) );
					aExternalScheme.SetChar( aExternalScheme.Len() - 1, ':' );
					break;

				case INET_PROT_POP3:
				case INET_PROT_OUT:
				case INET_PROT_VIM:
//				case INET_PROT_NEWS:
					aExternalScheme.Insert(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(
								INET_VENDOR_SCHEME_PREFIX ) ), 0 );
					break;

				default:
					// external == internal
					break;
			}
		}

    	CntNodeFactory* pThis = CONST_CAST( CntNodeFactory*, this );
		pThis->_pExternalScheme = new String( aExternalScheme );
	}

	return *_pExternalScheme;
}

//============================================================================
//
// CntNodeFactoryList Implementation.
//
//============================================================================

CntNodeFactoryList::CntNodeFactoryList()
: List( 4, 4 )
{
}

//----------------------------------------------------------------------------
CntNodeFactoryList::~CntNodeFactoryList()
{
	ULONG nCount = Count();
	for ( ULONG n = 0; n < nCount; ++n )
		delete GetObject( n );
}

//----------------------------------------------------------------------------
void CntNodeFactoryList::Insert( CntNodeFactory* pFactory )
{
    List::Insert( pFactory, LIST_APPEND );
}

//----------------------------------------------------------------------------
void CntNodeFactoryList::Remove( CntNodeFactory* pFactory )
{
    List::Remove( pFactory );
}

//----------------------------------------------------------------------------
// static
CntNodeFactoryList* CntNodeFactoryList::Get( CntNodeFactoryList** ppList )
{
	*ppList = new CntNodeFactoryList;
	CNT_DATA()->_pFactoriesList->Insert( ppList );
	return *ppList;
}

//============================================================================
//
// CntNode Implementation.
//
//============================================================================

//----------------------------------------------------------------------------

BOOL DestroyViewProperties_Impl( CntNodeJob* pJob, CntNode* pNode );
void DumpJob_Impl( CntNode* pNode, CntNodeJob* pJob );

//----------------------------------------------------------------------------

// ranges array
USHORT __READONLY_DATA aNodeDefaultRanges_Impl[] =
{
    WID_CHAOS_START, WID_CHAOS_END,
    0
};

//----------------------------------------------------------------------------

TYPEINIT1( CntNode, CntInterface );

//----------------------------------------------------------------------------
CntNode::CntNode( const USHORT *pRanges )
: CntInterface( pRanges ? pRanges : aNodeDefaultRanges_Impl ),
  _pJobQueue( NULL ),
  _pCurrentJob( NULL ),
  _pSubNodeList( NULL ),
  _xParent( NULL ),
  _xRefered( NULL ),
  _bIsInserted( FALSE ),
  _bDeleteDone( FALSE ),
  _bIsDead( FALSE ),
  _bInitialized( FALSE ),
  _bGetDataDone( FALSE ),
  _bIsDummy( FALSE ),
  _pCreator( NULL ),
  _pUserData( NULL )
{
	// Ensure nodes supporting WID_OPEN, do also support WID_CLOSE...
	if ( GetItemState( WID_OPEN, FALSE ) >= SFX_ITEM_DISABLED )
	{
		if ( GetItemState( WID_CLOSE, FALSE ) < SFX_ITEM_DISABLED )
		{
//			DBG_ERROR(
//				"CntNode::SetReferedNode - WID_CLOSE missing in ranges!" );
			MergeRange( WID_CLOSE, WID_CLOSE );
		}
	}
}

//----------------------------------------------------------------------------
CntNode::~CntNode()
{
    if ( _xRefered.Is() )
        EndListening( *&_xRefered );

    if ( _pJobQueue )
    {
        ULONG nCount = _pJobQueue->Count();
        for ( ULONG n = 0; n < nCount; n++ )
            delete _pJobQueue->GetObject( n );

        delete _pJobQueue;
    }

    DBG_ASSERT( !SubNodeCount(), "~CntNode: There are subnodes!" );
    delete _pSubNodeList;

    CntNodeUserData *pData = GetUserData();
    while ( pData )
    {
        SetUserData( pData->_pNextData );
        delete pData;
        pData = GetUserData();
    }
}

//----------------------------------------------------------------------------
CntNode* CntNode::DoInitialize(
		CntNodeFactory* pCreator, CntNode* pParent, const String& rNodeURL )
{
	DBG_ASSERT( !_bInitialized,
				"CntNode::DoInitialize - Already initialized!" );

    if ( pCreator )
    {
        _pCreator = pCreator;

        // Compatibility stuff.
        _aChildDelims = pCreator->GetChildDelims();
    }

    // RNM neither has a parent nor a (real) URL!
    if ( !pParent )
    {
        // Remember own URL
        CntNode::Put(
            CntStringItem( WID_OWN_URL, rNodeURL ), WID_OWN_URL );
        return this;
    }

    SetParent_Impl( pParent );

    DBG_ASSERT( pParent == GetParent(),
                "CntNode::Initialize - wrong parent!!!" );

    String aOwnURL;
   	const SfxPoolItem* pItem = NULL;
   	if ( GetItemState( WID_OWN_URL, FALSE, &pItem ) != SFX_ITEM_SET )
   	{
       	// Construct own URL from rNodeURL and pParent's URL
       	aOwnURL = rNodeURL;
       	ConstructOwnURL_Impl( aOwnURL );
   	}
   	else
       	aOwnURL = ITEM_VALUE( CntStringItem, *pItem );

    // Remember own URL
    CntNode::Put( CntStringItem( WID_OWN_URL, aOwnURL ), WID_OWN_URL );

	// For nodes other than CntStorageNodes and CntViewNodes, default
	// WID_REAL_URL to WID_OWN_URL:
	if ( GetItemState( WID_REAL_URL ) < SFX_ITEM_SET )
	{
		if ( !( ISA( CntStorageNode ) || ISA( CntViewNode ) ) )
			CntNode::Put(
				CntStringItem( WID_REAL_URL, aOwnURL ), WID_REAL_URL );
	}

    // Insert ourself in parent's child list.
    pParent->InsertChild_Impl( this );

    return this;
}

//----------------------------------------------------------------------------
// virtual
CntNode* CntNode::Initialize( CntNode* pParent, const String& rNodeURL )
{
	if ( _bInitialized )
	{
		//////////////////////////////////////////////////////////////////
		// Re-initialization.
		//////////////////////////////////////////////////////////////////

    	// RNM neither has a parent nor a (real) URL!
    	if ( !pParent )
    	{
        	// Remember own URL
        	CntNode::Put(
            	CntStringItem( WID_OWN_URL, rNodeURL ), WID_OWN_URL );
    	}
		else
		{
    		DBG_ASSERT( pParent == GetParent(),
                		"CntNode::Initialize - wrong parent!!!" );

    		// Remember new URL
    		CntNode::Put(
				CntStringItem( WID_OWN_URL, rNodeURL ), WID_OWN_URL );

			if ( !( ISA( CntStorageNode ) || ISA( CntViewNode ) ) )
				CntNode::Put(
					CntStringItem( WID_REAL_URL, rNodeURL ), WID_REAL_URL );

    		// Set dummy state according to new URL.
    		_bIsDummy = IsDummyURL_Impl( rNodeURL );

    		// Reinsert me at my parent. My own URL may have changed - so
    		// parents subnode list must be resorted.
    		GetParent()->_pSubNodeList->Remove( this );
    		GetParent()->InsertChild_Impl( this );
		}
	}
	else
	    _bInitialized = TRUE;

    return this;
}

//----------------------------------------------------------------------------
// virtual
void CntNode::QueryDelete()
{
	// About to be destroyed!

	if ( _xParent.Is() )
	{
		NAMESPACE_VOS( OGuard ) aGuard( _xParent->getMutex() );

		// Has another thread set a reference on 'this' in the meantime?
		if ( GetRefCount() > 0 )
			return;

		// Detach from parent.
   		_xParent->Removed( this );
	}

	// Destroy 'this'!
	CntInterface::QueryDelete();
}

//----------------------------------------------------------------------------
// virtual
void CntNode::GetOwnURL( String& rOwnURL )
{
    CntNode* pParent = GetParent();

    if ( !pParent )
        return;

    ///////////////////////////////////////////////////////////////////////
    // Construction of own URL...
    ///////////////////////////////////////////////////////////////////////

    String aParentURL( OWN_URL( pParent ) );
    xub_StrLen nSearchPos = 0;

    if ( aParentURL.Len() == 0 )
    {
        //////////////////////////////////////////////////////////////////
        // Parent is the RNM -> 'this' is a root node.
        //////////////////////////////////////////////////////////////////

        String aWild( GetCreator()->GetWildCard() );
        if ( rOwnURL.Len() > aWild.Len() )
            nSearchPos = rOwnURL.Match( aWild );
        else
            nSearchPos = aWild.Match( rOwnURL );

		// Special cases...
		if ( rOwnURL.GetChar( nSearchPos - 1 ) == '/' )
		{
			if ( rOwnURL.GetChar( nSearchPos - 2 ) == '/' )
			{
				if ( rOwnURL.GetChar( nSearchPos - 3 ) == '/' )
				{
					// e.g. "file:///..." must be searched from 3rd slash.
					--nSearchPos;
				}
			}
			else
			{
				// e.g.: ".component:ss/..." must be searched from 1st slash.
				--nSearchPos;
			}
		}
    }
    else
    {
        //////////////////////////////////////////////////////////////////
        // Parent is not the RNM -> 'this' is not a root node.
        //////////////////////////////////////////////////////////////////

        nSearchPos = rOwnURL.Match( aParentURL );

        // If my URL part starts with a child delimiter of my parent,
        // it must be skipped in further processing.
        if ( pParent->IsChildDelim_Impl( rOwnURL, nSearchPos ) )
            nSearchPos++;

    }

    //////////////////////////////////////////////////////////////////////
    // Search a child delimiter of 'this' in rOwnURL, cut it at that pos.
    //////////////////////////////////////////////////////////////////////

    const String& rDelims = GetChildDelims();

    xub_StrLen nDelims = rDelims.Len();
    for ( USHORT n = 0; n < nDelims; ++n )
    {
        sal_Unicode cCurrDel = rDelims.GetChar( n );

        xub_StrLen nPos = rOwnURL.Search( cCurrDel, nSearchPos );
        if ( nPos != STRING_NOTFOUND )
        {
            // Do not cut a final '/'!
            if ( rOwnURL.GetChar( nPos ) != '/' )
                nPos--;
            else if ( nPos && ( rOwnURL.GetChar( nPos - 1 ) == ':' ) )
            {
                // Another URL scheme in URL - ignore!
                continue;
            }

            // Gotcha!
            rOwnURL.Erase( nPos + 1 );
            break;
        }
    }

    //////////////////////////////////////////////////////////////////////
    // Remove trailing child delimiters, if 'this' cannot have children.
    //////////////////////////////////////////////////////////////////////

    if ( nDelims == 0 )
    {
        xub_StrLen nLast = rOwnURL.Len() - 1;
        while ( pParent->IsChildDelim_Impl( rOwnURL, nLast ) )
        {
            rOwnURL.Erase( nLast );
            nLast--;
        }
    }
}

//----------------------------------------------------------------------------
CntNode* CntNode::Query( const String& rNodeURL, BOOL bCreate )
{
    if ( IsDead() )
        return NULL;

    String aNodeURL( rNodeURL );

/*
#ifdef DBG_UTIL
    if ( !GetParent() )
    {
        NormalizeURL( aNodeURL );
		DBG_ASSERT( aNodeURL == rNodeURL, "CntNode::Query: Invalid URL!" );
    }
#endif
*/

    xub_StrLen nLenInURL = aNodeURL.Len();
    if ( !nLenInURL )
        return NULL;

    String aOwnURL( OWN_URL( this ) );
    xub_StrLen nLenOwnURL = aOwnURL.Len();

    // In case aNodeURL is 'shorter' than own URL the requested node cannot be
    // one of our children.

    // Special case, where nLenOwnURL > nLenInURL:
    // i.e. rNodeURL = "news://sdnews" In the system, there exists
	// a node with the URL "news://sdnews/", which must be found!

	bool bSelf    = false;
	bool bMatched = false;
	if (nLenInURL == nLenOwnURL)
		if (aNodeURL == aOwnURL)
			bSelf = true;
		else
			return 0;
	else if (nLenInURL == nLenOwnURL + 1)
		if (aOwnURL.Match(aNodeURL) == STRING_MATCH)
		{
			if (IsChildDelim_Impl(aNodeURL, nLenOwnURL))
				bSelf = true;
			else
				bMatched = true;
		}
	else if (nLenOwnURL == nLenInURL + 1)
		if (aNodeURL.Match(aOwnURL) == STRING_MATCH
			&& IsChildDelim_Impl(aOwnURL, nLenInURL))
			bSelf = true;
		else
			return 0;
	else if (nLenInURL < nLenOwnURL)
		return 0;

    if ( bSelf )
	{
		// Node is locked until it is completely initialized.
		// So we can be sure never to return an uninitialized
		// node.
		getMutex().acquire();
		getMutex().release();
        return this;
	}

    // Can aNodeURL be a child?
	if ( !bMatched && ( aOwnURL.Match( aNodeURL ) != STRING_MATCH ) )
		return NULL;

    return QueryChildren_Impl( aNodeURL, bCreate );
}

//----------------------------------------------------------------------------
String ReplaceWildCard_Impl( const String& rWild, const String& rString )
{
    String aTitle( rWild );

    xub_StrLen nPos = aTitle.Search( '*' );
    if ( nPos == STRING_NOTFOUND )
    {
        aTitle += rString;
    }
    else
    {
#ifdef DBG_UTIL
        if ( aTitle.Search( '*', ++nPos ) != STRING_NOTFOUND )
        {
            DBG_ERROR( "ReplaceWildCard_Impl: wildcard invalid!" );
        }
#endif
        aTitle.SearchAndReplace( '*', rString );
    }

    return aTitle;
}

//----------------------------------------------------------------------------
String CntNode::CreateInterimURL( CntNodeFactory* pFac /* = NULL */ )
{
    //  Scheme for a interim URL:
    //  Parent-URL +  Child-URL prefix + "Interim" + current date
    //  + current time + (ULONG)this + counter + Child-URL postfix

    String aURL( OWN_URL( this ) );

    UniString aInterim(	UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "Interim" ) ) );
    DateTime aCurrDateTime; // now
    aInterim += UniString::CreateFromInt32( aCurrDateTime.GetDate() );
    aInterim += UniString::CreateFromInt32( aCurrDateTime.GetTime() );
    aInterim += UniString::CreateFromInt32( sal_Int32( this ) );

    ULONG& rnCounter = CNT_DATA()->_nInterimURL;
    aInterim += UniString::CreateFromInt32( rnCounter );
    ++rnCounter;

    if ( !pFac )
    {
        xub_StrLen nLen = aURL.Len();
        if ( nLen )
        {
            const String rDelims = GetChildDelims();
            sal_Unicode  aChar;

            if ( rDelims.Len() == 0 )
            {
                DBG_ERROR( "CreateInterimURL: node has no child delimiters!" );
                aChar = '/';
            }
            else
            {
                DBG_ASSERT( rDelims.Len() < 2,
                            "CreateInterimURL: node has more then 1 child"
                            " delimiter - defaulting to first!!!" );

                aChar = rDelims.GetChar( 0 );
            }

            if ( aURL.GetChar( nLen - 1 ) != aChar )
                aURL += aChar;
        }
    }
    else
    {
        aInterim = ReplaceWildCard_Impl( pFac->GetWildCard(), aInterim );

        xub_StrLen nLast = aURL.Len() - 1;
        if ( aURL.GetChar( nLast ) == aInterim.GetChar( 0 ) )
            aURL.Erase( nLast );

    }

    aURL += aInterim;

    return aURL;
}

//----------------------------------------------------------------------------
// virtual
void CntNode::SetReferedNode( CntNode* pNode )
{
    if ( _xRefered == pNode )
        return;

	getMutex().acquire();

    if ( _xRefered.Is() )
        EndListening( *&_xRefered );

    CntInterface::SetParent( pNode );
    _xRefered = pNode;

	getMutex().release();

    // remember refered URL
    CntNode::Put( CntStringItem( WID_REFERED_URL, OWN_URL( pNode ) ),
				  WID_REFERED_URL );
    StartListening( *pNode );
}

//----------------------------------------------------------------------------
CntNode* CntNode::GetMostReferedNode() const
{
    CntNode* pNode = CONST_CAST( CntNode*, this );
    while ( pNode->_xRefered.Is() )
        pNode = pNode->_xRefered;

    return pNode;
}

//----------------------------------------------------------------------------
CntNode* CntNode::GetRootNode() const
{
    CntNode* pRoot = CONST_CAST( CntNode*, this );
    while ( pRoot->GetParent() && ( pRoot->GetParent() != CNT_RNM() ) )
        pRoot = pRoot->GetParent();

    return pRoot;
}

//------------------------------------------------------------------------
BOOL CntNode::IsRootNode() const
{
    return ( &_xParent == CNT_RNM() );
}

//----------------------------------------------------------------------------
// virtual
void CntNode::Inserted( CntNode *pNewNode, CntNodeJob* pJob, BOOL bBroadcast )
{
    if ( pNewNode == this )
    {
        DBG_ERROR( "CntNode::Inserted - Cannot insert into myself" );
        return;
    }

    // adopt node...
    pNewNode->SetInserted_Impl();

    if ( bBroadcast )
        Broadcast( CntNodeHint( pNewNode, CNT_ACTION_INSERTED, pJob ) );
}

//----------------------------------------------------------------------------
void CntNode::Removed( CntNode *pNode )
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    if ( _pSubNodeList )
    {
       	_pSubNodeList->Remove( pNode );

       	if ( _pSubNodeList->Count() == 0 )
       	{
           	delete _pSubNodeList;
           	_pSubNodeList = NULL;
       	}
    }
}

//------------------------------------------------------------------------
CntNodeJobQueue* CntNode::GetJobQueue()
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    if ( !_pJobQueue )
    {
        // Create new job queue...
        _pJobQueue = new CntNodeJobQueue;

        // ... and the standard (first) job list.
        _pJobQueue->Insert( new CntNodeJobList );
    }

    return _pJobQueue;
}

//------------------------------------------------------------------------
void CntNode::EnqueueJob( CntNodeJob* pJob )
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    CntNodeJobQueue* pJobQueue = GetJobQueue();
    CntNodeJobList*  pJobList  = pJobQueue->GetObject( 0 );

    // Insert job in standard (first) job list.
    pJobList->Insert( pJob, LIST_APPEND );

#ifdef DBG_UTIL
#ifndef USE_JOB_DISPATCHER
    if ( ( CNT_RNM() != this ) && ( pJobList->Count() > 1 ) )
	{
		ChaosTaskBase* pTask = pJob->getTaskBase();
		if ( pTask && pTask->isSynchronous() )
		{
			DBG_ERROR( "CntNode::EnqueueJob - "
				   	   "Synchronous UCB task in queue may cause deadlock!" );
		}
	}
#endif
#endif
}

//----------------------------------------------------------------------------
CntNodeJob* CntNode::DequeueJob( CntNodeJob *pJob )
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    if ( !_pJobQueue )
        return NULL;

    CntNodeJobList* pJobList = _pJobQueue->GetObject( 0 );

    if ( !pJobList )
        return NULL;

    // Note: If pJobList is empty after removing pJob, it will not be
    //       destroyed to avoid "create/destroy" sequences (overhead!)
    //       assuming a node ones processed a job will do it again.

    // Remove job from standard (first) job list.
    return pJobList->Remove( pJob );
}

//------------------------------------------------------------------------
//virtual
const SfxPoolItem* CntNode::JobArrived( CntNodeJob *pJob )
{
    if ( pJob->IsSynchronous() )
    {
        // Synchronous jobs are always executed immediately.
        return DoExecuteJob( pJob );
    }

    // Enqueue asynchronous job.
    EnqueueJob( pJob );

    if ( _pJobQueue->GetObject( 0 )->Count() == 1 )
    {
#ifdef USE_JOB_DISPATCHER
        // I'm idle - job can be executed (almost) immediately.
		// This prevents a synchronous call stack for an asynchronous job.
		if ( getJobDispatcher() )
	    	new CntJobRescheduler( this, pJob );
		else
			pJob->Cancel();

		return NULL;
#else
        // I'm idle - job can be executed immediately. - This results in a
		// synchronous call stack for an asynchronous job!
        return DoExecuteJob( pJob );
#endif /* USE_JOB_DISPATCHER */
    }

    // Busy.
    return NULL;
}

//------------------------------------------------------------------------
//virtual
BOOL CntNode::JobFinished( CntNodeJob *pJob )
{
    if ( pJob->IsSynchronous() )
    {
        // Nothing to do on end of a synchronous job.
        return TRUE;
    }

    // Asynchronous job finished...

    BOOL bIsCurrent = ( GetCurrentJob() == pJob );

    // Remove job and continue with next
    if ( !DequeueJob( pJob ) )
        return FALSE;

    if ( _pJobQueue && _pJobQueue->GetObject( 0 )->Count() && bIsCurrent )
#ifdef USE_JOB_DISPATCHER
	{
		if ( getJobDispatcher() )
	    	new CntJobRescheduler( this, GetJob( 0 ) );
		else
			GetJob( 0 )->Cancel();
	}
#else
        new CntJobRescheduler( this, GetJob( 0 ) );
#endif

    return TRUE;
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntNode::InsertJob( CntNodeJob *pJob )
{
    const SfxPoolItem* pReq   = pJob->GetRequest();
    USHORT             nWhich = pReq->Which();
    switch ( nWhich )
    {
        case WID_DELETE:
            if ( !ITEM_VALUE( CntBoolItem, *pReq ) &&
                 CntViewBase::IsRootViewURL( OWN_URL( this ) ) )
            {
                // First, release all children!
                Broadcast( CntNodeHint( this, CNT_ACTION_KILL_ALL, pJob ) );
                pJob->Done();
                return NULL;
            }

            if ( _xRefered && _xRefered->_bDeleteDone )
            {
                // Enqueue job.
                pJob->AddRef();
                StartListening( *pJob );
                EnqueueJob( pJob );
                return DoExecuteJob( pJob );
            }
            break;

        default:
            break;
    }

    // Jobs are generally processed by most refered node (service node).
    if ( _xRefered )
    {
        pJob->SetSubject( _xRefered );
        return _xRefered->InsertJob( pJob );
    }

    return DoInsertJob( pJob );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntNode::DoInsertJob( CntNodeJob *pJob )
{
    pJob->AddRef();
    StartListening( *pJob );

    // Synchronous jobs are always handled by base class.
    if ( pJob->IsSynchronous() )
        return CntNode::JobArrived( pJob );

    return JobArrived( pJob );
}

//----------------------------------------------------------------------------
BOOL CntNode::RemoveJob( CntNodeJob *pJob )
{
    BOOL bSuccess = FALSE;
    BOOL bSyncJob = pJob->IsSynchronous();
    if ( bSyncJob )
        bSuccess = CntNode::JobFinished( pJob );
    else
        bSuccess = JobFinished( pJob );

    if ( bSuccess )
    {
        if ( ( GetCurrentJob() == pJob ) && !bSyncJob )
            _pCurrentJob = NULL;

        // Attention: The job may be the only one holding a reference on
        //            "this". So "this" may be destroyed after following
        //            ReleaseRef()!!!
        pJob->ReleaseRef();
    }

    return bSuccess;
}

//----------------------------------------------------------------------------
void BroadcastRecursive_Impl(
					CntNode* pNode, CntAction eAction, CntNodeJob* pJob )
{
    if ( !pNode )
        return;

    CntNodeRef xNode = pNode;

	{
		NAMESPACE_VOS( OGuard ) aGuard( pNode->getMutex() );

    	ULONG nCount = pNode->SubNodeCount();
    	for ( ULONG n = 0; n < nCount; ++n )
        	BroadcastRecursive_Impl( pNode->GetSubNode( n ), eAction, pJob );
	}

    pNode->Broadcast( CntNodeHint( pNode, eAction, pJob ) );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntNode::DoExecuteJob( CntNodeJob *pJob )
{
#ifdef DBG_CHAOS_LOG_JOBS
    DumpJob_Impl( this, pJob );
#endif

    pJob->Started();

    if ( pJob->GetSubject()->IsDead() )
    {
//        DBG_ERROR( "CntNode::DoExecuteJob - subject is dead!" );
        pJob->Cancel();
        return NULL;
    }

    CntNodeJobRef xJob   = pJob;
    USHORT        nWhich = pJob->GetRequest()->Which();
    switch ( nWhich )
    {
        case WID_PUTDATA:
            // complete request ( needed for correct boot strapping only )
            CompletePutDataRequest_Impl( pJob );
            break;

        case WID_CREATE_NEW:
		{
            CntItemListItem *pListItem = (CntItemListItem *)pJob->GetRequest();

            // Find factory for given node type.
            INetContentType eType = (INetContentType)
                        ITEM_VALUE( CntUInt16Item,
                                    *( pListItem->Get( WID_FACTORY_NO ) ) );

            CntNodeFactory* pFac = NULL;
            ULONG nFacs = FactoryCount();
            for ( ULONG i = 0; i < nFacs; i++ )
            {
                pFac = GetFactory( i );
                if ( pFac->GetId() == eType )
                    break;
                else
                    pFac = NULL;
            }

			if ( pFac && ( pFac->GetFlags() & CNT_CREATION_FLAG_TITLE ) )
			{
				// Title required, but not given?
				const CntStringItem* pItem =
					static_cast< const CntStringItem * >(
											pListItem->Get( WID_TITLE ) );
				if ( !pItem || !pItem->GetValue().Len() )
				{
					String aTitle(INetContentTypes::GetPresentation
								   (eType,
									CntRootNodeMgr::GetIniManager()->
                                     getIntlWrapper().getLanguage()));
					if ( !pItem )
                    	pListItem->Append(
							new CntStringItem( WID_TITLE, aTitle ) );
					else
						const_cast<
							CntStringItem * >( pItem )->SetValue( aTitle );
                }
            }

			break;
		}

        case WID_DELETE:
        {
            CntNode* pSubject = pJob->GetSubject();
            if ( pSubject->SubNodeCount() )
            {
                // First, release all children!
                pSubject->Broadcast(
					CntNodeHint( pSubject, CNT_ACTION_KILL_ALL, pJob ) );

				{
					NAMESPACE_VOS( OGuard ) aGuard( pSubject->getMutex() );

                	ULONG nCount = pSubject->SubNodeCount();
                	for ( ULONG n = 0; n < nCount; ++n )
                    	BroadcastRecursive_Impl( pSubject->GetSubNode( n ),
                        	                     CNT_ACTION_DELETED, pJob );
				}
            }
            break;
        }

        default:
            break;
    }

    if ( !pJob->IsRescheduled() && !pJob->IsSynchronous() )
        _pCurrentJob = pJob;

    return ExecuteJob( pJob );
}

//----------------------------------------------------------------------------
// virtual
const SfxPoolItem* CntNode::ExecuteJob( CntNodeJob *pJob )
{
    CntNode *pSubject = pJob->GetSubject();

    // Job forwarded from descendant and not handled by protocol node?
    if ( this != pSubject )
    {
#ifdef DBG_UTIL
		CntNode * pNode = pSubject;
		while ( pNode && ( pNode != this ) )
			pNode = pNode->GetParent();

		DBG_ASSERT( pNode == this,
				    "CntNode::ExecuteJob(): Subject not a descendant" );
#endif
        // Bounce it back!
        return pSubject->CntNode::InsertJob( pJob );
    }

    const SfxPoolItem* pReq = pJob->GetRequest();
    USHORT nWhich = pReq->Which();
    switch ( nWhich )
    {
        case WID_CREATE_NEW:
        {
            CntItemListItem *pListItem = (CntItemListItem *)pReq;

            String     aURL;
            CntNodeRef xParent = this;

            // Find factory for given node type.
            INetContentType eType = (INetContentType)
                        ITEM_VALUE( CntUInt16Item,
                                    *( pListItem->Get( WID_FACTORY_NO ) ) );

            CntNodeFactory* pFac = NULL;
            ULONG nFacs = FactoryCount();
            for ( ULONG i = 0; i < nFacs; i++ )
            {
                pFac = GetFactory( i );
                if ( pFac->GetId() == eType )
                    break;
                else
                    pFac = NULL;
            }

            // Root-Node to create?
            BOOL bRoot = FALSE;
            if ( !pFac )
            {
                nFacs = CNT_RNM()->FactoryCount();
                for ( ULONG i = 0; i < nFacs; i++ )
                {
                    pFac = CNT_RNM()->GetFactory( i );
                    if ( pFac->GetId() == eType )
                    {
                        bRoot = TRUE;
                        break;
                    }
                    else
                        pFac = NULL;
                }
            }

            if ( !pFac )
            {
                DBG_ERROR( "WID_CREATE_NEW: No factory found!" );
                pJob->Done();
                return NULL;
            }

            if ( !bRoot )
            {
                USHORT nCount = pListItem->Count();
                for ( USHORT n = 0; n < nCount; n++ )
                {
                    // URL for new node supplied?
                    if ( (*pListItem)[n].Which() == WID_OWN_URL )
                    {
                        aURL = ITEM_VALUE( CntStringItem,
                                           (*pListItem)[ n ] );
                        pListItem->Remove( n );

						// #83140# The FTP code deliberately generates an
						// 'illegal' URL when asked to create a new folder or
						// document.  Therefore, that URL must not be
						// normalized (it would be transformed into a 'legal'
						// one).  And since the URLs that are considered here
						// are always created within the CHAOS code, there
						// should never be a need to normalize one, anyway:
#if 0
                        if ( !NormalizeURL( aURL ) )
                        {
                            pJob->Cancel();
                            return NULL;
                        }
#endif

                        break;
                    }
                }

                if ( !aURL.Len() )
                {
#if 0
	// Done in DoExecuteJob already

                    if ( pFac->GetFlags() & CNT_CREATION_FLAG_TITLE )
                    {
                        // Title required, but not given?
                        if ( !pListItem->Get( WID_TITLE ) )
                        {
                            String
							 aTitle(INetContentTypes::GetPresentation
									 (eType,
									  CntRootNodeMgr::GetIniManager()->
                                       getIntlWrapper().getLanguage()));
                            pListItem->Append(
                                new CntStringItem( WID_TITLE, aTitle ) );
                        }
                    }
#endif
                    nCount = pListItem->Count();
                    for ( USHORT n = 0; n < nCount; n++ )
                    {
                        if ( (*pListItem)[n].Which() == WID_TITLE )
                        {
                            // Assemble URL for the new node...
                            aURL = OWN_URL( this );

                            if ( IsRootNode() )
                            {
                                // Process server base, if exists.

                                // Note: The server base string must be
                                //       formatted correctly. For instance
                                //       it must be finalized by a slash
                                //       for FTP...
                                String aBase( ITEMSET_VALUE(
                                                pJob->GetClient(),
                                                CntStringItem,
                                                WID_SERVERBASE ) );
                                if ( aBase.Len() )
                                {
                                    if ( IsChildDelim_Impl( aBase, 0 ) )
                                    {
                                        if ( aBase.GetChar( 0 ) ==
                                             aURL.GetChar( aURL.Len() - 1 ) )
                                            aBase.Erase( 0, 1 );
                                    }
                                    else
                                    {
                                        const sal_Unicode aChar =
                                            pFac->GetWildCard().GetChar( 0 );
                                        if ( ( aBase.GetChar( 0 ) != aChar ) &&
                                             ( aURL.GetChar( aURL.Len() - 1 )
                                               != aChar ) )
                                            aURL += aChar;
                                    }

                                    aURL += aBase;

                                    xParent = Query( aURL );
                                }
                            }

                            const String aTitle(
                                ReplaceWildCard_Impl( pFac->GetWildCard(),
                                     ITEM_VALUE( CntStringItem,
                                                 (*pListItem)[ n ] ) ) );

                            xub_StrLen nLast = aURL.Len() - 1;
                            if ( aURL.GetChar( nLast ) == aTitle.GetChar( 0 ) )
                                aURL.Erase( nLast );

                            aURL += aTitle;

                            // The WID_TITLE item was only temporary...
                            pListItem->Remove( n );

                            if ( !NormalizeURL( aURL ) )
                            {
                                pJob->Cancel();
                                return NULL;
                            }

                            break;
                        }
                    }
                }

                if ( pFac->GetFlags() & CNT_CREATION_FLAG_SENDMESSAGE )
                {
                    DBG_ASSERT( eType == CONTENT_TYPE_X_CNT_MESSAGE,
                            "WID_CREATE_NEW: OutTray only handles messages!" );

                    // Node is a message to be sent via the outtray
                    xParent = CNT_RNM()->Query(
								UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM(
										"out:///~" ) ) );

                    nFacs = xParent->FactoryCount();
                    for ( ULONG j = 0; j < nFacs; j++ )
                    {
                        pFac = xParent->GetFactory( j );
                        if ( pFac->GetId() == eType )
                            break;
                        else
                            pFac = NULL;
                    }

                    if ( !pFac )
                    {
                        DBG_ERROR( "WID_CREATE_NEW: No factory found!" );
                        pJob->Cancel();
                        return NULL;
                    }
                }
            }
            else
            {
                // Creation of new view to root node.
                xParent = CNT_RNM();
            }

            // Node is to be constructed via property tabpage.
            if ( !aURL.Len() &&
                 ( bRoot ||
                   ( pFac->GetFlags() & CNT_CREATION_FLAG_PROPERTIES ) ) )
            {
                aURL = OWN_URL( xParent );

				String aWild( pFac->GetWildCard() );
				if ( !bRoot &&
					 ( aWild.GetChar( 0 ) == aURL.GetChar( aURL.Len() - 1 ) ) )
					aWild.Erase( 0, 1 );

                aURL += aWild;

                // Compatibility stuff.
                if ( bRoot && ( aURL.GetChar( aURL.Len() - 1 ) == '*' ) )
                    aURL.Erase( aURL.Len() - 1 );
            }

            // No URL yet? -> Create interim-URL for new node.
            if ( !aURL.Len() )
                aURL = xParent->CreateInterimURL();

            // Create a new node and initialize it.

            CntNodeRef xNewNode( NULL );

            if ( CntViewBase::IsRootViewURL( pFac->GetWildCard() ) )
            {
                // Creation of "special" view node (not root storage).

                String aWild( pFac->GetWildCard() );
                aURL = OWN_URL( this );

				if ( INetURLObject::CompareProtocolScheme( aURL )
				     == INET_PROT_FILE )
				{
					aURL.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "temp" ) );

    	            xub_StrLen nPos = aWild.Search( '*' );

        	        DBG_ASSERT( nPos != STRING_NOTFOUND,
            	                "WID_CREATE_NEW: invalid factory wildcard!" );

                	aURL += aWild.Copy( nPos + 1 );

                	// Make sure, a file with the name just calculated does
                	// not exist.
                	DirEntry aNewFile( aURL, FSYS_STYLE_URL );
                	if ( aNewFile.Exists() )
                	{
                    	aURL = OWN_URL( this );
                    	DirEntry aNew( aURL, FSYS_STYLE_URL );
                    	aNew.MakeShortName( aNewFile.GetName() );
                    	aURL += aNew.GetName();
                	}

                	xNewNode = xParent->CreateChild_Impl( pFac, aURL );
					xNewNode->_bIsDummy = TRUE;
				}
            }
            else if ( !bRoot )
            {
                xNewNode = xParent->CreateChild_Impl( pFac, aURL );
            }
            else
            {
                String aViewURL( OWN_URL( this ) );

				if ( INetURLObject::CompareProtocolScheme( aViewURL )
					 == INET_PROT_FILE )
				{
                	aViewURL.AppendAscii(
							RTL_CONSTASCII_STRINGPARAM( "temp." ) );
                	aViewURL.AppendAscii(
							RTL_CONSTASCII_STRINGPARAM( STG_FILE_EXTENSION ) );

                	// Make sure, a file with the name just calculated does
                	// not exist.
                	DirEntry aNewFile( aViewURL, FSYS_STYLE_URL );
                	if ( aNewFile.Exists() )
                	{
                    	aViewURL = OWN_URL( this );
                    	DirEntry aNew( aViewURL, FSYS_STYLE_URL );
                    	aNew.MakeShortName( aNewFile.GetName() );
                    	aViewURL += aNew.GetName();
                	}

                	// Create View Storage file.
                	ErrCode nError = CntRootStorageNode::create( aViewURL );
                	if ( nError == ERRCODE_NONE )
                	{
                    	xNewNode = CNT_RNM()->Query( aViewURL );
                    	if ( xNewNode.Is() )
                    	{
                        	CntAnchorRef xAnchor(
											new CntAnchor( NULL, xNewNode ) );

                        	// HACK(): Jeder root node kriegt einen Cache!
                        	aURL.Insert(
								UniString::CreateFromAscii(
									RTL_CONSTASCII_STRINGPARAM(
							  			STG_PROTOCOL_CACHE ) ), 0 );

                        	xAnchor->Put(
									CntStringItem( WID_REFERED_URL, aURL ) );

                        	if ( !xNewNode->GetReferedNode() )
                        	{
                            	// Error
                            	xAnchor->Put( CntBoolItem( WID_DELETE, TRUE ) );
                            	pJob->Cancel();
                            	return NULL;
                        	}
                    	}
                	}
				}
            }

			DBG_ASSERT( xNewNode.Is(), "WID_CREATE_NEW - No node created!" );
            pJob->Done();

            return new CntNodeItem( 0, xNewNode );
        }

        case WID_DELETE:
        {
            if ( SubNodeCount() )
            {
                // First, release all children!
                Broadcast( CntNodeHint( this, CNT_ACTION_KILL_ALL, pJob ) );
            }

            // Physically destroy or move to "trash" ?
            BOOL bDestroy = ITEM_VALUE( CntBoolItem, *pReq );

            ULONG nReferers = ( (const CntUInt32Item&)
                                Get( WID_REFERER_COUNT, FALSE ) ).GetValue();
            if ( bDestroy )
            {
				if ( nReferers )
                	nReferers--;

                if ( nReferers )
                    Put( CntUInt32Item( WID_REFERER_COUNT, nReferers ) );

                // Destroy persistemt view properties.
                DestroyViewProperties_Impl( pJob, this );
            }

            _bDeleteDone = TRUE;

            if ( !nReferers && bDestroy )
            {
                _bIsDead = TRUE;

                // Kill all outstanding jobs!
                ULONG n = 0;
                while( JobCount() > 1 )
                {
                    CntNodeJob* pCurr = GetJob( n );
                    if ( pCurr == pJob )
                        n = 1;
                    else
                        pCurr->Cancel();
                }
            }

            // The info is temporary needed for processing the broadcast
            CntInterface::Put( *pReq, WID_DELETE );

            DBG_ASSERT( pJob->GetClient()->ISA( CntAnchor ),
                        "Client for WID_DELETE job must be a CntAnchor!" );

            if ( ( (CntAnchor*)pJob->GetClient() )->GetNode() == this )
            {
                // Last node processed delete operation. Inform all
                // relevant views.
                CntNode* pSubject = this;
                if ( !CntViewBase::IsRootViewURL( OWN_URL( this ) ) )
                    pSubject = GetMostReferedNode();

                pSubject->Broadcast(
							CntNodeHint( pSubject, CNT_ACTION_DELETED, pJob ) );
            }
            else
            {
                // Operation not finished yet!
                pJob->Broadcast(
							CntNodeHint( this, CNT_ACTION_DELETED, pJob ) );
            }

            CntInterface::Put( CntBoolItem( WID_DELETE, FALSE ), WID_DELETE );

            pJob->Done();
            return NULL;
        }

        case WID_MESSAGEVIEW_MODE:
            SwitchMessageViewMode_Impl( pJob, *pReq );
            break;

        case WID_SENTMESSAGEVIEW_MODE:
            SwitchSentMessageViewMode_Impl( pJob, *pReq );
            break;

        case WID_FOLDERVIEW_MODE:
            SwitchFolderViewMode_Impl( pJob, *pReq );
            break;

        case WID_FILTERED:
            SwitchFilter_Impl( pJob, *pReq );
            break;

        case WID_THREADED:
            SwitchThreading_Impl( pJob, *pReq );
            break;

        case WID_GETDATA:
        {
            if ( _bGetDataDone )
                break;

            ////////////////////////////////////////////////////
            // get user data
            ////////////////////////////////////////////////////

            // Assemble name of property-stream.
            String aPropsName( GetPropertyKey() );
            CntStorageNode* pStgNode = pJob->GetUserDataNode( FALSE );
            if ( pStgNode && !pStgNode->IsDummy() )
            {
                CntStoreItemSetRef xUserSet(
                        pStgNode->openItemSet( aPropsName, STREAM_STD_READ ) );

                if ( xUserSet.Is() )
                    CntNode::Put( *xUserSet );
            }

            _bGetDataDone = TRUE;
            break;
        }

        case WID_PUTDATA:
        {
            const CntItemListItem *pListItem = (const CntItemListItem *)pReq;
            USHORT nCount = pListItem->Count();
            for ( USHORT n = 0; n < nCount; n++ )
            {
                const SfxPoolItem& rItem = (*pListItem)[n];
                USHORT nWhichId = rItem.Which();
                switch ( nWhichId )
                {
                    case WID_SERVERNAME:
                        // Workaround:
                        // Sometimes the UI puts empty server names!
                        if ( !( ITEM_VALUE( CntStringItem, rItem ).Len() ) )
                        {
                            // Do never store empty server names...
                            continue;
                        }
                        break;

                    case WID_MESSAGEVIEW_MODE:
                        SwitchMessageViewMode_Impl( pJob, rItem );
                        break;

                    case WID_SENTMESSAGEVIEW_MODE:
                        SwitchSentMessageViewMode_Impl( pJob, rItem );
                        break;

                    case WID_FOLDERVIEW_MODE:
                        SwitchFolderViewMode_Impl( pJob, rItem );
                        break;

                    case WID_FILTERED:
                        SwitchFilter_Impl( pJob, rItem );
                        break;

                    case WID_THREADED:
                        SwitchThreading_Impl( pJob, rItem );
                        break;

                    default:
                        break;
                }

                // store the item in the appropriate storage node...
                StoreItem_Impl( pJob, rItem );
            }
            pJob->Done();
            return NULL;
        }

        case WID_DEFAULT:
        {
            CntUShortListItem* pListItem = (CntUShortListItem *)pReq;
            USHORT nCount = pListItem->Count();
            if ( !nCount )
            {
                // reset all auto inherited items
                SfxWhichIter aIter( *this );
                USHORT nWhichId = aIter.FirstWhich();
                while ( nWhichId )
                {
                    if ( pSubject->IsItemFlag(
                                        nWhichId, CNT_ITEM_AUTO_INHERIT ) )
                        pListItem->Append( nWhichId );

                    nWhichId = aIter.NextWhich();
                }
            }

            // reset all items
            nCount = pListItem->Count();
            for ( USHORT n = 0; n < nCount; n++ )
            {
                USHORT nWhichId = (*pListItem)[ n ];

				if ( pSubject->GetItemState( nWhichId ) <= SFX_ITEM_DISABLED )
					continue;

                // erase stored item
                EraseItem_Impl( pJob, nWhichId );

                CntAnchor* pClient = NULL;
                if ( pJob->GetClient()->ISA( CntAnchor ) )
                    pClient = (CntAnchor*)pJob->GetClient();
                else
                {
                    DBG_ERROR( "Client for WID_DEFAULT not a CntAnchor!" );
                    break;
                }

                const SfxPoolItem* pItem = NULL;

                if ( pSubject->IsItemFlag( nWhichId, CNT_ITEM_AUTO_INHERIT ) )
                {
                    CntNode* pNode = pClient->GetNode();
                    const CntItemListItem* pDefsItem =
                                                pNode->GetChildDefaultsItem();
                    if ( pDefsItem )
                        pItem = pDefsItem->Get( nWhichId );
                    else
                        pItem = pNode->GetInheritedItem( nWhichId );
                }

                if ( !pItem )
                {
                    // reset to pool/CntDefaults value
                    CntDefaults* pDefs = GetDefaults();
                    pItem = pDefs
                          ? &( pDefs->Get( nWhichId ) )
                          : &( GetPool()->GetDefaultItem( nWhichId ) );
                }

                if ( pItem )
                {
                    // perform the action associated with pItem (job)
                    pClient->Put( *pItem );
                }
            }
            break;
        }

        case WID_SET_AS_DEFAULT:
        {
            CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
            if ( !pClient )
                break;

            CntNode* pRoot = pClient->GetNode()->GetRootNode();
            const String& rRootURL = OWN_URL( pRoot );
            if ( !CntViewBase::IsRootViewURL( rRootURL ) )
                break;

            CntUShortListItem* pListItem = (CntUShortListItem *)pReq;
            USHORT nCount = pListItem->Count();
            if ( !nCount )
            {
                // set all auto inherited items
                SfxWhichIter aIter( *this );
                USHORT nWhichId = aIter.FirstWhich();
                while ( nWhichId )
                {
                    if ( pSubject->IsItemFlag(
                                        nWhichId, CNT_ITEM_AUTO_INHERIT ) )
                        pListItem->Append( nWhichId );

                    nWhichId = aIter.NextWhich();
                }
            }

            // Get defaults item for my content type.
            const INetContentType eType =
                pClient->GetNode()->GetMostReferedNode()->GetCreator()->GetId();
            const CntItemListItem* pDefsItem =
                                pClient->GetNode()->GetChildDefaultsItem();
            CntItemListItem* pMyDefsItem = NULL;
            if ( !pDefsItem )
            {
                pMyDefsItem = new CntItemListItem( WID_CHILD_DEFAULTS,
                                                   GetPool() );
                pMyDefsItem->Append(
                              new CntContentTypeItem( WID_CONTENT_TYPE,
                                                      eType ) );
            }
            else
                pMyDefsItem = new CntItemListItem( *pDefsItem, GetPool() );

            USHORT n;

            // Remove all items given in pListItem from aMyDefsItem.
            nCount = pListItem->Count();
            for ( n = 0; n < nCount; ++n )
            {
                USHORT nWID = (*pListItem)[ n ];

                // m = 1, because first item is always WID_CONTENT_TYPE,
                // which can be skipped.
                for ( USHORT m = 1; m < pMyDefsItem->Count(); ++m )
                {
                    if ( (*pMyDefsItem)[ m ].Which() == nWID )
                    {
                        pMyDefsItem->Remove( m );
                        m--;
                    }
                }
            }

            // Add all items given in pListItem to aMyDefsItem.
            for ( n = 0; n < nCount; ++n )
            {
                USHORT nWID = (*pListItem)[ n ];

                // Fill defaults item with values currently set for client.
                if ( pClient->GetItemState( nWID, TRUE ) >
                     SFX_ITEM_DISABLED )
                    pMyDefsItem->Append( pClient->Get( nWID ).Clone() );
                else
                    pMyDefsItem->Append(
                            GetPool()->GetDefaultItem( nWID ).Clone() );

                // Erase stored item.
                EraseItem_Impl( pJob, nWID );
            }

            CntAnchorRef xRoot( new CntAnchor( NULL, pRoot ) );
            if ( !xRoot->GetError() )
            {
                const CntItemListItem& rAllDefsItem =
                    (const CntItemListItem&)pRoot->Get( WID_CHILD_DEFAULTS );
                CntItemListItem aAllDefsItem( rAllDefsItem, GetPool() );

                nCount = aAllDefsItem.Count();
                for ( n = 0; n < nCount; ++n )
                {
                    CntItemListItem* pDefsItem =
                        (CntItemListItem*)&(aAllDefsItem[ n ]);
                    const CntContentTypeItem* pTypeItem =
                        (const CntContentTypeItem*)
                        pDefsItem->Get( WID_CONTENT_TYPE );
                    if ( pTypeItem )
                    {
                        const INetContentType eCurrType =
                                                    pTypeItem->GetEnumValue();
                        if ( eCurrType == eType )
                        {
                            aAllDefsItem.Remove( n );
                            break;
                        }
                    }
                }

                aAllDefsItem.Append( pMyDefsItem );

                // Transfer new child defaults item in root view node.
                xRoot->Put( aAllDefsItem );
            }
            else
            {
                // Error. Cleanup...
                delete pMyDefsItem;
            }

            break;
        }

        case WID_CHILD_DEFAULTS:
            if ( !IsRootNode() )
            {
                // Only root nodes handle WID_CHILD_DEFAULTS.
                return NULL;
            }
            else
            {
                CntAnchor* pClient = (CntAnchor*)pJob->GetClient();
                CntViewNode::PutChildViewDefaults(
                                            pClient->GetNode(),
                                            (const CntItemListItem&)*pReq );
            }
            break;

        default:
            break;
    }

    if ( !pReq->ISA( SfxVoidItem ) )
    {
        // Flagged as user-, own- or view-property?
        if ( pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP ) ||
             pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP ) ||
             pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_OWNPROP  ) )
            StoreItem_Impl( pJob, *pReq );
        else
            Put( *pReq );
    }

    pJob->Done();
    return NULL;
}

//----------------------------------------------------------------------------
void CntNode::RescheduleJob( CntNodeJob *pJob )
{
    pJob->SetRescheduled();

#ifdef USE_JOB_DISPATCHER
	if ( getJobDispatcher() )
    	new CntJobRescheduler( this, pJob );
	else
		pJob->Cancel();
#else
    new CntJobRescheduler( this, pJob );
#endif
}

//----------------------------------------------------------------------------
const ULONG CntNode::JobCount() const
{
    if ( !_pJobQueue )
        return 0;

	NAMESPACE_VOS( OGuard ) aGuard(
						SAL_CONST_CAST( CntNode*, this )->getMutex() );

    ULONG nJobCount = 0;

    ULONG nLists = _pJobQueue->Count();
    for ( ULONG n = 0; n < nLists; ++n )
    {
        CntNodeJobList* pList = _pJobQueue->GetObject( n );
        if ( pList )
            nJobCount += pList->Count();
    }

    return nJobCount;
}

//----------------------------------------------------------------------------
CntNodeJob* CntNode::GetJob( ULONG nPos ) const
{
    ULONG nCount = JobCount();
    if ( !nCount )
        return NULL;

    if ( nPos > ( nCount - 1 ) )
        return NULL;

    CntNodeJobList* pList = NULL;
    ULONG           n     = 0;

	NAMESPACE_VOS( OGuard ) aGuard(
						SAL_CONST_CAST( CntNode*, this )->getMutex() );

    nCount = 0;

    // There may be leading empty lists!
    ULONG nSubSets = _pJobQueue->Count();
    while ( !nCount && ( n < nSubSets ) )
    {
        pList  = _pJobQueue->GetObject( n );
        nCount = pList->Count();
        n++;
    }

    // Convert absolute index (nPos) to index in appropriate job list.
    ULONG nIndex = nPos;
    while ( ( nPos > ( nCount - 1 ) ) && ( n < nSubSets) )
    {
        nIndex = nPos - nCount;

        pList  = _pJobQueue->GetObject( n );
        nCount += pList->Count();
        n++;
    }

    return pList->GetObject( nIndex );
}

//----------------------------------------------------------------------------
// virtual
FASTBOOL CntNode::IsItemFlag( USHORT nWID, USHORT nFlag ) const
{
	if ( _xRefered.Is() )
		return _xRefered->IsItemFlag( nWID, nFlag );

	return CntInterface::IsItemFlag( nWID, nFlag );
}

//----------------------------------------------------------------------------
// virtual
void CntNode::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
    //////////////////////////////////////////////////////////////////////
    // CntNodeJob notifications handling.
    //////////////////////////////////////////////////////////////////////

    CntNodeJob *pBroadcastingJob = NULL;
    if ( rBC.ISA( CntNodeJob ) )
        pBroadcastingJob = (CntNodeJob*)&rBC;

    if ( pBroadcastingJob )
    {
        BOOL bRemoveJob    = FALSE;
        BOOL bScheduleNext = FALSE;

        if ( rHint.ISA( CntStatusHint ) )
        {
            const CntStatusHint* pStatusHint = (const CntStatusHint*)&rHint;
            const CntStatus eStatus = pStatusHint->GetStatus();

            // Job done or canceled?
            if ( ( eStatus == CNT_STATUS_DONE ) ||
                 ( ( eStatus == CNT_STATUS_ERROR ) &&
                   ( pStatusHint->GetError() == ERRCODE_ABORT ) ) )
                bRemoveJob = TRUE;
        }
        else if ( rHint.ISA( CntScheduleJobHint ) )
            bScheduleNext = TRUE;

        if ( bRemoveJob || bScheduleNext )
        {
            if ( !bScheduleNext )
                EndListening( *pBroadcastingJob );

            RemoveJob( pBroadcastingJob );
            return;
        }
    }

    //////////////////////////////////////////////////////////////////////
    // CntNodeHint handling.
    //////////////////////////////////////////////////////////////////////

    const CntNodeHint *pNodeHint = NULL;
    if ( rHint.ISA( CntNodeHint ) )
        pNodeHint = (const CntNodeHint*)&rHint;

    if ( pNodeHint )
    {
        CntAction eAction = pNodeHint->GetAction();
        switch ( eAction )
        {
            case CNT_ACTION_DELETED:
                if ( pBroadcastingJob )
                    return;

                Broadcast( CntNodeHint( this, eAction, pNodeHint->GetJob() ) );
                return;

            case CNT_ACTION_KILL_ALL:
                // all views must be informed...
                Broadcast( CntNodeHint( this, eAction, pNodeHint->GetJob() ) );
                return;

            case CNT_ACTION_EXCHANGED:
            {
                if ( !GetReferedNode() )
                    return;

                CntNode *pBC = NULL;
                if ( rBC.ISA( CntNode ) )
                    pBC = (CntNode*)&rBC;

                if ( pBC != GetReferedNode() )
                    return;

                CntNodeRef xOld( GetReferedNode() );
                CntNodeRef xNew( pNodeHint->GetNode() );

                SetReferedNode( xNew );

                // Transfer outstanding jobs to pNew
                TransferJobsToDo_Impl( xOld, xNew );

                Broadcast( CntNodeHint( this, eAction, pNodeHint->GetJob() ) );
                return;
            }

            case CNT_ACTION_INSERTED:
            case CNT_ACTION_FILENAME_CHANGED:
                // all views must be informed...
                Broadcast( rHint );
                return;

            default:
                return;
        }
    }

    CntInterface::Notify( rBC, rHint );
}

//----------------------------------------------------------------------------
void CntNode::Flush()
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    for ( ULONG n = 0; n < SubNodeCount(); ++n )
        _pSubNodeList->GetObject(n)->Flush();
}

//----------------------------------------------------------------------------
// virtual
void CntNode::SetConnMode( CntConnMode eConnMode )
{
    CntNode::Put( CntConnModeItem( WID_CONNECTION_MODE, eConnMode ),
                  WID_CONNECTION_MODE );
}

//----------------------------------------------------------------------------
BOOL CntNode::IsItemSticky( CntNodeJob *pJob,
                            USHORT nWhich,
                            SfxPoolItem** ppItem /* = NULL */ )
{
    CntNode* pSubject = pJob->GetSubject();

    // flagged as user- or view-property?
    BOOL bIsViewProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP );
    BOOL bIsUserProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP );
    BOOL bIsOwnProp  = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_OWNPROP );

    if ( bIsViewProp || bIsUserProp || bIsOwnProp )
    {
        // find storage
        CntStorageNode *pStorNode =
             bIsViewProp ? pJob->GetViewDataNode( FALSE )
                         : ( bIsUserProp ? pJob->GetUserDataNode( FALSE )
                                         : pJob->GetDirectoryNode( FALSE ) );

        if ( !pStorNode )
            return FALSE;

        // assemble name of propterty-stream
        String aPropsName( GetPropertyKey( bIsOwnProp ) );

        // get property-set
        CntStoreItemSetRef xSet(
                pStorNode->openItemSet( aPropsName, STREAM_STD_READ ) );
        if ( xSet.Is() )
        {
            const SfxPoolItem* pItem = NULL;
            SfxItemState eState = xSet->GetItemState( nWhich, FALSE, &pItem );

            if ( ppItem && pItem )
			{
				// pItem may be destroyed in dtor of xSet!!!
                *ppItem = pItem->Clone();
			}

            if ( eState == SFX_ITEM_SET )
                return TRUE;
        }
    }

    return FALSE;
}

//------------------------------------------------------------------------
const String CntNode::GetPropertyKey( BOOL bOwnProps )
{
    // assemble name of propterty-stream
    String aPropsName;
    if ( bOwnProps )
        aPropsName = UniString::CreateFromAscii(
					 	RTL_CONSTASCII_STRINGPARAM(	STG_OWN_PROPERTY_SET ) );
    else
    {
        aPropsName = OWN_URL( this );

        //////////////////////////////////////////////////////////////////
        // Compatibility: props of root nodes never have a final slash.
        //////////////////////////////////////////////////////////////////

        if ( IsRootNode() && !IsDummy() )
        {
            xub_StrLen nLast = aPropsName.Len() - 1;
            if ( ( aPropsName.GetChar( nLast ) == '/' ) &&
                 ( aPropsName.GetChar( nLast - 1 ) != '/' ) )
                aPropsName.Erase( nLast );
        }
    }

    aPropsName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );
    return aPropsName;
}

//----------------------------------------------------------------------------
// virtual
CntJobDispatcher* CntNode::getJobDispatcher() const
{
	if ( _xParent.Is() )
		return _xParent->getJobDispatcher();

	return NULL;
}

//----------------------------------------------------------------------------
ULONG CntNode::Dump_Impl( SvStream &rStream, USHORT nLevel, BOOL bHTML ) const
{
    if ( bHTML )
        rStream.WriteByteStringLine( UniString::CreateFromAscii( "<OL>" ),
									 RTL_TEXTENCODING_ASCII_US );

    // Assemble line...
    UniString aLine;

    if ( bHTML )
    {
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "<LI><DD><NOBR>" ) );
    }
    else
    {
        for ( USHORT i = 0; i < nLevel; ++i )
            aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "    " ) );
    }

    const UniString& rOwnURL = OWN_URL( this );

    if ( bHTML )
    {
	    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&quot;" ) );

//      BOOL bHREF = CNT_RNM()->IsViewNode( rOwnURL, IsRootNode() );
        BOOL bHREF =
            ( rOwnURL.Len() &&
              ( rOwnURL.SearchAscii(
                	STG_PROTOCOL_USER ) == STRING_NOTFOUND ) &&
              ( rOwnURL.SearchAscii(
					STG_PROTOCOL_CACHE ) == STRING_NOTFOUND ) );
        if ( bHREF )
            aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "<A HREF=\"" ) );

		// Translate the URL into HTML text:
		UniString aURL;
		for (xub_StrLen i = 0; i < rOwnURL.Len(); ++i)
		{
			sal_Unicode cChar = rOwnURL.GetChar(i);
			if (cChar == '<')
				aURL.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&lt;" ) );
			else if (cChar == '>')
				aURL.AppendAscii(  RTL_CONSTASCII_STRINGPARAM( "&gt;" ) );
			else if (cChar == '&')
				aURL.AppendAscii(  RTL_CONSTASCII_STRINGPARAM( "&amp;" ) );
			else if (cChar == '"')
				aURL.AppendAscii(  RTL_CONSTASCII_STRINGPARAM( "&quot;" ) );
			else if (cChar >= ' ' && cChar <= '~' || cChar == '\t')
				aURL  += cChar;
			else
			{
				aURL.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&#" ) );
				aURL += cChar;
				aURL += ';';
			}
		}
		aLine += aURL;

        if ( bHREF )
        {
            aLine.AppendAscii(
					RTL_CONSTASCII_STRINGPARAM( "\" TARGET=\"_blank\">" ) );
            aLine  += aURL;
            aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "</A>" ) );
        }

	    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&quot;" ) );
    }
    else
	{
	    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "\"" ) );
        aLine += rOwnURL;
	    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "\"" ) );
	}

    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " [" ) );
    aLine += UniString( GetRefCount() ).ToInt32();
    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "] [" ) );

    ULONG nJobs = JobCount();
    aLine += nJobs;

    if ( nJobs && ( this != CNT_RNM() ) )
    {
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " :" ) );
        for ( ULONG n = 0; n < nJobs; ++n )
        {
            aLine += ' ';
            aLine += GetJob( n )->GetRequest()->Which();
        }
    }

    aLine += ']';

    if ( bHTML )
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "</NOBR></DD></LI>" ) );

    rStream.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );

    // Process subnodes...
    ULONG nCount = SubNodeCount();
    ULONG nTotal = nCount;

    for ( ULONG n = 0; n < nCount; ++n )
        nTotal += GetSubNode( n )->Dump_Impl( rStream, nLevel + 1, bHTML );

    if ( bHTML )
        rStream.WriteByteStringLine( UniString::CreateFromAscii( "</OL>" ),
									 RTL_TEXTENCODING_ASCII_US );

    return nTotal;
}

//----------------------------------------------------------------------------
ULONG CntNode::Dump( SvStream &rStream, USHORT /* nLevel */ ) const
{
    // Note: nLevel is obsolete, since we have Dump_Impl(...).

    BOOL bHTML = FALSE;
    if ( rStream.Tell() )
    {
        rStream.Seek( STREAM_SEEK_TO_BEGIN );
        UniString aFirst;
        if ( rStream.ReadByteStringLine( aFirst, RTL_TEXTENCODING_ASCII_US ) )
        {
            if ( aFirst.Len() && ( aFirst.Search(
									UniString::CreateFromAscii(
										RTL_CONSTASCII_STRINGPARAM(
											"<HTML>" ) ) )== 0 ) )
                bHTML = TRUE;
        }

        rStream.Seek( STREAM_SEEK_TO_END );
    }

    if ( bHTML )
    {
        rStream.WriteByteStringLine( UniString::CreateFromAscii(
										"<FONT FACE=\"Fixedsys\">" ),
									 RTL_TEXTENCODING_ASCII_US );
        rStream.WriteByteStringLine( UniString::CreateFromAscii(
										"<P><U>Current Object Hierarchy</U></P>" ),
									 RTL_TEXTENCODING_ASCII_US );
        rStream.WriteByteStringLine( UniString::CreateFromAscii(
										"<P>\"URL\" [refcount] [jobcount : jobids]</P>" ),
									 RTL_TEXTENCODING_ASCII_US );
        rStream.WriteByteStringLine( UniString::CreateFromAscii(
										"<P></P>" ),
									 RTL_TEXTENCODING_ASCII_US );
    }

    ULONG nTotal = Dump_Impl( rStream, 0, bHTML );

    UniString aLine;
    if ( bHTML )
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "<P>" ) );

    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Total Objects: " ) );
    aLine += UniString( ++nTotal ).ToInt32();

    if ( bHTML )
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "<BR>" ) );

    rStream.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );

    aLine.AssignAscii( "Total Jobs: " );
    aLine += UniString( CNT_RNM()->JobCount() ).ToInt32();

    if ( bHTML )
        aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "<BR><BR>" ) );

    rStream.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );

	if ( bHTML )
		aLine.AssignAscii( "<P><U>" );
	else
		aLine.Erase();

	aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Known Views" ) );

	if ( bHTML )
		aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "</U></P>" ) );

   	rStream.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );

    if ( bHTML )
        rStream.WriteByteStringLine( UniString::CreateFromAscii( "<OL>" ),
									 RTL_TEXTENCODING_ASCII_US );

	const CntViewList* pViews = CNT_RNM()->GetViewList();
	ULONG nCount = pViews->Count();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntViewEntry* pEntry = pViews->GetObject( n );

		if ( bHTML )
        	aLine.AssignAscii( "<LI><DD><NOBR>" );
		else
			aLine.Erase();

		if ( bHTML )
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&quot;" ) );
		else
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "\"" ) );

		aLine += pEntry->aViewURL;

		if ( bHTML )
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "&quot;" ) );
		else
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "\"" ) );

		aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) );
		aLine += pEntry->aContentType;
		aLine .AppendAscii(RTL_CONSTASCII_STRINGPARAM( ") - " ) );

		if ( CntViewBase::ViewFileExists( pEntry->aViewURL ) )
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "Valid" ) );
		else
			aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "InValid" ) );

	    if ( bHTML )
    	    aLine.AppendAscii(
				RTL_CONSTASCII_STRINGPARAM( "</NOBR></DD></LI>" ) );

	    rStream.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
	}

    if ( bHTML )
        rStream.WriteByteStringLine( UniString::CreateFromAscii(
										"</OL></P></FONT><FONT>" ),
									 RTL_TEXTENCODING_ASCII_US );
    return nTotal;
}

//----------------------------------------------------------------------------
BOOL CntNode::IsDummyURL_Impl( const String& rURL )
{
	if ( ( rURL.Len() > 2 ) &&
		 ( rURL.GetChar( rURL.Len() - 3 ) == ':' ) &&
		 ( rURL.GetChar( rURL.Len() - 2 ) == '/' ) &&
		 ( rURL.GetChar( rURL.Len() - 1 ) == '/' ) )
	{
        return TRUE;
	}
    else if ( _pCreator )
    {
        if ( CntViewBase::IsRootViewURL( rURL ) )
        {
            if ( rURL.Search( '*' ) != STRING_NOTFOUND )
                return TRUE;
        }
        else if ( ( _pCreator->GetWildCard().Len() > 1 ) &&
		          ( rURL.Search(
				  		_pCreator->GetWildCard() ) != STRING_NOTFOUND ) )
        {
            return TRUE;
        }
    }

    return FALSE;
}

//----------------------------------------------------------------------------
void CntNode::ConstructOwnURL_Impl( String& rOwnURL )
{
    //////////////////////////////////////////////////////////////////////
    // Construct own URL. (may be overridden by node implementations)
    //////////////////////////////////////////////////////////////////////
    GetOwnURL( rOwnURL );

    if ( !rOwnURL.Len() )
        return;

    //////////////////////////////////////////////////////////////////////
    // Dummy node?
    //////////////////////////////////////////////////////////////////////
    _bIsDummy = IsDummyURL_Impl( rOwnURL );

    if ( _bIsDummy )
    {
        // Disable all WID_CREATE_NEW items, accept those flagged with
        // CNT_CREATION_FLAG_SENDMESSAGE ( Send a message via out tray ).
        CntDefaults* pDefs = GetDefaults();
        if ( pDefs )
        {
            CntItemListItem aNewItem( WID_CREATE_NEW, GetPool() );

            const CntItemListItem& rListItem =
                        (const CntItemListItem&)pDefs->Get( WID_CREATE_NEW );

            USHORT nCount = rListItem.Count();
            for( USHORT n = 0; n < nCount; ++n )
            {
                const CntItemListItem& rCurr =
                            (const CntItemListItem&)(rListItem)[ n ];
                USHORT nFlags = ITEM_VALUE( CntUInt16Item,
                                            *rCurr.Get( WID_CREATION_FLAGS ) );
                if ( nFlags & CNT_CREATION_FLAG_SENDMESSAGE )
                    aNewItem.Append( rCurr.Clone() );
            }

            if ( aNewItem.Count() )
                Put( aNewItem );
            else
                DisableItem( WID_CREATE_NEW );
        }
    }
}

//------------------------------------------------------------------------
// static
BOOL CntNode::TransferJobsToDo_Impl( CntNode* pOld, CntNode* pNew )
{
    CntNode* pCurrOld = pOld;
    CntNode* pCurrNew = pNew;

    // Process all nodes including refered nodes of pOld and pNew
    while ( pCurrOld && pCurrNew && ( pCurrOld != pCurrNew ) )
    {
		NAMESPACE_VOS( OGuard ) aGuard1( pCurrOld->getMutex() );
		NAMESPACE_VOS( OGuard ) aGuard2( pCurrNew->getMutex() );

        ULONG n = 0;
        while ( pCurrOld->JobCount() > n )
        {
            CntNodeJobRef xCurr  = pCurrOld->GetJob( n );
            USHORT        nWhich = xCurr->GetRequest()->Which();
            CntNodeJob*   pCurr  = pCurrOld->GetCurrentJob();
			BOOL		  bKept  = FALSE;

            if ( ( nWhich == WID_PUTDATA ) || ( pCurr == &xCurr ) || !pCurr )
            {
                // PUTDATA's, current and synchronous jobs must remain
                // at pCurrOld
                n++;
                bKept = TRUE;
            }
            else
            {
                // Remove job from pOld's queue
                if ( !pCurrOld->RemoveJob( xCurr ) )
                    n++;
            }

            // Insert job in pNew's queue
            BOOL       bNewClient = TRUE;
            CntAnchor* pParent    = PTR_CAST( CntAnchor, xCurr->GetClient() );
            if ( pParent )
            {
                // Points job client to view node?
                CntNode* pNode = pParent->GetNode();
                if ( pNode && CntViewBase::IsViewURL( OWN_URL( pNode ) ) )
                {
                    CntNode* pTmp = pNode->GetReferedNode();
                    while ( pTmp )
                    {
                        if ( pTmp == pCurrNew )
                        {
                            // Client is view node to new node, keep "him".
                            bNewClient = FALSE;
                            break;
                        }

                        pTmp = pTmp->GetReferedNode();
                    }
                }

                pParent = pParent->GetParent();
            }

            CntInterfaceRef xNewClient( bNewClient
                                        ? new CntAnchor( pParent, pCurrNew )
                                        : xCurr->GetClient() );
            pCurrNew->InsertJob(
                new CntNodeJob( xCurr, xNewClient,
                                pCurrNew, *( xCurr->GetRequest() ),
                                xCurr->IsMakePersist(), xCurr->IsLogged(),
								xCurr->getTaskBase() ) );
			if ( !bKept )
			{
				// Done with the 'original'.
				xCurr->Done( FALSE );
			}
        }

        pCurrOld = pCurrOld->GetReferedNode();
        pCurrNew = pCurrNew->GetReferedNode();
    }

    return TRUE;
}

//----------------------------------------------------------------------------
void CntNode::UpdateChildItems_Impl( const SfxPoolItem& rItem )
{
    USHORT nWhich = rItem.Which();

	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    ULONG nCount = SubNodeCount();

	if ( !nCount )
        return;

	CntNodeList aNodeList( (USHORT)nCount );

	// Make a copy of current child list.
	ULONG n = 0;
    for ( n = 0; n < nCount; ++n )
    {
        CntNode* pChild = GetSubNode( n );

		// Hold the child, it may be destroyed during further processing!!!
		pChild->AddRef();
		aNodeList.Insert( pChild, LIST_APPEND );
	}

    INetContentType eThisType = GetMostReferedNode()->GetCreator()->GetId();
	CntDefaults* 	pThisDefs = GetMostReferedNode()->GetDefaults();

    for ( n = 0; n < nCount; ++n )
    {
        CntNode* pChild = aNodeList.GetObject( n );

        if ( nWhich == WID_CHILD_DEFAULTS )
        {
            const CntItemListItem* pListItem = pChild->GetChildDefaultsItem();
            if ( pListItem )
            {
                USHORT nCount1 = pListItem->Count();
                // m = 1, because first item is always WID_CONTENT_TYPE,
                // which can be skipped.
                for ( USHORT m = 1; m < nCount1; ++m )
                {
                    const SfxPoolItem& rCurr = (*pListItem)[ m ];
                    UpdateChildItems_Impl( rCurr );
                }
                break;
            }
            else
                pChild->UpdateChildItems_Impl( rItem );
        }
        else
        {
            // Is item in ranges of child?
            if ( pChild->GetItemState( nWhich, TRUE ) < SFX_ITEM_DEFAULT )
                continue;

            if ( !ITEMSET_VALUE( pChild, CntBoolItem, WID_FLAG_IS_FOLDER ) )
                continue;

            CntNode* pMostRef = pChild->GetMostReferedNode();

            // Is item in parent unequal to child's item or is special
            // processing needed?
            BOOL bForcedPut = ( ( nWhich == WID_AUTOUPDATE_INTERVAL ) ||
                                ( nWhich == WID_UPDATE_ENABLED ) );
            if ( bForcedPut || ( pChild->Get( nWhich ) != rItem ) )
            {
				BOOL bUpdate = TRUE;

                if ( !bForcedPut )
                {
                    INetContentType eChildType = pMostRef->GetCreator()->GetId();
                    if ( eThisType != eChildType )
                    {
                        const CntItemListItem* pListItem =
                                            pChild->GetChildDefaultsItem();
                        if ( pListItem )
                        {
                            const SfxPoolItem* pDefItem =
                                                    pListItem->Get( nWhich );
                            if ( pDefItem &&
                                 ( *pDefItem == pChild->Get( nWhich ) ) )
                                bUpdate = FALSE;
                        }

						if ( bUpdate )
						{
							CntDefaults* pChildDefs = pMostRef->GetDefaults();
							if ( pChildDefs && pThisDefs )
							{
								// Unequal class defaults -> item cannot be
								// inherited to children.
								if ( pChildDefs->Get( nWhich ) !=
													pThisDefs->Get( nWhich ) )
									bUpdate = FALSE;
							}
						}
                    }
                }

				if ( bUpdate )
				{
                	CntAnchorRef xAnchor( new CntAnchor( NULL, pChild ) );
                	if ( !xAnchor->GetError() )
                	{
                    	CntNodeJobRef xJob(
                                   	new CntNodeJob( NULL, xAnchor,
                                                   	pMostRef, rItem, FALSE ) );
                    	if ( !pMostRef->IsItemSticky( xJob, nWhich ) )
                        	xAnchor->Put( xJob );
                	}
				}
            }

            // nothing to do...
        }
    }

	// Release children...
	for ( n = 0; n < nCount; ++n )
	{
		CntNode* pChild = aNodeList.GetObject( n );
		pChild->ReleaseRef();
	}
}

//----------------------------------------------------------------------------
// static
const SfxPoolItem* CntNode::SetProperty_Impl( CntInterface* pTarget,
                                              const SfxPoolItem& rItem,
                                              BOOL bIsViewProp )
{
    USHORT nWhich = rItem.Which();

    if ( bIsViewProp )
    {
        // View property:
        // There may be various anchors interested in the changed property.
        // So the view node of job's client will do a broadcast to inform all.

        CntAnchor* pAnchor = PTR_CAST( CntAnchor, pTarget );

        DBG_ASSERT( pAnchor, "Client for view props must be a CntAnchor!" );

        if ( pAnchor )
		{
        	CntNode* pNode = pAnchor->GetNode();
        	if ( pNode && CntViewBase::IsViewURL( OWN_URL( pNode ) ) )
        	{
            	pNode->CntInterface::Put( rItem, nWhich );

            	if ( pNode->IsItemFlag( nWhich, CNT_ITEM_AUTO_INHERIT ) ||
                 	 ( nWhich == WID_CHILD_DEFAULTS ) )
            	{
                	CntViewNode::SyncChildViewDefaults( pNode, rItem );
                	pNode->UpdateChildItems_Impl( rItem );
            	}
            	return NULL;
        	}

			// Make sure the item is in ranges!!! CntAnchor's generally have
			// optimized mini ranges, but sometimes they must store other
			// items directly.
			if ( pAnchor->GetItemState( nWhich, FALSE ) < SFX_ITEM_DISABLED )
				pAnchor->MergeRange( nWhich, nWhich );
		}
    }

	pTarget->CntInterface::Put( rItem, nWhich );
	return NULL;
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntNode::StoreItem_Impl( CntNodeJob *pJob,
                                            const SfxPoolItem &rItem )
{
    USHORT   nWhich   = rItem.Which();
    CntNode* pSubject = pJob->GetSubject();

    // flagged as view-property?
    BOOL bIsViewProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP );

    CntInterface *pTarget = bIsViewProp
                          ? pJob->GetClient()
                          : this;

    // flagged as hidden?
    if ( IsItemFlag( nWhich, CNT_ITEM_HIDDEN ) )
        return SetProperty_Impl( pTarget, rItem, bIsViewProp );

    // flagged as user- or own-property?
    BOOL bIsUserProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP );
    BOOL bIsOwnProp  = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_OWNPROP );

    if ( !bIsViewProp && !bIsUserProp && !bIsOwnProp )
        return SetProperty_Impl( pTarget, rItem, bIsViewProp );

    if ( !pJob->IsMakePersist() )
        return SetProperty_Impl( pTarget, rItem, bIsViewProp );

    ///////////////////////////////////////////////////////////////////////////
    // Only store things that have changed...
    ///////////////////////////////////////////////////////////////////////////
    const SfxPoolItem* pItem = NULL;
    if ( !pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_GARBLE ) &&
         ( pTarget->GetItemState( nWhich, bIsViewProp, &pItem )
           == SFX_ITEM_SET ) )
    {
        if ( pItem && ( *pItem == rItem ) )
        {
            if ( bIsOwnProp )
            {
                // Differences between cache and target?
                CntStorageNode* pCache = pJob->GetDirectoryNode();
                if ( pCache && ( pCache->GetItemState( nWhich, FALSE, &pItem )
                                 == SFX_ITEM_SET ) )
                {
                    if ( pItem && ( *pItem == rItem ) )
                        return NULL;
                }
            }
            else
                return NULL;
        }
    }

#ifdef NEVER_CHANGING_DEFAULTS
    // Funkt. zwar, aber wenn sich mal die Pooldefaults/CntDefaults
    // aendern, hat das Objekt ploetzlich andere Einstellungen!!!

    ///////////////////////////////////////////////////////////////////////////
    // Erase item from storage, if it is the pool default or CntDefault...
    ///////////////////////////////////////////////////////////////////////////

    pItem = NULL;

    // Is value to store the pool-/CntDefault?
    CntDefaults* pDefs = GetDefaults();
    pItem = pDefs ? &( pDefs->Get( nWhich ) )
                  : &( GetPool()->GetDefaultItem( nWhich ) );
    if ( pItem )
    {
        if ( *pItem == rItem )
        {
            // erase the item from storage...
            EraseItem_Impl( pJob, nWhich );
            return SetProperty_Impl( pTarget, rItem, bIsViewProp );
        }
    }
#endif

    ///////////////////////////////////////////////////////////////////////////
    // Process automatic inherited items...
    ///////////////////////////////////////////////////////////////////////////

    if ( pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_INHERIT ) )
    {
        if ( !IsItemSticky( pJob, nWhich ) )
        {
            BOOL bSave = FALSE;

            if ( bIsViewProp )
            {
	            CntNode* pNode = this;
                if ( pTarget->ISA( CntAnchor ) )
					pNode = ( (CntAnchor*)pTarget )->GetNode();

                const CntItemListItem* pChildDefs =
                                            	pNode->GetChildDefaultsItem();
                if ( pChildDefs )
                {
                    const SfxPoolItem* pDefItem = pChildDefs->Get( nWhich );
                    if ( pDefItem  )
                    {
                        if ( *pDefItem == rItem )
                        {
                            // Do not save the value, because it's
                            // a child default!
                            return SetProperty_Impl(
                                            pTarget, rItem, bIsViewProp );
                        }
                        else
                            bSave = TRUE;
                    }
                }
            }

            if ( !bSave )
            {
				CntNode* pNode = this;
				if ( bIsViewProp )
				{
	                if ( pTarget->ISA( CntAnchor ) )
						pNode = ( (CntAnchor*)pTarget )->GetNode();
				}

				const SfxPoolItem* pItm = pNode->GetInheritedItem( nWhich );
				if ( pItm )
				{
                   	if ( *pItm == rItem )
                   	{
                       	// Do not save the value, because the parent has it!
                        return SetProperty_Impl( pTarget, rItem, bIsViewProp );
					}
                }
				else
				{
                    CntDefaults* pDefs = GetMostReferedNode()->GetDefaults();
                    pItm = pDefs
                         ? &( pDefs->Get( nWhich ) )
                         : &( GetPool()->GetDefaultItem( nWhich ) );
					if ( *pItm == rItem )
					{
                       	// Do not save the value, because it's the default
						// for this class!
                        return SetProperty_Impl( pTarget, rItem, bIsViewProp );
					}
				}
            }
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    // #62661# Special handling for WID_TITLE. Never store the default title
	//         defined for an object type to enable change of title when
	//         switching UI language.
    ///////////////////////////////////////////////////////////////////////////

	if ( nWhich == WID_TITLE )
	{
		const CntContentTypeItem& rTypeItem =
				(const CntContentTypeItem&)pTarget->Get( WID_CONTENT_TYPE );
  		INetContentType eType = rTypeItem.GetEnumValue();
		String aDefTitle(INetContentTypes::GetPresentation
						  (eType,
						   CntRootNodeMgr::GetIniManager()->
                            getIntlWrapper().getLanguage()));
		if ( aDefTitle == ITEM_VALUE( CntStringItem, rItem ) )
		{
			// Erase old value from storage
			EraseItem_Impl( pJob, nWhich );

			// Set, but do not store new value.
	        return SetProperty_Impl( pTarget, rItem, bIsViewProp );
		}
	}

    ///////////////////////////////////////////////////////////////////////////
    // Store item in appropriate storage...
    ///////////////////////////////////////////////////////////////////////////

	if ( !ITEMSET_VALUE( pSubject, CntBoolItem, WID_FLAG_IS_FOLDER ) )
	{
		if ( bIsViewProp || bIsOwnProp || bIsUserProp )
		{
//			DBG_ERROR( "CntNode::StoreItem_Impl - CNT_ITEM_AUTO_*PROP "
//			           "not supported for non-folder objects!" );
	        return SetProperty_Impl( pTarget, rItem, bIsViewProp );
		}
	}

    // find storage
    CntStorageNode *pStorNode = bIsViewProp
                              ? pJob->GetViewDataNode()
                              : ( bIsUserProp ? pJob->GetUserDataNode()
                                              : pJob->GetDirectoryNode() );

//    DBG_ASSERT( pStorNode, "StoreItem: No storage node!");
    if ( !pStorNode || pStorNode->IsDummy() )
        return SetProperty_Impl( pTarget, rItem, bIsViewProp );

    // assemble name of propterty-stream
    String aPropsName( GetPropertyKey( bIsOwnProp ) );

    // get property-set
    pStorNode->attrib( aPropsName, 0,
                       CNTDIRENTRY_ATTRIB_HIDDEN | CNTDIRENTRY_ATTRIB_CREATE );
    CntStoreItemSetRef xSet( pStorNode->openItemSet( aPropsName,
                                                     STREAM_STD_READWRITE ) );
    if ( xSet.Is() )
    {
        DBG_ASSERT( !( pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_GARBLE ) &&
             // compatibility stuff.
             rItem.ISA( CntUnencodedStringItem ) &&
             !rItem.ISA( CntStringItem ) ),
			 "CntNode::StoreItem_Impl : Wrong item type!" );

        // store in property-set
        xSet->Put( rItem );
    }

    xSet.Clear();

    ///////////////////////////////////////////////////////////////////////////
    // Put item into appropriate target...
    ///////////////////////////////////////////////////////////////////////////

    if ( bIsOwnProp )
    {
        CntNode* pTemp = pStorNode;
        while ( pTemp )
        {
            pTemp->CntInterface::Put( rItem, nWhich );
            pTemp = pTemp->GetReferedNode();
        }
    }

    return SetProperty_Impl( pTarget, rItem, bIsViewProp );
}

//----------------------------------------------------------------------------
BOOL CntNode::EraseItem_Impl( CntNodeJob *pJob, USHORT nWhich )
{
    CntNode* pSubject = pJob->GetSubject();

    // flagged as user- or view-property?
    BOOL bIsViewProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP );
    BOOL bIsUserProp = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP );
    BOOL bIsOwnProp  = pSubject->IsItemFlag( nWhich, CNT_ITEM_AUTO_OWNPROP );

    if ( bIsViewProp || bIsUserProp || bIsOwnProp )
    {
        // find storage
        CntStorageNode *pStorNode =
             bIsViewProp ? pJob->GetViewDataNode( FALSE )
                         : ( bIsUserProp ? pJob->GetUserDataNode( FALSE )
                                         : pJob->GetDirectoryNode( FALSE ) );

        if ( !pStorNode || pStorNode->IsDummy() )
            return FALSE;

        // assemble name of propterty-stream
        String aPropsName( GetPropertyKey( bIsOwnProp ) );

        // get property-set
        CntStoreItemSetRef xSet(
             pStorNode->openItemSet( aPropsName,
                                     STREAM_STD_READWRITE | STREAM_NOCREATE ) );
        if ( xSet.Is() )
        {
            if ( xSet->GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
            {
                // Only this item left?
                // Remove whole storage from storage medium...
                if ( xSet->Count() == 1 )
                {
                    // xSet must be cleared, otherwise remove will fail!
                    xSet.Clear();
                    pStorNode->remove( aPropsName );
                }
                else
                    xSet->ClearItem( nWhich );

                return TRUE;
            }

            // Storage empty? Remove it from storage medium...
            if ( xSet->Count() == 0 )
            {
                // xSet must be cleared, otherwise remove will fail!
                xSet.Clear();
                pStorNode->remove( aPropsName );
            }
        }
    }

    return FALSE;
}

//----------------------------------------------------------------------------
CntNode* CntNode::QueryChildren_Impl( const String& rNodeURL, BOOL bCreate )
{
	getMutex().acquire();

    ULONG nCount = SubNodeCount();
	if ( nCount )
	{
    	xub_StrLen nLenInURL = rNodeURL.Len();

    	long nStart = 0;
    	long nEnd   = nCount - 1;

    	if ( CNT_RNM() == this )
    	{
			static const UniString aFsysRootURL(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(	CNT_FSYS_ROOT_URL ) ) );

        	CntNode* pChild = _pSubNodeList->GetObject( 0 );
        	const String& rChildURL = OWN_URL( pChild );
        	if ( rChildURL == aFsysRootURL )
        	{
            	// First child is file system root node ( file:/// ). Skip it,
            	// if we are not looking for a file URL, which is not(!) a
            	// View URL.

            	nStart = 1;

            	UniString aTmp( aFsysRootURL );
            	aTmp += '*';
            	WildCard aWild( aTmp );
            	if ( aWild.Matches( rNodeURL ) )
            	{
                	// file URL to find...

                	if ( !CNT_RNM()->IsViewNode( rNodeURL, TRUE ) && // Root?
                     	 !CNT_RNM()->IsViewNode( rNodeURL, FALSE ) ) // Sub?
                	{
                    	// No View URL: file root node is always inserted
                    	// at first position in RNM's subnode list.
                    	// So we can find it very fast.
                    	nStart = nEnd = 0;
                	}
            	}
        	}
    	}

       	CntNodeRef xChild = 0;

    	while ( nStart <= nEnd )
    	{
        	long nMid = ( nEnd - nStart ) / 2 + nStart;

        	xChild = _pSubNodeList->GetObject( nMid );
        	const String& rChildURL = OWN_URL( xChild );
        	if ( !xChild->IsDead() )
        	{
            	xub_StrLen nLenChildURL = rChildURL.Len();
            	if ( nLenInURL == nLenChildURL )
            	{
                	xub_StrLen nPos = rNodeURL.Match( rChildURL );
                	if ( nPos == STRING_MATCH )
                	{
                    	// gotcha!
						break;
                	}
            	}
            	else if ( nLenInURL > nLenChildURL )
            	{
                	// Dummy nodes never have children.
                	if ( !xChild->IsDummy() )
                	{
                    	xub_StrLen nPos = rNodeURL.Match( rChildURL );
                    	if ( nPos == ( nLenInURL - 1 ) )
                    	{
                        	CntNodeRef xNode = xChild->GetChildDelims().Len()
                                       	   	 ? &xChild
                                       	   	 : this;

                        	// differ URL's only by a final '/' or another
							// child delimiter of xChild's URL?
                        	if ( xNode->IsChildDelim_Impl( rNodeURL, nPos ) )
                        	{
                            	// gotcha!
								break;
                        	}
                    	}

                    	if ( nPos == nLenChildURL )
                    	{
                        	if ( xChild->IsChildDelim_Impl( rNodeURL, nPos ) ||
                             	 xChild->IsChildDelim_Impl( rNodeURL, nPos - 1 ) )
                        	{
								getMutex().release();

                            	// rNodeURL describes a child of xChild
                            	return xChild->QueryChildren_Impl(
                                                   		rNodeURL, bCreate );
                        	}
                    	}
                	}
            	}
            	else if ( nLenInURL == ( nLenChildURL - 1 ) )
            	{
                	xub_StrLen nPos = rChildURL.Match( rNodeURL );
                	if ( nPos == nLenInURL )
                	{
                    	// differ URL's only by a final '/' or another child
                    	// delimiter of xChild's URL?
                    	CntNodeRef xNode = xChild->GetChildDelims().Len()
                                   	     ? &xChild
                                   	     : this;

                    	if ( xNode->IsChildDelim_Impl( rChildURL, nPos ) )
                    	{
                        	// gotcha!
							break;
                    	}
                	}
            	}
        	}

        	if ( rChildURL > rNodeURL )
            	nEnd = nMid - 1;
        	else
            	nStart = nMid + 1;

			xChild = 0;

    	} // end: while ( nStart <= nEnd )

		if ( xChild.Is() )
		{
       		// Found!
			getMutex().release();

			// A node is locked until it is completely initialized.
			// So we can be sure never to return an uninitialized node.
			xChild->getMutex().acquire();
			xChild->getMutex().release();

			// I'm the last one holding a reference on xChild. Another
			// thread may have released the last reference in the meantime
			// and just waits for access to parent node's mutex to remove
			// xChild from parent and to destroy xChild. Prevent this!
			if ( xChild->GetRefCount() == 1 )
				xChild->RestoreNoDelete();

       		return xChild;
		}
	}

	// Not found. Create new.

    if ( bCreate )
	{
		//  Mutex will ( and must ) be released in CreateChild_Impl!
        return CreateChild_Impl( rNodeURL, TRUE );
	}

	getMutex().release();
    return NULL;
}

//----------------------------------------------------------------------------
CntNode* CntNode::CreateChild_Impl( const String& rNodeURL, BOOL bReleaseMutex )
{
	const String& rOwnURL = OWN_URL( this );

    xub_StrLen nPos = rOwnURL.Len();
    if ( IsChildDelim_Impl( rNodeURL, nPos - 1 ) )
        nPos--;

    const String aChildrenURL( rNodeURL.Copy( nPos ) );

	BOOL bSubNode = ( aChildrenURL.Len() < rNodeURL.Len() );

    // Do we have a matching subnode factory?
    CntNodeFactory *pFactory = NULL;
    ULONG nCount = FactoryCount();
    for ( USHORT m = 0; !pFactory && ( m < nCount ); ++m )
    {
        pFactory = GetFactory( m );

        String aChildURL( aChildrenURL );

		const String aWild = pFactory->GetWildCard();
        if ( bSubNode || ( aWild.GetChar( aWild.Len() - 1 ) != '*' ) )
        {
            // Node chain to create?
            // Get URL for first(!) child to determine correct factory.

            // e.g. FSYS - "/bla/blub.txt" must use a factory for a folder -
            //      folder factory matches only "/*/" - so "blub.txt" must
            //      be cutted.

            const String& rDelims = pFactory->GetChildDelims();
            for ( xub_StrLen n = 0; n < rDelims.Len(); n++ )
            {
                sal_Unicode cCurr = rDelims.GetChar( n );
                xub_StrLen nCurr = aChildURL.Search( cCurr, 1  );
                if ( ( nCurr != STRING_NOTFOUND ) &&
                     ( nCurr != ( aChildURL.Len() - 1 ) ) )
                {
                    // Special cases...
                    if ( cCurr == '/' )
                    {
                        // Ignore other protocols in child URL.
                        if ( aChildURL.GetChar( nCurr - 1 ) == ':' )
                            continue;

                        // WORKAROUND: This algorithm destroys Message-URL's,
                        //             because Message-Ids may contain slashes
                        //             ( -> RFC) and these are not(!) child
                        //             delimiters here!
						static const UniString aMsgPattern(
							UniString::CreateFromAscii(
								RTL_CONSTASCII_STRINGPARAM( "/<*@*>" ) ) );

                        if ( WildCard( aMsgPattern ).Matches( aChildURL ) )
                            continue;

                        nCurr++;
                    }

                    aChildURL.Erase( nCurr );
                    break;
                }
            }
        }

        if ( !pFactory->Matches( aChildURL, GetCreator() ) )
            pFactory = NULL;
    }

    if ( !pFactory )
	{
    	// No factory -> no new node...

		if ( bReleaseMutex )
			getMutex().release();

    	return NULL;
	}

    // Create and initialize a new node.
    CntNode* pChild = CreateChild_Impl( pFactory, rNodeURL, bReleaseMutex );
	if ( pChild )
	{
   		// Contains rNodeURL further nodes to be constructed?
		const String& rChildURL = OWN_URL( pChild );
   		if ( rNodeURL.Len() > rChildURL.Len() )
   		{
			xub_StrLen nLast = rNodeURL.Len() - 1;
			if ( nLast == rChildURL.Len() )
			{
       			// Differ URL's only by a final child delimiter?
       			if ( pChild->IsChildDelim_Impl( rNodeURL, nLast ) )
				{
					if ( bReleaseMutex )
						pChild->getMutex().release();

					return pChild;
				}
			}

       		return pChild->CreateChild_Impl( rNodeURL, bReleaseMutex );
   		}
		else
		{
			if ( bReleaseMutex )
		 		pChild->getMutex().release();
		}
	}

	return pChild;
}

//----------------------------------------------------------------------------
CntNode* CntNode::CreateChild_Impl(
			CntNodeFactory* pFac, const String& rNodeURL, BOOL bReleaseMutex )
{
    // Create and initialize a new node.
    CntNodeRef xChild = pFac->CreateInstance( this, rNodeURL );

	if ( bReleaseMutex )
	{
		xChild->getMutex().acquire();

		// Mutex must be released before calling virtual
		// (init) methods, which cannot be controlled.
		getMutex().release();
	}

	if ( xChild.Is() )
	{
		// Set connection mode of new node.
    	xChild->SetConnMode(
			(CntConnMode)ITEMSET_VALUE(
							this, CntConnModeItem, WID_CONNECTION_MODE ) );

		// Call virtual init method.
#if 0
		// better.
		xChild = pChild->Initialize( this, OWN_URL( pChild ) );
#else
		// compatible.
		xChild = xChild->Initialize( this, rNodeURL );
#endif

		if ( !xChild.Is() )
		{
    		// Error initializing new node...
    		return NULL;
		}

   		if ( this == CNT_RNM() )
   		{
       		CntNode* pRoot = xChild->GetRootNode();
       		if ( CntViewBase::IsRootViewURL( OWN_URL( pRoot ) ) )
       		{
           		// Register Root View at RNM.
           		CNT_RNM()->AddView( pRoot );
       		}
    	}

		// Make sure the refcount of the new node is correct. It must be
		// SV_NO_DELETE_REFCOUNT when leaving this method. Otherwise it
		// would be destroyed when going out of method's scope.
		xChild->RestoreNoDelete();
	}

	return xChild;
}

//----------------------------------------------------------------------------
BOOL CntNode::IsChildDelim_Impl( const String& rNodeURL, USHORT nPos )
{
    if ( nPos >= rNodeURL.Len() )
        return FALSE;

    String aDelims = GetChildDelims();
    xub_StrLen nDelims = aDelims.Len();
    sal_Unicode aFinal  = rNodeURL.GetChar( nPos );
    for ( USHORT n = 0; n < nDelims; ++n )
    {
        if ( aFinal == aDelims.GetChar( n ) )
            return TRUE;
    }

    return FALSE;
}

//----------------------------------------------------------------------------
void CntNode::InsertChild_Impl( CntNode *pNewChild )
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    ULONG nCount = SubNodeCount();

    if ( nCount == 0 )
    {
        _pSubNodeList = new CntNodeList;
        _pSubNodeList->Insert( pNewChild );
    }
    else
    {
        long nStart = 0;

        const String& rChild = OWN_URL( pNewChild );
        if ( CNT_RNM() == this )
        {
			static const UniString aFsysRootURL(
						UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM(	CNT_FSYS_ROOT_URL ) ) );

            if ( rChild == aFsysRootURL )
            {
                // File system root node will always be inserted at first
                // position in RNM's subnode list.
                _pSubNodeList->Insert( pNewChild, (ULONG)0 );
                return;
            }

            // Skip file system root node.
            CntNode* pChild = _pSubNodeList->GetObject( 0 );
            const String& aChildURL = OWN_URL( pChild );
            if ( aChildURL == aFsysRootURL )
                nStart++;
        }

        long nEnd = nCount - 1;
        long nMid = nEnd / 2;
        StringCompare eCompVal = COMPARE_LESS;

        while ( nStart <= nEnd )
        {
            nMid = ( nEnd - nStart ) / 2 + nStart;
            CntNode* pData = (CntNode*)_pSubNodeList->GetObject( nMid );

            const String& rData = OWN_URL( pData );
            if ( rData > rChild )
            {
                eCompVal = COMPARE_GREATER;
                nEnd = nMid - 1;
            }
            else
            {
                eCompVal = COMPARE_LESS;
                nStart = nMid + 1;
            }
        }

        if ( eCompVal == COMPARE_LESS ) // Array.str < rData
        {
            _pSubNodeList->Insert( pNewChild, nMid + 1 );
        }
        else if ( eCompVal == COMPARE_GREATER ) // Array.str > rData
        {
            _pSubNodeList->Insert( pNewChild, nMid );
        }
    }
}

//----------------------------------------------------------------------------
BOOL CntNode::CancelAllJobs_Impl()
{
	NAMESPACE_VOS( OGuard ) aGuard( getMutex() );

    BOOL bRet = TRUE;

    ULONG nCount = SubNodeCount();
    for ( ULONG n = 0; n < nCount; n++ )
    {
        CntNode* pCurr = GetSubNode( n );
        if ( !pCurr->CancelAllJobs_Impl() )
            bRet = FALSE;
    }

    while ( JobCount() )
    {
        CntNodeJob* pCurr = GetJob( 0 );
        pCurr->Cancel();
    }

    if ( JobCount() )
    {
        DBG_ERROR( "still jobs after cancelling all!" );
        bRet = FALSE;
    }

    return bRet;
}

//----------------------------------------------------------------------------
void CntNode::CompletePutDataRequest_Impl( CntNodeJob* pJob )
{
    // Boot-strapping?
    if ( !IsDummy() )
        return;

    // Boot-strap - complete list item
    SfxItemPool* pPool = GetPool();
    CntItemListItem aItem( (CntItemListItem&)*( pJob->GetRequest() ) );
    SfxWhichIter aIter( *this );
    USHORT nWhich = aIter.FirstWhich();
    while ( nWhich )
    {
        if ( !aItem.Get( nWhich ) )
        {
           	// Dynamic pool default for item set?
           	const SfxPoolItem* pDefault = pPool->GetPoolDefaultItem( nWhich );
           	if ( pDefault )
           	{
				BOOL bValid =
						THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_FOLDER );
				if ( !bValid )
				{
					BOOL bAutoProp =
							IsItemFlag( nWhich, CNT_ITEM_AUTO_VIEWPROP );
					if ( !bAutoProp )
						bAutoProp =
							IsItemFlag( nWhich, CNT_ITEM_AUTO_OWNPROP );
					if ( !bAutoProp )
						bAutoProp =
							IsItemFlag( nWhich, CNT_ITEM_AUTO_USERPROP );

					if ( !bAutoProp )
					{
						// Auto-Props are only for folder-objects.
						bValid = TRUE;
					}
				}

				if ( bValid )
				{
               		const CntDefaults* pDefs = GetDefaults();
               		if ( pDefs )
               		{
						const SfxPoolItem& rItem = pDefs->Get( nWhich );
						if ( !rItem.ISA( CntStringItem ) ||
						 	 ITEM_VALUE( CntStringItem, rItem ).Len() > 0 )
						{
	                   		// Append class default item.
                   			aItem.Append( rItem.Clone() );
						}
               		}
               		else
               		{
						if ( !pDefault->ISA( CntStringItem ) ||
						 	 ITEM_VALUE( CntStringItem, *pDefault ).Len() > 0 )
						{
                   			// Append dynamic pool default item.
                   			aItem.Append( pDefault->Clone() );
						}
               		}
				}
			}
        }
        nWhich = aIter.NextWhich();
    }

    pJob->SetRequest( aItem );
}

//----------------------------------------------------------------------------
void CntNode::SwitchMessageViewMode_Impl( CntNodeJob *pJob,
                                          const SfxPoolItem &rNewMode )
{
    USHORT nCurrent = ITEMSET_VALUE( pJob->GetClient(),
                                     CntMsgViewModeItem,
                                     WID_MESSAGEVIEW_MODE );
    USHORT nNew = ITEM_VALUE( CntMsgViewModeItem, rNewMode );

    if ( nNew == nCurrent )
        return;

    CntItemListItem aListItem( WID_MESSAGEVIEW_MODE );

    if ( nCurrent == CNT_VIEW_ALL_ARTICLES )
    {
        // switching from "All" to something other...
        switch ( nNew )
        {
            case CNT_VIEW_UNREAD_ARTICLES:
                aListItem.Append( new CntBoolItem( WID_IS_READ, TRUE ) );
                break;

            case CNT_VIEW_READ_ARTICLES:
                aListItem.Append( new CntBoolItem( WID_IS_READ, FALSE ) );
                break;

            case CNT_VIEW_MARKED_ARTICLES:
                aListItem.Append( new CntBoolItem( WID_IS_MARKED, FALSE ) );
                break;

            case CNT_VIEW_MARKED_AND_UNREAD_ARTICLES:
                break;

            default:
                DBG_ERROR( "Unknown message viewmode requested!" );
                return;
        }
    }
    else
    {
        // switching from anything to something other...
    }

    CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
    DBG_ASSERT( pClient, "Job client must be a CntAnchor!" );

    // Inform all anchors on top of pClient's node.
    if ( pClient && pClient->GetNode() )
    {
        // Note: Broadcasting an empty ListItem will force a re-open of
        //       the notified anchor.
        pClient->GetNode()->Broadcast( SfxPoolItemHint( &aListItem ) );
    }
}

//----------------------------------------------------------------------------
void CntNode::SwitchSentMessageViewMode_Impl( CntNodeJob *pJob,
                                              const SfxPoolItem &rNewMode )
{
    USHORT nCurrent = ITEMSET_VALUE( pJob->GetClient(),
                                     CntSentMsgViewModeItem,
                                     WID_SENTMESSAGEVIEW_MODE );
    USHORT nNew = ITEM_VALUE( CntSentMsgViewModeItem, rNewMode );

    if ( nNew == nCurrent )
        return;

    CntItemListItem aListItem( WID_SENTMESSAGEVIEW_MODE );

    if ( nCurrent == CNT_SENT_VIEW_ALL_ARTICLES )
    {
        // switching from "All" to something other...
        switch ( nNew )
        {
            case CNT_SENT_VIEW_SENT_ARTICLES:
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_WRITTEN ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_PARTIALLY_LOCALLY_SENT ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_RECOVERABLE_LOCAL_ERROR ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_NONRECOVERABLE_LOCAL_ERROR ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_EXTERNAL_ERROR ) );
                break;

            case CNT_SENT_VIEW_UNSENT_ARTICLES:
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_COMPLETELY_LOCALLY_SENT ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_WAITING_CONFIRMATION ) );
                aListItem.Append( new CntOutMsgInternalStateItem(
                    WID_OUTMSGINTERNALSTATE,
                    CNT_OUTMSG_INTERNALSTATE_CONFIRMED ) );
                break;

            case CNT_SENT_VIEW_MARKED_ARTICLES:
                aListItem.Append( new CntBoolItem( WID_IS_MARKED, FALSE ) );
                break;

            default:
                DBG_ERROR( "Unknown sent message viewmode requested!" );
                return;
        }
    }
    else
    {
        // switching from anything to something other...
    }

    CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
    DBG_ASSERT( pClient, "Job client must be a CntAnchor!" );

    // Inform all anchors on top of pClient's node.
    if ( pClient && pClient->GetNode() )
    {
        // Note: Broadcasting an empty ListItem will force a re-open of
        //       the notified anchor.
        pClient->GetNode()->Broadcast( SfxPoolItemHint( &aListItem ) );
    }
}

//----------------------------------------------------------------------------
void CntNode::SwitchFolderViewMode_Impl( CntNodeJob *pJob,
                                         const SfxPoolItem &rNewMode )
{
    USHORT nCurrent = ITEMSET_VALUE( pJob->GetClient(),
                                     CntFolderViewModeItem,
                                     WID_FOLDERVIEW_MODE );
    USHORT nNew = ITEM_VALUE( CntFolderViewModeItem, rNewMode );

    if ( nNew == nCurrent )
        return;

    CntItemListItem aListItem( WID_FOLDERVIEW_MODE );

    if ( nCurrent == CNT_VIEW_ALL_FOLDERS )
    {
        // switching from "All" to something other...
        switch ( nNew )
        {
            case CNT_VIEW_SUBSCRIBED_FOLDERS:
                aListItem.Append(
                        new CntBoolItem( WID_FLAG_SUBSCRIBED, FALSE ) );
                break;

            case CNT_VIEW_ACTIVE_FOLDERS:
                // aktiv = abonniert && (gelesene Nachrichten == 0)
                break;

            case CNT_VIEW_NEW_FOLDERS:
                // destroy all + update
                aListItem.Append(
                        new CntBoolItem( WID_UPDATE, TRUE ) );
                break;

            default:
                DBG_ERROR( "Unknown folder viewmode requested!" );
                return;
        }
    }
    else
    {
        // switching from anything to something other...
    }

    CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
    DBG_ASSERT( pClient, "Job client must be a CntAnchor!" );

    // Inform all anchors on top of pClient's node.
    if ( pClient && pClient->GetNode() )
    {
        // Note: Broadcasting an empty ListItem will force a re-open of
        //       the notified anchor.
        pClient->GetNode()->Broadcast( SfxPoolItemHint( &aListItem ) );
    }
}

//----------------------------------------------------------------------------
void CntNode::SwitchFilter_Impl( CntNodeJob *pJob,
								 const SfxPoolItem &rNewMode )
{
    BOOL bNew = ITEM_VALUE( CntBoolItem, rNewMode );
    BOOL bCurrent =
			ITEMSET_VALUE( pJob->GetClient(), CntBoolItem, WID_FILTERED );

	// No compare here, because this function is called too, when the
	// rules (WID_RULES) have changed.
	//    if ( bNew == bCurrent )
	//        return;

    CntItemListItem aListItem( WID_FILTERED );

    CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
    DBG_ASSERT( pClient, "Job client must be a CntAnchor!" );

    // Inform all anchors on top of pClient's node.
    if ( pClient && pClient->GetNode() )
    {
        // Note: Broadcasting an empty ListItem will force a re-open of
        //       the notified anchor.
        pClient->GetNode()->Broadcast( SfxPoolItemHint( &aListItem ) );
    }
}

//----------------------------------------------------------------------------
void CntNode::SwitchThreading_Impl( CntNodeJob *pJob,
									const SfxPoolItem &rNewMode )
{
    BOOL bNew = ITEM_VALUE( CntBoolItem, rNewMode );
    BOOL bCurrent =
			ITEMSET_VALUE( pJob->GetClient(), CntBoolItem, WID_THREADED );

    if ( bNew == bCurrent )
        return;

    CntItemListItem aListItem( WID_THREADED );

    CntAnchor* pClient = PTR_CAST( CntAnchor, pJob->GetClient() );
    DBG_ASSERT( pClient, "Job client must be a CntAnchor!" );

    // Inform all anchors on top of pClient's node.
    if ( pClient && pClient->GetNode() )
    {
        // Note: Broadcasting an empty ListItem will force a re-open of
        //       the notified anchor.
        pClient->GetNode()->Broadcast( SfxPoolItemHint( &aListItem ) );
    }
}

//----------------------------------------------------------------------------
// virtual
com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
CntNode::getInterface() const
{
	return com::sun::star::uno::Reference< com::sun::star::uno::XInterface >();
}

//----------------------------------------------------------------------------
// static
void CntNode::SetClassDefaults( CntDefaults** ppDefs, CntDefaults* pNewDefs )
{
	*ppDefs = pNewDefs;
	if ( ppDefs )
		CNT_DATA()->_pDefaultsList->Insert( ppDefs );
}

//----------------------------------------------------------------------------
const CntItemListItem* CntNode::GetChildDefaultsItem() const
{
    if ( IsRootNode() )
        return NULL;

    if ( !CntViewBase::IsSubViewURL( OWN_URL( this ) ) )
        return NULL;

    // Get defaults item for my content type.
    const INetContentType eType = GetMostReferedNode()->GetCreator()->GetId();
    CntItemListItem& rAllDefsItem =
            (CntItemListItem&)GetRootNode()->Get( WID_CHILD_DEFAULTS );
    USHORT nCount = rAllDefsItem.Count();
    for ( USHORT n = 0; n < nCount; ++n )
    {
        CntItemListItem* pDefsItem = (CntItemListItem*)&(rAllDefsItem[ n ]);
        const CntContentTypeItem* pTypeItem =
                (const CntContentTypeItem*)pDefsItem->Get( WID_CONTENT_TYPE );
        if ( pTypeItem )
        {
            const INetContentType eCurrType = pTypeItem->GetEnumValue();
            if ( eCurrType == eType )
                return pDefsItem;
        }
    }

    return NULL;
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntNode::GetInheritedItem( USHORT nWhich ) const
{
    CntNode* pParent = GetParent();

    // Is item in parents ranges?
    const SfxPoolItem* pItem = NULL;
    if ( pParent->GetItemState( nWhich, TRUE, &pItem ) >= SFX_ITEM_DEFAULT )
    {
        CntDefaults* pDefs    = GetMostReferedNode()->GetDefaults();
        CntDefaults* pParDefs = pParent->GetMostReferedNode()->GetDefaults();

        if ( pDefs && pParDefs )
        {
            // Unequal class defaults -> item cannot be inherited from
            // parent.
            if ( pDefs->Get( nWhich ) != pParDefs->Get( nWhich ) )
                return NULL;
        }

        return pItem;
    }

    return NULL;
}

//----------------------------------------------------------------------------
BOOL DestroyViewProperties_Impl( CntNodeJob* pJob, CntNode* pNode )
{
    if ( pNode->IsRootNode() || !pNode->GetParent() )
        return FALSE;

    CntStorageNode* pView = pJob->GetViewDataNode( FALSE );
    if ( !pView )
        return FALSE;

    // Remove any possible stored view data for the node and it's children.

	String aWild( OWN_URL( pNode->GetMostReferedNode() ) );
	aWild += '*';
	aWild.AppendAscii( RTL_CONSTASCII_STRINGPARAM( STG_PROPS_EXTENSION ) );

	WildCard aPattern( aWild );

	// Iteration over all hidden entries.
	CntStorageIterator aIter( CNTDIRENTRY_ATTRIB_HIDDEN, 0 );
	String aEntry( pView->iter( aIter ) );

	while ( aEntry.Len() )
	{
		if ( aPattern.Matches( aEntry ) )
			pView->remove( aEntry );

		aEntry = pView->iter( aIter );
	}

    return TRUE;
}

//----------------------------------------------------------------------------
void DumpJob_Impl( CntNode* pNode, CntNodeJob* pJob )
{
#ifdef DBG_UTIL
    SvFileStream aDump( UniString::CreateFromAscii(
							RTL_CONSTASCII_STRINGPARAM( "c:\\chaos.log" ) ),
						STREAM_STD_READWRITE );
    aDump.Seek( STREAM_SEEK_TO_END );
    UniString aLine( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM(
			"--------------------------------------------------------" ) ) );
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    DateTime aCurrDateTime;
    aLine = UniString( aCurrDateTime.GetDate() ).ToInt32();
    aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " : " ) );
    aLine += aCurrDateTime.GetTime();
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "conn: " );
    USHORT eConnMode = ( (const CntConnModeItem&)
                        CNT_RNM()->CntNode::Get( WID_CONNECTION_MODE ) )
                        .GetValue();
	if ( ( eConnMode == CNT_CONN_MODE_ONLINE ) )
    	aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "online" ) );
	else
    	aLine.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "offline" ) );

    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "requ: " );

    aLine += pJob->GetRequest()->Which();
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "valu: " );
    UniString aText;
    if( pJob->GetRequest()->ISA(CntStringItem) )
        aText = ITEM_VALUE( CntStringItem, *(pJob->GetRequest()) );
    else
        pJob->GetRequest()->GetPresentation( SFX_ITEM_PRESENTATION_COMPLETE,
                                             SFX_MAPUNIT_APPFONT,
                                             SFX_MAPUNIT_APPFONT,
                                             aText );
    aLine += aText;
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "clnt: " );
    aLine += OWN_URL( ( (CntAnchor*)pJob->GetClient() )->GetNode() );
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "subj: " );
    aLine += OWN_URL( pJob->GetSubject() );
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
    aLine.AssignAscii( "this: " );
    aLine += OWN_URL( pNode );
    aDump.WriteByteStringLine( aLine, RTL_TEXTENCODING_ASCII_US );
#endif
}

//============================================================================
//
// CntNodeHint Implementation.
//
//============================================================================

TYPEINIT1( CntNodeHint, SfxHint );

//----------------------------------------------------------------------------
CntNodeHint::CntNodeHint( CntNode *pNode, CntAction eAction, CntNodeJob* pJob )
:   _xNode( pNode ),
    _eAction( eAction ),
	_xJob( pJob )
{
//	DBG_ASSERT( pJob,"CntNodeHint - No job!" );
}

//============================================================================
//
// CntNodeItem Implementation.
//
//============================================================================

TYPEINIT1( CntNodeItem, SfxPoolItem );

//----------------------------------------------------------------------------
CntNodeItem::CntNodeItem( const CntNodeItem &rOrig )
:   SfxPoolItem( rOrig.Which() ),
    _xNode( rOrig._xNode )
{
}

//----------------------------------------------------------------------------
CntNodeItem::CntNodeItem( USHORT nID, CntNode * pNode )
:   SfxPoolItem( nID ),
    _xNode( pNode )
{
}

//----------------------------------------------------------------------------
// virtual
int CntNodeItem::operator==( const SfxPoolItem& rItem ) const
{
    // only pointer compare
    return &((CntNodeItem&)rItem)._xNode == &_xNode;
}

//----------------------------------------------------------------------------
// virtual
SfxPoolItem* CntNodeItem::Clone( SfxItemPool *pPool ) const
{
    return new CntNodeItem( *this );
}

//============================================================================
//
// CntURLTransformer Implementation.
//
//============================================================================

// static
BOOL CntURLTransformer::NormalizeURL( String& rURL )
{
	return chaos::NormalizeURL( rURL );
}

//----------------------------------------------------------------------------
// static
BOOL CntURLTransformer::ToExternalURL( String& rURL )
{
	ULONG nCount = CNT_RNM()->FactoryCount();
	for ( ULONG n = 0; n < nCount; ++n )
	{
		CntNodeFactory* pFac  = CNT_RNM()->GetFactory( n );
		const String& rScheme = pFac->GetInternalScheme();

		if ( rScheme.Len() && ( rScheme.Match( rURL ) == STRING_MATCH ) )
		{
			rURL.SearchAndReplace( rScheme, pFac->GetExternalScheme() );
			break;
		}
	}

	return TRUE;
}

//----------------------------------------------------------------------------
// static
BOOL CntURLTransformer::ToInternalURL( String& rURL )
{
	static const UniString aPrefix(
			UniString::CreateFromAscii(
				RTL_CONSTASCII_STRINGPARAM(	INET_VENDOR_SCHEME_PREFIX ) ) );

	UniString aLowerURL( rURL );
	aLowerURL.ToLowerAscii();
	if ( aPrefix.Match( aLowerURL ) == STRING_MATCH )
	{
		ULONG nCount = CNT_RNM()->FactoryCount();
		for ( ULONG n = 0; n < nCount; ++n )
		{
			CntNodeFactory* pFac  = CNT_RNM()->GetFactory( n );
			const String& rScheme = pFac->GetExternalScheme();

			UniString aLowerScheme( rScheme );
			aLowerScheme.ToLowerAscii();
			if ( rScheme.Len() &&
				 ( aLowerScheme.Match( aLowerURL ) == STRING_MATCH ) )
			{
				String aTemp( pFac->GetInternalScheme() );
				aTemp += rURL.Copy( rScheme.Len() );
				rURL = aTemp;
				break;
			}
		}
	}

	return TRUE;
}

