/*************************************************************************
 *
 *  $RCSfile: cntmsgnd.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _INETCOREMSG_HXX //autogen
#include <inet/inetmsg.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif

#include <cntmsgnd.hxx>

#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _ULSTITEM_HXX
#include <ulstitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CNTMBITM_HXX
#include <cntmbitm.hxx>
#endif
#ifndef _CNTDEFS_HXX
#include <cntdefs.hxx>
#endif
#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif

using namespace chaos;

//============================================================================
//
// CntMessageNode Implementation.
//
//============================================================================

TYPEINIT1_AUTOFACTORY( CntMessageNode, CntDocumentNode );

//----------------------------------------------------------------------------
// ranges array
USHORT __READONLY_DATA aMsgRanges_Impl[] =
{
	// no WID_DUMMY_ARG1 - WID_FACTORY_NAME
	WID_NEWS_XREF,			WID_NEWS_XREF,
	// no WID_CREATION_FLAGS, WID_DUMMY_ARG3
	WID_MSG_START,			WID_HIDE_SUBJECT,
	// no WID_RESEND_MSG,
	WID_MARK_THREAD_UNREAD,	WID_NEWS_XREFLIST,
	// no WID_OUTMSGINTERNALSTATE, WID_RECIPIENTLIST, WID_DEFAULT
	WID_OPEN,				WID_PASTE,
	// no WID_RENAME
	WID_HAS_DATA,			WID_ALL_END,
	// no WID_SYNCHRONIZE - WID_CREATE_NEW
	WID_INSERT,				WID_INSERT,
	// no WID_UPDATE - WID_SERVERPORT
	WID_MAILSEND_USERNAME,	WID_SERVERBASE,
	// no WID_SMTP_GATEWAY - WID_LAST_UID
	WID_UNDELETE,			WID_REOPEN,
	// no WID_RNM_FILECONVERSION_LIST - WID_MSG_COLUMN_WIDTHS
	WID_PROPERTYLIST,		WID_SEND_VIM_POPATH,
	WID_DOCUMENT_HEADER,	WID_DOCUMENT_SIZE,
	WID_EXPORT,				WID_EXPORT,
	WID_ACTION_LIST,		WID_ACTION_LIST,
	WID_SEND_FORMATS,		WID_SEND_COPY_TARGET,
	0
};

//----------------------------------------------------------------------------
CNT_NODE_SUBCLASS_IMPL( CntMessageNode )
{
	// No factories to register...
}

//----------------------------------------------------------------------------
CntMessageNode::CntMessageNode( const USHORT *pRanges /* = NULL */ )
: 	CntDocumentNode( pRanges ? pRanges : aMsgRanges_Impl ),
	_bIsLocked( FALSE )
{
    // No class defaults set?
	CntDefaults* pClassDefs = GetDefaults();
	if ( pClassDefs == NULL )
	{
        // Create class defaults
		pClassDefs = new CntDefaults(
			*this, aMsgRanges_Impl, CntDocumentNode::GetDefaults() );

        // Set defaults for a message
		pClassDefs->Put( CntContentTypeItem(
			WID_CONTENT_TYPE, CONTENT_TYPE_X_CNT_MESSAGE ) );

		pClassDefs->Put( CntBoolItem( WID_FLAG_IS_MESSAGE, TRUE ) );

		pClassDefs->Put( CntBoolItem( WID_FLAG_READONLY, TRUE ) );
	}
	CntInterface::SetParent( pClassDefs );
}

//----------------------------------------------------------------------------
// virtual
CntMessageNode::~CntMessageNode()
{
}

//----------------------------------------------------------------------------
// virtual
FASTBOOL CntMessageNode::IsItemFlag( USHORT nWID, USHORT nFlag ) const
{
	switch ( nFlag )
	{
		case CNT_ITEM_HIDDEN:
		{
			switch ( nWID )
			{
				case WID_USERNAME:
				case WID_PASSWORD:
				case WID_SERVERNAME:
				case WID_MAILSEND_USERNAME:
				case WID_MAILSEND_PASSWORD:
				case WID_MAILSEND_SERVERNAME:
				case WID_NEWSSEND_USERNAME:
				case WID_NEWSSEND_PASSWORD:
				case WID_NEWSSEND_SERVERNAME:
				case WID_REPLY_TO_DEFAULT:
				case WID_FROM_DEFAULT:
				case WID_SERVERBASE:

				case WID_SEND_USERNAME:
				case WID_SEND_PASSWORD:
				case WID_SEND_SERVERNAME:
				case WID_SEND_REPLY_TO_DEFAULT:
				case WID_SEND_FROM_DEFAULT:
				case WID_SEND_PUBLIC_PROT_ID:
				case WID_SEND_PRIVATE_PROT_ID:
				case WID_SEND_PUBLIC_OUTBOXPROPS:
				case WID_SEND_PRIVATE_OUTBOXPROPS:
				case WID_SEND_VIM_POPATH:
				case WID_SEND_FORMATS:
				case WID_SEND_COPY_TARGET:
					// Do never show these items (for instance on property
					// tab pages)
					return TRUE;

				default:
					break;
			}

			break;
		}

		default:
			break;
	}

	return CntInterface::IsItemFlag( nWID, nFlag );
}

//----------------------------------------------------------------------------
// virtual
const SfxPoolItem* CntMessageNode::ExecuteJob( CntNodeJob *pJob )
{
	switch ( pJob->GetRequest()->Which() )
	{
		case WID_MESSAGEBODY:
		{
			const CntMessageBodyItem* pBody =
							(const CntMessageBodyItem*)pJob->GetRequest();
			INetCoreNewsMessage* pMessage = pBody->Get();

			if ( !pMessage )
				break;

			CntNode* pSubject = pJob->GetSubject();

			// Set WID's corresponding to header fields of pMessage.
			String aStr;

			aStr = pMessage->GetFrom();
			if ( aStr.Len() )
				pSubject->Put( CntNameItem( WID_FROM, aStr ) );

			aStr = pMessage->GetReplyTo();
			if ( aStr.Len() )
				pSubject->Put( CntStringItem( WID_REPLY_TO, aStr ) );

			if ( pSubject->GetItemState( WID_TO, FALSE ) != SFX_ITEM_SET )
			{
				aStr = pMessage->GetTo();
				if ( aStr.Len() )
					pSubject->Put( CntStringItem( WID_TO, aStr ) );
			}

			if ( pSubject->GetItemState( WID_CC, FALSE ) != SFX_ITEM_SET )
			{
				aStr = pMessage->GetCC();
				if ( aStr.Len() )
					pSubject->Put( CntStringItem( WID_CC, aStr ) );
			}

			if ( pSubject->GetItemState( WID_BCC, FALSE ) != SFX_ITEM_SET )
			{
				aStr = pMessage->GetBCC();
				if ( aStr.Len() )
					pSubject->Put( CntStringItem( WID_BCC, aStr ) );
			}

			if ( pSubject->GetItemState( WID_NEWSGROUPS, FALSE ) != SFX_ITEM_SET )
			{
				aStr = pMessage->GetNewsgroups();
				if ( aStr.Len() )
					pSubject->Put( CntStringItem( WID_NEWSGROUPS, aStr ) );
			}

			aStr = pMessage->GetSubject();
			if ( aStr.Len() )
				pJob->GetViewDataTarget()->CntInterface::Put(
								CntStringItem( WID_TITLE, aStr ), WID_TITLE );

			aStr = pMessage->GetInReplyTo();
			if ( aStr.Len() )
				pSubject->Put( CntStringItem( WID_IN_REPLY_TO, aStr ) );

			aStr = pMessage->GetReferences();
			if ( aStr.Len() )
				pSubject->Put( CntStringItem( WID_REFERENCES, aStr ) );

			break;
		}

		default:
			break;
	}

	return CntDocumentNode::ExecuteJob( pJob );
}

//----------------------------------------------------------------------------
BOOL CntMessageNode::SetIsLocked( BOOL bNew )
{
	BOOL bOld = _bIsLocked;
	_bIsLocked = bNew;
	return bOld;
}

