/*************************************************************************
 *
 *  $RCSfile: cntdata.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_SIMPLERESMGR_HXX_
#include <tools/simplerm.hxx>
#endif
#ifndef _INET_WRAPPER_HXX
#include <inet/wrapper.hxx>
#endif
#ifndef _SFXCANCEL_HXX
#include <svtools/cancel.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include "inimgr.hxx"
#endif
#ifndef _CNTDEFS_HXX
#include "cntdefs.hxx"
#endif
#ifndef _CNTNODE_HXX
#include "cntnode.hxx"
#endif

#include <cntdata.hxx>

using namespace chaos;

/*========================================================================
 *
 * CntSystemData_Impl Implementation.
 *
 *======================================================================*/

CntSystemData_Impl::CntSystemData_Impl()
:	_pProcessServiceMgr( NULL ),
	_pIniMgr( NULL ),
	_pExtCancelMgr( NULL ),
	_pOwnCancelMgr( NULL ),
	_pResMgr( NULL ),
	_pINetWrapper( NULL ),
	_nInterimURL( 0 ),
	_pDefaultsList( new CntDefaultsList( 64, 4 ) ),
	_pFactoriesList( new CntNodeFactoryListList( 16, 4 ) ),
	_bCHAOSAvail( TRUE )
{
}

//----------------------------------------------------------------------------
CntSystemData_Impl::~CntSystemData_Impl()
{
	if ( _pProcessServiceMgr )
		_pProcessServiceMgr->release();

	delete _pIniMgr;

	// Do not delete _pExtCancelMgr!!!

	delete _pOwnCancelMgr;

	delete _pResMgr;

	delete _pINetWrapper;

	while ( _pDefaultsList->Count() )
	{
		CntDefaults** ppDefs = _pDefaultsList->GetObject( 0 );
		_pDefaultsList->Remove( ppDefs );
		delete *ppDefs;
		*ppDefs = NULL;
		ppDefs = NULL;
	}
	delete _pDefaultsList;

	while ( _pFactoriesList->Count() )
	{
		CntNodeFactoryList** ppList = _pFactoriesList->GetObject( 0 );
		_pFactoriesList->Remove( ppList );
		delete *ppList;
		*ppList = NULL;
		ppList = NULL;
	}
	delete _pFactoriesList;
}

