/*************************************************************************
 *
 *  $RCSfile: cntapi.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EINF_HXX //autogen
#include <tools/errinf.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SVTOOLS_CINTITEM_HXX
#include <svtools/cintitem.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXNRANGES_HXX
#include <svtools/nranges.hxx>
#endif

#include <cntapi.hxx>

#ifndef _CNTRIDS_HRC
#include <cntrids.hrc>
#endif
#ifndef _CNTDATA_HXX
#include <cntdata.hxx>
#endif
#ifndef _ILSTITEM_HXX
#include <ilstitem.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _OUTITEMS_HXX
#include <outitems.hxx>
#endif
#ifndef _CNTSITEM_HXX
#include <cntsitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CNTTRITM_HXX
#include <cnttritm.hxx>
#endif
#ifndef _CNTCMITM_HXX
#include <cntcmitm.hxx>
#endif
#ifndef _CNTTHRD_HXX
#include <cntthrd.hxx>
#endif
#ifndef _CNTRESID_HXX
#include <cntresid.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTMSGNODE_HXX
#include <cntmsgnd.hxx>
#endif
#ifndef _CNTSTGND_HXX
#include <cntstgnd.hxx>
#endif
#ifndef _CNTVNODE_HXX
#include <cntvnode.hxx>
#endif
#ifndef _CNTOUT_HXX
#include <cntout.hxx>
#endif
#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif
#ifndef _CNTSDITM_HXX
#include <cntsditm.hxx>
#endif
#ifndef _CNTANCHR_HXX
#include <cntanchr.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _CNTSYS_HXX
#include <cntsys.hxx>
#endif
#ifndef _CHAOS_INIMGR_HXX
#include <inimgr.hxx>
#endif

using namespace chaos;

// Macro fuer den Call-Profiler unter WinNT
// mit S_CAP kann eine Messung gestarted, mit E_CAP wieder gestoppt werden
#if defined( WNT ) && defined( PROFILE )

extern "C" {
	void StartCAP();
	void StopCAP();
	void DumpCAP();
};

#define S_CAP	StartCAP();
#define E_CAP	StopCAP(); DumpCAP();

#endif

static void CleanUpParentChain_Impl( CntAnchor *pParent );
static CntNode* QueryNode_Impl( const String& rURL );

// ranges array
//USHORT __READONLY_DATA aDummyAnchorRanges_Impl[] =
USHORT __READONLY_DATA aMaxAnchorRanges_Impl[] =
{
	WID_MARK_THREAD_READ,		WID_MARK_THREAD_READ,
	WID_MARK_THREAD_UNREAD,		WID_MARK_THREAD_UNREAD,
	WID_PRIORITY, 				WID_MSG_END,
	WID_TITLE,					WID_IS_READ,
	WID_SORTING,				WID_SORTING,
	WID_VIEW_START,				WID_VIEW_END,
	WID_VIEW2_START,			WID_VIEW2_END,
	WID_USER_SORT_CRITERIUM,	WID_HEADER_CONFIG,
	0
};

// ranges array
USHORT __READONLY_DATA aMinAnchorRanges_Impl[] =
{
	WID_TITLE, 					WID_TITLE,
	WID_FLAG_IS_DOCUMENT,	 	WID_FLAG_IS_DOCUMENT,
	0
};

// ranges array
USHORT __READONLY_DATA aVirtualMsgFolderRanges2_Impl[] =
{
	WID_MARK_THREAD_READ,		WID_MARK_THREAD_READ,
	WID_HIDE_SUBJECT,			WID_HIDE_SUBJECT,
	WID_MARK_THREAD_UNREAD,		WID_MARK_THREAD_UNREAD,
	WID_SEEN_STATUS, 			WID_SEEN_STATUS,
	WID_TITLE, 					WID_TITLE,
	WID_DATE_CREATED,			WID_IS_READ,
	0
};

// ranges array
USHORT __READONLY_DATA aViewAnchorRanges_Impl[] =
{
	WID_SEEN_STATUS,				WID_SEEN_STATUS,
	WID_TITLE, 						WID_TITLE,
	WID_MSG_COLUMN_INFO,			WID_MSG_COLUMN_INFO,
	WID_FOLDERVIEW_MODE, 			WID_RULES,
	WID_FLAG_SUBSCRIBED,			WID_FLAG_SUBSCRIBED,
	WID_FROM_DEFAULT,				WID_UPDATE_ENABLED,
	WID_SHOW_MSGS_HAS_TIMELIMIT,	WID_SHOW_MSGS_TIMELIMIT,
	WID_MSG_COLUMN_WIDTHS,			WID_MSG_COLUMN_WIDTHS,
	WID_SEND_PUBLIC_PROT_ID,		WID_SEND_PRIVATE_OUTBOXPROPS,
	WID_SEND_REPLY_TO_DEFAULT,		WID_SEND_FROM_DEFAULT,
	WID_VIEW_START,					WID_VIEW_END,
	WID_VIEW2_START,				WID_VIEW2_END,
	WID_USER_SORT_CRITERIUM,		WID_HEADER_CONFIG,
	WID_SEND_FORMATS,				WID_SEND_COPY_TARGET,
	0
};

static String aEmptyString_Impl;

//============================================================================

#define MAX_CHILD_COUNT 2500

//============================================================================
//
// CntAnchor Implementation.
//
//============================================================================

TYPEINIT1( CntAnchor, CntInterface );

//----------------------------------------------------------------------------
#define CNTANCHOR_INIT()		\
	CntInterface( aMinAnchorRanges_Impl ), \
	_pSubAnchors( 0 ),			\
	_pParentAnchor( pParent ),	\
	_pThreader( 0 ),			\
	_pCntThreadData( 0 ),		\
	_bIsThreaded( FALSE ),		\
	_bGetDataDone( FALSE ),		\
	_bIgnoreFilterdMsg( FALSE ),\
	_bIsInserted( FALSE ),		\
	_bIgnoreNodes( FALSE ),		\
	_bMarkedAsRead( FALSE ),	\
	_bDontThread( FALSE ),		\
	_bLocked( FALSE ),			\
	_bIsOpen( FALSE ),			\
	_bIsExpanded( FALSE ),		\
	_bMarkedAsRoot( FALSE ),	\
	_bIsVisible( FALSE ),		\
	_bNeedRelease( FALSE ),		\
	_bInitSubAnchors( FALSE ),	\
	_bHasRules( TRUE ),			\
	_bShowFolders( FALSE ),		\
	_bShowDocuments( FALSE ),	\
	_bIsDocument( TRUE ),		\
	_bUsesNewView( FALSE ),		\
	_bInOpen( FALSE ),			\
	_bIsVisibleRoot( FALSE ),	\
	_bExpanding( FALSE ),		\
	_bCleanupParents( FALSE ),	\
	_bNotifyExpanded( FALSE ),	\
	_bFolderFirst( FALSE ),		\
	_bCollectAnchors( FALSE ),	\
	_bIsRootAnchor( FALSE ),	\
	_bNotifyAll( FALSE ),		\
	_nError( ERRCODE_NONE ),	\
	_nSeenCount( 0 ),			\
	_nTotalChildren( 0 ),		\
	_nSortingInfo( 0 ),			\
	_nOpenCount( 0 ),			\
	_pSearchData( 0 ),			\
	_pChildList( 0 ),			\
	_pNextBrother( 0 ),			\
	_pChangedItem( 0 ),			\
	_pOpenData( 0 ),			\
	_pImpData( 0 )

//----------------------------------------------------------------------------
CntAnchor::CntAnchor( CntAnchor* pParent, const String& rURL, BOOL bCheckURL )
:	CNTANCHOR_INIT()
{
	_pImpData = new CntAnchor_Impl;
	vos::OGuard aGuard( *GetMutex() );

	_nError = 1;

	if ( rURL.Len() )
	{
		// Is CHAOS available?
		if ( CntRootNodeMgr::IsCHAOS() )
		{
			CntNodeRef xNode( NULL );

			String aURL( rURL );
			BOOL   bURLValid = !bCheckURL;

			if ( bCheckURL )
				bURLValid = NormalizeURL( aURL );

			if ( bURLValid )
			{
				xNode = QueryNode_Impl( aURL );
				if ( xNode.Is() )
				{
					// Set refered node.
					SetNode( xNode );

					// Success!
					_nError = 0;
				}
			}
		}
	}

	if ( _pParentAnchor )
	{
		_pNextBrother = _pParentAnchor->_pChildList;
		_pParentAnchor->_pChildList = this;
	}

	if ( _nError )
	{
		// Error!
		SetRanges( aMaxAnchorRanges_Impl );
		_xNode.Clear();
	}
}

//----------------------------------------------------------------------------
CntAnchor::CntAnchor( CntAnchor* pParent, CntNode* pNode )
:	CNTANCHOR_INIT()
{
	_pImpData = new CntAnchor_Impl;
	vos::OGuard aGuard( *GetMutex() );

	if ( pParent )
	{
		_pNextBrother = pParent->_pChildList;
		pParent->_pChildList = this;
	}

	// Is CHAOS available?
	if ( CntRootNodeMgr::IsCHAOS() )
	{
		if ( pNode )
		{
			// Set refered node.
			CntNodeRef xNode( pNode );
			SetNode( xNode );

			// Success!
			return;
		}

		// No error - Dummy anchor.
	}
	else
	{
		// Error!
		_nError = 1;
	}

	// Error / Dummy anchor
	SetRanges( aMaxAnchorRanges_Impl );
	_xNode.Clear();
}

//----------------------------------------------------------------------------
// virtual
CntAnchor::~CntAnchor()
{
	vos::OClearableGuard aGuard( *GetMutex() );

	// send outstanding close events
	if ( _nOpenCount && _xNode.Is() )
	{
		CntNodeJob *pJob = new CntNodeJob( NULL, _xNode, _xNode,
							   CntInt32Item( WID_CLOSE, _nOpenCount ) );

		// Enqueue job in referred node.
		_xNode->InsertJob( pJob );
	}

	RemoveSubAnchors( FALSE );
	RemoveFromNode();

	_pThreader = NULL;

	// in _pChildList stehen alle Anker, die diesen Anker als Parent haben,
	// aber nicht ueber InsertSubAnchor eingefuegt wurden. Bei diesen Ankern
	// wird der Parent auf NULL gesetzt um Zugriffe auf den geloeschten Anker
	// zu vermeiden
	while ( _pChildList )
	{
		CntAnchor *pChild = _pChildList;
		pChild->_pParentAnchor = NULL;
		_pChildList = pChild->_pNextBrother;
		pChild->_pNextBrother = NULL;;
	}

	if ( GetParent() )
	{
		if ( _bIsInserted )
			GetParent()->RemoveSubAnchor( this, FALSE );
		else
			GetParent()->RemoveFromChildList( this );
	}

	if ( _xNode.Is() )
		EndListening( *&_xNode );

	aGuard.clear();

	DELETEZ( _pCntThreadData );
	DELETEZ( _pSearchData );
	DELETEZ( _pOpenData );
	DELETEZ( _pImpData );

	DBG_ASSERT( _nTotalChildren == 0, "Not all Children removed?" );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntAnchor::Put_NonPersist( const SfxPoolItem& rProp )
{
	return PutItem_Impl( rProp, rProp.Which(), FALSE, NULL, NULL, NULL );
}

//----------------------------------------------------------------------------
// virtual
const SfxPoolItem* CntAnchor::Put( const SfxPoolItem& rProp, USHORT nWhich )
{
	return PutItem_Impl( rProp, nWhich, TRUE, NULL, NULL, NULL );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntAnchor::Put( const SfxPoolItem& rProp,
								   SfxCancellable** pCancellable )
{
	return PutItem_Impl( rProp, rProp.Which(), TRUE, NULL, NULL, pCancellable );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntAnchor::Put( const SfxPoolItem& rProp,
								   const Link& rErrorHandler,
								   SfxCancellable** pCancellable,
								   ChaosTaskBase * pTaskBase )
{
	return PutItem_Impl(
			rProp, rProp.Which(), TRUE, NULL, &rErrorHandler, pCancellable,
			pTaskBase );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntAnchor::Put( CntNodeJob* pJob )
{
	const SfxPoolItem* pReq = pJob->GetRequest();
	return PutItem_Impl(
			*pReq, pReq->Which(), pJob->IsMakePersist(), pJob, NULL, NULL );
}

//----------------------------------------------------------------------------
const SfxPoolItem* CntAnchor::PutItem_Impl( const SfxPoolItem& rProp,
										   	USHORT nWhich,
										   	BOOL bMakePersist,
										   	CntNodeJob* pJob,
											const Link* pErrorHandler,
										   	SfxCancellable** pCancellable,
											ChaosTaskBase * pTaskBase )
{
	vos::OClearableGuard aGuard( *GetMutex() );

	CntOpenMode	  eOpenMode;
	USHORT		  nWhichId = rProp.Which();
	SfxPoolItem*  pNewProp = NULL;
	CntNodeJobRef xJob( pJob );

	// Is node "deleted"?
	if ( _xNode.Is() && _xNode->IsDead() )
		return NULL;

	switch ( nWhichId )
	{
		case WID_SORTING:
			CntInterface::Put( rProp, nWhichId );
			break;

		case WID_MARK_THREAD_READ:
		case WID_MARK_THREAD_UNREAD:
		case WID_MARK_THREAD_MARKED:
		case WID_MARK_THREAD_UNMARKED:
		{
			CntAnchor *pAnchor = this;

			while ( pAnchor->GetThreader() && ( pAnchor->GetThreader() !=
												pAnchor->GetParent() ) )
				pAnchor = pAnchor->GetParent();

			if ( WID_MARK_THREAD_READ == nWhichId )
				pAnchor->MarkThread( CntBoolItem( WID_IS_READ, TRUE ) );
			else if ( WID_MARK_THREAD_UNREAD == nWhichId )
				pAnchor->MarkThread( CntBoolItem( WID_IS_READ, FALSE ) );
			else if ( WID_MARK_THREAD_MARKED == nWhichId )
				pAnchor->MarkThread( CntBoolItem( WID_IS_MARKED, TRUE ) );
			else
				pAnchor->MarkThread( CntBoolItem( WID_IS_MARKED, FALSE ) );
			return NULL;
		}

		case WID_CLOSE:
			_bShowDocuments = FALSE;
			_bShowFolders 	= FALSE;

			if ( _nOpenCount )
			{
				_nOpenCount -= 1;
				pNewProp = new CntInt32Item( nWhichId, 1 );
			}
			else
			{
				DBG_WARNING( "CntAnchor::PutItem_Impl - OpenCount underflow" );
				return NULL;
			}
			break;

		case WID_OPEN:
		{
			eOpenMode = (CntOpenMode)ITEM_VALUE( CntOpenModeItem, rProp );

			if ( ( eOpenMode == CNT_OPEN_CLOSE_ALL ) ||
				 ( eOpenMode == CNT_OPEN_CANCEL_OPEN ) )
			{
				delete _pCntThreadData;
				_pCntThreadData = NULL;

				CntNodeJob	*pCurJob = NULL;
				CntNode		*pNode = GetNode();

				if ( pNode )
					pNode = pNode->GetMostReferedNode();
				if ( pNode )
				CntNodeJob *pCurJob = pNode->GetCurrentJob();

				if ( pCurJob &&
				     ( ( pCurJob->GetRequest()->Which() == WID_OPEN ) ||
					   ( pCurJob->GetRequest()->Which() == WID_UPDATE ) ) )
				{
					// Wir duerfen nur Jobs abbrechen, die wir selbst
					// aufgesetzt haben!
					if ( pCurJob->GetClient() == this )
					{
						_bIgnoreNodes = TRUE;
						pCurJob->Cancel();
					}
				}
				_bIsOpen = FALSE;
				_bIsExpanded = FALSE;
				return NULL;
			}

			if ( eOpenMode != CNT_OPEN_DOCUMENT )
			{
				_bIsOpen = TRUE;
				_bIsExpanded = TRUE;
			}

			// Wenn unsere Children weg sind, wir aber noch threading Daten
			// haben, dann sollten wir spaetestens jetzt aufraeumen.
//? Warum nicht immer (oder immer, wenn keine OPEN_MSG) ?
			if ( _pCntThreadData &&
				 ( !SubAnchorCount() || ( eOpenMode == CNT_OPEN_DOCUMENTS ) ) )
			{
				delete _pCntThreadData;
				_pCntThreadData = NULL;
			}

			// Wir reagieren im Notify() nur auf Nodes, die auch zu dem
			// Open-Modus passen.
			if ( eOpenMode == CNT_OPEN_DOCUMENTS )
			{
				_bShowDocuments = TRUE;
				_bShowFolders = FALSE;
			}
			else if ( eOpenMode == CNT_OPEN_FOLDERS )
			{
				_bShowDocuments = FALSE;
				_bShowFolders = TRUE;
			}
			else if ( eOpenMode == CNT_OPEN_ALL )
			{
				_bShowDocuments = TRUE;
				_bShowFolders = TRUE;
			}

			_bInOpen = TRUE;
			_nOpenCount += 1;

#if defined( WNT ) && defined( PROFILE ) && defined( DV_PROFILING )
			// Um das Oeffnen eine Gruppe zu profilen, muessen wir
			// auf ein CNT_OPEN_DOCUMENTS warten, fuer das oeffnen einer
			// NewsBox brauchen wir ein CNT_OPEN_FOLDERS
			if ( eOpenMode == CNT_OPEN_FOLDERS )
				S_CAP ;
#endif

			// Reset possibly existing "auto update" results for 'this'.
			CNT_RNM()->ResetUpdateResults( this, FALSE );

			break;
		}

		case WID_SYNCHRONIZE:
		case WID_UPDATE:
			if ( ! _bIsOpen )
			{
				_bShowDocuments = TRUE;
				_bShowFolders = TRUE;
			}
			break;

		case WID_GETDATA:
			// Do a WID_GETDATA only onces...
			if ( _bGetDataDone )
				return NULL;
			else
				_bGetDataDone = TRUE;

			break;

		case WID_PUTDATA:
		{
			CntItemListItem& rPutDataItem = (CntItemListItem&)rProp;
			for ( USHORT n = 0; n < rPutDataItem.Count(); ++n )
			{
				switch ( rPutDataItem[ n ].Which() )
				{
					case WID_SERVERNAME:
					case WID_MAILSEND_SERVERNAME:
					case WID_NEWSSEND_SERVERNAME:
					{
						// Server names are case-insensitive (RFC)
						CntStringItem& rItem =
									(CntStringItem&)rPutDataItem[ n ];
						String aServerName( rItem.GetValue() );
						aServerName.ToLowerAscii();
						rItem.SetValue( aServerName );
						break;
					}

#ifndef CASE_SENSITIVE_USERNAMES
					case WID_USERNAME:
					case WID_MAILSEND_USERNAME:
					case WID_NEWSSEND_USERNAME:
					{
						// Workaround: User names are case-insensitive,
						// except for VIM.
						if ( INetURLObject::CompareProtocolScheme(
										GetServiceURL() ) != INET_PROT_VIM )
						{
							CntStringItem& rItem =
									(CntStringItem&)rPutDataItem[ n ];
							String aUserName( rItem.GetValue() );
							aUserName.ToLower();
							rItem.SetValue( aUserName );
						}
						break;
					}
#endif

					default:
						break;
				}
			}

			/////////////////////////////////////////////////////////////
			// Auto-Update-Stuff
			/////////////////////////////////////////////////////////////

			// Is update possible (item in my ranges)?
			if ( GetItemState( WID_UPDATE_ENABLED, TRUE ) >= SFX_ITEM_DEFAULT )
			{
				BOOL  bUpdate   = FALSE;
				ULONG nInterval = 0;

				const CntBoolItem* pEnabled = (const CntBoolItem*)
									rPutDataItem.Get( WID_UPDATE_ENABLED );
				if ( pEnabled )
					bUpdate = pEnabled->GetValue();
				else
					bUpdate =
						THIS_ITEM_VALUE( CntBoolItem, WID_UPDATE_ENABLED );

				if ( !bUpdate )
					nInterval = CNT_UPDATEREQUEST_REMOVE;
				else
				{
					const CntUInt32Item* pInterval = (const CntUInt32Item*)
									rPutDataItem.Get( WID_AUTOUPDATE_INTERVAL );
					if ( pInterval )
						nInterval = pInterval->GetValue();
					else
						nInterval = THIS_ITEM_VALUE( CntUInt32Item,
								                 	WID_AUTOUPDATE_INTERVAL );
				}

				CNT_RNM()->RequestAutoUpdate( this, nInterval );
			}

			break;
		}

		case WID_REFERED_URL:
		{
			CntStringItem& rItem = (CntStringItem&)rProp;
			String aURL( rItem.GetValue() );
			if ( !NormalizeURL( aURL ) )
			{
				DBG_ERRORFILE( "WID_REFERED_URL: URL invalid!" );
				return NULL;
			}

			pNewProp = new CntStringItem( WID_REFERED_URL, aURL );

			// Release auto-update-requests.
			CNT_RNM()->RequestAutoUpdate( this,	CNT_UPDATEREQUEST_REMOVEALL );

			break;
		}

		case WID_DELETE:
		{
            // Create correct request (soft delete no longer supported).
            pNewProp = new CntBoolItem( WID_DELETE, TRUE );

			// Reset possibly existing "auto update" results for 'this'
			// and its children.
			CNT_RNM()->ResetUpdateResults( this, TRUE );

			// Release auto-update-requests.
			CNT_RNM()->RequestAutoUpdate( this,	CNT_UPDATEREQUEST_REMOVEALL );

			break;
		}

		case WID_PREPARE_MOVE:
			// Release auto-update-requests.
			CNT_RNM()->RequestAutoUpdate( this,	CNT_UPDATEREQUEST_REMOVEALL );
			break;

		case WID_TRANSFER:
		{
			const CntTransferItem& rItem = (const CntTransferItem&)rProp;
			if ( !rItem.isMoveOperation() )
			{
				// Nothing to do on copy operation.
				break;
			}

			CntAnchorRef xAnchor( new CntAnchor( NULL, rItem.getSourceURL() ) );
			xAnchor->Put( SfxVoidItem( WID_PREPARE_MOVE ) );
			break;
		}

		case WID_UPDATE_ENABLED:
		{
			// Is item in my ranges?
			if ( GetItemState( WID_UPDATE_ENABLED, TRUE ) < SFX_ITEM_DEFAULT )
				break;

			BOOL  bUpdate   = ITEM_VALUE( CntBoolItem, rProp );
			ULONG nInterval = CNT_UPDATEREQUEST_REMOVE;

			if ( bUpdate )
				nInterval = THIS_ITEM_VALUE( CntUInt32Item,
				                             WID_AUTOUPDATE_INTERVAL );

			CNT_RNM()->RequestAutoUpdate( this, nInterval );
			break;
		}

		case WID_AUTOUPDATE_INTERVAL:
		{
			// Is item in my ranges?
			if ( GetItemState( WID_UPDATE_ENABLED, TRUE ) < SFX_ITEM_DEFAULT )
				break;

			BOOL bUpdate = THIS_ITEM_VALUE( CntBoolItem, WID_UPDATE_ENABLED );
			if ( bUpdate )
			{
				// (Re-)register the autoupdate-request at Rootnode-Manager
				ULONG nInterval = ITEM_VALUE( CntUInt32Item, rProp );

				CNT_RNM()->RequestAutoUpdate( this, nInterval );
			}
			break;
		}

		case WID_HIDE_AUTHOR:
		case WID_HIDE_THREAD:
		case WID_HIDE_SUBJECT:
			CreateAndApplyRule( nWhichId );
			return NULL;

		case WID_FLAG_IS_MESSAGE:
			if ( ITEM_VALUE( CntBoolItem, rProp ) )
			{
				// adjust which ranges (if necessary)
				// --> new entries in context menu
				MergeRange( WID_MARK_THREAD_READ, WID_MARK_THREAD_READ );
				MergeRange( WID_HIDE_SUBJECT, WID_HIDE_SUBJECT);
				_bIsDocument = TRUE;
			}
			else
				_bIsDocument = FALSE;

			break;

		case WID_SEARCH:
		{
			// Other than for WID_UPDATE, where _bShowFolders/Documents must
			// be set TRUE in order to pass notifications about new nodes thru
			// to the 'message blinker', this need not be done here, because
			// search results are not communicated via CNT_ACTION_INSERTED.

			// For safety reasons...
			if ( !_bGetDataDone )
				Put( SfxVoidItem( WID_GETDATA ) );

			const CntSearchData& rData = ITEM_VALUE( CntSearchDataItem, rProp );
			if ( rData.DoSearchBase() )
			{
				CntSearchMatchMode eMode
				 = rData.MatchesIncomplete( *this,
											CntRootNodeMgr::GetIniManager()->
                                             getIntlWrapper() );
				if ( eMode != CNT_SEARCH_MATCH_UNKNOWN )
				{
					if ( eMode == CNT_SEARCH_MATCH_YES )
						BROADCAST( this,
								   CntSearchMatchedURLHint(GetViewURL()));
					CONST_CAST( CntSearchData&, rData ).BaseAlreadyMatched();
					// ok because WID_SEARCH is SFX_ITEM_NOT_POOLABLE
				}
			}
			break;
		}

		case WID_SERVERNAME:
		case WID_MAILSEND_SERVERNAME:
		case WID_NEWSSEND_SERVERNAME:
		{
			// Server names are case-insensitive (RFC)
			String aName( ITEM_VALUE( CntStringItem, rProp ) );
			pNewProp = new CntStringItem( nWhichId, aName.ToLowerAscii() );
			break;
		}

#ifndef CASE_SENSITIVE_USERNAMES
		case WID_USERNAME:
		case WID_MAILSEND_USERNAME:
		case WID_NEWSSEND_USERNAME:
		{
			// Workaround: User names are case-insensitive, except for VIM.
			if ( INetURLObject::CompareProtocolScheme( GetServiceURL() )
				 != INET_PROT_VIM )
			{
				String aName( ITEM_VALUE( CntStringItem, rProp ) );
				pNewProp = new CntStringItem( nWhichId, aName.ToLower() );
			}
			break;
		}
#endif

		default:
			break;
	}

	if ( _xNode.Is() )
	{
		CntAnchorRef xThis( this );

		// Encapsulate request in a job.
		if ( !xJob.Is() )
			xJob = new CntNodeJob( NULL, this, _xNode,
								   pNewProp ? *pNewProp : rProp,
								   bMakePersist, false, pTaskBase );

		// Set error handler.
		if ( pErrorHandler )
			xJob->SetErrorHandler( *pErrorHandler );

		if ( nWhichId == WID_OPEN )
		{
			if ( !_pOpenData )
				_pOpenData = new ImplOpenData( this );
			_pOpenData->SetOpenJob( xJob );
		}

		if ( nWhichId == WID_DELETE )
		{
			// Make sure, we have a cache/directory node at hand.
			xJob->GetDirectoryNode( FALSE );
		}

		// Give caller access to the job. So the action may be canceled
		// from outside CHAOS. - Somewhat dangerous...., but needed.
		if ( pCancellable )
			*pCancellable = xJob->GetCancellable();

		// Enqueue job in referred node.
		aGuard.clear();

		const SfxPoolItem *pRet = _xNode->InsertJob( xJob );

		vos::OClearableGuard aGuard2( *GetMutex() );

		// Encapsulate return value ( if it is a node ).
		CntNodeItem* pNodeItem = PTR_CAST( CntNodeItem, pRet );
		if ( pNodeItem )
		{
			CntAnchor* pParent  = NULL;
			CntNodeRef xNewNode( pNodeItem->GetValue() );

			if ( xNewNode.Is() )
			{
				if ( xNewNode->IsRootNode() )
					pParent = this;
				else
				{
					CntNode* pParentNode = xNewNode->GetParent();
					CntNode* pMyRefNode  = _xNode;

					// The new node is not always created for "this".
					// No parent is to be set, if the user selected
					// "New->Message" on a POP3-Box or a News-Box,
					// for example.
					while ( !pParent && pMyRefNode )
					{
						if ( pParentNode == pMyRefNode )
						{
							// This is the "normal" case.
							pParent = this;
						}
						else
						{
							CntNode* pCurrParent = pParentNode;

							while ( !pParent && pCurrParent )
							{
								if ( pCurrParent == pMyRefNode )
								{
									// Created node is a child node of my
									// refered node. This is the case, if
									// the user selected "New->Folder" on
									// a FTP-Server with a serverbase set,
									// for example.
									pParent = this;
								}
								else
									pCurrParent = pCurrParent->GetParent();
							}

							pMyRefNode = pMyRefNode->GetReferedNode();
						}
					}

					if ( pParent && pParent->GetNode() )
					{
						CntNodeRef xView( CntViewBase::MakeViewNode(
											xNewNode, pParent->GetNode() ) );
						if ( xView.Is() )
							xNewNode = xView;
					}
				}

				CntAnchorRef xNewAnchor( new CntAnchor( pParent, xNewNode ) );

				delete (SfxPoolItem*) pRet;
				pRet = new CntAnchorItem( 0, &xNewAnchor );;
			}
			else
			{
				delete (SfxPoolItem*) pRet;
				pRet = NULL;
			}
		}

		// Clean up OpenData if necessary
		if ( _pOpenData && _pOpenData->CheckOpenData() )
		{
			delete _pOpenData;
			_pOpenData = NULL;
		}

		delete pNewProp;
		return pRet;
	}
	else
	{
		// some special handling for "dummy" anchors
		if ( nWhichId == WID_IS_READ )
			MarkThread( rProp );
		else if ( nWhich == WID_DELETE )
		{
			for ( ULONG i=SubAnchorCount(); i; )
			{
				i--;
				CntAnchor *pChild = GetSubAnchor( i );
				pChild->Put( rProp, nWhich );
			}
		}
	}

	delete pNewProp;
	return CntInterface::Put( rProp, nWhich );
}

//----------------------------------------------------------------------------
// virtual
int CntAnchor::Put( const SfxItemSet& rSet, BOOL bInvalidAsDefault )
{
	if ( !_xNode.Is() )
		return CntInterface::Put( rSet, bInvalidAsDefault );

	// Create PUTDATA-Request from given itemset.
	CntItemListItem aPutDataItem( WID_PUTDATA, rSet );

	// Put it.
	PutItem_Impl( aPutDataItem, aPutDataItem.Which(), TRUE, NULL, NULL, NULL );
	return TRUE;
}

//----------------------------------------------------------------------------
BOOL CntAnchor::IsRootAnchor( BOOL bResolveLinks ) const
{
	BOOL	bIsRoot;

	if ( bResolveLinks )
	{
		String	aTarget;

		// Check if this anchor is only a link to another anchor
		if ( GetItemState( WID_TARGET_URL ) == SFX_ITEM_SET )
			aTarget = THIS_ITEM_VALUE( CntStringItem, WID_TARGET_URL );

		if ( aTarget.Len() )
		{
			// When this anchor is a link, check if the target of the link
			// is a link, too. But stop after dereferencing the link 9 times
			// to avoid recursions ( the link target should never be another
			// link, but who knows )

			USHORT		 nMaxDepth = 9;
			CntAnchorRef xAnchor = new CntAnchor( NULL, aTarget );

			do {

				if ( GetItemState( WID_TARGET_URL ) == SFX_ITEM_SET )
					aTarget = ITEMSET_VALUE( xAnchor, CntStringItem, WID_TARGET_URL );
				else
					aTarget.Erase();

				if ( aTarget.Len() )
					xAnchor = new CntAnchor( NULL, aTarget );

			} while ( aTarget.Len() && --nMaxDepth );

			bIsRoot = xAnchor->IsRootAnchor( FALSE );
		}
		else
			bIsRoot = ( _xNode.Is() && _xNode->IsRootNode() );
	}
	else
		bIsRoot = ( _xNode.Is() && _xNode->IsRootNode() );

	return bIsRoot;
}

//----------------------------------------------------------------------------
const String& CntAnchor::GetServiceURL() const
{
	if ( !GetNode() )
	{
		// Dummy anchors have no URL.
		return aEmptyString_Impl;
	}

	return OWN_URL( GetNode()->GetMostReferedNode() );
}

//----------------------------------------------------------------------------
const String CntAnchor::GetParentServiceURL() const
{
	// Parent does not exist.
	if ( !GetNode() )
	{
		// Dummy anchors have no URL.
		return aEmptyString_Impl;
	}

	CntNode * pMostRef = GetNode()->GetMostReferedNode();
	INetURLObject aURL( OWN_URL( pMostRef ) );
	switch ( aURL.GetProtocol() )
	{
		case INET_PROT_FTP:
		{
			String aURLPath( aURL.GetURLPath() );
			if ( !aURLPath.Len() || ( aURLPath == '/' ) )
				aURLPath =
					ITEMSET_VALUE( pMostRef, CntStringItem, WID_SERVERBASE );
			xub_StrLen i = aURLPath.Len();
			if ( i )
			{
				if ( aURLPath.GetChar( i - 1 ) == '/' )
					--i;
				while ( i && aURLPath.GetChar( i - 1 ) != '/' )
					--i;
			}
			if ( i > 1 )
			{
				aURL.SetURLPath( aURLPath.Copy( 0, i ) );
				return aURL.GetMainURL();
			}
			else
				return aEmptyString_Impl;
		}

		default:
			return OWN_URL( pMostRef->GetParent() );
	}
}

//----------------------------------------------------------------------------
const String& CntAnchor::GetRootServiceURL() const
{
	// Parent does not exist.
	if ( !GetNode() )
	{
		// Dummy anchors have no URL.
		return aEmptyString_Impl;
	}

	return OWN_URL( GetNode()->GetMostReferedNode()->GetRootNode() );
}

//----------------------------------------------------------------------------
const String CntAnchor::GetPresentationURL() const
{
	// Parent does not exist.
	if ( !GetNode() )
	{
		// Dummy anchors have no URL.
		return aEmptyString_Impl;
	}

	const String& rPres = ITEMSET_VALUE( GetNode()->GetMostReferedNode(),
		 								 CntStringItem, WID_REAL_URL );
	if ( rPres.Len() )
		return rPres;

	return GetServiceURL();
}

//----------------------------------------------------------------------------
const String CntAnchor::GetViewURL_Impl() const
{
	// Only folders have View-URL's.
	if ( !THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_FOLDER ) )
		return aEmptyString_Impl;

	if ( !GetNode() )
		return aEmptyString_Impl;

	String aViewURL( OWN_URL( GetNode() ) );
	if ( CntViewBase::IsViewURL( aViewURL ) )
		return aViewURL;

	// Last chance: Try to get own View URL via parent anchor...

	CntAnchor* pParent = CntAnchor::GetParent();

	// Skip Dummy anchors.
	while ( pParent && !pParent->GetNode() )
		pParent = pParent->GetParent();

	if ( !pParent )
		return aEmptyString_Impl;

	// Check parent anchor - it's most refered node must be a
	// parent of my most refered node.
	CntNode* pRoot  = pParent->GetNode()->GetMostReferedNode()->GetRootNode();
	CntNode* pNode  = GetNode()->GetMostReferedNode();
	CntNode* pRoot1 = pNode->GetRootNode();

	if ( pRoot1 == pRoot )
	{
		aViewURL = CntViewBase::GetRootViewURL( OWN_URL( pParent->GetNode() ) );
		if ( aViewURL.Len() )
		{
			aViewURL = CntViewBase::MakeViewURL( aViewURL, OWN_URL( pNode ) );
			return aViewURL;
		}
	}

	return aEmptyString_Impl;
}

//----------------------------------------------------------------------------
const String CntAnchor::GetViewURL( BOOL bStrict ) const
{
	String aViewURL( GetViewURL_Impl() );
	if ( aViewURL.Len() )
		return aViewURL;

	if ( bStrict )
		return aEmptyString_Impl;

#ifdef DBG_UTIL
	if ( THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_FOLDER ) &&
		 !THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_DOCUMENT ) )
		DBG_WARNING( "CntAnchor::GetViewURL - Using GetServiceURL!" );
#endif

	// Last choice.
	return GetServiceURL();
}

//----------------------------------------------------------------------------
const String CntAnchor::GetParentViewURL( BOOL bStrict ) const
{
	// 1 No underlying node, no URL.
	if ( !GetNode() )
		return aEmptyString_Impl;

	String aURL( OWN_URL( GetNode() ) );

	BOOL bRoot = FALSE;
	BOOL bView = CntViewBase::IsViewURL( bRoot, aURL );

	// 2 The underlying node is a view node on top of a service root node.
	// 2.1 For FTP, two cases can occur:
	// 2.1.1 The service root node represents the FTP root folder, in which
	//       case there is no parent.
	// 2.1.2 The service root node represents some FTP folder that has a
	//       parent, in which case the view URL is the appended with the
	//       parent's service URL.
	// 2.2 For services other than FTP, there is no parent.
	if ( bView && bRoot )
	{
		String aParentServiceURL( GetParentServiceURL() );
		if ( aParentServiceURL.Len()
			 && INetURLObject( aParentServiceURL ).GetProtocol()
			    == INET_PROT_FTP )
		{
			aURL = CntViewBase::MakeViewURL( aURL, aParentServiceURL );
			return aURL;
		}
		else
			return aEmptyString_Impl;
	}

	// 3 The underlying node is a view node on top of some non-root service
	//   node.
	// 3.1 For FTP, two cases can occur:
	// 3.1.1 The service node underneath the anchor represents the FTP root
	//       folder, in which there is no parent.
	// 3.1.2 The service node underneath the anchor represents some FTP folder
	//       that has a parent, in which case the #-part of the view URL must
	//       be replaced with the parent's service URL.
	// 3.2 For services other than FTP, two cases can occur, too:
	// 3.2.1 The service node's parent is a service root node, in which case
	//       the #-part must be stripped from the view URL.
	// 3.2.2 The service node's parent is some other non-root service node,
	//       in which case the #-part of the view URL must be replaced with
	//       the parent's service URL---cf. case 3.1.2.
	if ( bView && !bRoot )
	{
		xub_StrLen nHashPos = aURL.Search( CNT_VIEW_URL_DELIMITER );
		DBG_ASSERT( nHashPos != STRING_NOTFOUND, "Non-root view URL w/o #" );
		INetURLObject aURLObject( aURL.Copy( nHashPos + 1 ) );
		if ( aURLObject.GetProtocol() == INET_PROT_FTP )
		{
			String aPath( aURLObject.GetURLPath() );
			xub_StrLen nSlashCount = 0;
			for ( xub_StrLen i = 0; i < aPath.Len(); ++i )
				if ( aPath.GetChar(i) == '/' )
					++nSlashCount;
			if ( nSlashCount <= 2 )
				return aEmptyString_Impl;
		}
		else if ( GetNode()->GetMostReferedNode()->GetParent()->IsRootNode() )
		{
			aURL.Erase( nHashPos );
			return aURL;
		}
		aURL.Erase( nHashPos + 1 );
		aURL += GetParentServiceURL();
		DBG_ASSERT( aURL.Len() > nHashPos + 1,
				    "Non-root view node w/o parent service URL" );
		return aURL;
	}

	// 4 The underlying node is not a view node, in which case we fall back on
	//   the parent's service URL.
	if ( bStrict )
		return aEmptyString_Impl;
	else
	{
		DBG_WARNING(
			"CntAnchor::GetParentViewURL - Using GetParentServiceURL()" );
		return GetParentServiceURL();
	}
}

//----------------------------------------------------------------------------
const String CntAnchor::GetRootViewURL( BOOL bStrict ) const
{
	CntNode* pNode = GetNode();
	if ( pNode )
	{
		String aViewURL( CntViewBase::GetRootViewURL( OWN_URL( pNode ) ) );
		if ( aViewURL.Len() )
			return aViewURL;
	}

	if ( bStrict )
		return aEmptyString_Impl;

	// Last choice.
	DBG_WARNING( "CntAnchor::GetRootViewURL - Using GetRootServiceURL!" );
	return GetRootServiceURL();
}

//----------------------------------------------------------------------------
// static
BOOL CntAnchor::IsViewURL( const String& rURL )
{
	return ( CntViewBase::IsViewURL( rURL ) );
}

//----------------------------------------------------------------------------
// static
const String CntAnchor::ToViewURL( const String& rRootViewURL,
								   const String& rServiceURL )
{
	if ( !rRootViewURL.Len() || !rServiceURL.Len() )
		return String();

	String aViewURL( rRootViewURL );
	if ( !NormalizeURL( aViewURL ) )
		return String();

	if ( !CntViewBase::IsRootViewURL( aViewURL ) )
		return String();

	String aServiceURL( rServiceURL );
	if ( !NormalizeURL( aServiceURL ) )
		return String();

	// rRootViewURL really points to a Root View.
	CntNodeRef xRoot = CNT_RNM()->Query( aViewURL );
	if ( !xRoot.Is() )
		return String();

	// Check rServiceURL.
	CntNodeRef xNode = CNT_RNM()->Query( aServiceURL );
	if ( !xNode.Is() )
		return String();

	if ( &xNode == xRoot->GetMostReferedNode() )
	{
		// Root View!
		return aViewURL;
	}

	CntNode* pTmp = xNode->GetParent();
	while ( pTmp )
	{
		if ( pTmp == xRoot->GetMostReferedNode() )
		{
			// Node given by rServiceURL matches node given by rRootVieURL.
			break;
		}
		pTmp = pTmp->GetParent();
	}

	if ( !pTmp )
	{
		// Node given by rServiceURL does not match node given by rRootVieURL.
		return String();
	}

	aViewURL = CntViewBase::MakeViewURL( aViewURL, OWN_URL( &xNode ) );
	return aViewURL;
}

//----------------------------------------------------------------------------
// static
BOOL CntAnchor::ToServiceURL( String& rViewURL )
{
	if ( !rViewURL.Len() )
		return FALSE;

	String aURL( rViewURL );
	if ( !NormalizeURL( aURL ) )
		return FALSE;

	if ( CntViewBase::IsViewURL( aURL ) )
	{
		// View URL given.
		xub_StrLen nPos = aURL.Search( CNT_VIEW_URL_DELIMITER );
		if ( nPos == STRING_NOTFOUND )
		{
			// Root View URL.
			CntNodeRef xNode( CNT_RNM()->Query( aURL ) );
			if ( !xNode.Is() )
				return FALSE;

			rViewURL = OWN_URL( xNode->GetMostReferedNode() );
		}
		else
		{
			// Fuer Nicht-Storage-View-URL's ( z.B. Datenbank ) ist
			// die Service-URL immer gleich der View-URL!!!
			if ( CntViewStorageNode::IsSubViewURL( aURL ) )
			{
				// Sub View URL.
				rViewURL = aURL.Copy( nPos + 1 );
				aURL.Erase( nPos + 1 );
			}
		}
	}
	else
	{
		CntNodeRef xNode( CNT_RNM()->Query( aURL ) );
		if ( !xNode.Is() )
			return FALSE;

		rViewURL = OWN_URL( xNode->GetMostReferedNode() );
	}

	return TRUE;
}

//----------------------------------------------------------------------------
// static
BOOL CntAnchor::ToPresentationURL( String& rViewURL )
{
	if ( !rViewURL.Len() )
		return FALSE;

	String aURL( rViewURL );
	if ( !NormalizeURL( aURL ) )
		return FALSE;

	CntNodeRef xNode = CNT_RNM()->Query( aURL );
	if ( !xNode.Is() )
		return FALSE;

	xNode = xNode->GetMostReferedNode();

	const String& rPres = ITEMSET_VALUE( xNode, CntStringItem, WID_REAL_URL );
	if ( rPres.Len() )
	{
		rViewURL = rPres;
		return TRUE;
	}

	// Fall back to Service URL.
	rViewURL = OWN_URL( xNode );
	return TRUE;
}

//----------------------------------------------------------------------------
const String CntAnchor::GetCaseSensitiveFileURL() const
{
	// Same as GetPresentationURL() since CHAOS has no longer a File Service.
	return GetPresentationURL();
}

//----------------------------------------------------------------------------
ErrCode CntAnchor::SetNode( CntNode* pNode )
{
	vos::OGuard aGuard( *GetMutex() );

	if ( pNode == &_xNode )
		return ERRCODE_NONE;

	if ( _xNode.Is() )
		EndListening( *&_xNode );

	_xNode = pNode;

	if ( pNode )
	{
		StartListening( *pNode );

		_bIsDocument =
				ITEMSET_VALUE( pNode, CntBoolItem, WID_FLAG_IS_DOCUMENT );

		SfxUShortRanges *pRange;
		pRange = new SfxUShortRanges( aViewAnchorRanges_Impl );
		*pRange /= pNode->GetRanges();

		if ( !pRange->IsEmpty() )
			SetRanges( *pRange );

		delete pRange;
	}

	CntInterface::SetParent( pNode );

	return ERRCODE_NONE;
}

//----------------------------------------------------------------------------
// virtual
FASTBOOL CntAnchor::IsItemFlag( USHORT nWID, USHORT nFlag ) const
{
	if ( _xNode.Is() )
		return _xNode->IsItemFlag( nWID, nFlag );

	return CntInterface::IsItemFlag( nWID, nFlag );
}

//----------------------------------------------------------------------------
ULONG CntAnchor::FindPos( CntAnchor *pAnchor, BOOL &bFound )
{
	vos::OGuard aGuard( *GetMutex() );

	bFound = FALSE;

	if ( !_pSubAnchors || ! _pSubAnchors->Count() )
		return 0;

	long nStart = 0;
	long nEnd = _pSubAnchors->Count() - 1;
	long nMid = nEnd / 2;

	int nCompVal = 0;

	while ( nStart <= nEnd )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		CntAnchor* pData = (CntAnchor*)_pSubAnchors->GetObject( nMid );

		if ( pData == pAnchor )
		{
			bFound = TRUE;
			return nMid;
		}

		nCompVal = pData->Compare( pAnchor, TRUE );

		DBG_ASSERT( nCompVal, "Compare-Ergebnis falsch?" );

        if ( nCompVal < 0 )		// pData < pAnchor
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

	if ( nCompVal < 0 )			// pData < pAnchor
		return nMid + 1;
	else
		return nMid;
}

//----------------------------------------------------------------------------
void CntAnchor::InsertSubAnchor(
			CntAnchor *pNewAnchor, CntAnchor *pThreader, CntNodeJob* pJob )
{
	static ULONG nLastSortingID = 1;
	vos::OClearableGuard aGuard( *GetMutex() );

	CheckChildList();

	// We need to know, wether this Anchor is a root anchor or not
	// for sorting the children.
	_bIsRootAnchor = IsRootAnchor( TRUE );

	// Wenn pNewAnchor einen Parent hat, dann muss der Anker aus dessen Child
	// Liste ausgetragen werden
	if ( pNewAnchor->_pParentAnchor && ! pNewAnchor->_bIsInserted )
		pNewAnchor->_pParentAnchor->RemoveFromChildList( pNewAnchor );

	pNewAnchor->_pParentAnchor = this;

	// Wenn wir einen Anker in die Childlist eintragen, dann muessen
	// wir ihn auch festhalten, wenn wir den neuen Beamer benutzen

	if ( pNewAnchor->_bUsesNewView )
	{
		if ( ! pNewAnchor->_bNeedRelease )
		{
			pNewAnchor->AddRef();
			pNewAnchor->_bNeedRelease = TRUE;
		}
		pNewAnchor->_pThreader = pThreader;
	}
	else
	{
		if ( ( pThreader == this ) || !pThreader )
		{
			if ( pNewAnchor->_pThreader )
				pNewAnchor->ReleaseRef();
			pNewAnchor->_pThreader = NULL;
		}
		else
		{
			if ( ! pNewAnchor->_pThreader )
				pNewAnchor->AddRef();
			pNewAnchor->_pThreader = pThreader;
		}
	}
	// Insert Anchor in NodeList
	if ( pNewAnchor->GetNode() )
	{
		if ( pThreader )
			pThreader->CheckAndInsertInNode( pNewAnchor->GetNode() );
		else
			CheckAndInsertInNode( pNewAnchor->GetNode() );
	}

	if ( ! pNewAnchor->_nSortingInfo )
		pNewAnchor->_nSortingInfo = nLastSortingID++;

	BOOL	bFound;
	ULONG	nInsertionPos = FindPos( pNewAnchor, bFound );

	DBG_ASSERT( !bFound, "InsertSubAnchor(): Anchor already in List?" );

	if ( !_pSubAnchors )
		_pSubAnchors = new List( 128, 128 );
	else if ( ! GetNode() )
		RecalcDate( pNewAnchor );

	_pSubAnchors->Insert( pNewAnchor, nInsertionPos );
	_nTotalChildren += 1;

	if ( pThreader )
	{
		pThreader->_nTotalChildren += 1;
		pNewAnchor->CheckSeenStatus( TRUE );
	}

	pNewAnchor->_bIsInserted = TRUE;
	pNewAnchor->_bCollectAnchors = _bCollectAnchors;

	if ( pNewAnchor->_bUsesNewView )
	{
		CntAnchor *pAbsParent = GetAbsParent();
		if ( pAbsParent )
		{
			pAbsParent->_pSearchData->InsertAnchor( pNewAnchor );
		}
		if ( SubAnchorCount() == 1 )
		{
			pAbsParent = GetAbsParent( TRUE );
			if ( pAbsParent )
			{
				nInsertionPos = GetAbsPos();
				aGuard.clear();
				BROADCAST( pAbsParent, CntAnchorViewHint(
											CNT_ACTION_MODIFIED,
											nInsertionPos, 1, WID_INSERT ) );
			}
		}
	}
	else
	{
		aGuard.clear();
		BROADCAST( this,
				   CntAnchorHint( pNewAnchor, CNT_ACTION_INSERTED, pJob ) );
	}

	CheckChildList();
}

//----------------------------------------------------------------------------
void CntAnchor::RemoveSubAnchor( CntAnchor *pAnchor, BOOL bRelease )
{
	vos::OGuard aGuard( *GetMutex() );

	if ( !_pSubAnchors )
	{
		DBG_ERRORFILE( "CntAnchor: No list to remove from" );
		return;
	}

	CntAnchorRef xAnchor( this );

	CheckChildList();

	BOOL	bLast = FALSE;
	BOOL	bFound;
	ULONG	nPos;

	if ( _pSubAnchors->Last() == pAnchor )
	{
		nPos = _pSubAnchors->Count() - 1;
		bFound = TRUE;
		bLast = TRUE;
	}
	else
		nPos = FindPos( pAnchor, bFound );

	CntAnchor *pAbsParent = GetAbsParent();

	if (  pAnchor->_bUsesNewView && pAbsParent )
	{
		ULONG nTmp = pAnchor->GetAbsPos();
		BROADCAST( pAbsParent, CntAnchorViewHint( CNT_ACTION_REMOVING,
												  nTmp, 1 ) );
		if ( bLast )
			BROADCAST( pAbsParent, CntAnchorViewHint( CNT_ACTION_REMOVING_LAST,
													  nTmp, 1 ) );
	}

	// Den Anker schon hier aus der Liste nehmen, damit er beim
	// Broadcast auch wirklich schon weg ist
	if ( bFound )
		_pSubAnchors->Remove( nPos );

	// Anker aus der PosEntryListe entfernen
	if ( pAnchor->_bUsesNewView )
	{
		if ( pAbsParent )
		{
			pAbsParent->_pSearchData->RemoveAnchor( pAnchor );

			// Manchmal werden durch das RemoveAnchor auch alle Kinder
			// geloescht
			if ( !_pSubAnchors )
				return;
		}
		// Wenn der letzte Anker geloescht wurde, dann schicken wir
		// noch ein modified, damit das Plus Zeichen verschwindet
		if ( SubAnchorCount() == 0 )
		{
			pAbsParent = GetAbsParent( TRUE );
			if ( pAbsParent )
			{
				ULONG nTmp = GetAbsPos();
				BROADCAST( pAbsParent, CntAnchorViewHint(
											CNT_ACTION_MODIFIED,
											nTmp, 1 ) );
			}
		}
	}


	if ( bFound )
	{
		CntAnchorRef xAnchor( pAnchor );

		pAnchor->RemoveFromNode();
		pAnchor->_pParentAnchor = 0;
		pAnchor->_bIsInserted = FALSE;

		if ( ! pAnchor->_bUsesNewView )
			BROADCAST( pAnchor,
					   CntAnchorHint( pAnchor, CNT_ACTION_REMOVED, NULL ) );

		if ( pAnchor->_bIsThreaded )
		{
			CntSeenStatus eStatus = pAnchor->GetSeenStatus();
			if ( eStatus == CNT_ALL_SEEN )
				_nSeenCount -= 2;
			else if ( eStatus == CNT_SOME_SEEN )
				_nSeenCount -= 1;

			CheckSeenStatus();
		}

		if ( pAnchor->_pThreader )
		{
			if ( ! pAnchor->_bUsesNewView &&
				 ( pAnchor->_pThreader != this ) )
				pAnchor->ReleaseRef();
			pAnchor->_pThreader->_nTotalChildren -= 1;
			pAnchor->_pThreader = NULL;
		}

		if ( bRelease && pAnchor->_bNeedRelease )
		{
			pAnchor->ReleaseRef();
			pAnchor->_bNeedRelease = FALSE;
		}

		_nTotalChildren -= 1;
		CheckChildList();
		return;
	}

	DBG_ERROR( "CntAnchor: removing strange anchor" );
	return;
}

//----------------------------------------------------------------------------
void CntAnchor::RemoveSubAnchors( BOOL bBroadcast )
{
	vos::OGuard aGuard( *GetMutex() );

	if ( ! _pSubAnchors )
		return;

	if ( bBroadcast )
		Collapse( FALSE );

	// Da in Collapse manchmal auch die SubAnchors freigegeben werden,
	// muessen wir hier noch einmal prueffen!!!
	if ( _pSubAnchors )
	{
		// SubAnchor freigeben
		for ( ULONG nCount = _pSubAnchors->Count(); nCount > 0; --nCount )
		{
			CntAnchorRef xSub(
					(CntAnchor*)_pSubAnchors->GetObject( nCount - 1 ) );

			DBG_ASSERT( xSub->_pParentAnchor == this,
						"Kind ist nur ein Stiefkind?" );

			xSub->RemoveFromNode();
			xSub->_pParentAnchor = NULL;
			xSub->_bIsInserted = FALSE;
			if ( xSub->_pThreader )
			{
				xSub->_pThreader->_nTotalChildren -= 1;
				xSub->_pThreader = NULL;
			}
			if ( xSub->_bNeedRelease )
			{
				xSub->_bNeedRelease = FALSE;
				xSub->ReleaseRef();
			}
		}

		delete _pSubAnchors;
		_pSubAnchors = NULL;
		_nTotalChildren = 0;
	}
}

//----------------------------------------------------------------------------
BOOL CntAnchor::DeleteAnchor()
{
	vos::OGuard aGuard( *GetMutex() );

	// Wenn wir eine Nachricht sind und gegliedert und Kinder haben,
	// dann wird aus dem Msg-Anker ein virtueller Anker und anschliessend
	// werden die threading Daten aktualisiert ( ... oder besser umgekehrt! )
//? Warum nur bei Dokumenten?
	if ( _bIsThreaded && _bIsDocument && ( SubAnchorCount() > 1 ) &&
		 GetParent() && GetNode() )
	{
		CntAnchor	  *pRoot = GetTParent();
		CntThreadList *pList;

		for ( int i = 0; i < THREADITEM_ANZ; i++ )
		{
			pList = pRoot->_pCntThreadData->pItemLists[ i ];

			if ( pList )
			{
				ULONG        nPos;
				ItemListData *pData;

				String aValue( THIS_ITEM_VALUE( CntStringItem,
												pList->GetChildWID() ) );

				if ( pList->GetType() == CNT_THREADING_BY_PROPVALUE )
					Cnt_CutReply( aValue );

				pData = pList->FindEntry( aValue, nPos );

				if ( pData && ( pData->pAnchor == this ) )
				{
					pData->bIsVirtual = TRUE;
					pData->bIsReal = FALSE;
					pData->bIsCopy = FALSE;
				}
			}
		}

		EndListening( *&_xNode );

		String aTitle( THIS_ITEM_VALUE( CntStringItem, WID_TITLE ) );

		CntAnchor  *pParent = GetParent();
		BOOL		bWasExpanded = IsExpanded();

		if ( pParent )
		{
			if ( bWasExpanded )
				Collapse();
			if ( _bIsInserted )
				pParent->RemoveSubAnchor( this, FALSE );
		}

		_xNode = NULL;
		SetRanges( aVirtualMsgFolderRanges2_Impl );
		CntInterface::SetParent( NULL );

		CntInterface::Put( CntStringItem( WID_TITLE, aTitle ) );
		CntInterface::Put( CntBoolItem( WID_FLAG_IS_DOCUMENT, TRUE ) );

		if ( pParent )
		{
			pParent->InsertSubAnchor( this, NULL, NULL );
			if ( bWasExpanded )
				Expand();
		}

		CheckSeenStatus( TRUE );

		return FALSE;
	}

	// Wenn dieser Anker geloescht wird, dann interessiert sich
	// auch keiner mehr fuer dessen Kinder
	if ( SubAnchorCount() )
		Collapse();

	if ( GetParent() )
	{
		CntAnchor *pParent = GetParent();

		if ( SubAnchorCount() == 1 )
		{
			CntAnchorRef xAnchor = GetSubAnchor( 0 );
			xAnchor->ChangeParent( pParent, xAnchor->GetTParent() );
		}

		// Wenn dieser Knoten gethreaded war, dann sollte er aus den Threading
		// Listen rausgenommen werden
		if ( _bIsThreaded )
			RemoveFromLists();

		if ( _bIsInserted )
			pParent->RemoveSubAnchor( this );

		CleanUpParentChain_Impl( pParent );
	}

	return TRUE;
}

//----------------------------------------------------------------------------
CntAnchor* CntAnchor::GetSubAnchor( ULONG nPos ) const
{
	return ( _pSubAnchors && ( _pSubAnchors->Count() > nPos ) )
			 ? (CntAnchor*)_pSubAnchors->GetObject( nPos )
			 : NULL;
}

//----------------------------------------------------------------------------
static
BOOL IsRefered_Impl( CntNode* pNode, CntAnchor* pAnchor )
{
	CntNode* pCurr = pAnchor->GetNode();
	while ( pCurr )
	{
		if ( pCurr == pNode )
			return TRUE;

		pCurr = pCurr->GetReferedNode();
	}
	return FALSE;
}

//----------------------------------------------------------------------------
static
BOOL IsInTrash_Impl( CntAnchor* pAnchor )
{
	CntNode* pNode = pAnchor->GetNode();

	if ( !pNode )
		return FALSE;

	String aTrashURL = CNT_RNM()->GetTrashDirectory();
	if ( !aTrashURL.Len() )
		return FALSE;

	if ( aTrashURL.GetChar( aTrashURL.Len() - 1 ) != '/' )
		aTrashURL += '/';

	// In Trash folder?
	if ( OWN_URL( pNode ).Search( aTrashURL ) == 0 )
		return TRUE;

	return FALSE;
}

//----------------------------------------------------------------------------
static
void SetURLRecursive_Impl( CntNode* pNode )
{
	// Update pNode.
	if ( !pNode->IsRootNode() )
	{
		if ( CntViewBase::IsSubViewURL( OWN_URL( pNode ) ) )
		{
			String aNewURL( OWN_URL( pNode->GetRootNode() ) );
			const String& rTmp = OWN_URL( pNode );

			xub_StrLen nPos = rTmp.Search( CNT_VIEW_URL_DELIMITER );
			if ( nPos != STRING_NOTFOUND )
				aNewURL += rTmp.Copy( nPos );

			// Note: Do not call CntNode::Initialize(...) here, because it
			//       resorts the subnodes, which isn't necessary here ( When
			//       all subnodes are proceesed the sort order is the same
			//       as before ), but makes the iteration done by this
			//       algorithm impossible!!!

			pNode->CntInterface::Put(
						CntStringItem( WID_OWN_URL, aNewURL ), WID_OWN_URL );

			if ( pNode->GetItemState( WID_REAL_URL ) == SFX_ITEM_SET )
				pNode->CntInterface::Put(
						CntStringItem( WID_REAL_URL, aNewURL ), WID_REAL_URL );
		}
	}

	// Update children of pNode.
	ULONG nCount = pNode->SubNodeCount();
	for ( ULONG n = 0; n < nCount; n++ )
		SetURLRecursive_Impl( pNode->GetSubNode( n ) );
}

//----------------------------------------------------------------------------
static
void Invalidate_Impl( CntNode* pNode )
{
	const String& rURL = OWN_URL( pNode );

	// View-Root-Node?
	if ( CntViewBase::IsRootViewURL( rURL ) )
	{
		INetURLObject aURLObj( rURL );
		String aPath = aURLObj.GetPartBeforeLastName();

		CntAnchorRef xPath(	new CntAnchor( NULL, aPath ) );
		if ( xPath.Is() && !xPath->GetError() )
		{
			// Notify parent directory of node about invalid cache data.
			xPath->Put(	CntBoolItem( WID_IS_INVALID, TRUE ) );
		}
	}
}

//----------------------------------------------------------------------------
void CntAnchor::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	ACQUIRE_SOLAR_MUTEX();

	//////////////////////////////////////////////////////////////////////
	// SfxItemChangedHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( SfxItemChangedHint ) )
	{
		CntAnchorRef xAnchor = this;

		const SfxItemChangedHint *pItemHint =
											(const SfxItemChangedHint*)&rHint;
		USHORT nWhich = pItemHint->GetOldItem().Which();

		if ( nWhich == WID_TITLE )
		{
			const SfxPoolItem &rItem = Get( nWhich );
			if ( rItem != pItemHint->GetNewItem() )
			{
				Put( pItemHint->GetNewItem(), nWhich );
				return;
			}
		}

		CheckAnchor( pItemHint->GetOldItem() );

		switch ( nWhich )
		{
			case WID_OWN_URL:
			{
				// View-Storage file renamed?
				CntNode *pNode = PTR_CAST( CntNode, &rBC );
				if ( pNode == &_xNode )
				{
					if ( !CntViewBase::IsRootViewURL( OWN_URL( this ) ) )
						break;

					String aOldURL( ITEM_VALUE( CntStringItem,
						                        pItemHint->GetOldItem() ) );
					CntRootNodeMgr* pRNM = CNT_RNM();

					// Synchronize auto update requests at RNM.
					pRNM->SyncAutoUpdate( this, aOldURL );

					BOOL bUpdate =
							THIS_ITEM_VALUE( CntBoolItem, WID_UPDATE_ENABLED );
					if ( bUpdate )
					{
						ULONG nInterval =
									THIS_ITEM_VALUE( CntUInt32Item,
													 WID_AUTOUPDATE_INTERVAL );
						pRNM->RequestAutoUpdate( this, nInterval );
					}

					// Synchronize OutTray URL at RNM.
					if ( pNode->GetMostReferedNode()->ISA( CntOutTrayNode ) )
					{
						String aOutURL( pRNM->GetOutTrayURL( FALSE ) );
						if ( !aOutURL.Len() || ( aOutURL == aOldURL ) )
						{
							// Set new system OutTray.
							String aNewURL(
						 			ITEM_VALUE( CntStringItem,
											 	pItemHint->GetNewItem() ) );
							pRNM->SetOutTrayURL( aNewURL );
						}
					}
				}
				break;
			}

			case WID_FLAG_IS_FOLDER:
			case WID_SHOW_IN_EXPLORER:
			{
				BOOL bIsFolder = ITEM_VALUE( CntBoolItem, pItemHint->GetNewItem() );
				BOOL bIsReal;

				if ( nWhich == WID_SHOW_IN_EXPLORER )
					bIsReal = THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_IS_FOLDER );
				else
					bIsReal = FALSE;

				// Only remove non folder anchors when WID_SHOW_IN_EXPLORER changes
				if ( !bIsFolder && !bIsReal )
				{
					CntAnchor *pTParent = GetTParent();
					if ( pTParent && pTParent->_bShowFolders &&
						 ! pTParent->_bShowDocuments && GetParent() &&
						 _bIsInserted )
					{
						GetParent()->RemoveSubAnchor( this );
					}
				}

				break;
			}

			case WID_IS_READ:
				CheckSeenStatus();

				if ( ITEM_VALUE( CntBoolItem, pItemHint->GetNewItem() ) )
				{
					// Reset possibly existing "auto update" results for 'this'.
					CNT_RNM()->ResetUpdateResults( this, FALSE );
				}
				break;

			case WID_SORTING:
			{
				ReSort();
				CntAnchor *pAbsParent = GetAbsParent();
				if ( pAbsParent )
					pAbsParent->_pSearchData->ReSort();
				break;
			}

			case WID_FILTERED:
				_bHasRules = TRUE;
				break;

			case WID_RULES:
				// Wenn wir ein WID_RULES bekommen, schicken wir noch ein WID_FILTERED
				// hinterher, damit die Daten neu eingelesen werden.
				if ( !_bIgnoreFilterdMsg )
				{
					if ( THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_HAS_MESSAGES ) &&
					     THIS_ITEM_VALUE( CntBoolItem, WID_FILTERED ) )
						Put( CntBoolItem( WID_FILTERED, TRUE ), WID_FILTERED );
				}
				_bHasRules = TRUE;
				break;

			case WID_SERVERBASE:
				RemoveSubAnchors( TRUE );
				break;

			case WID_FSYS_SHOW_HIDDEN:
				// Wenn sich ShowHidden aendert, dann erzwingen wir ein neu
				// laden durch ein zu- und wieder aufklappen des Ankers
				// DV: WID_SYNCHRONIZE ist besser!
				if ( IsExpanded() )
					Put( SfxVoidItem( WID_SYNCHRONIZE ) );

				break;

			case WID_IS_MARKED:
			{
				// Marked objects never shall be deletable.
				CntNode* pNode = GetNode()->GetMostReferedNode();

				BOOL bMarked =
						ITEM_VALUE( CntBoolItem, pItemHint->GetNewItem() );
				if ( bMarked )
				{
					// Disable WID_DELETE.
					pNode->DisableItem( WID_DELETE );
				}
				else
				{
					SfxItemState eState = pNode->GetItemState( WID_DELETE );
					if ( eState & SFX_ITEM_DISABLED )
					{
						// Enable WID_DELETE.
						pNode->ClearItem( WID_DELETE );
					}
				}
				break;
			}

			case WID_TARGET_URL:
				if( IsExpanded())
				{
					CntOpenMode eMode = GetOpenMode();
					Collapse();
					Expand( eMode, FALSE, FALSE );
				}
				break;

			default:
				break;
		}

		// No return here - CntInterface handles SfxItemChangedHint's !
		CntInterface::Notify( rBC, rHint );
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// SfxPoolItemHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( SfxPoolItemHint ) )
	{
		const SfxPoolItemHint *pPoolItemHint = (const SfxPoolItemHint*)&rHint;
		CntItemListItem* pListItem
					= (CntItemListItem*)pPoolItemHint->GetObject();

		if ( pListItem->Count() )
		{
			const SfxPoolItem &nItem = (*pListItem)[ 0 ];
			USHORT             nWID = nItem.Which();

			// Wenn in der Liste ein UPDATE Item steht, dann muessen
			// wir einen Update - Job erzeugen, ansonsten muessen alle
			// Eintraege in der Ankerliste geloescht werden, die in der
			// Liste stehen ( DeleteChildren )
			// ( Bis jetzt gibt es das Update nur fuer Folder )
			if ( nWID == WID_UPDATE )
			{
				if ( IsOpen() )
					Put( CntOpenModeItem( WID_OPEN, CNT_OPEN_FOLDERS ) );
			}
			else
				DeleteChildren( pListItem );
		}
		else
		{
			BOOL		bDeleteMsgs;
			BOOL		bDeleteChildren = TRUE;
			CntAction	eAction;
			CntOpenMode	eOpenMode;

			switch ( pListItem->Which() )
			{
				case WID_FOLDERVIEW_MODE:
					eAction = CNT_ACTION_KILL_FOLDERS;
					eOpenMode = CNT_OPEN_FOLDERS;
					bDeleteMsgs = FALSE;
					break;

				case WID_MESSAGEVIEW_MODE:
				case WID_SENTMESSAGEVIEW_MODE:
				case WID_RULES:
				case WID_FILTERED:
					eAction = CNT_ACTION_KILL_MESSAGES;
					eOpenMode = CNT_OPEN_DOCUMENTS;
					bDeleteMsgs = TRUE;
					break;

				default:
					bDeleteChildren = FALSE;
					break;
			}

			if ( bDeleteChildren )
			{
				BOOL bIsOpen = IsOpen();
				BOOL bOld = _bShowFolders;

				Broadcast( CntAnchorHint( this, eAction, NULL ) );
				DeleteAllChildren( bDeleteMsgs );

				if ( bIsOpen )
				{
					Put( CntOpenModeItem( WID_OPEN, eOpenMode ) );
					_bShowFolders = bOld;
				}
			}
		}

		return;
	}

	//////////////////////////////////////////////////////////////////////
	// CntNodeHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntNodeHint ) )
	{
		const CntNodeHint *pNodeHint = (const CntNodeHint*)&rHint;
		switch ( pNodeHint->GetAction() )
		{
			// alter Subnode der jetzt reingehoert?
			case CNT_ACTION_RESULT:
			{
				// If the broadcaster is not a job, it should be a node
				// doing a CNT_ACTION_INSERTED_IN_MULTIPLE, which, at the
				// moment, is only issued from a search folder's WID_OPEN,
				// WID_UPDATE, and WID_SYNCHRONIZE; therefore, fall through to
				// CNT_ACTION_INSERTED is ok in that case:
				CntNodeJob * pJob = PTR_CAST(CntNodeJob, &rBC);
				if (pJob)
				{
					USHORT nWhich = pJob->GetRequest()->Which();

					// Alle Results, die nicht aus einem WID_OPEN,
					// WID_SYNCHRONIZE oder einem WID_UPDATE kommen, werden
					// ignoriert, die anderen fallen durch ins INSERTED
					if ( ( nWhich != WID_UPDATE ) &&
						 ( nWhich != WID_OPEN ) &&
						 ( nWhich != WID_SYNCHRONIZE ) )
						return;
				}

				// Note: fall-thru is okay!
			}

			// Neuer Subnode??
			case CNT_ACTION_INSERTED:
			{
				// zuerst evtl. vorhandene Regeln anwenden, dann pruefen,
				// ob der Knoten eingefuegt werden soll und zum Schluss
				// den Knoten einfuegen.

				if ( _bIgnoreNodes )
					return;

				CntNodeRef xNode( pNodeHint->GetNode() );
				CntAnchorRef xSelf( this );

				BOOL bThreadIt, bChecked, bIsDocument, bIsFolder;

				bIsDocument =
					ITEMSET_VALUE( &xNode, CntBoolItem, WID_FLAG_IS_DOCUMENT );

				// es gibt leider doch Objekte, die sowohl
				// Dokumente als auch Ordner sind. Ein einfaches
				// negieren von bIsDocument reicht deshalb nicht
				bIsFolder = !bIsDocument;
				bIsFolder |=
					ITEMSET_VALUE( &xNode, CntBoolItem, WID_FLAG_IS_FOLDER );
				bIsFolder |=
					ITEMSET_VALUE( &xNode, CntBoolItem, WID_SHOW_IN_EXPLORER );

				// Check if Node is already inserted
				if ( _bNotifyAll ||
					 ( ( ( bIsDocument && _bShowDocuments ) ||
					   	 ( bIsFolder && _bShowFolders ) ) &&
					   !CheckNode( &xNode ) ) )
				{
					CntNodeRef xView(
							CntViewBase::MakeViewNode( xNode, GetNode() ) );
					if ( xView.Is() )
						xNode = xView;

					// Neuen Anker erzeugen und festhalten
					CntAnchor* pParentAnchor = _bNotifyAll ? NULL : this;
					CntAnchorRef xNewAnchor(
									new CntAnchor( pParentAnchor, &xNode ) );

					// Anker initialisieren
					if ( _bInitSubAnchors || xNode->IsRootNode() )
						xNewAnchor->Put( SfxVoidItem( WID_GETDATA ) );

					if ( !bIsDocument )
					{
						if ( !_bInitSubAnchors )
						{
#ifdef INIT_ONLY_WHEN_NOT_VIEW_ALL
							if ( GetItemState( WID_FOLDERVIEW_MODE )
								 > SFX_ITEM_DISABLED )
							{
								if ( (CntFolderViewMode)
											 THIS_ITEM_VALUE(
												 CntFolderViewModeItem,
												 WID_FOLDERVIEW_MODE )
									 != CNT_VIEW_ALL_FOLDERS )
									xNewAnchor->Put(
											SfxVoidItem( WID_GETDATA ) );
							}
#else
							xNewAnchor->Put( SfxVoidItem( WID_GETDATA ) );
#endif
						}
#ifdef ONLY_2500_CHILDREN
						if ( _nTotalChildren >= MAX_CHILD_COUNT )
						{
							CntNode* pOwnNode =	GetNode()->GetMostReferedNode();
							CntNodeJob *pCurrJob = pOwnNode->GetCurrentJob();
							if ( pCurrJob )
							{
								USHORT nWhich =	pCurrJob->GetRequest()->Which();

								if ( ( nWhich == WID_OPEN ) ||
									 ( nWhich == WID_UPDATE ) ||
									 ( nWhich == WID_SYNCHRONIZE ) )
								{
									// Wir duerfen nur Jobs abbrechen,
									// die wir selbst aufgesetzt haben!
									if ( pCurrJob->GetClient() == this )
										pCurrJob->Cancel();

									ErrCode nError = *new StringErrorInfo(
											ERRCODE_CHAOS_TO_MANY_GROUPS,
											String() );

									CNT_RNM()->HandleError( nError, NULL );
								}
							}
							return;
						}
#endif
					}

					if ( _bNotifyAll )
					{
						CntNodeJob* pJob = pNodeHint->GetJob();
						if ( pJob )
						{
							// Filter objects not matching job's open mode.
							// Not all services support restricted modes.

							CntOpenModeItem* pItem =
								PTR_CAST( CntOpenModeItem, pJob->GetRequest() );
							if ( pItem )
							{
								CntOpenMode eMode = pItem->GetValue();
								switch ( eMode )
								{
									case CNT_OPEN_ALL:
										break;

									case CNT_OPEN_FOLDERS:
										if ( !bIsFolder )
											return;

										break;

									case CNT_OPEN_DOCUMENTS:
										if ( !bIsDocument )
											return;

										break;

									default:
										DBG_ERROR( "CntAnchor::Notify - "
												   "Unknown open mode! " );
										break;
								}
							}
						}

						Broadcast( CntAnchorHint( xNewAnchor,
											  	  CNT_ACTION_INSERTED,
											  	  pNodeHint->GetJob() ) );
					}
					else
					{
						CntAnchor* pSortParent = (CntAnchor*) GetSortParent();
						bThreadIt =
							pSortParent->ApplyRules( xNewAnchor, bChecked );

						if ( bThreadIt && !bChecked )
							bThreadIt =
								pSortParent->CheckViewMode( xNewAnchor );

						if ( bThreadIt )
						{
							InsertThreaded(
								NULL, xNewAnchor, pNodeHint->GetJob() );
							CheckAndInsertInNode( &xNode );
						}
					}

					if ( xNewAnchor->GetItemState( WID_IS_MARKED )
					     > SFX_ITEM_DISABLED )
					{
						// Marked objects never shall be deletable.
						BOOL bMarked = ITEMSET_VALUE(
									xNewAnchor, CntBoolItem, WID_IS_MARKED );
						CntNode* pNode =
									xNewAnchor->GetNode()->GetMostReferedNode();
						if ( bMarked )
						{
							// Disable WID_DELETE.
							pNode->DisableItem( WID_DELETE );
						}
//						else
//						{
//							SfxItemState eState =
//											pNode->GetItemState( WID_DELETE );
//							if ( eState & SFX_ITEM_DISABLED )
//							{
//								// Enable WID_DELETE.
//								pNode->ClearItem( WID_DELETE );
//							}
//						}
					}
				}
				return;
			}

			case CNT_ACTION_EXCHANGED:
			{
				if ( !GetNode() )
					return;

				CntNode *pBC = NULL;
				if ( rBC.ISA( CntNode ) )
					pBC = (CntNode*)&rBC;

				if ( pBC )
				{
					if ( pBC != GetNode() )
						return;

					SetNode( pNodeHint->GetNode() );
					_bGetDataDone = FALSE;

					if ( _bIsInserted )
					{
						// Parent Anker in den neuen Node eintragen
						CntAnchor *pParent = GetTParent();
						if ( pParent )
							pParent->CheckAndInsertInNode(
												pNodeHint->GetNode() );
						// und anschliessend in den Listen an der richtigen
						// Stelle wieder einsortieren
						pParent = GetParent();
						pParent->MoveAnchor( this );
					}

					Broadcast( CntAnchorHint( this,
											  CNT_ACTION_EXCHANGED,
											  pNodeHint->GetJob() ) );
				}
				else if ( rBC.ISA( CntNodeJob ) )
				{
					// Create a job and let the refered node handle it all...
					Put( CntStringItem( WID_REFERED_URL,
									OWN_URL( pNodeHint->GetNode() ) ) );
				}

				return;
			}

			case CNT_ACTION_DELETED:
			{
				CntNode* pNode = pNodeHint->GetNode();

				if ( IsRefered_Impl( pNode, this ) )
				{
					// deleted node is one of my refered nodes...

					if ( pNode != &_xNode )
					{
						BOOL bDestroy = ITEMSET_VALUE( pNode, CntBoolItem,
									                   WID_DELETE );
						CntNodeJob *pJob =	new CntNodeJob(
										NULL, this, _xNode,
										CntBoolItem( WID_DELETE, bDestroy ) );
						_xNode->InsertJob( pJob );
					}
					else
					{
						// Reset the delete-done flag for all refered nodes
						CntNode *pCurr = _xNode;
						while ( pCurr )
						{
							pCurr->ResetDeleteDone();
							pCurr = pCurr->GetReferedNode();
						}

						// View-Storage file for out tray deleted?
						if ( pNode->GetMostReferedNode()
						                    ->ISA( CntOutTrayNode ) )
						{
							CntRootNodeMgr* pRNM = CNT_RNM();
							String aCurr( pRNM->GetOutTrayURL() );
							String aThis( OWN_URL( pNode ) );

							if ( pRNM->GetOutTrayURL() == OWN_URL( pNode ) )
								pRNM->SetOutTrayURL( UniString() );
						}

						CntAnchorRef xThis( this );
						if ( DeleteAnchor() )
						{
							Broadcast( CntAnchorHint( this,
													  CNT_ACTION_DELETED,
													  pNodeHint->GetJob() ) );
#if 0
	// KSO: Doesn't work.
	//      Problems with actions taken when WID_DELETE jobs are done.

							// Release node...
							SetNode( NULL );
#endif
							_nError = 1024;
						}
					}
				}
				else
					DBG_ERROR( "Deleted node is not refered by me!");

				return;
			}

			case CNT_ACTION_REMOVED:
			{
				CntNode*   pNode   = pNodeHint->GetNode();
				CntAnchor* pAnchor = NULL;

				// This removed?
				if ( IsRefered_Impl( pNode, this ) )
				{
					pAnchor = this;
				}
				else
				{
					// Child removed?
					ULONG nCount = SubAnchorCount();
					for ( ULONG n = 0; n < nCount; n++ )
					{
						CntAnchor* pSub = GetSubAnchor( n );
						if ( IsRefered_Impl( pNode, pSub ) )
						{
							pAnchor = pSub;
							break;
						}
					}
				}

				if ( pAnchor )
				{
					CntAnchor *pParent = pAnchor->GetParent();
					CntAnchorRef xAnchor( pAnchor );

					if ( pAnchor->_bUsesNewView )
					{
						DBG_ASSERT( pAnchor->GetParent(),
						            "Removing Child without Parent" );
						if ( pAnchor->GetParent() && pAnchor->_bIsInserted )
							pAnchor->GetParent()->RemoveSubAnchor( pAnchor );
					}
					else
					{
						pAnchor->Broadcast(
										CntAnchorHint( pAnchor,
												   	CNT_ACTION_REMOVED,
												   	pNodeHint->GetJob() ) );

#if 0
	// KSO: Doesn't work.
	//      Problems with actions taken when WID_DELETE jobs are done.

						// Release node...
						pAnchor->SetNode( NULL );
#endif
						pAnchor->_nError = 1024;
					}

					if ( _bCleanupParents )
					{
						// Wenn wir einen Pseudoparent haben und das letzte
						// Kind von diesem Parent waren, dann loeschen wir
						// auch noch den Parent. ... und dessen Parent, ...
						while ( pParent &&
								!pParent->GetNode() &&
								!pParent->SubAnchorCount() )
						{
							CntAnchor *pTemp = pParent;
							pParent = pParent->GetParent();
							if ( pParent )
							{
								pTemp->RemoveFromLists();
								pParent->RemoveSubAnchor( pTemp );
							}
						}
					}

					return;
				}

				return;
			}

			case CNT_ACTION_FILENAME_CHANGED:
			{
				if ( IsRootAnchor() )
				{
					if ( !CntViewBase::IsRootViewURL(
									OWN_URL( pNodeHint->GetNode() ) ) )
					{
						DBG_ERROR( "New URL is not for view file!" );
						return;
					}

					SetURLRecursive_Impl( pNodeHint->GetNode() );

					CntAnchorRef xThis( this );
					Broadcast( CntAnchorHint( this,
											  CNT_ACTION_FILENAME_CHANGED,
											  pNodeHint->GetJob() ) );
				}

				return;
			}

			case CNT_ACTION_MODIFIED:
			case CNT_ACTION_KILL_ALL:
			{
				if ( ( pNodeHint->GetAction() == CNT_ACTION_KILL_ALL ) &&
					 IsExpanded() )
					Collapse();

				CntAnchorRef xThis( this );
				Broadcast( CntAnchorHint( this,
										  pNodeHint->GetAction(),
										  pNodeHint->GetJob() ) );
				return;
			}

			default:
				DBG_ERROR( "Unhandled CntNodeHint!" );
				return;
		}

		// End of CntNodeHint handling.
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// CntNodeJob notifications handling.
	//////////////////////////////////////////////////////////////////////

	if ( rBC.ISA( CntNodeJob ) )
	{
		//////////////////////////////////////////////////////////////////
		// CntStatusHint handling.
		//////////////////////////////////////////////////////////////////

	    if ( rHint.ISA( CntStatusHint ) )
	    {
			CntNodeJob *pJob = (CntNodeJob*)&rBC;
			BOOL		bDone = FALSE;
			BOOL		bOpenDone = FALSE;

			CntAnchorRef xThis( this );

	        const CntStatusHint* pStatusHint = (const CntStatusHint*)&rHint;
	        const CntStatus eStatus = pStatusHint->GetStatus();

			if ( eStatus == CNT_STATUS_DONE )
			{
		        // Job done.
				bDone = TRUE;
				bOpenDone = TRUE;
			}
			else if ( ( eStatus == CNT_STATUS_ERROR ) &&
					  ( pStatusHint->GetError() == ERRCODE_ABORT ) &&
					  ! pJob->GetParent() )
			{
				// Cleanup after aborting an open job but
				// Ignore notifications from child jobs
				const SfxPoolItem* pReq = pJob->GetRequest();
				USHORT nWhich = pReq->Which();
				switch ( nWhich )
				{
					case WID_OPEN:
						_bInOpen = FALSE;
						// Fall-thru is okay.
					case WID_UPDATE:
					case WID_SYNCHRONIZE:
						_bExpanding = FALSE;
						_bIgnoreNodes = FALSE;
						bOpenDone = TRUE;
						break;
				}
			}

			if ( bOpenDone )
			{
				if ( _bNotifyExpanded )
				{
					USHORT nWhich = pJob->GetRequest()->Which();

					if ( ( nWhich == WID_OPEN ) && _pOpenData &&
						 ( _pOpenData->GetOpenJob() == pJob ) )
					{
						delete _pOpenData;
						_pOpenData = NULL;

						CntAnchor *pAbsParent = GetAbsParent();
						if ( pAbsParent )
						{
							// Do not broadcast, if job was cancelled.
							if ( bDone )
							{
								ULONG nPos = GetAbsPos();
								pAbsParent->Broadcast(
									CntAnchorViewHint( CNT_ACTION_EXPANDING,
													   nPos,
													   1,
													   WID_FLAG_EXPANDED ) );
							}
							_bNotifyExpanded = FALSE;
						}
					}
				}
				else
				{
					if ( _pOpenData )
					{
						delete _pOpenData;
						_pOpenData = NULL;
					}
				}
			}

			// Do not propagate notifications from child jobs.
			if ( !pJob->GetParent() )
				Broadcast( rHint );

			if ( bDone )
			{
				//////////////////////////////////////////////////////////
				// CntNodeJob done.
				//////////////////////////////////////////////////////////

				const SfxPoolItem* pReq = pJob->GetRequest();
				USHORT nWhich = pReq->Which();
				switch ( nWhich )
				{
					case WID_OPEN:
					{
						// Ignore notifications from child jobs.
						if ( pJob->GetParent() )
							return;

						_bIgnoreNodes = FALSE;
						_bInOpen = FALSE;

						CntOpenMode	eOpenMode = (CntOpenMode)
										ITEM_VALUE( CntOpenModeItem, *pReq );

#if defined( WNT ) && defined( PROFILE ) && defined( DV_PROFILING )
						// Hier wird das Profiling wieder ausgeschaltet.
						// Openmode wie oben
						if ( eOpenMode == CNT_OPEN_FOLDERS )
							E_CAP ;
#endif
						if (_bExpanding)
							ExpandChildren( eOpenMode );

						return;
					}

					case WID_UPDATE:
					{
						// Ignore notifications from child jobs.
						if ( pJob->GetParent() )
							return;

						_bIgnoreNodes = FALSE;

						return;
					}

					case WID_SYNCHRONIZE:
					{
						// Ignore notifications from child jobs.
						if ( pJob->GetParent() )
							return;

						_bIgnoreNodes = FALSE;
						return;
					}

					case WID_REFERED_URL:
						// adapt own which ranges
						SetRanges( pJob->GetSubject()->GetRanges() );
						return;

					case WID_GETDATA:
					{
						if ( !_xNode.Is() )
							return;

						// Note: This is for restoring update requests, for
						//       instance if a server was undeleted from trash
						//       or rootstg.scs was deleted.
						//       WID_GETDATA is called very early after
						//       object initialization.

						// Synchronize (Auto)-Update requests at RootNodeMgr...
						BOOL bUpdate = THIS_ITEM_VALUE( CntBoolItem,
							   	                        WID_UPDATE_ENABLED );
						if ( bUpdate )
						{
							if ( !IsInTrash_Impl( this ) )
							{
								ULONG nInterval =
									THIS_ITEM_VALUE( CntUInt32Item,
									  	             WID_AUTOUPDATE_INTERVAL );
								CNT_RNM()->RequestAutoUpdate( this, nInterval );
							}
						}

						if ( !_xNode->IsRootNode() )
							return;

						// Synchronize OutTray URL at RootNodeMgr...
						if ( !_xNode->GetMostReferedNode()
			      			  					   ->ISA( CntOutTrayNode ) )
							return;

						const String& rOwnURL = OWN_URL( _xNode );
						if ( !CntViewStorageNode::IsRootViewURL( rOwnURL ) )
							return;

						if ( ( CNT_RNM()->GetOutTrayURL().Len() == 0 ) &&
						     !IsInTrash_Impl( this ) )
							CNT_RNM()->SetOutTrayURL( rOwnURL );

						return;
					}

					case WID_PUTDATA:
					{
						const CntItemListItem *pListItem =
												(const CntItemListItem *)pReq;
						USHORT nCount = pListItem->Count();
						for ( USHORT n = 0; n < nCount; n++ )
						{
							const SfxPoolItem& rItem = (*pListItem)[ n ];

							if ( rItem.Which() == WID_TITLE )
							{
								Invalidate_Impl( GetNode() );
								CNT_RNM()->AddView( GetNode() );
							}
						}
						return;
					}

					case WID_DELETE:
						{
							CntNode* pSubject = pJob->GetSubject();
							Invalidate_Impl( pSubject );
							CNT_RNM()->RemoveView( pSubject );
						}
						break;

					case WID_TITLE: // Rename!
					case WID_INSERT:
					{
						CntNode* pSubject = ( nWhich == WID_TITLE )
										  ?	GetNode()
										  :	pJob->GetSubject();
						if ( !pSubject )
							break;

						Invalidate_Impl( pSubject );
						CNT_RNM()->AddView( pSubject );
						break;
					}

					case WID_UNDELETE:
					{
						// Restore data.
						Put( SfxVoidItem( WID_GETDATA ) );

						// Synchronize auto-update requests.
						BOOL bUpdate =
							THIS_ITEM_VALUE( CntBoolItem, WID_UPDATE_ENABLED );
						if ( bUpdate )
						{
							ULONG nInterval =
									THIS_ITEM_VALUE( CntUInt32Item,
													 WID_AUTOUPDATE_INTERVAL );
							CNT_RNM()->RequestAutoUpdate( this, nInterval );
						}
						break;
					}

					case WID_TRANSFER:
					{
						const CntTransferItem& rItem =
										(const CntTransferItem&)*pReq;
						if ( !rItem.isMoveOperation() )
						{
							// Nothing to do on copy operation.
							break;
						}

						CNT_RNM()->RemoveView( rItem.getSourceURL() );
						break;
					}

					default:
						break;
				}

				return;
			}

			return;
	    }

		//////////////////////////////////////////////////////////////////
		// CntUpdateHint handling.
		//////////////////////////////////////////////////////////////////

	    if ( rHint.ISA( CntUpdateHint ) )
		{
			Broadcast( rHint );
			return;
		}
	}

	//////////////////////////////////////////////////////////////////////
	// CntAnchorSaverHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntAnchorSaverHint ) )
	{
		const CntAnchorSaverHint *pAnchorSaverHint =
										(const CntAnchorSaverHint*)&rHint;

		CntNode	*pRoot = GetNode()->GetMostReferedNode();

        if ( pAnchorSaverHint->GetErrorCode() == ERRCODE_NONE )
		{
			Broadcast( CntAnchorSaverHint( pAnchorSaverHint->GetAnchor(),
										   CNT_ACTION_DELETE,
										   String() ) );
		}
		else if ( CheckViewMode( pAnchorSaverHint->GetAnchor() ) )
		{
			InsertThreaded( NULL, pAnchorSaverHint->GetAnchor(), NULL );
		}

		return;
	}

	//////////////////////////////////////////////////////////////////////
	// CntSearchMatched[URL]Hint, CntTransferHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntSearchMatchedURLHint ) ||
	     rHint.ISA( CntTransferHint ) )
	{
		Broadcast( rHint );
		return;
	}

	//////////////////////////////////////////////////////////////////////
	// CntStatusBarHint handling.
	//////////////////////////////////////////////////////////////////////

	if ( rHint.ISA( CntStatusBarHint ) )
	{
		// CntStatusBarHint werden an die naechste View Root weitergeleitet,
		// weil nur noch diese auf Status Hints lauschen!

		if ( _bUsesNewView )
		{
			CntAnchor *pAbsParent = GetRoot();
			if ( pAbsParent )
				pAbsParent->Broadcast( rHint );
			else
				Broadcast( rHint );
		}
		else
			Broadcast( rHint );
		return;
	}

	CntInterface::Notify( rBC, rHint );
}

//----------------------------------------------------------------------------
BOOL CntAnchor::OutTrayViewWanted( String& rOutURL )
{
	if ( THIS_ITEM_VALUE( CntBoolItem, WID_OUTTRAY_WANTED ) )
	{
		if ( CntSystem::ViewExists( String(), CONTENT_TYPE_X_CNT_OUTBOX ) )
			return FALSE;

		// Uhhh! Hardcore...
		rOutURL = UniString::CreateFromAscii(
					RTL_CONSTASCII_STRINGPARAM( STG_PROTOCOL_CACHE ) );
		rOutURL.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "out:///~" ) );
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
// static
const String& CntAnchor::GetOutTrayURL()
{
	return CNT_RNM()->GetOutTrayURL();
}

//----------------------------------------------------------------------------
void CntAnchor::MarkThread( const SfxPoolItem& rItem )
{
	vos::OGuard aGuard( *GetMutex() );

	USHORT		nWhich = rItem.Which();

	if ( _bIsDocument )
	{
		CntAnchor	*pChild;
		ULONG		i;
		ULONG		nCount = SubAnchorCount();

		for ( i=0; i<nCount; i++ )
		{
			pChild = GetSubAnchor( i );

			if ( pChild->SubAnchorCount() )
				pChild->MarkThread( rItem );
			else if ( pChild->_bIsDocument )
				if ( pChild->GetNode() )
					pChild->Put( rItem, nWhich );
				else
					pChild->CntInterface::Put( rItem, nWhich );
		}
	}

	if ( GetNode() )
		Put( rItem, nWhich );
	else
		CntInterface::Put( rItem, nWhich );
}

//----------------------------------------------------------------------------
void CntAnchor::Changed( const SfxPoolItem& rOld, const SfxPoolItem& rNew )
{
	// Do nothing if changing from a disabled item to an enabled one or vice
	// versa, or if both items are really the same:
	if (rOld.ISA(SfxVoidItem) || rNew.ISA(SfxVoidItem) || rOld == rNew)
		return;

	if ( rOld.Which() == WID_IS_READ )
		CheckSeenStatus();

	CheckAnchor( rOld );

	USHORT nWhich = rOld.Which();
	if ( nWhich == WID_SORTING )
	{
		ReSort();
		CntAnchor *pAbsParent = GetAbsParent();
		if ( pAbsParent )
			pAbsParent->_pSearchData->ReSort();
	}
	else if ( ( nWhich == WID_FLAG_SUBSCRIBED ) && _bIsThreaded )
	{
		BOOL bIsSubscribed = THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_SUBSCRIBED );

		if ( ! bIsSubscribed && !_bIsDocument )
		{
			// Wenn wir gethreaded sind und ein Ordner,
			// dann brauchen wir eine Sonderbehandlung
			HandleUnsubscribe();
		}
	}
}

//----------------------------------------------------------------------------
BOOL CntAnchor::CheckNode( CntNode *pNode )
{
	vos::OGuard aGuard( *GetMutex() );
	BOOL bFound = FALSE;

	//! HACK : da wir mal StorageNodes und mal NewsGroupNodes bekommen,
	//  suchen wir uns immer den untersten Node. (Es sei denn, wir sind
	//  ein RootNode ( HACK2: fuer Fsys, wenn 2 .scc auf eine Root zeigen
	if ( ! pNode->IsRootNode() )
		pNode = pNode->GetMostReferedNode();

	// Check if Node already inserted
	CntNodeUserData *pData = pNode->GetUserData();

	while ( pData && !bFound )
	{
		if ( pData->_pAnchor == this )
			bFound = TRUE;
		else
			pData = pData->_pNextData;
	}

	return bFound;
}

//----------------------------------------------------------------------------
BOOL CntAnchor::CheckAndInsertInNode( CntNode *pNode )
{
	vos::OGuard aGuard( *GetMutex() );

	BOOL bFound = FALSE;

	//! HACK : da wir mal StorageNodes und mal NewsGroupNodes bekommen,
	//  suchen wir uns immer den untersten Node. (Es sei denn, wir sind
	//  ein RootNode ( HACK2: fuer Fsys, wenn 2 .scc auf eine Root zeigen
	if ( ! pNode->IsRootNode() )
		pNode = pNode->GetMostReferedNode();

	// Check if Node already inserted
	CntNodeUserData *pData = pNode->GetUserData();

	while ( pData && !bFound )
	{
		if ( pData->_pAnchor == this )
			bFound = TRUE;
		else
			pData = pData->_pNextData;
	}

	if ( !bFound )
	{
		pData = new CntNodeUserData;
		pData->_pAnchor = this;
		pData->_pNextData = pNode->GetUserData();
		pNode->SetUserData( pData );
	}

	return bFound;
}

//----------------------------------------------------------------------------
void CntAnchor::RemoveFromNode()
{
	vos::OGuard aGuard( *GetMutex() );

	BOOL	bFound = FALSE;
	CntNode *pNode = GetNode();

	if ( !pNode || ! _bIsInserted )
		return;

	// Find Anchor into which the node should been inserted
	CntAnchor *pRoot = GetTParent();
	if ( !pRoot )
		return;

	//! HACK : da wir mal StorageNodes und mal NewsGroupNodes bekommen,
	//  suchen wir uns immer den untersten Node. (Es sei denn, wir sind
	//  ein RootNode ( HACK2: fuer Fsys, wenn 2 .scc auf eine Root zeigen
	if ( ! pNode->IsRootNode() )
		pNode = pNode->GetMostReferedNode();

	// Check if Node already inserted
	CntNodeUserData *pData = pNode->GetUserData();
	CntNodeUserData *pLast = pData;

	while ( pData && !bFound )
	{
		if ( pData->_pAnchor == pRoot )
			bFound = TRUE;
		else
		{
			pLast = pData;
			pData = pData->_pNextData;
		}
	}

	if ( bFound )
	{
		if ( pLast != pData )
			pLast->_pNextData = pData->_pNextData;
		else
			pNode->SetUserData( pData->_pNextData );
		delete pData;
	}
}

//----------------------------------------------------------------------------
void CntAnchor::RemoveFromChildList( CntAnchor *pAnchor )
{
	vos::OGuard aGuard( *GetMutex() );

	CntAnchor *pEntry = _pChildList;
	CntAnchor *pLast = NULL;

	while ( pEntry && ( pEntry != pAnchor ) )
	{
		pLast = pEntry;
		pEntry = pEntry->_pNextBrother;
	}

	if ( pEntry )
	{
		if ( pEntry == _pChildList )
			_pChildList = pEntry->_pNextBrother;
		else
			pLast->_pNextBrother = pEntry->_pNextBrother;

		pEntry->_pNextBrother = NULL;
	}
}

//----------------------------------------------------------------------------
com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
CntAnchor::getInterface() const
{
	if ( _xNode.Is() )
		return _xNode->GetMostReferedNode()->getInterface();

	return com::sun::star::uno::Reference< com::sun::star::uno::XInterface >();
}

//----------------------------------------------------------------------------
BOOL CntAnchor::IsComponent() const
{
	// Obsolete.
	return FALSE;
}

//----------------------------------------------------------------------------
void CntAnchor::GetAllRanges( SfxUShortRanges& rRange ) const
{
	vos::OGuard aGuard( *GetMutex() );

	rRange = GetRanges();
	const SfxItemSet* pParentItems = SfxItemSet::GetParent();

	while ( pParentItems )
	{
		rRange += pParentItems->GetRanges();
		pParentItems = pParentItems->GetParent();
	}
}

//----------------------------------------------------------------------------
SfxItemSet* CntAnchor::CloneItems() const
{
	vos::OGuard aGuard( *GetMutex() );

	SfxItemSet *pSet = NULL;

	if ( GetNode() )
	{
		pSet = GetNode()->Clone();
		// Wenn wir den Parent nicht setzen, gibt es GPFs wenn sich
		// irgend etwas an der Node-Struktur aendert.
		pSet->SetParent( this );
	}
	return pSet;
}

//////////////////////////////////////////////////////////////////////////////
// Q: Why does the class CntAnchor not have a member _pErrorHandlerLink?
// A: Because it would increase CntAnchor's object size. But in most cases
//    the member would not be filled and CntAnchor's should be as small as
//    possible.
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
BOOL CntAnchor::RegisterErrorHandler( const Link& rLink )
{
	return CNT_RNM()->RegisterErrorHandler( this, rLink );
}

//----------------------------------------------------------------------------
BOOL CntAnchor::DeregisterErrorHandler()
{
	return CNT_RNM()->DeregisterErrorHandler( this );
}

//----------------------------------------------------------------------------
const Link* CntAnchor::QueryErrorHandler() const
{
	return CNT_RNM()->QueryErrorHandler( this );
}

//----------------------------------------------------------------------------
void CntAnchor::SetOpenMode( CntOpenMode eOpenMode )
{
	vos::OGuard aGuard( *GetMutex() );

	if ( eOpenMode == CNT_OPEN_DOCUMENTS )
	{
		_bShowDocuments = TRUE;
		_bShowFolders = FALSE;
	}
	else if ( eOpenMode == CNT_OPEN_FOLDERS )
	{
		_bShowDocuments = FALSE;
		_bShowFolders = TRUE;
	}
	else if ( eOpenMode == CNT_OPEN_ALL )
	{
		_bShowDocuments = TRUE;
		_bShowFolders = TRUE;
	}
}

//----------------------------------------------------------------------------
// sind _bShowDocuments und _bShowFolders FALSE wird CntOpenAll zurueckgegeben
CntOpenMode CntAnchor::GetOpenMode() const
{
	vos::OGuard aGuard( *GetMutex() );
	CntOpenMode eMode = CNT_OPEN_ALL;

	if( !_bShowDocuments && _bShowFolders )
		eMode = CNT_OPEN_FOLDERS;
	else if( !_bShowFolders && _bShowDocuments )
		eMode = CNT_OPEN_DOCUMENTS;
	return eMode;
}

//----------------------------------------------------------------------------
static
void CleanUpParentChain_Impl( CntAnchor *pParent )
{
	if ( !pParent )
		return;

	CntAnchorRef xChild;
	CntAnchorRef xThreader;

	// Wenn wir nur noch ein Kind da ist, dann wird dieses temporaer entfernt
	// ...
	if ( pParent && !pParent->GetNode() && ( pParent->SubAnchorCount() == 1 ) )
	{
		xChild = pParent->GetSubAnchor( 0 );
		xThreader = xChild->GetThreader();
		xChild->RemoveFromLists();
		pParent->RemoveSubAnchor( xChild );
	}

	// Wenn wir einen Pseudoparent haben und das letzte Kind von diesem
	// Parent waren, dann loeschen wir auch noch den Parent.
	// ... und dessen Parent, ...
	while ( pParent && !pParent->GetNode() && !pParent->SubAnchorCount() )
	{
		CntAnchor *pTemp = pParent;
		pParent = pParent->GetParent();
		if ( pParent )
		{
			pTemp->RemoveFromLists();
			pParent->RemoveSubAnchor( pTemp );
		}
	}

	if ( xChild.Is() )
	{
		xThreader->InsertThreaded( NULL, xChild, NULL );
	}
}

//----------------------------------------------------------------------------
static CntNode* QueryNode_Impl( const String& rURL )
{
	CntNode* pNode = CNT_RNM()->Query( rURL );
	if ( !pNode )
	{
		// #69651# - View-Storage-URL, but node was not created, because
		//           the file has the wrong format? ( i.e. Writer-Document
		//           stored with file extension scc ) Create a "simple"
		//           file node for the URL.
		if ( INetURLObject::CompareProtocolScheme( rURL ) == INET_PROT_FILE )
		{
			if ( CntViewBase::IsRootViewURL( rURL ) )
			{
				CntNodeRef xParent( CNT_RNM()->Query(
						INetURLObject( rURL ).GetPartBeforeLastName() ) );
				if ( xParent.Is() )
					pNode = xParent->Query( rURL );
			}
		}
	}
	return pNode;
}

//============================================================================
//
// CntAnchorViewHint Implementation.
//
//============================================================================

TYPEINIT1( CntAnchorViewHint, SfxHint );

//============================================================================
//
// CntAnchorHint Implementation.
//
//============================================================================

TYPEINIT1( CntAnchorHint, SfxHint );

//----------------------------------------------------------------------------
CntAnchorHint::CntAnchorHint(
					CntAnchor *pAnchor, CntAction eAction, CntNodeJob* pJob )
:	_pAnchor( pAnchor ),
 	_eAction( eAction ),
	_pJob( pJob )
{
	_pAnchor->AddRef();

//	DBG_ASSERT( ( eAction != CNT_ACTION_INSERTED ) || _pJob,
//				"CntAnchorHint - CNT_ACTION_INSERTED without job!" );

	if ( _pJob )
		_pJob->AddRef();
}

//----------------------------------------------------------------------------
// virtual
CntAnchorHint::~CntAnchorHint()
{
	_pAnchor->ReleaseRef();

	if ( _pJob )
		_pJob->ReleaseRef();
}

//============================================================================
//
// CntAnchorSaverHint Implementation.
//
//============================================================================

TYPEINIT1( CntAnchorSaverHint, SfxHint );

//----------------------------------------------------------------------------
CntAnchorSaverHint::CntAnchorSaverHint( CntAnchor *pAnchor,
										CntSaverAction eAction,
										const String& rDest )
:	_nErrorCode( 0 ),
	_pAnchor( pAnchor ),
 	_eAction( eAction ),
 	_aDestination( rDest )
{
}

//============================================================================
//
// CntAnchorItem Implementation.
//
//============================================================================

TYPEINIT1( CntAnchorItem, SfxPoolItem );

//----------------------------------------------------------------------------
CntAnchorItem::CntAnchorItem( const CntAnchorItem &rOrig )
:	SfxPoolItem( rOrig.Which() ),
	_xAnchor( rOrig._xAnchor )
{
}

//----------------------------------------------------------------------------
CntAnchorItem::CntAnchorItem( USHORT nID, CntAnchor * pAnchor )
:	SfxPoolItem( nID ),
	_xAnchor( pAnchor )
{
}

//----------------------------------------------------------------------------
// virtual
int CntAnchorItem::operator==( const SfxPoolItem& rItem ) const
{
	// nur Pointer-Vergleich
	return &( (CntAnchorItem&)rItem )._xAnchor == &_xAnchor;
}

//----------------------------------------------------------------------------
// virtual
SfxPoolItem* CntAnchorItem::Clone( SfxItemPool * ) const
{
	return new CntAnchorItem( *this );
}

