/*************************************************************************
 *
 *  $RCSfile: cntanchr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_CENUMITM_HXX
#include <svtools/cenumitm.hxx>
#endif
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include <svtools/ctypeitm.hxx>
#endif
#ifndef _INETMSG_HXX
#include <svtools/inetmsg.hxx>
#endif
#ifndef _SORTITEM_HXX
#include <sortitem.hxx>
#endif
#ifndef _CSTRITEM_HXX
#include <cstritem.hxx>
#endif
#ifndef _CNTVWITM_HXX
#include <cntvwitm.hxx>
#endif
#ifndef _CNTCCITM_HXX
#include <cntccitm.hxx>
#endif
#ifndef _CNTANCHR_HXX
#include <cntanchr.hxx>
#endif
#ifndef _CNTAPI_HXX
#include <cntapi.hxx>
#endif
#ifndef _CNTNODE_HXX
#include <cntnode.hxx>
#endif
#ifndef _CNTRNMGR_HXX
#include <cntrnmgr.hxx>
#endif
#ifndef _CNTJOB_HXX
#include <cntjob.hxx>
#endif
#ifndef _INIMGR_HXX
#include <inimgr.hxx>
#endif

#include <string>
#include <algorithm>

using namespace chaos;

static BOOL Impl_IsExpandOnOpen();

//----------------------------------------------------------------------------
EntryData::EntryData( CntAnchor *pAnchor, CntAnchor* pRoot )
{
	short	   nDepth = 1;
	CntAnchor *pParent = pAnchor->GetParent();

	while ( pParent && ( pParent != pRoot ) )
	{
		++nDepth;
		pParent = pParent->GetParent();
	}

	if ( pParent )
		++nDepth;

	_nDepth		= nDepth;
	_ppAnchors	= new CntAnchor*[nDepth];
	_ppAnchors[ --nDepth ] = pAnchor;

	pParent = pAnchor->GetParent();
	while ( nDepth )
	{
		_ppAnchors[ --nDepth ] = pParent;
		pParent = pParent->GetParent();
	}
}

//----------------------------------------------------------------------------
EntryData::~EntryData()
{
	delete _ppAnchors;
}

//----------------------------------------------------------------------------
int EntryData::Compare( const EntryData *pCompare ) const
{
	int		nCompare = 0;
	short	nCurDepth = 0;
	short	nMinDepth = std::min( _nDepth, pCompare->_nDepth );

	while ( ! nCompare && ( nCurDepth < nMinDepth ) )
	{
		if ( _ppAnchors[ nCurDepth ] != pCompare->_ppAnchors[ nCurDepth ] )
		{
			nCompare = _ppAnchors[ nCurDepth ]->Compare( pCompare->_ppAnchors[ nCurDepth ], TRUE );
			DBG_ASSERT( nCompare, "Compare-Ergebnis fraglich!" );
		}
		nCurDepth++;
	}
	if ( ! nCompare )
	{
		if ( _nDepth < pCompare->_nDepth )
			nCompare = -1;
		else if ( _nDepth > pCompare->_nDepth )
			nCompare = 1;
	}
	return nCompare;
}

//----------------------------------------------------------------------------
CntAnchor *EntryData::GetAnchor( short nDepth ) const
{
	if ( nDepth && ( nDepth <= _nDepth ) )
		return _ppAnchors[ nDepth - 1 ];
	else
		return _ppAnchors[ _nDepth - 1 ];
}

//============================================================================
PosEntryFinder::PosEntryFinder( CntAnchor *pBroadcaster )
{
	_pEntries = new List( 128, 128 );
	_pBroadcaster = pBroadcaster;
}

//----------------------------------------------------------------------------
PosEntryFinder::~PosEntryFinder()
{
	EntryData *pEntry = (EntryData*) _pEntries->First();

	while ( pEntry )
	{
		delete pEntry;
		pEntry = (EntryData*) _pEntries->Next();
	}

	delete _pEntries;
}

//----------------------------------------------------------------------------
CntAnchor * PosEntryFinder::GetEntryAtPos( ULONG nPos ) const
{
	EntryData *pData = (EntryData*) _pEntries->GetObject( nPos );

	if ( pData )
		return pData->GetAnchor();
	else
	{
		DBG_ERRORFILE( "GetEntryAtPos() : Entry not found!" );
		return NULL;
	}
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::FindPos( EntryData *pData, BOOL &rFound ) const
{
	rFound = FALSE;

	if ( ! _pEntries->Count() )
		return 0;

	long nStart = 0;
	long nEnd = _pEntries->Count() - 1;
	long nMid = nEnd / 2;

	int nCompVal = 1;

	while ( nCompVal && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		EntryData* pMid = (EntryData*)_pEntries->GetObject( nMid );

		nCompVal = pMid->Compare( pData );

        if ( nCompVal < 0 )		// pMid < pData
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

	if ( nCompVal == 0 )
	{
		rFound = TRUE;
		return nMid;
	}
	else
	{
		if ( nCompVal < 0 )			// pMid < pData
			return nMid + 1;
		else
			return nMid;
	}
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::FindPos( EntryData *pData,
							   long nStart,
							   long nEnd ) const
{
	if ( ! _pEntries->Count() )
		return 0;

	if ( nEnd < nStart )
	{
		if ( nStart == 0 )
			return 0;
		else if ( nEnd == ((long) _pEntries->Count()) - 1 )
			return _pEntries->Count();
		DBG_ERRORFILE( "FindPos: End > Start! ");
	}

	long nMid;
	int nCompVal = 1;

	while ( nCompVal && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		EntryData* pMid = (EntryData*)_pEntries->GetObject( nMid );

		nCompVal = pMid->Compare( pData );

        if ( nCompVal < 0 )		// pMid < pData
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

	if ( nCompVal == 0 )
	{
		return nMid;
	}
	else
	{
		if ( nCompVal < 0 )			// pMid < pData
			return nMid + 1;
		else
			return nMid;
	}
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::FindNext( EntryData *pData, long nStart ) const
{
	if ( ! _pEntries->Count() )
		return 0;

	if ( nStart >= (long) _pEntries->Count() )
		return _pEntries->Count();

	short		 nDepth = pData->GetDepth();
	CntAnchor	*pAnchor = pData->GetAnchor( nDepth );
	long		 nEnd = _pEntries->Count() - 1;
	int			 nCompVal = 1;
	long		 nMid;

	while ( nCompVal && ( nStart <= nEnd ) )
	{
		nMid = ( nEnd - nStart ) / 2 + nStart;
		EntryData* pMid = (EntryData*)_pEntries->GetObject( nMid );

		// Wenn pMid ein Kind von pData ist, dann ist pMid kleiner!
		// Dadurch erreichen wir, dass wir einen Anker finden, der
		// groesser als pData ist und kein Kind von pData ist.
		if ( pMid->GetAnchor( nDepth ) == pAnchor )
			nCompVal = -1;
		else
			nCompVal = pMid->Compare( pData );

        if ( nCompVal < 0 )		// pMid < pData
			nStart = nMid + 1;
		else
			nEnd = nMid - 1;
	}

	if ( nCompVal == 0 )
	{
		DBG_ERRORFILE( "PosEntryFinder::FindNext: Anchor already in list" );
		return nMid;
	}
	else
	{
		if ( nCompVal < 0 )			// pMid < pData
			return nMid + 1;
		else
			return nMid;
	}
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::InsertAnchor( CntAnchor *pNew )
{
	BOOL		bFound;
	ULONG		nPos;
	EntryData  *pEntry = new EntryData( pNew, _pBroadcaster );

	nPos = FindPos( pEntry, bFound );

	if ( ! bFound )
	{
		_pEntries->Insert( (void*) pEntry, nPos );

		BROADCAST( _pBroadcaster,
				   CntAnchorViewHint( CNT_ACTION_INSERTED, nPos, 1 ) );
	}
	else
		DBG_ERRORFILE( "PosEntryFinder::InsertAnchor Anchor already in List" );



#ifdef DBG_UTIL_DV
	EntryData	*pNext;
	int			 nCompare;
	pEntry = (EntryData*) _pEntries->First();
	pNext = (EntryData*) _pEntries->Next();
	while ( pNext )
	{
		nCompare = pEntry->Compare( pNext );
		if ( nCompare != -1 )
		{
			String aDummy;
			DBG_ERROR( "Sortierung falsch" );
		}
		pEntry = pNext;
		pNext = (EntryData*) _pEntries->Next();
	}
#endif

	return nPos;
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::RemoveAnchor( CntAnchor *pAnchor )
{
	BOOL		bFound;
	ULONG		nPos;
	EntryData	aEntry( pAnchor, _pBroadcaster );

	nPos = FindPos( &aEntry, bFound );

	if ( bFound )
	{
		EntryData *pEntry;

		pEntry = (EntryData*) _pEntries->Remove( nPos );
		delete pEntry;
		BROADCAST( _pBroadcaster,
		           CntAnchorViewHint( CNT_ACTION_REMOVED, nPos, 1 ) );
	}
	else
		DBG_ERRORFILE( "PosEntryFinder::RemoveAnchor Anchor NOT in List" );

	return nPos;
}

//----------------------------------------------------------------------------
void PosEntryFinder::ChangeAnchorPos( CntAnchor *pAnchor,
									  SfxPoolItem *pChangedItem,
									  BOOL bLast )
{
	// Der Algorithmus sieht wie folgt aus: Zuerst wird die urspruengliche
	// Position des Ankers ermittelt ( dazu muss pChangedItem an diesem
	// Anker gesetzt werden ). Anschliessend wird geprueft, ob der Anker
	// mit seinem neuem Item kleiner ist, als sein Vorgaenger oder groesser
	// als sein Nachfolger. Anschliessend wird im entsprechenden Bereich
	// nach der neuen Einfuegeposition gesucht. Man kann nicht einfach im
	// gesamten Bereich suchen, weil der Anker mit seinem geaendertem Item
	// wahrscheinlich falsch einsortiert ist und damit die binaere Suche
	// scheitern laesst.
	// ACHTUNG: Wenn der Anker aufgeklappt ist, dann sind auch seine Kinder
	// falsch einsortiert! Aus diesem Grund muss in diesem Fall der
	// Nachfolger mit der Funktion FindNext() gesucht werden, die die Kinder
	// des Ankers gesondert behandelt.

	// Wenn wir nur einen Eintrag in der Liste haben, dann brauchen
	// wir nichts umzusortieren
	if ( _pEntries->Count() <= 1 )
		return;

	BOOL		bFound;
	long		nOldPos, nNewPos, nNext;
	EntryData	aEntry( pAnchor, _pBroadcaster );
	EntryData	*pEntry;

	pAnchor->SetChangedItem( pChangedItem );
	nOldPos = FindPos( &aEntry, bFound );

	if ( !bFound )
	{
		DBG_ERRORFILE( "PosEntryFinder::ChangeAnchorPos() Anchor NOT found" );
		return;
	}

	if ( pAnchor->IsExpanded() )
	{
		// Wenn wir aufgeklappt sind, dann muessen wir den naechsten
		// Anker finden, der kein Kind von uns ist.
		nNext = FindNext( &aEntry, nOldPos + 1 );
	}
	else
		nNext = nOldPos + 1;

	// pChangedItem darf erst hier zurueckgesetzt werden, weil FindNext()
	// auch die alten Werte braucht.
	pAnchor->SetChangedItem( NULL );

	if ( nOldPos > 0 )
		pEntry = (EntryData*) _pEntries->GetObject( nOldPos - 1 );
	else
		pEntry = NULL;

	if ( pEntry && ( pEntry->Compare( &aEntry ) == 1 ) )
	{
		// Der Anker ist kleiner als sein Vorgaenger, also muss seine
		// neue Position im Bereich [0..nOldPos-1] liegen. Mit dem
		// Vorgaenger haben wir schon verglichen, also koennen wir
		// FindPos() als Obergrenze nOldPos-2 mitgeben.
		nNewPos = FindPos( &aEntry, 0, nOldPos-2 );
	}
	else
	{
		if ( nNext < (long) _pEntries->Count() )
			pEntry = (EntryData*) _pEntries->GetObject( nNext );
		else
			pEntry = NULL;

		if ( pEntry && ( pEntry->Compare( &aEntry ) == -1 ) )
		{
			// Der Anker ist groesser als sein Nachfolger, ...
			nNewPos = FindPos( &aEntry, nNext+1, _pEntries->Count()-1 );
		}
		else
		{
			// Wenn wir hier landen, dann ist der Anker groesser als sein
			// Vorgaenger ( oder er hatte keinen ) und kleiner als sein
			// Nachfolger ( oder er hatte keinen ). Damit hat der Anker die
			// richtige Position und braucht nicht umsortiert zu werden.
			nNewPos = nOldPos;
		}
	}

	// Wenn die Positionen gleich sind, dann gibts nichts zu tun!
	if ( nOldPos == nNewPos )
		return;

	ULONG nCount = nNext - nOldPos;

	if ( bLast )
	{
		pAnchor->SetChangedItem( pChangedItem );
		BROADCAST( _pBroadcaster,
				   CntAnchorViewHint( CNT_ACTION_REMOVING_LAST,
											nOldPos, nCount ) );
		pAnchor->SetChangedItem( NULL );
	}

	if ( nOldPos < nNewPos )
	{
		// Da wir immer erst entfernen und dann einfuegen, muss nNewPos
		// zu Beginn dekrementiert werden
		nNewPos -= 1;
		while ( nOldPos < nNext )
		{
			pEntry = (EntryData*)_pEntries->Remove( nOldPos );
			_pEntries->Insert( (void*) pEntry, nNewPos );
			nNext -= 1;
		}
		// Da an der alten Position nCount Eintraege entfernt wurden,
		// verschiebt sich die neue Position entsprechend
		nNewPos = nNewPos - nCount + 1;
	}
	else
	{
		while ( nOldPos < nNext )
		{
			pEntry = (EntryData*)_pEntries->Remove( nOldPos++ );
			_pEntries->Insert( (void*) pEntry, nNewPos++ );
		}
		// Fuer den Broadcast() Aufruf brauchen wir wieder die
		// urspruenglichen Werte
		nOldPos = nOldPos - nCount;
		nNewPos = nNewPos - nCount;
	}

	BROADCAST( _pBroadcaster,
			   CntAnchorViewHint(
			   		CNT_ACTION_REMOVED, nOldPos, nCount,
					pChangedItem->Which() ));
	BROADCAST( _pBroadcaster,
			   CntAnchorViewHint(
			   		CNT_ACTION_INSERTED, nNewPos, nCount ) );
}

//----------------------------------------------------------------------------
void PosEntryFinder::ReSort()
{
	EntryData	*pTemp, *pA, *pB;

	if ( _pEntries->Count() <= 2 )
	{
		if ( _pEntries->Count() == 2 )
		{
			pA = (EntryData*) _pEntries->GetObject( 0 );
			pB = (EntryData*) _pEntries->GetObject( 1 );
			if ( pA->Compare( pB ) > 0 )
			{
				_pEntries->Replace( pB, (ULONG) 0 );
				_pEntries->Replace( pA, (ULONG) 1 );
			}
		}
	}
	else
	{
		// Sorting with HeapSort ()
		ULONG		nI, nJ;
		ULONG		nL = _pEntries->Count() / 2 + 1;
		ULONG		nIR = _pEntries->Count();

		while ( TRUE )
		{
			if ( nL > 1 )
			{
				--nL;
				pTemp = (EntryData*) _pEntries->GetObject( nL - 1 );
			}
			else
			{
				pTemp = (EntryData*) _pEntries->GetObject( nIR - 1 );
				_pEntries->Replace( _pEntries->GetObject( (ULONG) 0 ), nIR - 1 );
				--nIR;
				if ( nIR == 1 )
				{
					_pEntries->Replace( pTemp, (ULONG) 0 );
					break;
				}
			}
			nI = nL;
			nJ = 2*nL;
			while ( nJ <= nIR )
			{
				if ( nJ < nIR )
				{
					pA = (EntryData*) _pEntries->GetObject( nJ - 1 );
					pB = (EntryData*) _pEntries->GetObject( nJ );
					if ( pA->Compare( pB ) < 0 )
						nJ++;
				}
				pA = (EntryData*) _pEntries->GetObject( nJ - 1 );
				if ( pTemp->Compare( pA ) < 0 )
				{
					_pEntries->Replace( _pEntries->GetObject( nJ - 1 ), nI - 1 );
					nI = nJ;
					nJ *= 2;
				}
				else
					nJ = nIR + 1;
			}
			_pEntries->Replace( pTemp, nI - 1 );
		}
#ifdef DBG_UTIL_DV
		pA = (EntryData*) _pEntries->First();
		pB = (EntryData*) _pEntries->Next();
		while ( pB )
		{
			int nCompare = pA->Compare( pB );
			if ( nCompare > 0 )
			{
				String aDummy;
				DBG_ERRORFILE( "Sortierung FALSCH!" );
			}
			pA = pB;
			pB = (EntryData*) _pEntries->Next();
		}
#endif
	}

	if ( _pEntries->Count() )
		BROADCAST( _pBroadcaster,
				   CntAnchorViewHint( CNT_ACTION_MODIFIED,
				   					  0, _pEntries->Count(), WID_SORTING ) );
}

//----------------------------------------------------------------------------
ULONG PosEntryFinder::Expand( CntAnchor *pAnchor, ULONG &rPos, BOOL bRecursive )
{
	ULONG	nCount, nPos, nTotals;
	nCount = pAnchor->SubAnchorCount();
	nPos = 0;
	nTotals = 0;

	while ( nCount )
	{
		CntAnchor *pChild = pAnchor->GetSubAnchor( nPos );
		EntryData *pEntry = new EntryData( pChild, _pBroadcaster );

		--nCount;
		nPos++;
		nTotals++;

		// Die SV Liste fuegt die Eintraege immer VOR der uebergebenen Position ein,
		// deshalb muessen wir rPos zuerst erhoehen !
		rPos++;
		_pEntries->Insert( (void*) pEntry, rPos );

		if ( ( bRecursive || pChild->IsExpanded() ) && pChild->SubAnchorCount() )
		{
			nTotals += Expand( pChild, rPos, bRecursive );
			pChild->SetExpanded( TRUE );
		}
	}
	return nTotals;
}

//----------------------------------------------------------------------------
void PosEntryFinder::Collapse( CntAnchor *pAnchor, ULONG nStartPos,
							   ULONG &rCount, BOOL bRecursive )
{
	short		nDepth;
	ULONG		nPos = nStartPos + 1;
	EntryData  *pEntry = (EntryData*) _pEntries->GetObject( nStartPos );

	nDepth = pEntry->GetDepth();
	rCount = 0;

	pEntry = (EntryData*) _pEntries->GetObject( nPos );

	while ( pEntry && ( pEntry->GetAnchor( nDepth ) == pAnchor ) )
	{
		pEntry->GetAnchor()->SetExpanded( FALSE );
		_pEntries->Remove( nPos );
		delete pEntry;
		rCount++;
		pEntry = (EntryData*) _pEntries->GetObject( nPos );
	}
}

//----------------------------------------------------------------------------
void PosEntryFinder::MoveAnchor( CntAnchor *pAnchor )
{
	BOOL		 bFound = FALSE;
	ULONG		 nPos, nOldPos, nMin, nAnz;
	EntryData	*pData = (EntryData*) _pEntries->First();

	nOldPos = 0;

	while ( pData && !bFound )
	{
		if ( pData->GetAnchor() == pAnchor )
			bFound = TRUE;
		else
		{
			pData = (EntryData*) _pEntries->Next();
			nOldPos++;
		}
	}

	DBG_ASSERT( bFound, "MoveAnchor: Anchor not in List?" );

	if ( bFound )
	{
		pData = (EntryData*) _pEntries->Remove();
		nPos = FindPos( pData, bFound );
		_pEntries->Insert( pData, nPos );
	}

	if ( nOldPos != nPos )
	{
		if ( nOldPos < nPos )
		{
			nMin = nOldPos;
			nAnz = nPos - nOldPos;
		}
		else
		{
			nMin = nPos;
			nAnz = nOldPos - nPos;
		}
		BROADCAST( _pBroadcaster,
				   CntAnchorViewHint( CNT_ACTION_MODIFIED, nMin, nAnz + 1 ) );
	}
}

//----------------------------------------------------------------------------
#if 0
void PosEntryFinder::StartCollecting()
{
	_bCollectData = TRUE;
	_bUseModCount = TRUE;
	_aTimer.Start();
}

//----------------------------------------------------------------------------

void PosEntryFinder::StopCollecting()
{
	if ( ! _bCollectData )
		return;

	if ( IsDirty() )
		CheckForModifications();

	_aTimer.Stop();
	_bCollectData = FALSE;
	_bUseModCount = FALSE;
}

//----------------------------------------------------------------------------

void PosEntryFinder::CheckForModifications()
{
	ULONG	nStart = 0;
	ULONG	nCount = 0;
	BOOL	bInserting;

	if ( _nLast >= _pEntries->Count() )
	{
		DBG_ERRORFILE( "StopCollecting: Ende groesser als Anzahl" );
		_nLast = _pEntries->Count() - 1;
	}

	for ( ULONG i = _nFirst; i<=_nLast; i++ )
	{
		EntryData  *pEntry = (EntryData*) _pEntries->GetObject( i );

		if ( pEntry->_bNew )
		{
			_nModCount--;
			pEntry->_bNew = FALSE;
			if ( nCount && bInserting && ( i == nStart + nCount ) )
				nCount ++;
			else
			{
				if ( nCount )
				{
					// Send Notify
					if ( bInserting )
					{
						BROADCAST( _pBroadcaster,
								   CntAnchorViewHint(
								   		CNT_ACTION_INSERTED, nStart, nCount ) );
					}
					else
					{
						BROADCAST( _pBroadcaster,
								   CntAnchorViewHint(
								   		CNT_ACTION_REMOVED, nStart, nCount ) );
					}
				}
				nStart = i;
				nCount = 1;
				bInserting = TRUE;
			}
		}
		else if ( pEntry->_bDeleted )
		{
			_pEntries->Remove( i );
			delete pEntry;
			_nModCount--;
			_nDeleted--;

			if ( nCount && !bInserting && ( i == nStart ) )
				nCount ++;
			else
			{
				if ( nCount )
				{
					// Send Notify
					if ( bInserting )
					{
						BROADCAST( _pBroadcaster,
								   CntAnchorViewHint(
								   		CNT_ACTION_INSERTED, nStart, nCount ) );
					}
					else
					{
						BROADCAST( _pBroadcaster,
								   CntAnchorViewHint(
								   		CNT_ACTION_REMOVED, nStart, nCount ) );
					}
				}
				nStart = i;
				nCount = 1;
				bInserting = FALSE;
			}

			i--;
			_nLast--;
		}
	}

	if ( nCount )
	{
		// Send Notify
		if ( bInserting )
		{
			BROADCAST( _pBroadcaster,
					   CntAnchorViewHint(
					   		CNT_ACTION_INSERTED, nStart, nCount ) );
		}
		else
		{
			BROADCAST( _pBroadcaster,
					   CntAnchorViewHint(
					   		CNT_ACTION_REMOVED, nStart, nCount ) );
		}
	}


	DBG_ASSERT( ! _nModCount, "StopCollecting: Anzahl der bearbeiteten Elemente falsch!" );

	_nLast = 0;
	_nFirst = ULONG_MAX;
	_nModCount = 0;

	if ( _nDeleted )
		_nDeleted = 0;
}

//----------------------------------------------------------------------------

IMPL_LINK( PosEntryFinder, TimeOut, void*, pTmp )
{
	if ( IsDirty() )
		CheckForModifications();

	_aTimer.SetTimeout( COLLECTING_TIMER_INTERVAL );
	_aTimer.Start();

	return NULL;
}
#endif

//****************************************************************************
void CntAnchor::MakeRootVisible()
{
	if ( !_bIsVisibleRoot )
	{
		_bIsVisibleRoot = TRUE;
		if ( ! _pSearchData )
			_pSearchData = new PosEntryFinder( this );

		_pSearchData->InsertAnchor( this );
	}
}


//----------------------------------------------------------------------------
CntAnchor *CntAnchor::GetAnchor( ULONG nAbsPos ) const
{
	CntAnchor *pAnchor;

	if ( _pSearchData )
		pAnchor = _pSearchData->GetEntryAtPos( nAbsPos );
	else
		pAnchor = GetSubAnchor( nAbsPos );

	DBG_ASSERT( pAnchor, "GetAnchor: Child not found!" );

	return pAnchor;
}

//----------------------------------------------------------------------------
ULONG CntAnchor::AnchorCount() const
{
	if ( _pSearchData )
		return _pSearchData->Count();
	else
		return SubAnchorCount();
}

//----------------------------------------------------------------------------
ULONG CntAnchor::GetAbsPos() const
{
	ULONG		nAbsPos = ANCHOR_NOT_FOUND;
	CntAnchor  *pAbsParent = GetAbsParent( TRUE );

	if ( pAbsParent )
	{
		BOOL		bFound;
		EntryData	aEntry( (CntAnchor*) this, pAbsParent );

		nAbsPos = pAbsParent->_pSearchData->FindPos( &aEntry, bFound );

		DBG_ASSERT( bFound, "GetAbsPos() : Anchor not in List!" );
	}

	return nAbsPos;
}

//----------------------------------------------------------------------------
USHORT CntAnchor::GetDepth( CntAnchor *pRoot ) const
{
	USHORT		 nDepth = 0;
	CntAnchor	*pParent = GetParent();

	while ( pParent && ( pParent != pRoot ) && ( this != pRoot ) )
	{
		pParent = pParent->GetParent();
		nDepth++;
	}

	if ( this != pRoot )
		if ( pRoot->_bIsVisibleRoot )
			nDepth++;

#ifdef DBG_UTIL
	if ( this != pRoot )
		DBG_ASSERT( pParent, "GetDepth: Anchor not child from Root" );
#endif

	return nDepth;
}

//----------------------------------------------------------------------------
CntAnchor * CntAnchor::GetAbsParent( BOOL bIgnoreSelf ) const
{
	CntAnchor *pParent;

	if ( bIgnoreSelf )
		pParent = GetParent();
	else
		pParent = (CntAnchor*) this;

	while ( pParent && pParent->_bIsExpanded && ! pParent->_bMarkedAsRoot )
	{
		pParent = pParent->GetParent();
	}

	if ( pParent && pParent->_bMarkedAsRoot )
	{
		// Wenn noch keine SuchListe angelegt wurde, dann machen wir das jetzt!
		if ( ! pParent->_pSearchData )
			pParent->_pSearchData = new PosEntryFinder( pParent );
		return pParent;
	}
	else
		return NULL;
}

//----------------------------------------------------------------------------
const CntAnchor * CntAnchor::GetSortParent() const
{
	const CntAnchor *pParent = this;

	// We need to know, wether this Anchor is a root anchor or not
	if ( ! pParent->_bCheckedForRoot )
	{
		CntAnchor* pTmp = const_cast< CntAnchor * >( pParent );
		pTmp->_bIsRootAnchor = IsRootAnchor( TRUE );
		pTmp->_bCheckedForRoot = TRUE;
	}

	while ( pParent && pParent->_bIsExpanded &&
			! pParent->_bMarkedAsRoot &&
			! pParent->_bIsRootAnchor )
	{
		pParent = pParent->GetParent();

		// We need to know, wether this Anchor is a root anchor or not
		if ( pParent && ! pParent->_bCheckedForRoot )
		{
			CntAnchor* pTmp = const_cast< CntAnchor * >( pParent );
			pTmp->_bIsRootAnchor = IsRootAnchor( TRUE );
			pTmp->_bCheckedForRoot = TRUE;
		}
	}

	if ( pParent && pParent->_bMarkedAsRoot )
		return pParent;
	else
		return this;
}

//----------------------------------------------------------------------------
CntAnchor * CntAnchor::GetRoot() const
{
	CntAnchor *pParent = (CntAnchor*) this;

	while ( pParent && ! pParent->_bMarkedAsRoot )
	{
		pParent = pParent->GetParent();
	}

	return pParent;
}

//----------------------------------------------------------------------------
void CntAnchor::Expand( BOOL bRecursive, BOOL bNotify )
{
	CntOpenMode eOpenMode = CNT_OPEN_ALL;

	if ((!_bIsDocument
		 || THIS_ITEM_VALUE(CntBoolItem, WID_FLAG_IS_FOLDER))
		&& THIS_ITEM_VALUE(CntBoolItem, WID_FLAG_HAS_FOLDER))
	{
		eOpenMode = CNT_OPEN_FOLDERS;
	}
	else if ( _bIsDocument && THIS_ITEM_VALUE( CntBoolItem, WID_FLAG_HAS_MESSAGES ) )
	{
		eOpenMode = CNT_OPEN_MESSAGES;
	}

	Expand( eOpenMode, bRecursive, bNotify );
}

//----------------------------------------------------------------------------
void CntAnchor::Expand( CntOpenMode eOpenMode, BOOL bRecursive, BOOL bNotify )
{
	// Wenn wir bereits aufgeklappt sind, dann duerfen wir nicht noch einmal
	// aufklappen
	if ( _bIsExpanded )
		return;

	if ( ! GetFolderFirst() && GetParent() )
		SetFolderFirst( GetParent()->GetFolderFirst() );

	// bIsExpanded muss zuerst gesetzt werden, damit GetAbsParent()
	// auch einen Parent findet.
	_bIsExpanded = TRUE;

	// Wenn wir recursiv arbeiten, dann wird nach einem Open nicht mehr
	// alles aufgeklappt !!!
	_bExpanding = !bRecursive;

	_bNotifyExpanded = bNotify;

	if ( Impl_IsExpandOnOpen() &&
		 ( GetItemState( WID_FLAG_EXPANDED, TRUE ) >= SFX_ITEM_DEFAULT ) )
		Put( CntBoolItem( WID_FLAG_EXPANDED, TRUE ), WID_FLAG_EXPANDED );

	CntAnchor  *pAbsParent = GetAbsParent();
	EntryData	aEntry( this, pAbsParent );
	ULONG		nStartPos;

	if ( pAbsParent )
	{
		BOOL bFound = FALSE;
		nStartPos = pAbsParent->_pSearchData->FindPos( &aEntry, bFound );
		DBG_ASSERT( bFound, "CntAnchor::Expand : Anchor not found in List" );
	}

	// Wenn wir Kinder haben, dann werden diese jetzt angezeigt
	if ( SubAnchorCount() )
	{
		if ( pAbsParent )
		{
			ULONG	nLastPos = nStartPos;

			pAbsParent->_pSearchData->Expand( this, nLastPos, bRecursive );
			BROADCAST( pAbsParent,
					   CntAnchorViewHint( CNT_ACTION_INSERTED, nStartPos + 1,
										  nLastPos - nStartPos ) );
		}
	}

	// there is a collision between #62502 and #74344 so we need a hack!
	// an aditional open when threaded is only needed, when we expand a threaded
	// newsgroup and want to see the messages as children
	if ( !_bIsThreaded || ( !_bIsDocument && ( eOpenMode == CNT_OPEN_ALL ) ) )
	{
		// Wir schicken auch noch ein Open hinterher
		_bIsVisible = TRUE;
		Put( CntOpenModeItem( WID_OPEN, eOpenMode ), WID_OPEN );
	}

	// Damit der aufgeklappte Eintrag auch richtig angezeigt wird, muessen wir
	// noch ein modified an den parent schicken
	if ( pAbsParent )
		BROADCAST( pAbsParent, CntAnchorViewHint( CNT_ACTION_MODIFIED,
												  nStartPos, 1,
												  WID_FLAG_EXPANDED ) );
}

//----------------------------------------------------------------------------
void CntAnchor::Collapse( BOOL bRecursive )
{
	CntAnchor *pAbsParent = GetAbsParent();

	_bNotifyExpanded = FALSE;

	if ( pAbsParent )
	{
		if ( pAbsParent != this )
		{
			BOOL		bFound = FALSE;
			ULONG		nStartPos, nCount;
			EntryData	aEntry( this, pAbsParent );

			nStartPos = pAbsParent->_pSearchData->FindPos( &aEntry, bFound );

			DBG_ASSERT( bFound, "CntAnchor::Expand : Anchor not found in List" );

			pAbsParent->_pSearchData->Collapse( this, nStartPos, nCount, bRecursive );

			_bIsExpanded = FALSE;

			if ( nCount )
				BROADCAST( pAbsParent, CntAnchorViewHint( CNT_ACTION_REMOVED,
														  nStartPos + 1,
														  nCount ) );
			BROADCAST( pAbsParent, CntAnchorViewHint( CNT_ACTION_MODIFIED,
													  nStartPos, 1,
													  WID_FLAG_EXPANDED ) );
		}
		else
		{
			_bIsExpanded = FALSE;
			BROADCAST( this, CntAnchorViewHint( CNT_ACTION_REMOVED, 0,
										  		_pSearchData->Count() ) );
			DELETEZ( _pSearchData );
		}
	}

//	if ( _bIsOpen && ( !_bIsThreaded || ( _bShowFolders && _bShowDocuments ) ) )
	if ( _bIsOpen && !_bIsThreaded )
	{
		_bIsOpen = FALSE;
		_bIsVisible = FALSE;
		RemoveSubAnchors( FALSE );
		Put( CntCmpCommandItem( WID_COMPONENT_COMMAND,
								rtl::OUString::createFromAscii( "collapse" ) ),
			 WID_COMPONENT_COMMAND );
		Put( SfxVoidItem( WID_CLOSE ), WID_CLOSE );
	}

	if ( Impl_IsExpandOnOpen() &&
		 ( GetItemState( WID_FLAG_EXPANDED, TRUE ) >= SFX_ITEM_DEFAULT ) )
		Put( CntBoolItem( WID_FLAG_EXPANDED, FALSE ), WID_FLAG_EXPANDED );
}

//----------------------------------------------------------------------------
void CntAnchor::ExpandChildren( CntOpenMode	eOpenMode )
{
	if ( ! _bExpanding || ! Impl_IsExpandOnOpen() )
		return;

	ULONG nCount = SubAnchorCount();

	for ( ULONG i=0; i<nCount; i++ )
	{
		CntAnchor *pChild = GetSubAnchor( i );

		if ( ( GetItemState( WID_FLAG_EXPANDED, TRUE ) >= SFX_ITEM_DEFAULT ) &&
			 ( ITEMSET_VALUE( pChild, CntBoolItem, WID_FLAG_EXPANDED ) ) &&
			 ( ITEMSET_VALUE( pChild, CntBoolItem, WID_FLAG_IS_FOLDER ) ) )
		{
			BOOL bNoRecursion = TRUE;
			CntNode *pChildNode = pChild->GetNode();
			CntAnchor *pParent = this;

			while ( pParent && bNoRecursion )
			{
				if ( pParent->GetNode() == pChildNode )
					bNoRecursion = FALSE;
				pParent = pParent->GetParent();
			}

			if ( bNoRecursion )
			{
				pChild->RegisterErrorHandler( LINK( pChild, CntAnchor, HandleError ) );
				pChild->Expand( eOpenMode );
				pChild->DeregisterErrorHandler();
			}
		}
	}

	_bExpanding = FALSE;
}

//----------------------------------------------------------------------------
BOOL CntAnchor::FindNext( CntAnchor **pResult, ULONG nStartPos, BOOL bUnRead ) const
{
	BOOL		bFound = FALSE;
	CntAnchor  *pAnchor = GetSubAnchor( nStartPos++ );

	while ( !bFound && pAnchor )
	{
		if ( pAnchor->GetNode() )
		{
			if ( bUnRead )
				bFound = ! ((const CntBoolItem &) pAnchor->Get( WID_IS_READ )).GetValue();
			else
				bFound = TRUE;
			if ( bFound )
				*pResult = pAnchor;
		}
		if ( !bFound && pAnchor->SubAnchorCount() )
			bFound = pAnchor->FindNext( pResult, 0, bUnRead );

		if ( !bFound )
			pAnchor = GetSubAnchor( nStartPos++ );
	}

	return bFound;
}

//----------------------------------------------------------------------------
BOOL CntAnchor::FindPrev( CntAnchor **pResult, ULONG nStartPos, BOOL bUnRead ) const
{
	BOOL		bFound = FALSE;
	CntAnchor  *pAnchor = GetSubAnchor( nStartPos-- );

	while ( !bFound && pAnchor )
	{
		if ( pAnchor->SubAnchorCount() )
			bFound = pAnchor->FindPrev( pResult, pAnchor->SubAnchorCount() - 1, bUnRead );

		if ( !bFound && pAnchor->GetNode() )
		{
			if ( bUnRead )
				bFound = ! ((const CntBoolItem &) pAnchor->Get( WID_IS_READ )).GetValue();
			else
				bFound = TRUE;
			if ( bFound )
				*pResult = pAnchor;
		}

		if ( !bFound )
			pAnchor = GetSubAnchor( nStartPos-- );
	}

	if ( !bFound && !_bMarkedAsRoot && GetNode() )
	{
		if ( bUnRead )
			bFound = ! ((const CntBoolItem &) Get( WID_IS_READ )).GetValue();
		else
			bFound = TRUE;
		if ( bFound )
			*pResult = (CntAnchor*) this;
	}

	return bFound;
}

//----------------------------------------------------------------------------
CntAnchor* CntAnchor::GetNextAnchor( BOOL bUnRead, BOOL bMakeVisible,
									 BOOL bForward, BOOL bIgnoreSelf )
{
	BOOL		bFound = FALSE;
	CntAnchor  *pAnchor = NULL;
	CntAnchor  *pLast, *pParent;

	// Wenn wir einen ungelesen Anker suchen, dann pruefen wir zuerst,
	// ob wir selbst ungelesen sind (wenn nicht bIgnoreSelf gesetzt ist)
	if ( bUnRead && !bIgnoreSelf && GetNode() )
	{
		bFound = ! ((const CntBoolItem &) Get( WID_IS_READ )).GetValue();
		if ( bFound )
			pAnchor = this;
	}

	if ( !bFound && bForward && SubAnchorCount() )
		bFound = FindNext( &pAnchor, 0, bUnRead );

	if ( !bFound && !_bMarkedAsRoot )
	{
		pLast = this;
		pParent = GetParent();
		while ( !bFound && pParent )
		{
			ULONG nPos = pParent->FindPos( pLast, bFound );
			DBG_ASSERT( bFound, "GetNextAnchor(): Anchor not in List?" );

			if ( bForward )
				bFound = pParent->FindNext( &pAnchor, ++nPos, bUnRead );
			else
				bFound = pParent->FindPrev( &pAnchor, --nPos, bUnRead );

			if ( !pParent->_bMarkedAsRoot )
			{
				pLast = pParent;
				pParent = pParent->GetParent();
			}
			else
				pParent = NULL;
		}
	}

	if ( bMakeVisible && pAnchor && !pAnchor->_bMarkedAsRoot )
	{
		pParent = pAnchor->GetParent();
		while ( pParent && !pParent->IsExpanded() )
		{
			pParent->Expand();
			if ( !pParent->_bMarkedAsRoot )
				pParent = pParent->GetParent();
			else
				pParent = NULL;
		}
	}

	return pAnchor;
}

//----------------------------------------------------------------------------
void CntAnchor::ReSort()
{
	CntAnchor	*pTemp, *pA, *pB;

	if ( SubAnchorCount() <= 2 )
	{
		if ( SubAnchorCount() == 2 )
		{
			pA = GetSubAnchor( 0 );
			pB = GetSubAnchor( 1 );
			if ( pA->Compare( pB, TRUE ) > 0 )
			{
				_pSubAnchors->Replace( pB, (ULONG) 0 );
				_pSubAnchors->Replace( pA, (ULONG) 1 );
			}
		}
	}
	else
	{
		// Sorting with HeapSort ()
		ULONG		nI, nJ;
		ULONG		nL = SubAnchorCount() / 2 + 1;
		ULONG		nIR = SubAnchorCount();

		while ( TRUE )
		{
			if ( nL > 1 )
			{
				--nL;
				pTemp = GetSubAnchor( nL - 1 );
			}
			else
			{
				pTemp = GetSubAnchor( nIR - 1 );
				_pSubAnchors->Replace( GetSubAnchor( (ULONG) 0 ), nIR - 1 );
				--nIR;
				if ( nIR == 1 )
				{
					_pSubAnchors->Replace( pTemp, (ULONG) 0 );
					break;
				}
			}
			nI = nL;
			nJ = 2*nL;
			while ( nJ <= nIR )
			{
				if ( nJ < nIR )
				{
					pA = GetSubAnchor( nJ - 1 );
					pB = GetSubAnchor( nJ );
					if ( pA->Compare( pB, TRUE ) < 0 )
						nJ++;
				}
				pA = GetSubAnchor( nJ - 1 );
				if ( pTemp->Compare( pA, TRUE ) < 0 )
				{
					_pSubAnchors->Replace( GetSubAnchor( nJ - 1 ), nI - 1 );
					nI = nJ;
					nJ *= 2;
				}
				else
					nJ = nIR + 1;
			}
			_pSubAnchors->Replace( pTemp, nI - 1 );
		}
	}

	CheckChildList();

	if ( _pSubAnchors )
	{
		CntAnchor *pChild = (CntAnchor*) _pSubAnchors->First();

		while ( pChild )
		{
			if ( pChild->SubAnchorCount() )
				pChild->ReSort();
			pChild = (CntAnchor*) _pSubAnchors->Next();
		}
	}
}

//---------------------------------------------------------------------------
void CntAnchor::RecalcDate( CntAnchor *pAnchor )
{
	int nCompare;

	const SfxPoolItem &rMyDate = Get( WID_DATE_CREATED );
	const SfxPoolItem &rNewDate = pAnchor->Get( WID_DATE_CREATED );

	if ( 0 != ( nCompare = rNewDate.Compare( rMyDate ) ) )
	{
		BOOL		bFound = FALSE;
		CntAnchor  *pTParent = GetTParent();
		CntAnchor  *pParent = GetParent();
		CntAnchor  *pAbsParent = GetAbsParent();

		if ( pAbsParent )
		{
			pAbsParent->_pSearchData->RemoveAnchor( this );
		}

		if ( pTParent )
		{
			const CntSortingItem &rItem = (const CntSortingItem &) pTParent->Get( WID_SORTING );
			BOOL	bAscending;

			bFound = rItem.Contains( WID_DATE_CREATED, bAscending );

			if ( bFound )
			{
				if ( bAscending && ( nCompare > 0 ) )
					Put( rNewDate, WID_DATE_CREATED );
				else if ( ! bAscending && ( nCompare < 0 )  )
					Put( rNewDate, WID_DATE_CREATED );
			}
		}

		if ( !bFound && ( nCompare > 0 ) )
			Put( rNewDate, WID_DATE_CREATED );

		if ( pAbsParent )
		{
			pAbsParent->_pSearchData->InsertAnchor( this );
		}
	}
}

//---------------------------------------------------------------------------
void CntAnchor::CheckAnchor( const SfxPoolItem& rChangedItem )
{
	USHORT nWhich = rChangedItem.Which();

	if ( ( nWhich == WID_SORTING ) || ( nWhich == WID_REFERED_URL ) )
		return;

	if ( _bIsInserted )
	{
		CntAnchor *pParent = GetTParent();
		CntAnchorRef xAbsParent = GetAbsParent( TRUE );

		if ( pParent )
		{
			const CntSortingItem &rItem = (const CntSortingItem &) pParent->Get( WID_SORTING );
			USHORT               nSortitems = rItem.Count();

			if ( ( ( WID_FLAG_IS_FOLDER == nWhich ) &&
				   ( pParent->GetFolderFirst() ) ) ||
				 ( rItem.Contains( rChangedItem.Which() ) ) )
			{
				BOOL	 bFound;
				BOOL	 bLast;
				ULONG	 nPos;
				List	*pSubAnchors = GetParent()->_pSubAnchors;

				_pChangedItem = (SfxPoolItem*) &rChangedItem;
				nPos = GetParent()->FindPos( this, bFound );
				bLast =  (nPos == GetParent()->SubAnchorCount() - 1);
				_pChangedItem = NULL;

				if ( bFound )
				{
					pSubAnchors->Remove( nPos );
					nPos = GetParent()->FindPos( this, bFound );
					pSubAnchors->Insert( this, nPos );
				}

				if ( xAbsParent.Is() )
					xAbsParent->_pSearchData->ChangeAnchorPos( this,
															   (SfxPoolItem*) &rChangedItem,
															   bLast );
			}
		}

	   	if ( xAbsParent.Is() )
	   	{
			ULONG nAbsPos = GetAbsPos();
			BROADCAST( xAbsParent, CntAnchorViewHint( CNT_ACTION_MODIFIED,
													  nAbsPos, 1,
													  rChangedItem.Which() ) );
		}

		GetParent()->CheckChildList();
	}
}

//---------------------------------------------------------------------------
void CntAnchor::MoveAnchor( CntAnchor *pAnchor )
{
	if ( !_pSubAnchors || !pAnchor->_bIsInserted )
		return;

	BOOL		 bFound;
	ULONG		 nPos;
	CntAnchor	*pTemp = (CntAnchor*) _pSubAnchors->Remove( (void*) pAnchor );
	CntAnchor	*pAbsParent = GetAbsParent();

	DBG_ASSERT( pTemp == pAnchor, "MoveAnchor: Anchor not in List?" );

	nPos = FindPos( pAnchor, bFound );
	_pSubAnchors->Insert( pAnchor, nPos );

	if ( pAbsParent && pAbsParent->_pSearchData )
		pAbsParent->_pSearchData->MoveAnchor( pAnchor );
}

//----------------------------------------------------------------------------
IMPL_LINK( CntAnchor, HandleError, CntErrorData*, pErr )
{
	ErrCode nErr = pErr->_nError;

	if ( GetItemState( WID_FLAG_EXPANDED, TRUE ) >= SFX_ITEM_DEFAULT )
		Put( CntBoolItem( WID_FLAG_EXPANDED, FALSE ), WID_FLAG_EXPANDED );

	_bIsExpanded = FALSE;

	return ERRCODE_BUTTON_OK;
}

//---------------------------------------------------------------------------
#ifdef DBG_UTIL
void CntAnchor::CheckChildList()
{
#ifdef CHECK_ANCHORS
	if ( _pSubAnchors )
	{
		CntAnchor *pA, *pB;
		pA = (CntAnchor*) _pSubAnchors->First();
		pB = (CntAnchor*) _pSubAnchors->Next();

		if ( pA && ( pA->GetParent() != this ) )
			DBG_ERRORFILE( "Falscher Parent!" );

		while ( pB )
		{
			if ( pA == pB )
				DBG_ERRORFILE( "Anchor zweimal in der Liste!" );
			if ( pB->GetParent() != this )
				DBG_ERRORFILE( "Falscher Parent!" );
			if ( pA->GetTParent() != pB->GetTParent() )
				DBG_ERRORFILE( "Unterschiedliche Threader!" );

			if ( pA != pB )
			{
				int nCompare = pA->Compare( pB, TRUE );
				if ( nCompare >= 0 )
					DBG_ERRORFILE( "Sortierung FALSCH!" );
			}
			pA = pB;
			pB = (CntAnchor*) _pSubAnchors->Next();
		}
	}
#endif
}
#endif

//---------------------------------------------------------------------------

BOOL Impl_IsExpandOnOpen()
{
	BOOL bIsExpandOnOpen = TRUE;
#if 0
	CntIniManager *pIniMan = CntRootNodeMgr::GetIniManager();

	if (pIniMan)
	{
		String sIniValue( pIniMan->getEntry( CNT_KEY_AUTOOPEN ) );
		if ( sIniValue.Len() )
		{
			USHORT nVal = sIniValue.ToInt32();
			if ( nVal )
				bIsExpandOnOpen = TRUE;
			else
				bIsExpandOnOpen = FALSE;
		}
	}
#endif
	return bIsExpandOnOpen;
}



