/*************************************************************************
 *
 *  $RCSfile: continfo.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONTINFO_HXX
#define _CONTINFO_HXX

#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SFXLSTNER_HXX
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXNRANGES_HXX
#include <svtools/nranges.hxx>
#endif
#ifndef _CNTAPI_HXX
#include "cntapi.hxx"
#endif

#ifndef _UCBHELPER_MACROS_HXX
#include <ucbhelper/macros.hxx>
#endif

namespace chaos {

struct CntItemMapEntry;
class ChaosContentProvider;

//============================================================================
//
// class ChaosPropertySetInfo.
//
//============================================================================

class ChaosPropertySetInfo :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::beans::XPropertySetInfo,
				public SfxListener
{
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
	com::sun::star::uno::Sequence< com::sun::star::beans::Property >* m_pChaosProps;
	com::sun::star::uno::Sequence< com::sun::star::beans::Property >* m_pUcbProps;
	CntAnchorRef			m_xAnchor;
	SfxUShortRanges			m_aRanges;
	vos::OMutex				m_aMutex;
	ChaosContentProvider*	m_pProvider;
	sal_Bool				m_bHasViewData : 1;

private:
	sal_Bool isHandleValid( sal_uInt16 nHandle ) const;
	sal_Bool isEntryValid ( const CntItemMapEntry* pEntry, sal_Bool bCheckHandle ) const;
	const com::sun::star::uno::Sequence< com::sun::star::beans::Property >& getChaosProperties();
	const com::sun::star::uno::Sequence< com::sun::star::beans::Property >& getUcbProperties();
    sal_Bool queryProperty( const rtl::OUString& rName, com::sun::star::beans::Property& rProp );

public:
	ChaosPropertySetInfo(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			ChaosContentProvider* pProvider,
		    CntAnchor* pAnchor );
	virtual ~ChaosPropertySetInfo();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

	// XPropertySetInfo
    virtual com::sun::star::uno::Sequence< com::sun::star::beans::Property > SAL_CALL getProperties()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::beans::Property SAL_CALL getPropertyByName( const rtl::OUString& aName )
		throw( com::sun::star::beans::UnknownPropertyException, com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL hasPropertyByName( const rtl::OUString& Name )
		throw( com::sun::star::uno::RuntimeException );

	// SfxListener
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// Own methods.
	const SfxUShortRanges& getRanges() const { return m_aRanges; }
	void resetUcbPropertyInfo()   { DELETEZ( m_pUcbProps ); }
	void resetChaosPropertyInfo() { DELETEZ( m_pChaosProps ); }
};

//============================================================================
//
// class ChaosCommandInfo.
//
//============================================================================

class ChaosCommandInfo :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::ucb::XCommandInfo,
				public SfxListener
{
	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > m_xSMgr;
	com::sun::star::uno::Sequence< com::sun::star::ucb::CommandInfo >* m_pChaosCommands;
	com::sun::star::uno::Sequence< com::sun::star::ucb::CommandInfo >* m_pUcbCommands;
	CntAnchorRef	        m_xAnchor;
	SfxUShortRanges	        m_aRanges;
	vos::OMutex				m_aMutex;
	sal_Bool				m_bHasViewData : 1;

private:
	sal_Bool isHandleValid( sal_uInt16 nHandle ) const;
	sal_Bool isEntryValid( const CntItemMapEntry* pEntry, sal_Bool bCheckHandle ) const;
	const com::sun::star::uno::Sequence< com::sun::star::ucb::CommandInfo >& getChaosCommands();
	const com::sun::star::uno::Sequence< com::sun::star::ucb::CommandInfo >& getUcbCommands();
    sal_Bool queryCommand( const rtl::OUString& rName, com::sun::star::ucb::CommandInfo& rCommand );
    sal_Bool queryCommand( sal_Int32 nHandle, com::sun::star::ucb::CommandInfo& rCommand );

public:
	ChaosCommandInfo(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
			 CntAnchor* pAnchor );
	virtual ~ChaosCommandInfo();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

	// XCommandInfo
    virtual com::sun::star::uno::Sequence< com::sun::star::ucb::CommandInfo > SAL_CALL getCommands()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::ucb::CommandInfo SAL_CALL getCommandInfoByName( const rtl::OUString& Name )
		throw( com::sun::star::ucb::UnsupportedCommandException, com::sun::star::uno::RuntimeException );
    virtual com::sun::star::ucb::CommandInfo SAL_CALL getCommandInfoByHandle( sal_Int32 Handle )
		throw( com::sun::star::ucb::UnsupportedCommandException, com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL hasCommandByName( const rtl::OUString& Name )
		throw( com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL hasCommandByHandle( sal_Int32 Handle )
		throw( com::sun::star::uno::RuntimeException );

	// SfxListener
	virtual void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// Own methods.
	const SfxUShortRanges& getRanges() const { return m_aRanges; }
	void resetChaosCommandInfo() { DELETEZ( m_pChaosCommands ); }
};

}

#endif /* !_CONTINFO_HXX */
