/*************************************************************************
 *
 *  $RCSfile: cntiahdl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONAPPROVE_HPP_
#include <com/sun/star/task/XInteractionApprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONDISAPPROVE_HPP_
#include <com/sun/star/task/XInteractionDisapprove.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XINTERACTIONRETRY_HPP_
#include <com/sun/star/task/XInteractionRetry.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_AUTHENTICATIONREQUEST_HPP_
#include <com/sun/star/ucb/AuthenticationRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_HANDLECOOKIESREQUEST_HPP_
#include <com/sun/star/ucb/HandleCookiesRequest.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEBADTRANSFERURLEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveBadTransferURLException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVECHAOSEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveCHAOSException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVEIOEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveIOException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKConnectEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkConnectException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKOFFLINEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkOffLineException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKREADEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkReadException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKRESOLVENAMEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkResolveNameException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_INTERACTIVENETWORKWRITEEXCEPTION_HPP_
#include <com/sun/star/ucb/InteractiveNetworkWriteException.hpp>
#endif
#ifndef _ERRCODE_HXX
#include <tools/errcode.hxx>
#endif
#ifndef _EINF_HXX
#include <tools/errinf.hxx>
#endif

#ifndef _CNTBASE_HXX
#include <cntbase.hxx>
#endif
#ifndef CHAOS_CNTIAHDL_HXX
#include <cntiahdl.hxx>
#endif
#ifndef _CNTIDS_HRC
#include <cntids.hrc>
#endif

using namespace chaos;
using namespace com::sun::star::task;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;

//============================================================================
//
//  class CntInteractionHandler
//
//============================================================================

// virtual
Any SAL_CALL CntInteractionHandler::queryInterface(const Type & rType)
	throw (RuntimeException)
{
	Any aRet
		= cppu::queryInterface(rType,
							   static_cast< XInteractionHandler * >(this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL
CntInteractionHandler::handle(const Reference< XInteractionRequest > &
							      rRequest)
	throw (RuntimeException)
{
	if (!rRequest.is())
		return;

	Any aTheRequest = rRequest->getRequest();
	Sequence< Reference< XInteractionContinuation > > aContinuations
		= rRequest->getContinuations();

	AuthenticationRequest aAuthenticationRequest;
	if (aTheRequest >>= aAuthenticationRequest)
		return; //@@@

	HandleCookiesRequest aCookiesRequest;
	if (aTheRequest >>= aCookiesRequest)
		return; //@@@

	sal_uInt32 nErrorID;

	InteractiveIOException aIOException;
	InteractiveNetworkException aNetworkException;
	InteractiveCHAOSException aCHAOSException;
	InteractiveBadTransferURLException aTransferException;
	if (aTheRequest >>= aIOException)
	{
		static const sal_uInt32 aID[IOErrorCode_WRONG_VERSION + 1]
			= { ERRCODE_IO_ABORT, // ABORT
				ERRCODE_IO_ACCESSDENIED, // ACCESS_DENIED
				ERRCODE_IO_ALREADYEXISTS, // ALREADY_EXISTING
				ERRCODE_IO_BADCRC, // BAD_CRC
				ERRCODE_IO_CANTCREATE, // CANT_CREATE
				ERRCODE_IO_CANTREAD, // CANT_READ
				ERRCODE_IO_CANTSEEK, // CANT_SEEK
				ERRCODE_IO_CANTTELL, // CANT_TELL
				ERRCODE_IO_CANTWRITE, // CANT_WRITE
				ERRCODE_IO_CURRENTDIR, // CURRENT_DIRECTORY
				ERRCODE_IO_DEVICENOTREADY, // DEVICE_NOT_READY
				ERRCODE_IO_NOTSAMEDEVICE, // DIFFERENT_DEVICES
				ERRCODE_IO_GENERAL, // GENERAL
				ERRCODE_IO_INVALIDACCESS, // INVALID_ACCESS
				ERRCODE_IO_INVALIDCHAR, // INVALID_CHARACTER
				ERRCODE_IO_INVALIDDEVICE, // INVALID_DEVICE
				ERRCODE_IO_INVALIDLENGTH, // INVALID_LENGTH
				ERRCODE_IO_INVALIDPARAMETER, // INVALID_PARAMETER
				ERRCODE_IO_ISWILDCARD, // IS_WILDCARD
				ERRCODE_IO_LOCKVIOLATION, // LOCKING_VIOLATION
				ERRCODE_IO_MISPLACEDCHAR, // MISPLACED_CHARACTER
				ERRCODE_IO_NAMETOOLONG, // NAME_TOO_LONG
				ERRCODE_IO_NOTEXISTS, // NOT_EXISTING
				ERRCODE_IO_NOTEXISTSPATH, // NOT_EXISTING_PATH
				ERRCODE_IO_NOTSUPPORTED, // NOT_SUPPORTED
				ERRCODE_IO_NOTADIRECTORY, // NO_DIRECTORY
				ERRCODE_IO_NOTAFILE, // NO_FILE
				ERRCODE_IO_OUTOFSPACE, // OUT_OF_DISK_SPACE
				ERRCODE_IO_TOOMANYOPENFILES, // OUT_OF_FILE_HANDLES
				ERRCODE_IO_OUTOFMEMORY, // OUT_OF_MEMORY
				ERRCODE_IO_PENDING, // PENDING
				ERRCODE_IO_RECURSIVE, // RECURSIVE
				ERRCODE_IO_UNKNOWN, // UNKNOWN
				ERRCODE_IO_WRITEPROTECTED, // WRITE_PROTECTED
				ERRCODE_IO_WRONGFORMAT, // WRONG_FORMAT
				ERRCODE_IO_WRONGVERSION }; // WRONG_VERSION
		nErrorID = aID[aIOException.Code];
	}
	else if (aTheRequest >>= aNetworkException)
	{
		InteractiveNetworkOffLineException aOffLineException;
		InteractiveNetworkResolveNameException aResolveNameException;
		InteractiveNetworkConnectException aConnectException;
		InteractiveNetworkReadException aReadException;
		InteractiveNetworkWriteException aWriteException;
		nErrorID = (aTheRequest >>= aOffLineException) ?
			           ERRCODE_INET_OFFLINE :
			       (aTheRequest >>= aResolveNameException) ?
			           *new StringErrorInfo(ERRCODE_INET_NAME_RESOLVE,
											aResolveNameException.Server) :
			       (aTheRequest >>= aConnectException) ?
			           *new StringErrorInfo(ERRCODE_INET_CONNECT,
											aConnectException.Server) :
			       (aTheRequest >>= aReadException) ?
			           *new StringErrorInfo(ERRCODE_INET_READ,
											aReadException.Diagnostic) :
			       (aTheRequest >>= aWriteException) ?
			           *new StringErrorInfo(ERRCODE_INET_WRITE,
											aWriteException.Diagnostic) :
			           ERRCODE_INET_GENERAL;
	}
	else if (aTheRequest >>= aCHAOSException)
		nErrorID
			= aCHAOSException.Arguments.getLength() >= 2 ?
			      *new TwoStringErrorInfo(aCHAOSException.ID,
										  aCHAOSException.Arguments[0],
										  aCHAOSException.Arguments[1]) :
			  aCHAOSException.Arguments.getLength() == 1 ?
			      *new StringErrorInfo(aCHAOSException.ID,
									   aCHAOSException.Arguments[0]) :
				  aCHAOSException.ID;
	else if (aTheRequest >>= aTransferException)
		nErrorID = ERRCODE_CHAOS_TRANSFER_URL_NOT_SUPPORTED;
	else
	{
		DBG_ERROR("CntInteractionHandler::handle(): Unknown request");
		return;
	}

	CntErrorData aData(nErrorID, 0, 0, 0, 0);
	switch (m_rHandler.Call(&aData))
	{
		case ERRCODE_BUTTON_OK:
		case ERRCODE_BUTTON_YES:
			{for (sal_Int32 i = 0; i < aContinuations.getLength(); ++i)
			{
				Reference< XInteractionApprove > xApprove(aContinuations[i],
														  UNO_QUERY);
				if (xApprove.is())
				{
					xApprove->select();
					break;
				}
			}}
			break;

		case ERRCODE_BUTTON_CANCEL:
			{for (sal_Int32 i = 0; i < aContinuations.getLength(); ++i)
			{
				Reference< XInteractionAbort > xAbort(aContinuations[i],
													  UNO_QUERY);
				if (xAbort.is())
				{
					xAbort->select();
					break;
				}
			}}
			break;

		case ERRCODE_BUTTON_RETRY:
			{for (sal_Int32 i = 0; i < aContinuations.getLength(); ++i)
			{
				Reference< XInteractionRetry > xRetry(aContinuations[i],
													  UNO_QUERY);
				if (xRetry.is())
				{
					xRetry->select();
					break;
				}
			}}
			break;

		case ERRCODE_BUTTON_NO:
			{for (sal_Int32 i = 0; i < aContinuations.getLength(); ++i)
			{
				Reference< XInteractionDisapprove >
					xDisapprove(aContinuations[i], UNO_QUERY);
				if (xDisapprove.is())
				{
					xDisapprove->select();
					break;
				}
			}}
			break;
	}
}

