/*************************************************************************
 *
 *  $RCSfile: prot.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/29 13:52:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_INTERLOCK_H_
#include <osl/interlck.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_UNLOAD_H_
#include <rtl/unload.h>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _TYPELIB_TYPEDESCRIPTION_H_
#include <typelib/typedescription.h>
#endif
#ifndef _UNO_DISPATCHER_H_
#include <uno/dispatcher.h>
#endif
#ifndef _UNO_ENVIRONMENT_H_
#include <uno/environment.h>
#endif
#ifndef _UNO_SEQUENCE2_H_
#include <uno/sequence2.h>
#endif
#ifndef _UNO_MAPPING_H_
#include <uno/mapping.h>
#endif
#ifndef _UNO_LBNAMES_H_
#include <uno/lbnames.h>
#endif


using namespace ::rtl;
using namespace ::osl;

namespace prot_uno
{

//==================================================================================================
static rtl_StandardModuleCount g_moduleCount = MODULE_COUNT_INIT;

enum protmode { protmode_none, protmode_stdout, protmode_stderr, protmode_trace, protmode_file };

//--------------------------------------------------------------------------------------------------
static inline typelib_TypeDescriptionReference * & union_getSetType(
	void * pUnion, typelib_TypeDescription * pTD ) SAL_THROW( () )
{
	sal_Int64 * pDiscr = ((typelib_UnionTypeDescription *)pTD)->pDiscriminants;
	sal_Int64 nDiscr   = *(sal_Int64 *)pUnion;
	for ( sal_Int32 nPos = ((typelib_UnionTypeDescription *)pTD)->nMembers; nPos--; )
	{
		if (pDiscr[nPos] == nDiscr)
			return ((typelib_UnionTypeDescription *)pTD)->ppTypeRefs[nPos];
	}
	// default
	return ((typelib_UnionTypeDescription *)pTD)->pDefaultTypeRef;
}
//--------------------------------------------------------------------------------------------------
static OUString val2str( void * pVal, typelib_TypeDescriptionReference * pTypeRef ) SAL_THROW( () )
{
	OSL_ASSERT( pVal );
	if (pTypeRef->eTypeClass == typelib_TypeClass_VOID)
		return OUString( RTL_CONSTASCII_USTRINGPARAM("void") );
	
	OUStringBuffer buf( 64 );
	buf.append( (sal_Unicode)'(' );
	buf.append( pTypeRef->pTypeName );
	buf.append( (sal_Unicode)')' );
	
	switch (pTypeRef->eTypeClass)
	{
	case typelib_TypeClass_INTERFACE:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( (sal_Int64)*(void **)pVal, 16 );
		break;
	case typelib_TypeClass_UNION:
	{
		typelib_TypeDescription * pTypeDescr = 0;
		TYPELIB_DANGER_GET( &pTypeDescr, pTypeRef );
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("{ ") );
		buf.append( val2str( (char *)pVal + ((typelib_UnionTypeDescription *)pTypeDescr)->nValueOffset,
							 union_getSetType( pVal, pTypeDescr ) ) );
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" }") );
		TYPELIB_DANGER_RELEASE( pTypeDescr );
		break;
	}
	case typelib_TypeClass_STRUCT:
	case typelib_TypeClass_EXCEPTION:
	{
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("{ ") );
		typelib_TypeDescription * pTypeDescr = 0;
		TYPELIB_DANGER_GET( &pTypeDescr, pTypeRef );
		OSL_ASSERT( pTypeDescr );
		
		typelib_CompoundTypeDescription * pCompType = (typelib_CompoundTypeDescription *)pTypeDescr;
		sal_Int32 nDescr = pCompType->nMembers;
		
		if (pCompType->pBaseTypeDescription)
		{
			buf.append( val2str( pVal, ((typelib_TypeDescription *)pCompType->pBaseTypeDescription)->pWeakRef ) );
			if (nDescr)
				buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(", ") );
		}
		
		typelib_TypeDescriptionReference ** ppTypeRefs = pCompType->ppTypeRefs;
		sal_Int32 * pMemberOffsets = pCompType->pMemberOffsets;
		rtl_uString ** ppMemberNames = pCompType->ppMemberNames;
		
		for ( sal_Int32 nPos = 0; nPos < nDescr; ++nPos )
		{
			buf.append( ppMemberNames[nPos] );
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" = ") );
			typelib_TypeDescription * pMemberType = 0;
			TYPELIB_DANGER_GET( &pMemberType, ppTypeRefs[nPos] );
			buf.append( val2str( (char *)pVal + pMemberOffsets[nPos], pMemberType->pWeakRef ) );
			TYPELIB_DANGER_RELEASE( pMemberType );
			if (nPos < (nDescr -1))
				buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(", ") );
		}
		
		TYPELIB_DANGER_RELEASE( pTypeDescr );
		
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" }") );
		break;
	}
	case typelib_TypeClass_SEQUENCE:
	{
		typelib_TypeDescription * pTypeDescr = 0;
		TYPELIB_DANGER_GET( &pTypeDescr, pTypeRef );
		
		uno_Sequence * pSequence = *(uno_Sequence **)pVal;
		typelib_TypeDescription * pElementTypeDescr = 0;
		TYPELIB_DANGER_GET( &pElementTypeDescr, ((typelib_IndirectTypeDescription *)pTypeDescr)->pType );
		
		sal_Int32 nElementSize = pElementTypeDescr->nSize;
		sal_Int32 nElements	   = pSequence->nElements;
		
		if (nElements)
		{
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("{ ") );
			char * pElements = pSequence->elements;
			for ( sal_Int32 nPos = 0; nPos < nElements; ++nPos )
			{
				buf.append( val2str( pElements + (nElementSize * nPos), pElementTypeDescr->pWeakRef ) );
				if (nPos < (nElements -1))
					buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(", ") );
			}
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" }") );
		}
		else
		{
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("{}") );
		}
		TYPELIB_DANGER_RELEASE( pElementTypeDescr );
		TYPELIB_DANGER_RELEASE( pTypeDescr );
		break;
	}
	case typelib_TypeClass_ANY:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("{ ") );
		buf.append( val2str( ((uno_Any *)pVal)->pData,
							 ((uno_Any *)pVal)->pType ) );
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM(" }") );
		break;
	case typelib_TypeClass_TYPE:
		buf.append( (*(typelib_TypeDescriptionReference **)pVal)->pTypeName );
		break;
	case typelib_TypeClass_STRING:
		buf.append( (sal_Unicode)'\"' );
		buf.append( *(rtl_uString **)pVal );
		buf.append( (sal_Unicode)'\"' );
		break;
	case typelib_TypeClass_ENUM:
	{
		typelib_TypeDescription * pTypeDescr = 0;
		TYPELIB_DANGER_GET( &pTypeDescr, pTypeRef );
		
		sal_Int32 * pValues = ((typelib_EnumTypeDescription *)pTypeDescr)->pEnumValues;
		sal_Int32 nPos = ((typelib_EnumTypeDescription *)pTypeDescr)->nEnumValues;
		while (nPos--)
		{
			if (pValues[nPos] == *(int *)pVal)
				break;
		}
		if (nPos >= 0)
			buf.append( ((typelib_EnumTypeDescription *)pTypeDescr)->ppEnumNames[nPos] );
		else
			buf.append( (sal_Unicode)'?' );
		
		TYPELIB_DANGER_RELEASE( pTypeDescr );
		break;
	}
	case typelib_TypeClass_BOOLEAN:
		if (*(sal_Bool *)pVal)
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("true") );
		else
			buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("false") );
		break;
	case typelib_TypeClass_CHAR:
		buf.append( (sal_Unicode)'\'' );
		buf.append( *(sal_Unicode *)pVal );
		buf.append( (sal_Unicode)'\'' );
		break;
	case typelib_TypeClass_FLOAT:
		buf.append( *(float *)pVal );
		break;
	case typelib_TypeClass_DOUBLE:
		buf.append( *(double *)pVal );
		break;
	case typelib_TypeClass_BYTE:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( (sal_Int32)*(sal_Int8 *)pVal, 16 );
		break;
	case typelib_TypeClass_SHORT:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( (sal_Int32)*(sal_Int16 *)pVal, 16 );
		break;
	case typelib_TypeClass_UNSIGNED_SHORT:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( (sal_Int32)*(sal_uInt16 *)pVal, 16 );
		break;
	case typelib_TypeClass_LONG:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( *(sal_Int32 *)pVal, 16 );
		break;
	case typelib_TypeClass_UNSIGNED_LONG:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
		buf.append( (sal_Int64)*(sal_uInt32 *)pVal, 16 );
		break;
	case typelib_TypeClass_HYPER:
	case typelib_TypeClass_UNSIGNED_HYPER:
		buf.appendAscii( RTL_CONSTASCII_STRINGPARAM("0x") );
#if defined(GCC) && defined(SPARC)
		{
			sal_Int64 aVal;
			*(sal_Int32 *)&aVal = *(sal_Int32 *)pVal;
			*((sal_Int32 *)&aVal +1)= *((sal_Int32 *)pVal +1);
			buf.append( aVal, 16 );
		}
#else
		buf.append( *(sal_Int64 *)pVal, 16 );
#endif
		break;
		
	case typelib_TypeClass_VOID:
	case typelib_TypeClass_ARRAY:
	case typelib_TypeClass_UNKNOWN:
	case typelib_TypeClass_SERVICE:
	case typelib_TypeClass_MODULE:
	default:
		buf.append( (sal_Unicode)'?' );
	}
	
	return buf.makeStringAndClear();
}

//==================================================================================================
struct prot_Mapping : public uno_Mapping
{
	oslInterlockedCount		nRef;
	
	uno_ExtEnvironment *	pFrom;
	uno_ExtEnvironment *	pTo;

	Mutex					aWriteMutex;
	protmode				eProtMode;
	FILE *					file;
	void writeLine( const OUString & rLine );
	
	prot_Mapping( uno_ExtEnvironment * pFrom_, uno_ExtEnvironment * pTo_ ) SAL_THROW( () );
	~prot_Mapping() SAL_THROW( () );
};

//==== a uno protocol proxy ========================================================================
struct prot_unoInterfaceProxy : public uno_Interface
{
	oslInterlockedCount					nRef;
	prot_Mapping *						pProtMapping;
	
	// mapping information
	uno_Interface *						pUnoI; // wrapped interface
	typelib_InterfaceTypeDescription *	pTypeDescr;
	OUString							oid;
	
	// ctor
	inline prot_unoInterfaceProxy(
        prot_Mapping * pProtMapping_,
        uno_Interface * pUnoI_,
        typelib_InterfaceTypeDescription * pTypeDescr_,
        const OUString & rOId_ ) SAL_THROW( () );
};
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_unoInterfaceProxy_dispatch(
	uno_Interface * pUnoI, 
	const typelib_TypeDescription * pMemberType,
	void * pReturn,
	void * pArgs[],
	uno_Any ** ppException ) SAL_THROW_EXTERN_C()
{
	prot_unoInterfaceProxy * pThis = static_cast< prot_unoInterfaceProxy * >( pUnoI );
	OUStringBuffer line( 128 );
	
	typelib_TypeDescriptionReference * pReturnTypeRef = 0;
	sal_Int32 nOutParams = 0;

	switch (pMemberType->eTypeClass)
	{
	case typelib_TypeClass_INTERFACE_ATTRIBUTE:
		if (pReturn)
		{
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("+ GET attribute ") );
			line.append( ((typelib_InterfaceMemberTypeDescription *)pMemberType)->pMemberName );
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" [") );
			line.append( ((typelib_InterfaceAttributeTypeDescription *)pMemberType)->
						 pAttributeTypeRef->pTypeName );
			line.append( (sal_Unicode)']' );
			pReturnTypeRef = ((typelib_InterfaceAttributeTypeDescription *)pMemberType)->pAttributeTypeRef;
		}
		else
		{
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("+ SET attribute ") );
			line.append( ((typelib_InterfaceMemberTypeDescription *)pMemberType)->pMemberName );
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" = ") );
			line.append( val2str(
				pArgs[0], ((typelib_InterfaceAttributeTypeDescription *)pMemberType)->pAttributeTypeRef ) );
		}
		break;
	case typelib_TypeClass_INTERFACE_METHOD:
	{
		if (((typelib_InterfaceMethodTypeDescription *)pMemberType)->bOneWay)
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("+ METHOD oneway call ") );
		else
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("+ METHOD call ") );
		line.append( ((typelib_InterfaceMemberTypeDescription *)pMemberType)->pMemberName );
		
		typelib_InterfaceMethodTypeDescription * pMTD =
			(typelib_InterfaceMethodTypeDescription *)pMemberType;
		
		if (pMTD->nParams)
		{
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("( ") );
			for ( sal_Int32 nPos = 0; nPos < pMTD->nParams; ++nPos )
			{
				const typelib_MethodParameter & rParam = pMTD->pParams[nPos];

				line.append( (sal_Unicode)'[' );
				if (rParam.bIn)
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM("in") );
				if (rParam.bOut)
				{
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM("out") );
					++nOutParams;
				}
				line.appendAscii( RTL_CONSTASCII_STRINGPARAM("] ") );
				line.append( rParam.pTypeRef->pTypeName );
				line.append( (sal_Unicode)' ' );
				line.append( rParam.pName );
				if (rParam.bIn)
				{
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" = ") );
					line.append( val2str( pArgs[nPos], rParam.pTypeRef ) );
				}
				if (nPos < (pMTD->nParams -1))
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM(", ") );
			}
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" )") );
		}
		else
		{
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("()") );
		}
		
		pReturnTypeRef = ((typelib_InterfaceMethodTypeDescription *)pMemberType)->pReturnTypeRef;
		break;
	}
	default:
		OSL_ENSURE( sal_False, "### illegal member typeclass!" );
	}
	
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" on interface ") );
	line.append( ((typelib_TypeDescription *)pThis->pTypeDescr)->pTypeName );
	line.append( (sal_Unicode)':' );
	line.append( pThis->oid );
	
	pThis->pProtMapping->writeLine( line.makeStringAndClear() );
	
	(*pThis->pUnoI->pDispatcher)( pThis->pUnoI, pMemberType, pReturn, pArgs, ppException );
	
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM("  => ") );
	if (*ppException)
	{
		line.append( (*ppException)->pType->pTypeName );
		line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" occured: ") );
		line.append( val2str( (*ppException)->pData, (*ppException)->pType ) );
	}
	else
	{
		line.appendAscii( RTL_CONSTASCII_STRINGPARAM("returned") );
		if (pReturnTypeRef &&
			(pReturnTypeRef->eTypeClass != typelib_TypeClass_VOID))
		{
			line.append( (sal_Unicode)' ' );
			line.append( val2str( pReturn, pReturnTypeRef ) );
		}
		
		if (nOutParams)
		{
			line.appendAscii( RTL_CONSTASCII_STRINGPARAM("; out/inout params: ") );
			
			typelib_InterfaceMethodTypeDescription * pMTD =
				(typelib_InterfaceMethodTypeDescription *)pMemberType;
			
			for ( sal_Int32 nPos = 0; nPos < pMTD->nParams; ++nPos )
			{
				const typelib_MethodParameter & rParam = pMTD->pParams[nPos];

				if (rParam.bOut)
				{
					line.append( (sal_Unicode)'[' );
					if (rParam.bIn)
						line.appendAscii( RTL_CONSTASCII_STRINGPARAM("in") );
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM("out] ") );
//  					line.append( rParam.pTypeRef->pTypeName );
//  					line.append( (sal_Unicode)' ' );
					line.append( rParam.pName );
					line.appendAscii( RTL_CONSTASCII_STRINGPARAM(" = ") );
					line.append( val2str( pArgs[nPos], rParam.pTypeRef ) );
					if (--nOutParams)
						line.appendAscii( RTL_CONSTASCII_STRINGPARAM(", ") );
				}
			}
		}
	}
	
	line.append( (sal_Unicode)'.' );
	pThis->pProtMapping->writeLine( line.makeStringAndClear() );
}

//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_unoInterfaceProxy_free(
	uno_ExtEnvironment * pEnv, void * pProxy ) SAL_THROW_EXTERN_C()
{
	prot_unoInterfaceProxy * pThis =
		static_cast< prot_unoInterfaceProxy * >(
			reinterpret_cast< uno_Interface * >( pProxy ) );
	OSL_ASSERT( pEnv == pThis->pProtMapping->pTo );
	
	OUStringBuffer line( 64 );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM("* FREEing proxy ") );
	line.append( ((typelib_TypeDescription *)pThis->pTypeDescr)->pTypeName );
	line.append( (sal_Unicode)':' );
	line.append( pThis->oid );
	pThis->pProtMapping->writeLine( line.makeStringAndClear() );
	
	(*pThis->pProtMapping->pFrom->revokeInterface)( pThis->pProtMapping->pFrom, pThis->pUnoI );
	(*pThis->pUnoI->release)( pThis->pUnoI );
	typelib_typedescription_release( (typelib_TypeDescription *)pThis->pTypeDescr );
	(*pThis->pProtMapping->release)( pThis->pProtMapping );
	
#ifdef DEBUG
	*(int *)pProxy = 0xdeadbabe;
#endif
	delete pThis;
}
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_unoInterfaceProxy_acquire(
	uno_Interface * pUnoI ) SAL_THROW_EXTERN_C()
{
	oslInterlockedCount n = osl_incrementInterlockedCount( & static_cast< prot_unoInterfaceProxy * >( pUnoI )->nRef );
	
	OUStringBuffer line( 64 );
	prot_unoInterfaceProxy * pThis = static_cast< prot_unoInterfaceProxy * >( pUnoI );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM("* ACQUIRE proxy call (ref = ") );
	line.append( (sal_Int32)n );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM(") on interface ") );
	line.append( ((typelib_TypeDescription *)pThis->pTypeDescr)->pTypeName );
	line.append( (sal_Unicode)':' );
	line.append( pThis->oid );
	pThis->pProtMapping->writeLine( line.makeStringAndClear() );
	
	if (1 == n)
	{
		// rebirth of proxy zombie
		// register at uno env
		void * pThis = static_cast< uno_Interface * >( pUnoI );
		(*static_cast< prot_unoInterfaceProxy * >( pUnoI )->pProtMapping->pTo->registerProxyInterface)(
			static_cast< prot_unoInterfaceProxy * >( pUnoI )->pProtMapping->pTo,
			&pThis, prot_unoInterfaceProxy_free,
			static_cast< prot_unoInterfaceProxy * >( pUnoI )->oid.pData,
			static_cast< prot_unoInterfaceProxy * >( pUnoI )->pTypeDescr );
		OSL_ASSERT( pThis == static_cast< uno_Interface * >( pUnoI ) );
	}
}
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_unoInterfaceProxy_release(
	uno_Interface * pUnoI ) SAL_THROW_EXTERN_C()
{
	oslInterlockedCount n = osl_decrementInterlockedCount( & static_cast< prot_unoInterfaceProxy * >( pUnoI )->nRef );
	
	OUStringBuffer line( 64 );
	prot_unoInterfaceProxy * pThis = static_cast< prot_unoInterfaceProxy * >( pUnoI );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM("* RELEASE proxy call (ref count = ") );
	line.append( (sal_Int32)n );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM(") on interface ") );
	line.append( ((typelib_TypeDescription *)pThis->pTypeDescr)->pTypeName );
	line.append( (sal_Unicode)':' );
	line.append( pThis->oid );
	pThis->pProtMapping->writeLine( line.makeStringAndClear() );
	
	if (! n)
	{
		// revoke from uno env on last release
		(*static_cast< prot_unoInterfaceProxy * >( pUnoI )->pProtMapping->pTo->revokeInterface)(
			static_cast< prot_unoInterfaceProxy * >( pUnoI )->pProtMapping->pTo, pUnoI );
	}
}
//__________________________________________________________________________________________________
inline prot_unoInterfaceProxy::prot_unoInterfaceProxy(
	prot_Mapping * pProtMapping_, uno_Interface * pUnoI_,
	typelib_InterfaceTypeDescription * pTypeDescr_, const ::rtl::OUString & rOId_ ) SAL_THROW( () )
	: nRef( 1 )
	, pProtMapping( pProtMapping_ )
	, pUnoI( pUnoI_ )
	, pTypeDescr( pTypeDescr_ )
	, oid( rOId_ )
{
	OUStringBuffer line( 64 );
	line.appendAscii( RTL_CONSTASCII_STRINGPARAM("* NEW proxy introduction (ref = 1) ") );
	line.append( ((typelib_TypeDescription *)pTypeDescr)->pTypeName );
	line.append( (sal_Unicode)':' );
	line.append( oid );
	pProtMapping->writeLine( line.makeStringAndClear() );
	
	(*pProtMapping->acquire)( pProtMapping );
	typelib_typedescription_acquire( (typelib_TypeDescription *)pTypeDescr );
	if (! ((typelib_TypeDescription *)pTypeDescr)->bComplete)
		::typelib_typedescription_complete( (typelib_TypeDescription **)&pTypeDescr );
	OSL_ENSURE( ((typelib_TypeDescription *)pTypeDescr)->bComplete, "### type is incomplete!" );
	(*pProtMapping->pFrom->registerInterface)(
		pProtMapping->pFrom, reinterpret_cast< void ** >( &pUnoI ), oid.pData, pTypeDescr );
	(*pUnoI->acquire)( pUnoI );
	
	// uno_Interface
	uno_Interface::acquire = prot_unoInterfaceProxy_acquire;
	uno_Interface::release = prot_unoInterfaceProxy_release;
	uno_Interface::pDispatcher = prot_unoInterfaceProxy_dispatch;
}

//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_Mapping_mapInterface(
	uno_Mapping * pMapping, void ** ppOut,
	void * pUnoI, typelib_InterfaceTypeDescription * pTypeDescr ) SAL_THROW_EXTERN_C()
{
	OSL_ASSERT( ppOut && pTypeDescr );
	if (*ppOut)
	{
		(*reinterpret_cast< uno_Interface * >( *ppOut )->release)(
			reinterpret_cast< uno_Interface * >( *ppOut ) );
		*ppOut = 0;
	}
	if (pUnoI && pTypeDescr)
	{
		// get object id of uno interface to be wrapped
		rtl_uString * pOId = 0;
		(*static_cast< prot_Mapping * >( pMapping )->pFrom->getObjectIdentifier)(
			static_cast< prot_Mapping * >( pMapping )->pFrom, &pOId, pUnoI );
		OSL_ASSERT( pOId );
		
		if (pOId)
		{
			// try to get any known interface from target environment
			(*static_cast< prot_Mapping * >( pMapping )->pTo->getRegisteredInterface)(
				static_cast< prot_Mapping * >( pMapping )->pTo, ppOut, pOId, pTypeDescr );
			if (! *ppOut) // no existing interface, register new proxy interface
			{
				// try to publish a new proxy (ref count initially 1)
				void * pProxy = new prot_unoInterfaceProxy(
					static_cast< prot_Mapping * >( pMapping ),
					reinterpret_cast< uno_Interface * >( pUnoI ), pTypeDescr, pOId );
				
				// proxy may be exchanged during registration
				(*static_cast< prot_Mapping * >( pMapping )->pTo->registerProxyInterface)(
					static_cast< prot_Mapping * >( pMapping )->pTo,
					&pProxy, prot_unoInterfaceProxy_free, pOId, pTypeDescr );
				
				*ppOut = pProxy;
			}
			rtl_uString_release( pOId );
		}
	}
}
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_Mapping_free( uno_Mapping * pMapping ) SAL_THROW_EXTERN_C()
{
	delete static_cast< prot_Mapping * >( pMapping );
}
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_Mapping_acquire( uno_Mapping * pMapping ) throw ()
{
	if (1 == osl_incrementInterlockedCount( &static_cast< prot_Mapping * >( pMapping )->nRef ))
	{
		OUString aPurpose( RTL_CONSTASCII_USTRINGPARAM("prot") );
		::uno_registerMapping(
            &pMapping,
            prot_Mapping_free,
            (uno_Environment *)((prot_Mapping *)pMapping)->pFrom,
            (uno_Environment *)((prot_Mapping *)pMapping)->pTo,
            aPurpose.pData );
	}
}
//--------------------------------------------------------------------------------------------------
static void SAL_CALL prot_Mapping_release( uno_Mapping * pMapping ) throw ()
{
	if (! osl_decrementInterlockedCount( &static_cast< prot_Mapping * >( pMapping )->nRef ))
	{
		::uno_revokeMapping( pMapping );
	}
}

//__________________________________________________________________________________________________
void prot_Mapping::writeLine( const OUString & rLine )
{
	if (eProtMode != protmode_none)
	{
		OString aLine( OUStringToOString( rLine, RTL_TEXTENCODING_ISO_8859_1 ) );
		
		MutexGuard aGuard( aWriteMutex );
		switch (eProtMode)
		{
		case protmode_trace:
			OSL_TRACE( aLine.getStr() );
			OSL_TRACE( "\n" );
			break;
		case protmode_stdout:
            ::fprintf( stdout, "%s\n", aLine.getStr() );
			break;
		case protmode_stderr:
            ::fprintf( stderr, "%s\n", aLine.getStr() );
			break;
		case protmode_file:
            ::fprintf( file, "%s\n", aLine.getStr() );
			break;
		}
	}
}
//__________________________________________________________________________________________________
prot_Mapping::prot_Mapping( uno_ExtEnvironment * pFrom_, uno_ExtEnvironment * pTo_ )
	: nRef( 1 )
	, pFrom( pFrom_ )
	, pTo( pTo_ )
	, eProtMode( protmode_none )
	, file( 0 )
{
    g_moduleCount.modCnt.acquire( &g_moduleCount.modCnt );
    
	(*((uno_Environment *)pFrom)->acquire)( (uno_Environment *)pFrom );
	(*((uno_Environment *)pTo)->acquire)( (uno_Environment *)pTo );
	//
	uno_Mapping::acquire = prot_Mapping_acquire;
	uno_Mapping::release = prot_Mapping_release;
	uno_Mapping::mapInterface = prot_Mapping_mapInterface;
	
	//
	char * pEnv, * pProtMode;
	if (pProtMode = ::getenv( "PROTUNO_MODE" ))
	{
		if (rtl_str_compareIgnoreAsciiCase( pProtMode, "file" ) == 0 &&
			(pEnv = ::getenv( "PROTUNO_FILE" )) &&
			(file = ::fopen( pEnv, "w" )))
		{
			eProtMode = protmode_file;
		}
		else if (rtl_str_compareIgnoreAsciiCase( pProtMode, "stdout" ) == 0)
		{
			eProtMode = protmode_stdout;
		}
		else if (rtl_str_compareIgnoreAsciiCase( pProtMode, "stderr" ) == 0)
		{
			eProtMode = protmode_stderr;
		}
		else if (rtl_str_compareIgnoreAsciiCase( pProtMode, "trace" ) == 0)
		{
			eProtMode = protmode_trace;
		}
	}
	// deprecated
	else if ((pEnv = ::getenv( "PROT_UNO" )) &&
			 (file = ::fopen( pEnv, "w" )))
	{
		eProtMode = protmode_file;
	}
}
//__________________________________________________________________________________________________
prot_Mapping::~prot_Mapping()
{
	if (file)
    {
		::fclose( file );
    }
	
	(*((uno_Environment *)pTo)->release)( (uno_Environment *)pTo );
	(*((uno_Environment *)pFrom)->release)( (uno_Environment *)pFrom );
    
	g_moduleCount.modCnt.release( &g_moduleCount.modCnt );
}
}

extern "C"
{
//##################################################################################################
sal_Bool SAL_CALL component_canUnload(
    TimeValue * pTime ) SAL_THROW_EXTERN_C()
{
	return ::prot_uno::g_moduleCount.canUnload( &::prot_uno::g_moduleCount, pTime );
}
//##################################################################################################
void SAL_CALL uno_initEnvironment(
	uno_Environment * pUnoEnv ) SAL_THROW_EXTERN_C()
{
	OSL_ENSURE( 0, "### no impl: unexpected call!" );
}
//##################################################################################################
void SAL_CALL uno_ext_getMapping(
	uno_Mapping ** ppMapping, uno_Environment * pFrom, uno_Environment * pTo ) SAL_THROW_EXTERN_C()
{
	OSL_ASSERT( ppMapping && pFrom && pTo );
	if (ppMapping && pFrom && pTo && pFrom->pExtEnv && pTo->pExtEnv)
	{
		uno_Mapping * pMapping = 0;
		
		if (0 == ::rtl_ustr_ascii_compare( pFrom->pTypeName->buffer, UNO_LB_UNO ) &&
			0 == ::rtl_ustr_ascii_compare( pTo->pTypeName->buffer, UNO_LB_UNO ))
		{
			OUString aPurpose( RTL_CONSTASCII_USTRINGPARAM("prot") );
			// ref count is initially 1
			pMapping = new prot_uno::prot_Mapping( pFrom->pExtEnv, pTo->pExtEnv );
			::uno_registerMapping(
                &pMapping, prot_uno::prot_Mapping_free,
                (uno_Environment *)pFrom->pExtEnv,
                (uno_Environment *)pTo->pExtEnv,
                aPurpose.pData );
		}
		
		if (*ppMapping)
        {
			(*(*ppMapping)->release)( *ppMapping );
        }
		*ppMapping = pMapping;
	}
}
}
