/*************************************************************************
 *
 *  $RCSfile: jthreadpool.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kr $ $Date: 2000/09/28 17:25:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <string.h>

#include <osl/diagnose.h>

#include <rtl/byteseq.hxx>

#include <uno/threadpool.h>

#include <com/sun/star/java/XJavaThreadRegister_11.hpp>

#include "jthreadpool.hxx"

using namespace ::rtl;
using namespace ::com::sun::star::java;
using namespace ::com::sun::star::uno;

//--------------------------------------------------------------------------
// This is a nasty hack to grant the javaloader_callback-routine access to
// the XJavaThreadRegister_11-instance.
// Note : This works only as long as there is only ONE VM PER PROCESS !
// Note : This is only a weak reference
//-------------------------------------------------------------------------
static JavaVMContext * __pVMContext = NULL;

struct JavaThreadpoolCallbackHolder
{
	jobject jCallback;
	jobject jThreadSpecificData;
	JavaVM *pVM;
};


//-----------------------
// is called, when a java request shall  be executed
//----------------------
static void SAL_CALL java_uno_mapping_callback(void *pThreadSpecificData) throw() {
	JavaThreadpoolCallbackHolder *pHolder = ( JavaThreadpoolCallbackHolder*)pThreadSpecificData;

	// Attach the thread to the java vm
	OSL_ASSERT(__pVMContext);

	JNIEnv *pMyEnv = 0;

	__pVMContext->registerThread();
	
	pHolder->pVM->AttachCurrentThread((void **)&pMyEnv, NULL);
	if(!pMyEnv)
	{
		OSL_ASSERT( 0 );
	}
	
	
	jclass jClassNativeCallback = pMyEnv->FindClass( "com/sun/star/lib/uno/environments/remote/INativeCallback" );
	if( pMyEnv->ExceptionOccurred() )
	{
		OSL_ASSERT( 0 );
		// There is no possibility to report an error to the caller !
		return;
	}

	jmethodID id = pMyEnv->GetMethodID( jClassNativeCallback ,
											   "doRequest",
											   "(Ljava/lang/Object;)V" );
	if( pMyEnv->ExceptionOccurred() )
	{
		OSL_ASSERT( 0 );
		// There is no possibility to report an error to the caller !
		return;
	}
	OSL_ASSERT( id );

	//--------------------
	//
	// Do the call
	//
	//--------------------	
	pMyEnv->CallVoidMethod( pHolder->jCallback, id , pHolder->jThreadSpecificData );
	if( pMyEnv->ExceptionOccurred() )
	{
		OSL_ASSERT( 0 );
		// There is no possibility to report an error to the caller !
		return;
	}

	// tiding up ....
	pMyEnv->DeleteGlobalRef( pHolder->jCallback );
	if( pMyEnv->ExceptionOccurred() )
	{
		OSL_ASSERT( 0 );
		// There is no possibility to report an error to the caller !
		return;
	}

	pMyEnv->DeleteGlobalRef( pHolder->jThreadSpecificData );
	if( pMyEnv->ExceptionOccurred() )
	{
		OSL_ASSERT( 0 );
		// There is no possibility to report an error to the caller !
		return;
	}

	__pVMContext->revokeThread();
	if(!__pVMContext->isThreadAttached())
		pHolder->pVM->DetachCurrentThread();

  	delete pHolder;
}

extern "C"
{
	
/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    add
 * Signature: ([B)Z
 */
JNIEXPORT jboolean JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_add
  (JNIEnv *pEnv , jclass theClass, jbyteArray theArray)
{
	jbyte *myJByteArray = pEnv->GetByteArrayElements(  theArray , 0 );
	if( pEnv->ExceptionOccurred() )
		return 0;
		
	ByteSequence seq((sal_Int8 *)myJByteArray , pEnv->GetArrayLength( theArray ) );
	sal_Bool b = uno_bindIdToCurrentThread( seq.getHandle() );
	
	pEnv->ReleaseByteArrayElements( theArray, myJByteArray , JNI_ABORT );
	if( pEnv->ExceptionOccurred() )
		return 0;

	return b;
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    createTicket
 * Signature: ()J
 */
	
JNIEXPORT jlong JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_createTicket
   (JNIEnv *pEnv, jclass theClass, jobject jDisposeId )
{
	return ( jlong ) uno_threadpool_createHandle( (sal_Int64) jDisposeId );
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    dispose
 * Signature: (J)V
 */
JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_dispose
  (JNIEnv *pEnv, jclass theClass ,  jobject jDisposeId)
{
	uno_threadpool_disposeThreads( (sal_Int64) jDisposeId );
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    reply
 * Signature: ([BLjava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_reply
  (JNIEnv *pEnv, jclass theClass, jbyteArray jID, jobject jThreadSpecificData)
{
	jobject jGlobalThreadSpecificData = pEnv->NewGlobalRef(jThreadSpecificData);
	if( pEnv->ExceptionOccurred() )
		return;

	jbyte *myJByteArray = pEnv->GetByteArrayElements( jID , 0 );
	if( pEnv->ExceptionOccurred() )
	{
		return;
	}
	sal_Int32 nLength = pEnv->GetArrayLength( jID );
	if( pEnv->ExceptionOccurred() )
	{
		return;
	}
	
	ByteSequence seq((sal_Int8 *)myJByteArray , nLength );
	uno_threadpool_putReply(seq.getHandle(), (void*)jGlobalThreadSpecificData);
	
	pEnv->ReleaseByteArrayElements(jID, myJByteArray, JNI_ABORT);
	if( pEnv->ExceptionOccurred() )
		return;
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    request
 * Signature: ([BLjava/lang/Object;Lcom/sun/star/lib/uno/environments/remote/NativeCallback;Z)V
 */
JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_request
  ( JNIEnv *pEnv,
    jclass theClass ,
	jbyteArray jID,
	jobject jThreadSpecificData,
	jobject callback,
	jboolean isOneway)
{
	JavaThreadpoolCallbackHolder *pHolder = new JavaThreadpoolCallbackHolder;

	pEnv->GetJavaVM( &(pHolder->pVM) );

	pHolder->jThreadSpecificData = pEnv->NewGlobalRef(  jThreadSpecificData );
	if( pEnv->ExceptionOccurred() )
		return;

	pHolder->jCallback = pEnv->NewGlobalRef( callback );
	if( pEnv->ExceptionOccurred() )
		return;	


	jbyte *myJByteArray = pEnv->GetByteArrayElements( jID , 0 );
	if( pEnv->ExceptionOccurred() )
	{
		return;
	}
	sal_Int32 nLength = pEnv->GetArrayLength( jID );
	if( pEnv->ExceptionOccurred() )
	{
		return;
	}

	ByteSequence seq((sal_Int8 *)myJByteArray, nLength);
	uno_threadpool_putRequest( seq.getHandle(),
							(void*)pHolder,
							java_uno_mapping_callback,
							isOneway);
	
	pEnv->ReleaseByteArrayElements( jID, myJByteArray , JNI_ABORT );
	if( pEnv->ExceptionOccurred() )
		return;
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    retrieve
 * Signature: ()[B
 */
JNIEXPORT jbyteArray JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_retrieve
   (JNIEnv *pEnv, jclass theClass)
{
	ByteSequence seq;
	{
		sal_Sequence *pSequence = 0;
		uno_getIdOfCurrentThread( &pSequence );
		seq = pSequence;
		rtl_byte_sequence_release( pSequence );
	}

	jbyteArray array = pEnv->NewByteArray( seq.getLength() );
	if( pEnv->ExceptionOccurred( ))
	{
		return 0;
	}

	jbyte *pMem = pEnv->GetByteArrayElements( array , 0 );
	if( pEnv->ExceptionOccurred( ))
	{
		return 0;
	}
	memcpy( pMem , seq.getConstArray() , seq.getLength() );

	pEnv->ReleaseByteArrayElements( array, pMem , 0 );
	if( pEnv->ExceptionOccurred( ))
	{
		return 0;
	}

	return array;
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    revoke
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_revoke
  (JNIEnv *, jclass)
{
	uno_releaseIdFromCurrentThread();
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    stopDispose
 * Signature: (J)V
 */
JNIEXPORT void JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_stopDispose
  (JNIEnv *pEnv, jclass theClass ,  jobject jDisposeId)
{
	uno_threadpool_disposeThreads( (sal_Int64) jDisposeId );
}

/*
 * Class:     com_sun_star_lib_uno_environments_remote_NativeThreadPool
 * Method:    waitOnTicket
 * Signature: (J)V
 */
JNIEXPORT jobject JNICALL Java_com_sun_star_lib_uno_environments_remote_NativeThreadPool_waitOnTicket
  (JNIEnv *pEnv, jclass theClass, jlong jLongValue)
{
	__pVMContext->registerThread();

	jobject jGlobalThreadSpecificData = 0;
	uno_threadpool_enter((uno_threadpool_Handle *)(sal_uInt32 )jLongValue, (void**)&jGlobalThreadSpecificData);

	// the thread specific data is a global ref, we have to get a local ref and free the global ref
	jclass jcObject = pEnv->FindClass("java/lang/Object");
	jobjectArray jaTmp = pEnv->NewObjectArray(1, jcObject, jGlobalThreadSpecificData);
	jobject jThreadSpecificData = pEnv->GetObjectArrayElement(jaTmp, 0);

	// delete the global ref
	pEnv->DeleteGlobalRef(jGlobalThreadSpecificData);

	__pVMContext->revokeThread();

	return jThreadSpecificData;
}

}

typedef Reference<XInterface> XInterfaceRef;

//--------------------------
// Init the java threadpool
//--------------------------
void SAL_CALL java_uno_mapping_initNativeThreadPool(JNIEnv *pEnv, JavaVMContext * pVMContext) throw(RuntimeException) {
	try {
		// now instantiate a NativeThreadPoolWrapper
		jclass jClassNativeThreadPoolWrapper = pEnv->FindClass("com/sun/star/lib/uno/environments/remote/NativeThreadPoolWrapper");
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 1")), XInterfaceRef());

		jmethodID idCtor = pEnv->GetMethodID( jClassNativeThreadPoolWrapper, "<init>", "()V");
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 2")), XInterfaceRef());

		jobject jThreadpool = pEnv->NewObject(jClassNativeThreadPoolWrapper, idCtor);
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 3")), XInterfaceRef());

		// get the Threadpool-class   
		jclass jClassTheThreadpool = pEnv->FindClass("com/sun/star/lib/uno/environments/remote/ThreadPool");
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 4")), XInterfaceRef());


		jmethodID idSetThreadpool = pEnv->GetStaticMethodID(jClassTheThreadpool,
															"setThreadPool",
															"(Lcom/sun/star/lib/uno/environments/remote/IThreadPool;)V");
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 5")), XInterfaceRef());


		pEnv->CallStaticVoidMethod(jClassTheThreadpool, idSetThreadpool, jThreadpool);
		if(pEnv->ExceptionOccurred()) throw RuntimeException(OUString(RTL_CONSTASCII_USTRINGPARAM("jthreadpool.cxx - error 6")), XInterfaceRef());

		// hold it weak
		__pVMContext = pVMContext;
	}
	catch(RuntimeException & runtimeException) {
		if(pEnv->ExceptionOccurred()) {
			pEnv->ExceptionDescribe();
			pEnv->ExceptionClear();
		}
		throw;
	}
}
