/*************************************************************************
 *
 *  $RCSfile: connectionWrapper.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dbo $ $Date: 2001/10/26 07:22:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <jvmHelp.hxx>

#include <string.h>

#include <osl/diagnose.h>


#include <connectionWrapper.hxx>


using namespace ::com::sun::star::uno;

using namespace ::rtl;

namespace java
{
	static void SAL_CALL ConnectionWrapper_acquire(remote_Connection * premote_Connection) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		osl_incrementInterlockedCount(&pConnectionWrapper->_refCount);
	}
	
	static void SAL_CALL ConnectionWrapper_release (remote_Connection * premote_Connection) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		if(!osl_decrementInterlockedCount(&pConnectionWrapper->_refCount))
			delete pConnectionWrapper;
	}

	static sal_Int32 SAL_CALL ConnectionWrapper_read(remote_Connection * premote_Connection, sal_Int8 *pDest, sal_Int32 nSize) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		jint jiRes = -1;

		JVMThreadAttach jvm(pConnectionWrapper->_pVMContext);
		
		try {
			jobjectArray joDest = jvm._pJNIEnv->NewObjectArray(1, pConnectionWrapper->_jcByteArray, 0);                       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 1"), Reference<XInterface>());
			jvm._pJNIEnv->SetObjectArrayElement(joDest, 0, jvm._pJNIEnv->NewByteArray(10));									  if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 2"), Reference<XInterface>());
			
			jiRes = jvm._pJNIEnv->CallIntMethod(pConnectionWrapper->_joConnection, pConnectionWrapper->_jmConnection_read, joDest, (jint)nSize);		      
			if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 3"), Reference<XInterface>());
			
			jbyteArray jaDest = reinterpret_cast<jbyteArray>(jvm._pJNIEnv->GetObjectArrayElement(joDest, 0));				  if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 4"), Reference<XInterface>());
			
			jbyte * pBytes = jvm._pJNIEnv->GetByteArrayElements(jaDest, NULL);												  if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 5"), Reference<XInterface>());
			memcpy(pDest, pBytes, jiRes * sizeof(sal_Int8));
			jvm._pJNIEnv->ReleaseByteArrayElements(jaDest, pBytes, 0);														  if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 6"), Reference<XInterface>());
		}
		catch(RuntimeException & runtimeException) {
			if(jvm._pJNIEnv->ExceptionOccurred()) {
				jvm._pJNIEnv->ExceptionDescribe();
				jvm._pJNIEnv->ExceptionClear();
			}
			
			osl_trace("ConnectionWrapper_read - runtimeException occurred");
			jiRes = -1;
		}

		return (sal_Int32)jiRes;
	}

	static sal_Int32 SAL_CALL ConnectionWrapper_write(remote_Connection * premote_Connection, const sal_Int8 *pSource, sal_Int32 nSize) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		JVMThreadAttach jvm(pConnectionWrapper->_pVMContext);
		
		try {
			jbyteArray jaSource = jvm._pJNIEnv->NewByteArray(nSize);													   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 7"), Reference<XInterface>());
			jbyte * pBytes = jvm._pJNIEnv->GetByteArrayElements(jaSource, NULL);										   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 8"), Reference<XInterface>());
			memcpy(pBytes, pSource, nSize * sizeof(jbyte));
			jvm._pJNIEnv->ReleaseByteArrayElements(jaSource, pBytes, 0);												   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 9"), Reference<XInterface>());
			
			jvm._pJNIEnv->CallVoidMethod(pConnectionWrapper->_joConnection, pConnectionWrapper->_jmConnection_write, jaSource, (jint)nSize);			   
			if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 10"), Reference<XInterface>());
		}
		catch(RuntimeException & runtimeException) {
			if(jvm._pJNIEnv->ExceptionOccurred()) {
				jvm._pJNIEnv->ExceptionDescribe();
				jvm._pJNIEnv->ExceptionClear();
			}
				
			osl_trace("ConnectionWrapper_read - runtimeException occurred");
			nSize = -1;
		}
		
		return nSize;
	}

	static void SAL_CALL ConnectionWrapper_flush(remote_Connection * premote_Connection) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		JVMThreadAttach jvm(pConnectionWrapper->_pVMContext);
		jvm._pJNIEnv->CallVoidMethod(pConnectionWrapper->_joConnection, pConnectionWrapper->_jmConnection_flush);
		if(jvm._pJNIEnv->ExceptionOccurred()) {
			jvm._pJNIEnv->ExceptionDescribe();
			jvm._pJNIEnv->ExceptionClear();
		}
	}

	static void SAL_CALL ConnectionWrapper_close(remote_Connection * premote_Connection) throw() {
		ConnectionWrapper * pConnectionWrapper = reinterpret_cast<ConnectionWrapper *>(premote_Connection);

		JVMThreadAttach jvm(pConnectionWrapper->_pVMContext);
		jvm._pJNIEnv->CallVoidMethod(pConnectionWrapper->_joConnection, pConnectionWrapper->_jmConnection_close);
		if(jvm._pJNIEnv->ExceptionOccurred()) {
			jvm._pJNIEnv->ExceptionDescribe();
			jvm._pJNIEnv->ExceptionClear();
		}
	}
	
	ConnectionWrapper::ConnectionWrapper(JavaVMContext * pVMContext, jobject joConnection) throw(RuntimeException)
		: _refCount(0),
		  _pVMContext(pVMContext)
	{
		_remote_Connection.acquire = ConnectionWrapper_acquire;
		_remote_Connection.release = ConnectionWrapper_release;
		_remote_Connection.read    = ConnectionWrapper_read;
		_remote_Connection.write   = ConnectionWrapper_write;
		_remote_Connection.flush   = ConnectionWrapper_flush;
		_remote_Connection.close   = ConnectionWrapper_close;
		  
		JVMThreadAttach jvm(_pVMContext);

		try {
			_jcByteArray = jvm._pJNIEnv->FindClass("[B");																	       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 12"), Reference<XInterface>());
			_jcByteArray = reinterpret_cast<jclass>(jvm._pJNIEnv->NewGlobalRef(reinterpret_cast<jobject>(_jcByteArray)));		   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 13"), Reference<XInterface>());
			
			jclass jcConnection = jvm._pJNIEnv->FindClass("com/sun/star/connection/XConnection");								   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 14"), Reference<XInterface>());
			
			_jmConnection_read  = jvm._pJNIEnv->GetMethodID(jcConnection, "read", "([[BI)I");									   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 15"), Reference<XInterface>());
//  		_jmConnection_read  = reinterpret_cast<jmethodID>(jvm._pJNIEnv->NewGlobalRef(reinterpret_cast<jobject>(_jmConnection_read)));
			_jmConnection_write = jvm._pJNIEnv->GetMethodID(jcConnection, "write", "([B)V");								       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 16"), Reference<XInterface>());
//  		_jmConnection_write = reinterpret_cast<jmethodID>(jvm._pJNIEnv->NewGlobalRef(reinterpret_cast<jobject>(_jmConnection_write)));
			_jmConnection_flush = jvm._pJNIEnv->GetMethodID(jcConnection, "flush", "()V");									       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 17"), Reference<XInterface>());
//  		_jmConnection_flush = reinterpret_cast<jmethodID>(jvm._pJNIEnv->NewGlobalRef(reinterpret_cast<jobject>(_jmConnection_flush)));
			_jmConnection_close = jvm._pJNIEnv->GetMethodID(jcConnection, "close", "()V");									       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 18"), Reference<XInterface>());
//  		_jmConnection_close = reinterpret_cast<jmethodID>(jvm._pJNIEnv->NewGlobalRef(reinterpret_cast<jobject>(_jmConnection_close)));
			
			_joConnection = jvm._pJNIEnv->NewGlobalRef(joConnection);														       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 19"), Reference<XInterface>());
		}
		catch(RuntimeException & runtimeException) {
			if(jvm._pJNIEnv->ExceptionOccurred()) {
				jvm._pJNIEnv->ExceptionDescribe();
				jvm._pJNIEnv->ExceptionClear();
			}

			throw;
		}
	}

	ConnectionWrapper::~ConnectionWrapper() throw(RuntimeException) {
		JVMThreadAttach jvm(_pVMContext);
		
		jvm._pJNIEnv->DeleteGlobalRef(_joConnection);																	       if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 20"), Reference<XInterface>());

		jvm._pJNIEnv->DeleteGlobalRef(reinterpret_cast<jobject>(_jmConnection_read));										   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 21"), Reference<XInterface>());
		jvm._pJNIEnv->DeleteGlobalRef(reinterpret_cast<jobject>(_jmConnection_write));										   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 22"), Reference<XInterface>());
		jvm._pJNIEnv->DeleteGlobalRef(reinterpret_cast<jobject>(_jmConnection_flush));										   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 23"), Reference<XInterface>());
		jvm._pJNIEnv->DeleteGlobalRef(reinterpret_cast<jobject>(_jmConnection_close));										   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 24"), Reference<XInterface>());

		jvm._pJNIEnv->DeleteGlobalRef(_jcByteArray);																		   if(jvm._pJNIEnv->ExceptionOccurred()) throw RuntimeException(OUString::createFromAscii("error 25"), Reference<XInterface>());
	}



}
