/*************************************************************************
 *
 *  $RCSfile: basiclib.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tbe $ $Date: 2001/08/03 15:14:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SFX_OBJFAC_HXX //autogen
#include <sfx2/docfac.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif

#include "basdoc.hxx"
#include "basidesh.hrc"
#include "iderdll.hxx"
#include "dllname.hxx"
#include "basicmod.hxx"

SFX_IMPL_MODULE_LIB( BasicIDE, String::CreateFromAscii(DLL_NAME) )

SFX_IMPL_SIMPLE_OBJECTFACTORY_LIB( BasicDocShell,
							SFXOBJECTSHELL_STD_NORMAL,
                            sbasic,
                            BasicIDE,
                            BASIC_MOD() )
{
	Factory().SetExplorerImageId( IMG_MACROLIB );
	Factory().RegisterHelpFile( String( RTL_CONSTASCII_USTRINGPARAM( "sbasic" ) ) );
    Factory().SetDocumentServiceName( ::rtl::OUString::createFromAscii( "dummy" ) );
    Factory().RegisterMenuBar( ResId(RID_DEFAULTMENU) );
    Factory().RegisterPluginMenuBar( ResId(RID_DEFAULTPLUGINMENU) );
}

/*************************************************************************
|*
|* LibInit
|* method is called before Application::Execute()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

void BasicIDEDLL::LibInit()
{
	BasicDocShell::RegisterFactory( SVX_INTERFACE_BASIDE_DOCSH );
	ByteString aResMgrName( "basctl" );
	aResMgrName += ByteString::CreateFromInt32( SOLARUPD );
    BasicIDEModuleDummy** ppShlPtr = (BasicIDEModuleDummy**) GetAppData(SHL_IDE);
    ResMgr* pMgr = ResMgr::CreateResMgr(
        aResMgrName.GetBuffer(), Application::GetSettings().GetUILanguage() );

    BASIC_MOD() = new BasicIDEModuleDummy( pMgr, TRUE, &BasicDocShell::Factory() );
}

/*************************************************************************
|*
|* LibExit
|* this method is called after Application::Execute()
|* do whatever you want, but no calls to Sd-DLL-code!
|*
\************************************************************************/

void BasicIDEDLL::LibExit()
{
    FreeLibBasicIDE();

	// destroy the dummy-module with Object-Factory-Pointer
    SfxModule *p = BASIC_MOD();
	delete p;
}

/************-*************************************************************
|*
|* Unterfenster oeffnen
|*
\************************************************************************/

SfxModule *BasicIDEModuleDummy::Load ()
{
    return LoadLibBasicIDE () ? BASIC_MOD() : 0;
}

