/*************************************************************************
 *
 *  $RCSfile: oodb.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_OODB_HXX
#define OODB_OODB_HXX


// USED SERVICES
	// BASE CLASSES
#include <oodb\srialdev.hxx>
	// COMPONENTS
#include <cosv\cosvfile.hxx>
#include <template\dicty.hxx>

#if defined(_USE_NAMESPACE) && defined(_NO_NAMESPACES_)
#undef _USE_NAMESPACE
#endif
#include <vos\mutex.hxx>
struct S_MainIndex;
struct S_AreaAdmin;
struct S_AreaOnCallAdmin;
struct S_Activity;
struct S_Handles;
	// PARAMETERS
#include <cosv\plocinfo.hxx>
#include <template\liste.hxx>
#include <oodb\odbtypes.hxx>
struct S_Area;
struct S_ObjectPosition;



/**	@task
	class Oodb provides an object oriented database.
**/
class Oodb : private SerialDevice
{
  public:
	// LIFEYCLE
						Oodb(
							const DiskLocation &
												i_rLocation);
						~Oodb();

	// OPERATORS

	// OPERATIONS
	void				GetNewId(
							OodbId &			io_nId );	/// io_nId.Area() must be valid, an new unique LocalId() will be created.  

	bool				AddAreas(
							const CosvList<String> &
												i_rNewAreaNames);
	bool				DeleteAreas(
							const CosvList<String> &
												i_rAreaToDeleteNames);
	bool				PutAreaOnCall(
							OodbAreaNr			i_nArea,
							intt				i_nPriority = -1);	// 1 is the best, 2 is less imortant, -1 at the end, 0 automatic
	void				ReleaseAreaOnCall(
							OodbAreaNr			i_nArea);

	SerialDevice *		StartAddObject(
							OodbId &			o_nNewObjectId,
							OodbAreaNr			i_nArea);
	bool				FinishAddObject();

	SerialDevice *		StartUpdateObject(
							OodbId				i_nObject);
	bool				FinishUpdateObject();

	bool				DeleteObject(
							OodbId				i_nObject);

	SerialDevice &		OpenDevice_forWrite(    /// Creates a new object, if i_nId does not exist. Throws exception in case of other errors.
							OodbId				i_nId);
	SerialDevice &		OpenDevice_forRead(		/// Throws exception in case of any errors.
							OodbId				i_nId);
	bool				CloseDevice();

	SerialDevice *		OpenObject(
							OodbId				i_nId);
	bool				CloseObject();

	void				AddUserHandle(
							intt				i_nHandle,
							OodbId				i_nObject );
	void				DeleteUserHandles(
							const CosvList<intt> &
												i_nHandles );

	// INQUIRY
	const DiskLocation &
						HomeDirectory() const;
	virtual bool	 	EndOfData() const;
	void				GetAreas(
							CosvList<intt> *	o_rAreaNrs,
							CosvList<String> *	o_rAreaNames ) const;
	void				GetAreasOnCall(
							CosvList<intt> *	o_rAreaNrs,
							CosvList<String> *	o_rAreaNames ) const;
	OodbAreaNr			AreaNr(
							const String &		i_rAreaName) const;
//	OodbAreaNr			AreaNr(
//							OodbId				i_nObject ) const;
	OodbId				GetUserHandled(
						   intt					i_nHandle );

  private:
	// TYPES

	// PRIVATE SERVING FUNCTIONS
	S_AreaAdmin &		Areas();
	void				StopActivity();

	// DATA
	DiskLocation		aDatabaseDirectory;

	// DYN
	S_AreaAdmin	*		dpAreas;
	// DYN
	S_AreaOnCallAdmin *
						dpAreasOnCall;

	// DYN
	S_Handles *		    dpUserHandles;

	// DYN
	S_Activity *		dpActivity;
	CosvFile *			pActiveFile;


	intt				nLastError;
#ifdef _NO_NAMESPACES_
	OMutex				aMyGuard;
#else
	vos::OMutex			aMyGuard;
#endif

// INTERFACE SerialDevice
  protected:
	virtual void	  	Write(
							const void *		i_pData,
							UINT32				i_nSize );
	virtual void	  	Read(
							void *				o_pData,
							UINT32				i_nSize );
};



// IMPLEMENTIERUNG

inline const DiskLocation &
Oodb::HomeDirectory() const
	{ return aDatabaseDirectory; }
inline S_AreaAdmin &
Oodb::Areas()
	{ assert(dpAreas != 0); return *dpAreas; }


/**		Aufbau der Datenbank
		--------------------

Diese steht in einem Verzeichnis. Dieses kann Untergruppen von
Dateien haben.

In jeder Untergruppe gibt es einen eigenen PersistentVector.

Ein Objekt in der Datenbank ist durch eine 32-Bit-Id eindeutig
identifiziert.

Es gibt eine Stammdatei, die alle Objekt-Ids den Unter-Ids in
den Gruppen zuordnet. Sie heit "mainindex.data".

Format von main.key:
---------------------
	4		VersionId
	252		Andere Version-Info
	n * SubgrouptInfo            Position == 2*ObjectId+256
	-----------------
		2		SubgroupIndex.
		4		SubgroupIndex_Position.


Dann gibt es die Liste der Subgroups "subgroups.lst.

Format von subgroups.lst:
--------------------------
	4		VersionId
	252		Andere Version-Info
	n * SubgroupInfo
	-----------------
		2		SubgroupIndex.
		4       Stringlen inclusive end-'\0'
		n		String-Zeichen


Fuer jede Subgroup gibt es einen eigenen Index. Der Index
heisst SG_<Nr>.pos

Format von Subgroup-Index:
--------------------------
	4		VersionId
	252		Andere Version-Info
	n * ObjectInfo            Position == 12*ObjectId+256
	--------------
		4		Position,
		4		Size,
		4		ObjectId

Und zu jeder Subgroup gehoert eine Datei mit den darin
enthaltenen Objekten. Diese heisst SG_<Nr>.data.

Format von Subgroup-Data:
-------------------------
	4		VersionId
	252		Andere Version-Info
	Objekte
	-------
		4		ObjectId,
		4		SchemeId,
		Elemente
		--------
			1		ElementNr,
			n		ElementData
		4		ElementNr mit Wert 0


	Format von ElementData:
	-----------------------
	Entweder:
		n       SimpleData
	Oder:
		4		RawDataSize in Bytes
		n		RawData
	Oder:
		4		StringSize incl. end-'\0'
		n		Characters of string
	Oder:
		4		SchemeId of sub-struct
		n * x	Elemente  like Elemente above.

	Oder:
		4		Nr of elements in List
		n * x	ElementData  like ElementData above.


Auerdem speichert die Datenbank die verwendeten Schemata,
die Datei schemes.lst.

Format von schemes.lst:
-----------------------
	4		VersionId
	252		Andere Version-Info
	Schemes
	-------
		4		SchemeId
		n		SchemeName
		SchemeMembers
		-------------
			2		MemberId
			2		MemberType
			[4[,4[,...]]]
					SubType  	only, if MemberType is of complex kind

Member



Die Datenbank stellt keine eigenen Indices zur Verfuegung,
das mu die nutzende Klasse intern regeln.



Beim Aendern von Objekten werden diese geloescht und am
Ende der Datei wieder angehaengt.


**/

#endif


