/*************************************************************************
 *
 *  $RCSfile: odbtypes.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef OODB_ODBTYPES_HXX
#define OODB_ODBTYPES_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
class SerialDevice;

typedef INT32  OodbSchemeId; 	// Unique Id of a scheme of an persistent object.
typedef INT32  OodbAreaNr;
typedef INT32  OodbLocalId;

class OodbId
{
  public:
						OodbId(
							OodbAreaNr			i_nArea = 0,
							OodbLocalId			i_nLocalId = 0)
							:	nArea(i_nArea), nLocalId(i_nLocalId) { }
						OodbId(
							const OodbId &		i_rId)
							:	nArea(i_rId.nArea), nLocalId(i_rId.nLocalId) { }

	OodbId &			operator=(
							const OodbId &		i_rId)
							{ nArea = i_rId.nArea; nLocalId = i_rId.nLocalId; return *this; }

						operator bool() const
							{ return nLocalId != 0; }

	bool				operator==(
							const OodbId &		i_rId) const;
	bool				operator!=(
							const OodbId &		i_rId) const;
	bool				operator<(
							const OodbId &		i_rId) const;
	bool				operator>(
							const OodbId &		i_rId) const;
	bool				operator<=(
							const OodbId &		i_rId) const;
	bool				operator>=(
							const OodbId &		i_rId) const;

	friend void			operator<<(
							AnyReadWrite &		o_rDest,
							const OodbId &		i_rSrc );
	friend void			operator>>(
							AnyReadWrite &		io_rSrc,
							OodbId &			i_rDest );

	friend void			Serialize(
							SerialDevice &		o_rDest,
							const OodbId &      x );
	friend void			Deserialize(
							SerialDevice &		io_rSrc,
							OodbId &            x );


	OodbAreaNr			Area() const
							{ return nArea; }
	OodbLocalId			LocalId() const
							{ return nLocalId; }

	void				Set(
							OodbAreaNr			i_nArea,
							OodbLocalId			i_nLocalId )
							{ nArea = i_nArea; nLocalId = i_nLocalId; }
	void				SetArea(
							OodbAreaNr			i_nArea )
							{ nArea = i_nArea; }
	void				SetLocalId(
							OodbLocalId			i_nLocalId )
							{ nLocalId = i_nLocalId; }


	static const OodbId &
						Null_();

  private:
	static OodbId 		aNull_;

	OodbAreaNr			nArea;
	OodbLocalId			nLocalId;
};


inline const OodbId &
OodbId::Null_()
	{ return aNull_; }


#endif


