/*************************************************************************
 *
 *  $RCSfile: access.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADC_ACCESS_HXX
#define ADC_ACCESS_HXX



// USED SERVICES
	// BASE CLASSES
#include <oodb/accessor.hxx>
	// COMPONENTS
	// PARAMETERS
#include <oodb/serilize.hxx>
#include <oodb/access_d.hxx>


template<class OBJ, class ELEM>
class MemberAccess : public MemberAccessor
{
  public:
	// LIFECYCLE
						MemberAccess(
							UINT8				i_nMemberId,
							ELEM OBJ::*   		i_pMember,
							bool                i_bIsValid = true );
	// OPERATOR
	const ELEM &		operator()(
							const OBJ &			i_rObj) const;
	ELEM &				operator()(
							OBJ & 				i_rObj) const;

	virtual void		operator()(
							MemberVisitor &		i_rVisitor,
							Reflected &  	    io_rObj ) const;

	// OPERATIONS
	virtual void		SerialWrite(
							SerialDevice &		io_rDest,
							const Reflected &	i_rObj ) const;
	virtual void		SerialRead(
							SerialDevice &		io_rSrc,
							Reflected &			o_rObj ) const;

  protected:
	ELEM OBJ::*         Member() const { return const_cast<MemberAccess<OBJ,ELEM>*>(this)->pMember; }

  private:
	virtual const S_Accessor_Data &
						Data() const;
	virtual S_Accessor_Data &
						Data();

	// DATA
	S_Accessor_Data		aData;
	ELEM OBJ::*			pMember;
};


// ****************     Implementation     ********************** //


template<class OBJ, class ELEM>
MemberAccess<OBJ,ELEM>::MemberAccess( UINT8 		i_nMemberId,
									  ELEM OBJ::*	i_pMember,
									  bool          i_bIsValid )
	:	// aData,
		pMember(i_pMember)
{
	aData.nMemberId = i_nMemberId;
	aData.pNext = 0;
	aData.bIsValid = i_bIsValid;
}

template<class OBJ, class ELEM>
const ELEM &
MemberAccess<OBJ,ELEM>::operator()(const OBJ & i_rObj) const
{
	return i_rObj.*pMember;
}

template<class OBJ, class ELEM>
ELEM &
MemberAccess<OBJ,ELEM>::operator()(OBJ & i_rObj) const
{
	return i_rObj.*pMember;
}

template<class OBJ, class ELEM>
void
MemberAccess<OBJ,ELEM>::operator()( MemberVisitor & io_rVisitor,
									Reflected &	  	io_rObj ) const
{
	// KORR
	assert(false);

//	PerformVisit( io_rVisitor, io_rObj.*pMember );
}

template<class OBJ, class ELEM>
void
MemberAccess<OBJ,ELEM>::SerialWrite( SerialDevice &	   o_rDest,
									 const Reflected & i_rObj ) const
{
	const OBJ & rObj = dynamic_cast<OBJ&>(const_cast<Reflected&>(i_rObj));
	Serialize(o_rDest,rObj.*pMember);
}

template<class OBJ, class ELEM>
void
MemberAccess<OBJ,ELEM>::SerialRead( SerialDevice & io_rSrc,
									Reflected &    o_rObj ) const
{
	OBJ & rObj = dynamic_cast<OBJ&>(o_rObj);
	Deserialize(io_rSrc,rObj.*pMember);
}

template<class OBJ, class ELEM>
const S_Accessor_Data &
MemberAccess<OBJ,ELEM>::Data() const
{
	return aData;
}

template<class OBJ, class ELEM>
S_Accessor_Data &
MemberAccess<OBJ,ELEM>::Data()
{
	return aData;
}




#endif

