/*************************************************************************
 *
 *  $RCSfile: hfi_globalindex.cxx,v $
 *
 *  $Revision: 1.2.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "hfi_globalindex.hxx"


// NOT FULLY DEFINED SERVICES
#include <string.h>
#include <algorithm>
#include "hfi_cetitle.hxx"

#ifdef UNX
#define stricmp strcasecmp
#endif

#ifdef SOLARIS
#include <ctype.h>
#endif

udmstri G_sDummy;
uintt   G_nDummy;



struct S_LessStr
{
  bool  operator()( const udmstri & s1,
                    const udmstri & s2 )
                    {
                        // The '+1' is due to the fact, that the first letter
                        //   gives type information.
                        // See at StoreString().
                        return stricmp( s1.c_str() + 1, s2.c_str() + 1 ) < 0;
                    }
};


const char *    sTypeNames[HF_IdlGlobalIndex::t_MAX ] =
                    { "service ", "interface ", "struct ", "exception ", "enum ",
                      "typedef ", "constants group ", "property ", "method ", "field ",
                      "value ", "constant "
                    };
const char *    sOwnerNames[HF_IdlGlobalIndex::t_MAX ] =
                    { "module ", "module ", "module ", "module ", "module ",
                      "module ", "module ", "service ", "interface ", "struct ",
                      "enum ", "constants group "
                    };
const char C_cSplit = '#';


const char C_cAlphabet[] =
"<a class=\"inverse\" href=\"index-1.html\"><B>A</B></a> <a class=\"inverse\" href=\"index-2.html\"><B>B</B></a> <a class=\"inverse\" href=\"index-3.html\"><B>C</B></a> <a class=\"inverse\" href=\"index-4.html\"><B>D</B></a> <a class=\"inverse\" href=\"index-5.html\"><B>E</B></a> "
"<a class=\"inverse\" href=\"index-6.html\"><B>F</B></a> <a class=\"inverse\" href=\"index-7.html\"><B>G</B></a> <a class=\"inverse\" href=\"index-8.html\"><B>H</B></a> <a class=\"inverse\" href=\"index-9.html\"><B>I</B></a> <a class=\"inverse\" href=\"index-10.html\"><B>J</B></a> "
"<a class=\"inverse\" href=\"index-11.html\"><B>K</B></a> <a class=\"inverse\" href=\"index-12.html\"><B>L</B></a> <a class=\"inverse\" href=\"index-13.html\"><B>M</B></a> <a class=\"inverse\" href=\"index-14.html\"><B>N</B></a> <a class=\"inverse\" href=\"index-15.html\"><B>O</B></a> "
"<a class=\"inverse\" href=\"index-16.html\"><B>P</B></a> <a class=\"inverse\" href=\"index-17.html\"><B>Q</B></a> <a class=\"inverse\" href=\"index-18.html\"><B>R</B></a> <a class=\"inverse\" href=\"index-19.html\"><B>S</B></a> <a class=\"inverse\" href=\"index-20.html\"><B>T</B></a> "
"<a class=\"inverse\" href=\"index-21.html\"><B>U</B></a> <a class=\"inverse\" href=\"index-22.html\"><B>V</B></a> <a class=\"inverse\" href=\"index-23.html\"><B>W</B></a> <a class=\"inverse\" href=\"index-24.html\"><B>X</B></a> <a class=\"inverse\" href=\"index-25.html\"><B>Y</B></a> "
"<a class=\"inverse\" href=\"index-26.html\"><B>Z</B></a>";



HF_IdlGlobalIndex::HF_IdlGlobalIndex(HtmlEnvironment & io_rEnv )
    :   HtmlFactory(io_rEnv),
        aText(2000)
{
    for ( int i = 0; i < C_nDataSize; ++i )
    {
        aData[i].reserve(200);
    }  // end for
}

HF_IdlGlobalIndex::~HF_IdlGlobalIndex()
{
}

void
HF_IdlGlobalIndex::Produce_Page( Xml::Element & o_rOut,
                                 char           i_cLetter )
{
    Out().Enter(o_rOut);
    cCurLetter = i_cLetter;

    Produce_Impl();


    CurOut() << new Html::HorizontalLine;
    Out().Leave();
}

void
HF_IdlGlobalIndex::Add_Service( const udmstri & i_sName )
{
    StoreString( i_sName, t_service );
}

void
HF_IdlGlobalIndex::Add_Interface( const udmstri & i_sName )
{
    StoreString( i_sName, t_interface );
}

void
HF_IdlGlobalIndex::Add_Struct( const udmstri & i_sName )
{
    StoreString( i_sName, t_struct );
}

void
HF_IdlGlobalIndex::Add_Exception( const udmstri & i_sName )
{
    StoreString( i_sName, t_exception );
}

void
HF_IdlGlobalIndex::Add_Function( const udmstri & i_sName )
{
    StoreString( i_sName, t_function, true );
}

void
HF_IdlGlobalIndex::Add_StructElement( const udmstri & i_sName )
{
    StoreString( i_sName, t_structelement, true );
}

void
HF_IdlGlobalIndex::Add_Property( const udmstri & i_sName )
{
    StoreString( i_sName, t_property, true );
}

void
HF_IdlGlobalIndex::Add_Enum( const udmstri & i_sName )
{
    StoreString( i_sName, t_enum );
}

void
HF_IdlGlobalIndex::Add_Typedef( const udmstri & i_sName )
{
    StoreString( i_sName, t_typedef );
}

void
HF_IdlGlobalIndex::Add_ConstantsGroup( const udmstri & i_sName )
{
    StoreString( i_sName, t_constantsgroup );
}

void
HF_IdlGlobalIndex::Add_Constant( const udmstri & i_sName )
{
    StoreString( i_sName, t_constant, true );
}

void
HF_IdlGlobalIndex::Add_EnumValue( const udmstri & i_sName )
{
    StoreString( i_sName, t_enumvalue, true );
}

void
HF_IdlGlobalIndex::StoreString( const udmstri &     i_sName,
                                E_Types             i_eType,
                                bool                i_bUseOwner )
{
    aText.seekp(0);

    aText << char('A'+char(i_eType));

    aText   << i_sName
            << C_cSplit
            << sCurModule;
    if (i_bUseOwner)
    {
        aText << "*"
              << sCurOwner;
    }

    int nBegin = tolower(aText.c_str()[1]);
    if (nBegin >= 'a' AND nBegin <= 'z')
        aData[nBegin-'a'].push_back(aText.c_str());
    else
        aData[C_nIndexUnderscore].push_back(aText.c_str());
}

void
HF_IdlGlobalIndex::Produce_Impl() const
{
    Page &      rLetter = aData[
                        (cCurLetter != '_' ? cCurLetter-'a' : C_nIndexUnderscore)
                           ];
    S_LessStr   aLess;
    std::sort( rLetter.begin(), rLetter.end(), aLess );

    HF_CeTitle  aTitle(CurOut());
    aTitle.Produce_Index( cCurLetter );

    // Letters Index
    CurOut()
        << new Xml::XmlCode(


            "<p align=\"center\"><a href=\"index-1.html\"><b>A</b></a> <a href=\"index-2.html\"><b>B</b></a> <a href=\"index-3.html\"><b>C</b></a> <a href=\"index-4.html\"><b>D</b></a> <a href=\"index-5.html\"><b>E</b></a> <a href=\"index-6.html\"><b>F</b></a> <a href=\"index-7.html\"><b>G</b></a> <a href=\"index-8.html\"><b>H</b></a> <a href=\"index-9.html\"><b>I</b></a> <a href=\"index-10.html\"><b>J</b></a>"
            " <a href=\"index-11.html\"><b>K</b></a> <a href=\"index-12.html\"><b>L</b></a> <a href=\"index-13.html\"><b>M</b></a> <a href=\"index-14.html\"><b>N</b></a> <a href=\"index-15.html\"><b>O</b></a> <a href=\"index-16.html\"><b>P</b></a> <a href=\"index-17.html\"><b>Q</b></a> <a href=\"index-18.html\"><b>R</b></a> <a href=\"index-19.html\"><b>S</b></a> <a href=\"index-20.html\"><b>T</b></a>"
            " <a href=\"index-21.html\"><b>U</b></a> <a href=\"index-22.html\"><b>V</b></a> <a href=\"index-23.html\"><b>W</b></a> <a href=\"index-24.html\"><b>X</b></a> <a href=\"index-25.html\"><b>Y</b></a> <a href=\"index-26.html\"><b>Z</b></a> <a href=\"index-27.html\"><b>_</b></a></p>" );

    StreamLock  slText(1000);
    StreamStr & aText = slText();

    StreamLock  slScope(1000);
    StreamStr & aScope = slScope();


    Page::iterator itEnd = rLetter.end();
    for ( Page::iterator iter = rLetter.begin();
          iter != itEnd;
          ++iter )
    {
        aText.seekp(0);
        aText << "<DT><A HREF=\"";
        aScope.seekp(0);

        int nType =  int(* (*iter).c_str()) - int('A');
        const char * pEntry = (*iter).c_str() + 1;
        const char * pSplit = strchr( pEntry,C_cSplit);
        const char * pOwnerSplit = strchr( pEntry,'*');
        if (pSplit == 0)
            continue;   // Should not be reached.

        const char * pModule = pSplit + 1;
        const char * pOwner  = pOwnerSplit != 0
                                    ?   pOwnerSplit + 1
                                    :   0;

        String sName(pEntry, pSplit - pEntry );

        if (pOwner == 0)
        {
            Env().Get_RelativeLinkToNamespaceDir(aScope,pModule);
            aScope.pop_back(1);
            const char *
                pFirst = aScope.c_str() + 3;
            const char *
                pLast = strrchr(pFirst,'/');
            if (pLast == '\0')
            {
                pLast = "Global Namespace";
                pFirst = "";
            }
            else
            {
                aScope[pLast-aScope.c_str()] = '\0';
                ++pLast;
            }
            aScope.replace_all('/','.');

            Env().Get_Link2Type( aText, pModule, sName );

                aText << "\">"
                  << "<B>" << sName << "</B></A> - \n"
                  << sTypeNames[nType]
                  << "in module "
                  << pFirst << ".<A NAME=\"\">" << pLast << "</A>"
//                << " in " << ( (*iter) + nSplit + 1 )
                  << "\n<DD>&nbsp\n";
        }
        else
        {
            String sModule( pModule, pOwnerSplit - pModule );
            Env().Get_RelativeLinkToNamespaceDir(aScope,sModule);
            aScope.replace_all('/','.');
            aScope.pop_front(3);
            aScope.pop_back(1);

            Env().Get_Link2Member( aText, sModule, pOwner, sName );

            aText << "\">"
                  << "<B>" << sName << "</B></A> - \n"
                  << sTypeNames[nType] << "in ";
                  if ( nType == t_structelement
                       AND strstr(pOwner,"xcept") != 0 )
                     aText << "exception ";
                  else
                     aText << sOwnerNames[nType];
            aText << aScope.c_str()
                  << ".<A NAME=\"\">" << pOwner << "</A>"
//                << " in " << ( (*iter) + nSplit + 1 )
                  << "\n<DD>&nbsp\n";
        }
        CurOut() << new Xml::XmlCode(aText.c_str());
    }   // end for
}



