/*************************************************************************
 *
 *  $RCSfile: di_summy.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "di_summy.hxx"


// NOT FULLY DEFINED SERVICES
#include <csi/l_uidl/function.hxx>
#include <csi/l_uidl/struelem.hxx>
#include <csi/l_uidl/attrib.hxx>
#include <csi/l_uidl/enumvalu.hxx>
#include <csi/l_uidl/constant.hxx>
#include <ary_i/codeinf2.hxx>



namespace display
{
namespace dsapi
{


Summary::Summary( const char *    		 i_sTitle,
				  const S_ActiveModule & i_rCurModule,
				  const char *           i_sTableWidthPercent,
				  bool                   i_bBig )
	:	HtmlDisplay_Impl(i_rCurModule),
		sTitle(i_sTitle),
		nContentsCount(0),
		pTable(0),
		sTableWidthPercent(i_sTableWidthPercent),
        bBig(i_bBig)
{
	Init(i_rCurModule);

	DYN Html_TableRow * dpTitleRow = new Html_TableRow;
	dpTitleRow->AddCell( new Html_TableCell(
								*new Html_AnyTag( *new Html_AnyTag( TextOH(i_sTitle),"B"),"H3", C_sStyleInverse ),
								"BGCOLOR=\"#666699\" COLSPAN=2" )
					   );
	pTable->AddRow(dpTitleRow);
}

Summary::~Summary()
{
}

void
Summary::Display_Function( const Function &			i_rData,
						   const CodeInformation *  i_pDocu )
{
	AddSummary(i_rData.Name(), i_pDocu);
}

void
Summary::Display_Attribute( const Attribute &		i_rData,
							const CodeInformation * i_pDocu )
{
	AddSummary(i_rData.Name(), i_pDocu);
}

void
Summary::Display_StructElement( const StructElement & 	i_rData,
								const CodeInformation * i_pDocu  )
{
	AddSummary(i_rData.Name(), i_pDocu);
}

void
Summary::Display_Constant(	const Constant & 		i_rData,
							const CodeInformation * i_pDocu )
{
	AddSummary(i_rData.Name(), i_pDocu);
}

void
Summary::Display_EnumValue(	const EnumValue &		i_rData,
							const CodeInformation * i_pDocu  )
{
	AddSummary(i_rData.Name(), i_pDocu);
}

void
Summary::Display_InterfaceExport( ary::Cei					i_nIfc,
								  const CodeInformation *   i_rExportDocu )
{
	if (i_nIfc == 0)
		return;

	nContentsCount++;

	Destination().AddData( *FullNameTypeLink(i_nIfc) );
	if (i_rExportDocu != 0)
	{
		if (i_rExportDocu->IsOptional())
			Destination().AddData( TextOH("  [ OPTIONAL ]") );
	}
	Destination().AddData( TextWH("<DL><DD>\n") );
	DisplayInformationParagraphs( i_rExportDocu );
	Destination().AddData( TextWH("</DD></DL>\n") );
	Destination().AddData( TextWH("<HR>\n") );
}

void
Summary::Init(const S_ActiveModule & i_rCurModule)
{
	HtmlDisplay_Impl::Init(i_rCurModule);
	nContentsCount = 0;
	pTable = & CreateTable(sTableWidthPercent);
	Destination().AddData(*pTable);
}

void
Summary::AddDivider()
{
	DYN Html_TableRow * dpRow = new Html_TableRow;
	dpRow->AddCell( new Html_TableCell(
								*new Html_HorizontalLine(""),
								" COLSPAN=2" )
					   );
	pTable->AddRow(dpRow);
}

void
Summary::AddSummary( const char *		     i_sName,
					 const CodeInformation * i_pDocu )
{
	nContentsCount++;

	DYN Html_TableRow * dpRow = new Html_TableRow;
	dpRow->AddCell( new Html_TableCell(
								LocalLink(i_sName),
								"width=30%" ) );

	if (i_pDocu != 0)
	{
		DYN Html_MultiPiece * dpShort = new Html_MultiPiece;
		DisplayShort(*dpShort, i_pDocu->Short());

		dpRow->AddCell(	new Html_TableCell(
								*dpShort,
								"width=70%" ) );
	}

	pTable->AddRow(dpRow);

	if (bBig)
		AddDivider();
}


}   // namespace dsapi
}   // namespace display

