/*************************************************************************
 *
 *  $RCSfile: di_linkg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "di_linkg.hxx"


// NOT FULLY DEFINED SERVICES
#include <ary_i/uidl/cenamesp.hxx>
#include <ary_i/codeinf2.hxx>
#include <csi/l_uidl/service.hxx>
#include <csi/l_uidl/intrface.hxx>
#include <csi/l_uidl/struct.hxx>
#include <csi/l_uidl/except.hxx>
#include <csi/l_uidl/enum.hxx>
#include <csi/l_uidl/typedef.hxx>
#include <csi/l_uidl/constant.hxx>



namespace display
{
namespace dsapi
{

GlobalLinkEntry::~GlobalLinkEntry()
{
}

void
GlobalLinkEntry::Display_Module( const ary::uidl::CeNamespace & i_rData,
								 const CodeInformation *        i_pDocu )
{
	static StreamStr  aLink(500);
	aLink.seekp(0);
	aLink << i_rData.Name() << "/module-ix.html";

	pRow->AddCell( new Html_TableCell(
								Create_TextLink(
									i_rData.Name(),
									aLink.c_str() ),
								"width=30%" ) );
	if (i_pDocu != 0)
	{
		DYN Html_MultiPiece * dpShort = new Html_MultiPiece;
		DisplayShort(*dpShort, i_pDocu->Short());
		pRow->AddCell(	new Html_TableCell(
										*dpShort,
								        "width=70%" ) );
	}
}

void
GlobalLinkEntry::Display_Service( const Service &		  i_rData,
								  const CodeInformation * i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_Interface( const Interface & 		i_rData,
									const CodeInformation * i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_Struct( const Struct &			 i_rData,
								 const CodeInformation * i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_Exception( const Exception &		i_rData,
									const CodeInformation * i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_Enum( const Enum &				i_rData,
							   const CodeInformation *  i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_Typedef( const Typedef &			i_rData,
								  const CodeInformation *   i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::Display_ConstantsGroup( const ConstantsGroup &		i_rData,
										 const CodeInformation *    i_pDocu )
{
	ShowLinkLine( i_rData.Name(), i_pDocu);
}

void
GlobalLinkEntry::ShowLinkLine( const char *				i_sName,
							   const CodeInformation *  i_pDocu )
{
	static StreamStr  aLink(500);
	aLink.seekp(0);
	aLink << i_sName << ".html";

	pRow->AddCell( new Html_TableCell(
								Create_TextLink(
									i_sName,
									aLink.c_str() ),
								"width=30%" ) );
	if (i_pDocu != 0)
	{
		DYN Html_MultiPiece * dpShort = new Html_MultiPiece;
		DisplayShort(*dpShort, i_pDocu->Short());
		pRow->AddCell(	new Html_TableCell(
										*dpShort,
								        "width=70%" ) );
	}
}


}   // namespace dsapi
}   // namespace display

