/*************************************************************************
 *
 *  $RCSfile: di_head.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADC_DISPLAY_DI_HEAD_HXX
#define ADC_DISPLAY_DI_HEAD_HXX



// USED SERVICES
	// BASE CLASSES
#include <display/uidldisp.hxx>
#include "dht_impl.hxx"
	// COMPONENTS
	// PARAMETERS


class CorporateFrame;

namespace display
{
namespace dsapi
{

struct S_ActiveModule;


class FileHeader : public DefaultedDisplay,
				   public HtmlDisplay_Impl
{
  public:
						FileHeader(
							const CorporateFrame &
												i_rFrame,
							const S_ActiveModule &
												i_rModule );
	virtual				~FileHeader();


	virtual void	  	Display_Module(
							const ary::uidl::CeNamespace &
												i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Service(
							const Service &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Interface(
							const Interface & 	i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Struct(
							const Struct &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Exception(
							const Exception &	i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Enum(
							const Enum &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_Typedef(
							const Typedef &		i_rData,
							const CodeInformation *
												i_rDocu );
	virtual void	  	Display_ConstantsGroup(
							const ConstantsGroup &
												i_rData,
							const CodeInformation *
												i_rDocu );

  private:
	void				AddLogo(
							Html_MultiPiece &	o_rTop );
	void				AddLine1(
							Html_MultiPiece &
												o_rTop,
							const char *		i_sObjectType,
							const char *		i_sObjectName );
	void				CompleteTop(
							DYN Html_MultiPiece &
												let_drTop );
	void				WriteModuleHierarchyWithLinks(
							Html_MultiPiece &	o_pDest,
							bool				i_bLeaveOutCurModule);

	const CorporateFrame *
						pFrame;
	const S_ActiveModule *
						pModule;
};


}   // namespace dsapi
}   // namespace display

#endif

