/*************************************************************************
 *
 *  $RCSfile: di_glbix.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADC_DISPLAY_DI_GLBIX_HXX
#define ADC_DISPLAY_DI_GLBIX_HXX



// USED SERVICES
	// BASE CLASSES
#include <display/uidldisp.hxx>
#include "dht_impl.hxx"
	// COMPONENTS
	// PARAMETERS



namespace display
{
namespace dsapi
{


class GlobalIndex_Docu
{
  public:
	enum E_Types
	{
		t_service 			= 0,
		t_interface 		= 1,
		t_struct			= 2,
		t_exception			= 3,
		t_enum				= 4,
		t_typedef			= 5,
		t_constantsgroup	= 6,
		t_property			= 7,
		t_function			= 8,
		t_structelement		= 9,
		t_enumvalue			= 10,
		t_constant			= 11,
		t_MAX
	};


						GlobalIndex_Docu();
	virtual				~GlobalIndex_Docu();

	void				WriteOut(
							Html_MultiPiece & 	o_rOut,
							char			    i_cLetter );

	void                SetCurModule(
							const udmstri &		i_sFullName )
												{ sCurModule = i_sFullName; }
	void                SetCurOwner(
							const udmstri &		i_sName )
												{ sCurOwner = i_sName; }
	void	  			Add_Service(
							const udmstri &		i_sName );
	void	  			Add_Interface(
							const udmstri &		i_sName );
	void	  			Add_Struct(
							const udmstri &		i_sName );
	void	  			Add_Function(
							const udmstri &		i_sName );
	void	  			Add_StructElement(
							const udmstri &		i_sName );
	void	  			Add_Exception(
							const udmstri &		i_sName );
	void	  			Add_Property(
							const udmstri &		i_sName );
	void	  			Add_Enum(
							const udmstri &		i_sName );
	void	  			Add_Typedef(
							const udmstri &		i_sName );
	void	  			Add_ConstantsGroup(
							const udmstri &		i_sName );
	void	  			Add_Constant(
							const udmstri &		i_sName );
	void	  			Add_EnumValue(
							const udmstri &		i_sName );


  private:
	typedef StringVector	Entry;

	void				StoreString(
							const udmstri &		i_sName,
							E_Types				i_eType,
							bool				i_bUseOwner = false );

	// DATA
	StreamStr			aText;
	udmstri 			sCurModule;
	udmstri 			sCurOwner;

	Entry				aData[26];
};


}   // namespace dsapi
}   // namespace display

#endif

