/*************************************************************************
 *
 *  $RCSfile: di_docu.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "di_docu.hxx"


// NOT FULLY DEFINED SERVICES
#include <csi/d_sapi/d_token.hxx>
#include <ary_i/uidl/gate.hxx>
#include <ary_i/uidl/cenamesp.hxx>



namespace display
{
namespace dsapi
{


static StreamStr G_aLink(1020);

DocuDisplay::~DocuDisplay()
{
}

void
DocuDisplay::Display_TextToken( const csi::dsapi::DT_TextToken & i_rToken )
{
	if (bGatherLink)
	{
		if (sLinkToken.length() == 0)
		{
			sLinkToken = i_rToken.GetText();
            return;
		}
		else
		{
			Cerr() << "Error in documentation: Too many or too few tokens for a link in <member> or <type>." << Endl();
			Cerr() << "  Link won't be created, but all tokens shown plain." << Endl();
			Destination().AddData( TextWH(" ") );
			Destination().AddData( TextWH(sLinkToken) );
			StopLinkGathering();
		}
	}	// endif (bGatherLink)

	Destination().AddData( TextWH(" ") );
	Destination().AddData( TextWH(i_rToken.GetText()) );
}

void
DocuDisplay::Display_MupType( const csi::dsapi::DT_MupType & i_rToken )
{
	if (i_rToken.IsBegin())
	{
		StartLinkGathering(i_rToken.Scope());
	}
	else
	{
		if (bGatherLink)
		{
			Destination().AddData( TextWH(" ") );
			Destination().AddData( CreateTypeLink() );
			StopLinkGathering();
		}
	}
}

void
DocuDisplay::Display_MupMember( const csi::dsapi::DT_MupMember & i_rToken )
{
	if (i_rToken.IsBegin())
	{
		StartLinkGathering(i_rToken.Scope());
	}
	else
	{
		if (bGatherLink)
		{
			Destination().AddData( TextWH(" ") );
			Destination().AddData( CreateMemberLink() );
			StopLinkGathering();
		}
	}
}

void
DocuDisplay::Display_MupConst( const csi::dsapi::DT_MupConst & i_rToken )
{
	Destination().AddData( TextWH(" ") );
	Destination().AddData( *new Html_AnyTag( TextWH(i_rToken.GetText()),"B" ) );
}

void
DocuDisplay::Display_Style( const csi::dsapi::DT_Style & i_rToken )
{
	Destination().AddData( TextWH(i_rToken.GetText()) );
}

void
DocuDisplay::Display_EOL()
{
	Destination().AddData( TextWH("\n") );
}

void
DocuDisplay::Display_StdAtTag( const csi::dsapi::DT_StdAtTag & i_rToken )
{
    if ( i_rToken.Text().IsEmpty() )
        return;

	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH(i_rToken.Title()),"H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;

	DocuDisplay  aSubDisplay(CurModule());
	i_rToken.Text().DisplayAt(aSubDisplay);
	aSubDisplay.Release(*dpText);

	dpDefList->AddDefinition( *dpText );
	Destination().AddData( *dpDefList );
}

void
DocuDisplay::Display_SeeAlsoAtTag( const csi::dsapi::DT_SeeAlsoAtTag & i_rToken )
{
	DYN Html_DefList * dpDefList = new Html_DefList;
	dpDefList->AddTerm( *new Html_AnyTag( TextOH("See also"),"H4") );

	udmstri sLinkText = i_rToken.LinkText();

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;

	DocuDisplay  aSubDisplay(CurModule());
	i_rToken.Text().DisplayAt(aSubDisplay);
	aSubDisplay.Release(*dpText);

	dpDefList->AddDefinition( CreateLinkToBeFound(sLinkText) );
	dpDefList->AddDefinition( *dpText );
	Destination().AddData( *dpDefList );
}

void
DocuDisplay::Display_ParameterAtTag( const csi::dsapi::DT_ParameterAtTag & i_rToken )
{
	DYN Html_DefList * dpDefList = new Html_DefList;
    StreamLock sParam(50);
	dpDefList->AddTerm( *new Html_AnyTag( TextOH( sParam() << "Parameter "
                                                           << i_rToken.Title()
                                                           << c_str ),
                                          "H4") );

	DYN Html_MultiPiece * dpText = new Html_MultiPiece;

	DocuDisplay  aSubDisplay(CurModule());
	i_rToken.Text().DisplayAt(aSubDisplay);
	aSubDisplay.Release(*dpText);

	dpDefList->AddDefinition( *dpText );
	Destination().AddData( *dpDefList );
}

DYN HtmlPiece &
DocuDisplay::CreateTypeLink()
{
	uintt nUsedTokens = 0;

	ary::uidl::CeNamespace * pNsp = GetNamespace(nUsedTokens,sScope);
	return CreateTypeLinkFromNsp(pNsp, sLinkToken);
}

DYN HtmlPiece &
DocuDisplay::CreateMemberLink()
{
	const char * pStart = sLinkToken.c_str();
	const char * pTrenner = strstr( pStart, "::" );
	if (pTrenner == 0)
		return TextWH(sLinkToken);

	udmstri sType = sLinkToken.substr(0, pTrenner - pStart);
	udmstri sMember = pTrenner+2;

	uintt nUsedTokens = 0;

	ary::uidl::CeNamespace * pNsp = GetNamespace(nUsedTokens,sScope);
	return CreateMemberLinkFromNsp(pNsp, sType, sMember, sLinkToken );
}

DYN HtmlPiece &
DocuDisplay::CreateTypeLinkFromNsp( ary::uidl::CeNamespace * i_pNsp,
									const udmstri &          i_sType )
{
	G_aLink.seekp(0);
	if (i_pNsp != 0)
	{
		i_pNsp->GetFullName(G_aLink,"/");
		G_aLink << "/";
		G_aLink << i_sType << ".html";
		return Create_TextLink( i_sType, RelaLink(Depth(),G_aLink.c_str()) );
	}
	else
	{
		G_aLink << i_sType << ".html";
		return Create_TextLink( i_sType, G_aLink.c_str() );
	}
}

DYN HtmlPiece &
DocuDisplay::CreateMemberLinkFromNsp( ary::uidl::CeNamespace * i_pNsp,
									  const udmstri &		   i_sType,
									  const udmstri &		   i_sMember,
									  const char *			   i_sText2Show	 )
{
	StreamLock sMember(50);
    sMember() << i_sMember;
	if ( strchr(sMember().c_str(),'(') != 0 )
    	sMember().pop_back(2);

	G_aLink.seekp(0);
	if (i_pNsp != 0)
	{
		i_pNsp->GetFullName(G_aLink,"/");
		G_aLink << "/";
		G_aLink << i_sType << ".html#" << sMember().c_str();
		return Create_TextLink( i_sText2Show, RelaLink(Depth(),G_aLink.c_str()) );
	}
	else
	{
		G_aLink << i_sType << ".html#" << sMember().c_str();
		return Create_TextLink( i_sText2Show, G_aLink.c_str() );
	}
}


DYN HtmlPiece &
DocuDisplay::CreateLinkToBeFound( const udmstri & i_sLinkText )
{
	StreamLock 	slText(100);
    StreamStr & sText = slText();
    sText << i_sLinkText;

    const char * cTrenner = "#";
    sText.replace_all("::",cTrenner);

	uintt nTokens = sText.token_count(*cTrenner);
	uintt nNspTokens = 0;
	ary::uidl::CeNamespace * pNsp = GetNamespace(nNspTokens, i_sLinkText);

	switch (nTokens - nNspTokens)
	{
		case 2:
					return CreateMemberLinkFromNsp(
											 pNsp,
											 sText.token( nNspTokens, *cTrenner ),
											 sText.token( nNspTokens+1, *cTrenner ),
											 i_sLinkText );
		case 1:
					return CreateTypeLinkFromNsp(
										   pNsp,
					                       sText.token(nNspTokens, *cTrenner) );
		default:
					return TextWH(i_sLinkText);
	}
}

ary::uidl::CeNamespace *
DocuDisplay::GetNamespace(	uintt &				o_nNrOfTokensUsed,
							const udmstri &		i_rScope )
{
	if (i_rScope.length() == 0 OR strcmp(i_rScope.c_str(), "::") == 0 )
		return 0;

	ary::uidl::CeNamespace * pNsp = &GetAryGate().GlobalNamespace();
	StreamLock slScope(100);
    StreamStr & sScope = slScope();
    sScope << i_rScope;

    const char * cTrenner = "#";
	sScope.replace_all("::",cTrenner);

	uintt nMax = sScope.token_count(*cTrenner);

	for ( o_nNrOfTokensUsed = 0; o_nNrOfTokensUsed < nMax; ++o_nNrOfTokensUsed )
	{
		udmstri sPart = sScope.token( o_nNrOfTokensUsed, *cTrenner );
		ary::uidl::CeNamespace * pSub = pNsp->SubNamespace(sPart);
		if (pSub != 0)
			pNsp = pSub;
		else
		{
			break;
		}
	}

	if (pNsp == &GetAryGate().GlobalNamespace())
		return 0;
	else
		return pNsp;
}


}   // namespace dsapi
}   // namespace display

