/*************************************************************************
 *
 *  $RCSfile: dht_impl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ADC_DISPLAY_DHT_IMPL_HXX
#define ADC_DISPLAY_DHT_IMPL_HXX



// USED SERVICES
	// BASE CLASSES
#include <csi/dis_html/htmlpie2.hxx>
	// COMPONENTS
	// PARAMETERS
#include "didl_def.hxx"
#include <ary_i/cei.hxx>


namespace ary
{
namespace info
{
class CodeInformation;
class DocuTex2;
class DocuToken;
}   // namespace info
}   // namespace ary

namespace ary
{
namespace uidl
{
    class Gate;
}
}



class Html_MultiPiece;
class HtmlPiece;

namespace display
{
namespace dsapi
{

class UnoApiDocuFile;
struct S_ActiveModule;


class HtmlDisplay_Impl
{
  public:
						~HtmlDisplay_Impl();

	virtual void		Init(
							const S_ActiveModule &
												i_rCurModule );
	void	   			Release(
							Html_MultiPiece &	o_rReceiver	);

	const udmstri &		DisplayCe(
							csi::uidl::Display &
												o_rDisplay,
							ary::Cei		   	i_nCeId );

	Html_MultiPiece &	Destination()			{ csv_assert(dpData != 0); return *dpData; }
	void                DisplayInformationParagraphs(
							const ary::info::CodeInformation *
												i_pDocu );

  protected:
						HtmlDisplay_Impl(
							const S_ActiveModule &
												i_rCurModule );
						HtmlDisplay_Impl(
							const S_ActiveModule *
												i_pCurModule );
	const S_ActiveModule &
						CurModule() const		{ return *pCurModule; }
	uintt				Depth() const;

	DYN HtmlPiece * 	FullNameTypeLink(
							ary::Cei			i_nType );

	const char *        FullTypeName(
							ary::Cei			i_nTypeId,
							bool *				o_bIsPredefined = 0 );
	const char *        TypeLink(
							ary::Cei			i_nTypeId );

	DYN Html_Link &		LocalLink(
							const char *		i_sName );
	DYN Html_Table &	CreateTable(
							const char *		i_sWidth = "100%" );
	void				DisplayShort(
							Html_MultiPiece &	o_rDestination,
							const ary::info::DocuTex2 &
												i_rDocu );
	void				DisplayDescription(
							Html_MultiPiece &	o_rDestination,
							const ary::info::DocuTex2 &
												i_rDocu );
  private:
	// DATA
	DYN Html_MultiPiece *
						dpData;
	const S_ActiveModule *
						pCurModule;
};

}   // namespace dsapi
}   // namespace display



class Html_Inverse : public HtmlPiece
{
  public:
						Html_Inverse(
							DYN HtmlPiece &		let_drInhalt,
							const udmstri		i_sBgColor );
						~Html_Inverse();
	virtual void		WriteOut(
							csv::File &			io_aFile );
  private:
	DYN HtmlPiece *		dpInhalt;
	udmstri				sBgColor;
	udmstri				sColor;
};

const char *
RelaLink( uintt 		nDepth,
		  const char *  i_sRootPath );


ary::uidl::Gate &	GetAryGate();


const char C_sStyleInverse[]	= "class=\"inverse\"";
const char C_sStyleInverseBig[] = "class=\"inversebig\"";
const char C_sMemberLink[]      = "class=\"memberlink\"";

#endif

