/*************************************************************************
 *
 *  $RCSfile: gate_i.cxx,v $
 *
 *  $Revision: 1.2.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:01:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include <uidl/gate_i.hxx>


// NOT FULLY DEFINED SERVICES
#include <csi/prl/quname2.hxx>
#include <uidl/namesp_i.hxx>
#include <csi/l_uidl/service.hxx>
#include <csi/l_uidl/property.hxx>
#include <csi/l_uidl/intrface.hxx>
#include <csi/l_uidl/function.hxx>
#include <csi/l_uidl/attrib.hxx>
#include <csi/l_uidl/struct.hxx>
#include <csi/l_uidl/struelem.hxx>
#include <csi/l_uidl/except.hxx>
#include <csi/l_uidl/enum.hxx>
#include <csi/l_uidl/enumvalu.hxx>
#include <csi/l_uidl/typedef.hxx>
#include <csi/l_uidl/constant.hxx>
#include <uidl/spece.hxx>
#include <adc_cl.hxx>




namespace ary
{
namespace uidl
{


namespace
{


class ReConnect_Interface2Service
{
  public:
	typedef std::map< Cei, DYN SCE_Service * >		    Root_Services;
	typedef std::map< Cei, DYN SCE_Interface * >		Root_Interfaces;

                        ReConnect_Interface2Service(
                            Root_Interfaces &   i_rInterfacesToUpdate )
                            :   rInterfacesToUpdate(i_rInterfacesToUpdate) {}

    void                operator()(
                            const Root_Services::value_type &
                                                i_rService ) const;
  private:
    SCE_Interface *     Get_Parent(
                            const SCE_Interface &   i_rChild ) const;

    typedef csi::uidl::Service::CommentedLinkList  IfcLinkList;

    Root_Interfaces &   rInterfacesToUpdate;
};

inline SCE_Interface *
ReConnect_Interface2Service::Get_Parent( const SCE_Interface & i_rChild ) const
{
    uintt nParentId = i_rChild.Client().Base().Id();
    if (nParentId != 0)
    {
        SCE_Interface * ret = rInterfacesToUpdate[nParentId];
        if (ret != 0)   // should be true
        {
            // KORR_FUTURE : make this command line dependant.
         	if ( strcmp(ret->Client().Name().c_str(), "XInterface") != 0 )
            {
             	return ret;
            }
        }
    }
    return 0;
}

void
ReConnect_Interface2Service::operator()( const Root_Services::value_type & i_rService ) const
{
    Cei                 nServiceId = i_rService.first;
    const IfcLinkList & rInterfaces = i_rService.second->Client().ServedInterfaces();

    for ( IfcLinkList::const_iterator it = rInterfaces.begin();
          it != rInterfaces.end();
          ++it )
    {
        for ( SCE_Interface * pIfc = rInterfacesToUpdate[(*it).first];
              pIfc != 0;
              pIfc = Get_Parent(*pIfc) )
        {
     	    pIfc->Client().Data().Add_UsingService(nServiceId);
        }
    }
}

}   // anonymous namespace


const Cei C_nGlobalNamspaceId = 1;

std::map<Cei, Cei>  aSequence2Type;


Gate_Impl::Gate_Impl()
{
	AddNamespace(0, C_nGlobalNamspaceId, "");

	CheckInType(C_nGlobalNamspaceId, "any");
	CheckInType(C_nGlobalNamspaceId, "boolean");
	CheckInType(C_nGlobalNamspaceId, "byte");
	CheckInType(C_nGlobalNamspaceId, "char");
	CheckInType(C_nGlobalNamspaceId, "double");
	CheckInType(C_nGlobalNamspaceId, "float");
	CheckInType(C_nGlobalNamspaceId, "hyper");
	CheckInType(C_nGlobalNamspaceId, "long");
	CheckInType(C_nGlobalNamspaceId, "short");
	CheckInType(C_nGlobalNamspaceId, "string");
	CheckInType(C_nGlobalNamspaceId, "type");
	CheckInType(C_nGlobalNamspaceId, "void");
	CheckInType(C_nGlobalNamspaceId, "unsigned hyper");
	CheckInType(C_nGlobalNamspaceId, "unsigned long");
	CheckInType(C_nGlobalNamspaceId, "unsigned short");
}

Gate_Impl::~Gate_Impl()
{
}

Cei
Gate_Impl::GetNewId()
{
	static Cei nNextFreeId_ = C_nGlobalNamspaceId + 1;

	return nNextFreeId_++;
}

csi::prl::RefNamespace
Gate_Impl::CheckInModule( Cei		   i_nParentId,
						  const char * i_sName )
{
	CeNamespace_Impl * pParent = FindNamespaceImpl(i_nParentId);
	if (pParent == 0)
		return 0;
	else
		return CheckInSubNamespace(*pParent, i_sName)->Id();
}

csi::prl::RefNamespace
Gate_Impl::CheckInModule( const QuName & i_rFullName )
{
	CeNamespace_Impl * ret = &GlobalNamespaceImpl();

	for ( csi::prl::QualifiedName::namespace_iterator iter = i_rFullName.first_namespace();
		  iter != i_rFullName.end();
		  ++iter )
	{
		csv_assert(ret != 0);
		ret = CheckInSubNamespace(*ret, *iter);
	}	// end for
	return ret->Id();
}

csi::prl::RefType
Gate_Impl::CheckInType( Cei					i_nTypeOwner,
						const char *		i_sType )
{
	CeNamespace_Impl * pNsp = FindNamespaceImpl(i_nTypeOwner);
	if (pNsp == 0)
		return 0;

	udmstri sType(i_sType);
	Cei ret = pNsp->FindName(sType);
	if (ret == 0)
	{
		Cei global = GlobalNamespaceImpl().FindName(sType);
		if (global != 0)
        	return global;

		ret = GetNewId();
		aPredeclarations[ret] = Name_n_Nsp(sType,pNsp);
		pNsp->AddName(ret, sType, CeNamespace_Impl::nok_predeclaration);
	}
	return ret;
}

csi::prl::RefType
Gate_Impl::CheckInSequence(	Cei i_nReferedTypeId )
{
	csi::prl::RefType ret = FindSequence(i_nReferedTypeId);
	if (NOT ret)
	{
		Cei   nNewId = GetNewId();
		aSequences[i_nReferedTypeId] = nNewId;
		ret = nNewId;
		aSequence2Type[nNewId] = i_nReferedTypeId;
	}
	return ret;
}

Gate::RService
Gate_Impl::Store_Service( Cei  						i_nOwner,
						  DYN csi::uidl::Service &  let_drService )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetNewId();
	aServices[nNewId] = new SCE_Service(let_drService);
	rNsp.AddName( nNewId, let_drService.Name(), CeNamespace_Impl::nok_service );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aServices[nNewId], &rNsp);
	return nNewId;
}


Gate::RInterface
Gate_Impl::Store_Interface( Cei  						i_nOwner,
							DYN csi::uidl::Interface &  let_drInterface )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetTypeIdForStore(rNsp,let_drInterface.Name());
	aInterfaces[nNewId] = new SCE_Interface(let_drInterface);
	rNsp.AddName( nNewId, let_drInterface.Name(), CeNamespace_Impl::nok_interface );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aInterfaces[nNewId], &rNsp);
	return nNewId;
}

Gate::RStruct
Gate_Impl::Store_Struct( Cei  					 i_nOwner,
						 DYN csi::uidl::Struct & let_drStruct )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetTypeIdForStore(rNsp,let_drStruct.Name());
	aStructs[nNewId] = new SCE_Struct(let_drStruct);
	rNsp.AddName( nNewId, let_drStruct.Name(), CeNamespace_Impl::nok_struct );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aStructs[nNewId], &rNsp);
	return nNewId;
}

Gate::RException
Gate_Impl::Store_Exception( Cei  						i_nOwner,
							DYN csi::uidl::Exception &	let_drException )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetTypeIdForStore(rNsp,let_drException.Name());
	aExceptions[nNewId] = new SCE_Exception(let_drException);
	rNsp.AddName( nNewId, let_drException.Name(), CeNamespace_Impl::nok_exception );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aExceptions[nNewId], &rNsp);
	return nNewId;
}

Gate::REnum
Gate_Impl::Store_Enum( Cei  				 i_nOwner,
					   DYN csi::uidl::Enum & let_drEnum )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetTypeIdForStore(rNsp,let_drEnum.Name());
	aEnums[nNewId] = new SCE_Enum(let_drEnum);
	rNsp.AddName( nNewId, let_drEnum.Name(), CeNamespace_Impl::nok_enum );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aEnums[nNewId], &rNsp);
	return nNewId;
}

Gate::RTypedef
Gate_Impl::Store_Typedef( Cei  						i_nOwner,
						  DYN csi::uidl::Typedef &  let_drTypedef )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetTypeIdForStore(rNsp,let_drTypedef.Name());
	aTypedefs[nNewId] = new SCE_Typedef(let_drTypedef);
	rNsp.AddName( nNewId, let_drTypedef.Name(), CeNamespace_Impl::nok_typedef );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aTypedefs[nNewId], &rNsp);
	return nNewId;
}

Gate::RConstantsGroup
Gate_Impl::Store_ConstantsGroup( Cei  					   		 i_nOwner,
								 DYN csi::uidl::ConstantsGroup & let_drGroup )
{
	CeNamespace_Impl & rNsp = Namespace(i_nOwner);
	Cei nNewId = GetNewId();
	aConstantsGroups[nNewId] = new SCE_ConstantsGroup(let_drGroup);
	rNsp.AddName( nNewId, let_drGroup.Name(), CeNamespace_Impl::nok_constantsgroup );

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aConstantsGroups[nNewId], &rNsp);
	return nNewId;
}


Gate::RConstant
Gate_Impl::Store_Constant( Cei  					 i_nOwner,
						   DYN csi::uidl::Constant & let_drConstant )
{
	Cei nNewId = GetNewId();
	aConstants[nNewId] = ConstantAtGroup(new SCE_Constant(let_drConstant), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aConstants[nNewId].first, 0);
	return nNewId;
}


Gate::RProperty
Gate_Impl::Store_Property( Cei  				 	 i_nOwner,
						   DYN csi::uidl::Property & let_drProperty )
{
	Cei nNewId = GetNewId();
	aProperties[nNewId] = PropertyAtParent(new SCE_Property(let_drProperty), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aProperties[nNewId].first, 0);
	return nNewId;
}

Gate::RFunction
Gate_Impl::Store_Function( Cei  					 i_nOwner,
						   DYN csi::uidl::Function & let_drFunction )
{
	Cei nNewId = GetNewId();
	aFunctions[nNewId] = FunctionAtParent(new SCE_Function(let_drFunction), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aFunctions[nNewId].first, 0);
	return nNewId;
}

Gate::RAttribute
Gate_Impl::Store_Attribute( Cei  						i_nOwner,
							DYN csi::uidl::Attribute &  let_drAttribute )
{
	Cei nNewId = GetNewId();
	aAttributes[nNewId] = AttributeAtParent(new SCE_Attribute(let_drAttribute), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aAttributes[nNewId].first, 0);
	return nNewId;
}


Gate::RStructElement
Gate_Impl::Store_StructElement( Cei  							i_nOwner,
								DYN csi::uidl::StructElement &  let_drElement )
{
	Cei nNewId = GetNewId();
	aStructElements[nNewId] = StructElementAtParent(new SCE_StructElement(let_drElement), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aStructElements[nNewId].first, 0);
	return nNewId;
}


Gate::REnumValue
Gate_Impl::Store_EnumValue( Cei  						i_nOwner,
							DYN csi::uidl::EnumValue &  let_drEnumValue )
{
	Cei nNewId = GetNewId();
	aEnumValues[nNewId] = EnumValueAtParent(new SCE_EnumValue(let_drEnumValue), i_nOwner);

	aGeneralSignpost[nNewId] = Ce_n_Nsp(aEnumValues[nNewId].first, 0);
	return nNewId;
}


void
Gate_Impl::ConnectAdditionalLinks()
{
    Cout() << "start secondary productions" << Endl();
    ReConnect_Interface2Service aInterfaceUpdater(aInterfaces);
    std::for_each( aServices.begin(), aServices.end(), aInterfaceUpdater );
    Cout() << "end secondary productions" << Endl();
}


CeNamespace *
Gate_Impl::FindNamespace( csi::prl::RefNamespace i_nNspRef ) const
{
	return FindNamespaceImpl(i_nNspRef.Id());
}

CeNamespace	*
Gate_Impl::FindNameAndNamespaceOfType( udmstri & o_rName,
									   uintt  & o_nSequenceCount,
									   Cei i_nType ) const
{
	CeNamespace * ret = 0;

	uintt 	nSequenceCounter = 0;
	bool    bDone = false;
	Cei 	nType = i_nType;
	do
	{
		std::map<Cei,Cei>::const_iterator found = aSequence2Type.find(nType);
		if (found != aSequence2Type.end())
		{
			nType = (*found).second;
			nSequenceCounter++;
		}
		else
		{
			bDone = true;
		}
	} while (NOT bDone);
	o_nSequenceCount = nSequenceCounter;

	Root_Ces::const_iterator found = aGeneralSignpost.find(nType);
	if (found != aGeneralSignpost.end())
	{
		ret = (*found).second.second;
		o_rName = (*found).second.first->Name();
	}
	else
	{
		Root_Predeclarations::const_iterator preDecl = aPredeclarations.find(nType);
		if (preDecl != aPredeclarations.end())
		{
			ret = (*preDecl).second.second;
			o_rName = (*preDecl).second.first;
		}
		else
		{
			ret = 0;
			o_rName = "(not found)";
			return ret;
		}
	}

	return ret;
}

CodeEntity2 *
Gate_Impl::FindCe( Cei i_nId ) const
{
	Root_Ces::const_iterator found = aGeneralSignpost.find(i_nId);

	return found != aGeneralSignpost.end()
				?	(*found).second.first
				:	(CodeEntity2*)0;
}

const csi::uidl::Function *
Gate_Impl::FindMethod( Cei i_nId ) const
{
    const FunctionAtParent *
        pFunctionHolder = csv::find_in_map( aFunctions, i_nId );
    if ( pFunctionHolder != 0 )
    {
        return &pFunctionHolder->first->Client();
    }

    return 0;
}

const csi::uidl::Attribute *
Gate_Impl::FindProperty( Cei i_nId ) const
{
    const AttributeAtParent *
        pPropertyHolder = csv::find_in_map( aAttributes, i_nId );
    if ( pPropertyHolder != 0 )
    {
        return &pPropertyHolder->first->Client();
    }

    return 0;
}

const csi::uidl::EnumValue *
Gate_Impl::FindEnumValue( Cei i_nId ) const
{
    const EnumValueAtParent *
        pValueHolder = csv::find_in_map( aEnumValues, i_nId );
    if ( pValueHolder != 0 )
    {
        return &pValueHolder->first->Client();
    }

    return 0;
}

const csi::uidl::Constant *
Gate_Impl::FindConstant( Cei i_nId ) const
{
    const ConstantAtGroup *
        pValueHolder = csv::find_in_map( aConstants, i_nId );
    if ( pValueHolder != 0 )
    {
        return &pValueHolder->first->Client();
    }

    return 0;
}

const csi::uidl::StructElement *
Gate_Impl::FindStructElement( Cei i_nId ) const
{
    const StructElementAtParent *
        pValueHolder = csv::find_in_map( aStructElements, i_nId );
    if ( pValueHolder != 0 )
    {
        return &pValueHolder->first->Client();
    }

    return 0;
}

const csi::uidl::StructElement *
Gate_Impl::FindExceptionElement( Cei i_nId ) const
{
#if 0 // So far, all exceptin elements are in struct-element-map:
    const ExceptionElementAtParent *
        pValueHolder = csv::find_in_map( aExceptionElements, i_nId );
    if ( pValueHolder != 0 )
    {
        return &pValueHolder->first->Client();
    }
    return 0;
#endif // 0

    return FindStructElement(i_nId);
}

CeNamespace	&
Gate_Impl::GlobalNamespace()
{
	return *aNamespaces[C_nGlobalNamspaceId];
}

CeNamespace_Impl *
Gate_Impl::AddNamespace( Cei				i_nParent,
						 Cei				i_nId,
						 const char *		i_sName )
{
	csv_assert(aNamespaces.find(i_nId) == aNamespaces.end());

	CeNamespace_Impl * pParent = FindNamespaceImpl(i_nParent);
	csv_assert(i_nParent != 0 ? pParent != 0 : pParent == 0);

	CeNamespace_Impl * ret = new CeNamespace_Impl( i_nId,
												   i_sName,
												   pParent,
												   *this );

	aGeneralSignpost[i_nId] = Ce_n_Nsp(new SCE_Module(*ret), pParent);

	aNamespaces[i_nId] = ret;
	if (pParent != 0)
		pParent->AddSubNamespace(*ret);
	return ret;
}

CeNamespace_Impl *
Gate_Impl::CheckInSubNamespace( CeNamespace_Impl &  i_rParent,
								const char *		i_sName )
{
	CeNamespace_Impl * ret = i_rParent.SubNamespaceImpl(i_sName);
	if (ret != 0)
		return ret;
	else
		return AddNamespace( i_rParent.Id(), GetNewId(), i_sName );
}

CeNamespace_Impl *
Gate_Impl::FindNamespaceImpl( Cei i_nNspId ) const
{
	Root_Modules::const_iterator found = aNamespaces.find(i_nNspId);

	return found != aNamespaces.end()
				?	(*found).second
				:	(CeNamespace_Impl*)0;
}

Cei
Gate_Impl::FindSequence( Cei i_nTypeId ) const
{
	Root_Sequences::const_iterator found = aSequences.find(i_nTypeId);
	return found != aSequences.end()
					?	(*found).second
					:	(Cei)0;
}

CeNamespace_Impl &
Gate_Impl::GlobalNamespaceImpl()
{
	return *aNamespaces[C_nGlobalNamspaceId];
}

CeNamespace_Impl &
Gate_Impl::Namespace( Cei i_nNamspaceId ) const
{
	CeNamespace_Impl * ret = FindNamespaceImpl(i_nNamspaceId);
	csv_assert(ret != 0);
	return *ret;
}

Cei
Gate_Impl::GetTypeIdForStore( CeNamespace_Impl &  i_rNamespace,
							  const udmstri &	  i_sTypeName )
{
	CeNamespace_Impl::Id_n_Declaration
			preDecl = i_rNamespace.FindPredeclaration(i_sTypeName);
	switch (preDecl.second)
	{
		case CeNamespace_Impl::pd_no:
									return GetNewId();
		case CeNamespace_Impl::pd_yes:
									aPredeclarations.erase(preDecl.first);
									return preDecl.first;
		case CeNamespace_Impl::pd_already_defined:
                                    Cerr() << "Error in IDL: Symbol \""
                                              << i_sTypeName
                                              << "\" already defined. Produced documentation may have inconsistent links and other errors."
                                              << Endl();
									return GetNewId();
                                    break;
	}
	return 0;
}

}   // namespace uidl
}   // namespace ary

