/*************************************************************************
 *
 *  $RCSfile: project.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <precomp.h>
#include <ary/project.hxx>


// NOT FULLY DECLARED SERVICES
#include <ary/docu.hxx>
#include <slots.hxx>
#include "gl_rcids.hxx"



namespace ary
{

TopProject::TopProject( Gid i_nProject )
    :   nId( i_nProject )
        // sName,
	    // aCppProjects
{
}

TopProject::~TopProject()
{
}

void
TopProject::Add_Project( Gid i_nProject )
{
    aCppProjects.insert( i_nProject );
}

void
TopProject::do_StoreAt( Display & o_rOut ) const
{
    // Probably not needed.
}

Rid
TopProject::inq_Id() const
{
    return nId;
}

RCid
TopProject::inq_RC() const
{
    return RCID_TOP;
}

const Documentation &
TopProject::inq_Info() const
{
    return Documentation::Null_();
}

void
TopProject::do_Add_Documentation( DYN Documentation & let_drInfo )
{
    // Does nothing.
}

Gid
TopProject::inq_Id_Group() const
{
    return nId;
}

const RepositoryEntity &
TopProject::inq_RE_Group() const
{
    return *this;
}

const group::SlotList &
TopProject::inq_Slots() const
{
    static const SlotAccessId aProjectSlotData[]
            = { SLOT_MetaProjects, SLOT_CppLocationBases };
    static const std::vector< SlotAccessId >
            aSlots( &aProjectSlotData[0],
                      &aProjectSlotData[0]
                        + sizeof aProjectSlotData / sizeof (SlotAccessId) );
    return aSlots;
}

DYN Slot *
TopProject::inq_Create_Slot( SlotAccessId i_nSlot ) const
{
    switch ( i_nSlot )
    {
//     	case SLOT_MetaProjects:     return new Slot_GidSet(aMyNamespaces);
        case SLOT_CppLocationBases: return new Slot_RidSet(aCppProjects);
        default:
                                return new Slot_Null;
    }   // end switch
}

const udmstri &
TopProject::inq_Name() const
{
    return sName;
}


}   // namespace ary


