/*************************************************************************
 *
 *  $RCSfile: getncast.hxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:01:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_GETNCAST_HXX
#define ARY_GETNCAST_HXX

//  VERSION:            Autodoc 2.2


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERSs
#include <ary/x_ary.hxx>

namespace ary
{


template <class DEST>
struct T2T { };


template <class DEST, class SRC>
inline bool
is_type( const SRC & i_rSrc, T2T<DEST> )
{
    return i_rSrc.ClassId() == DEST::class_id;
}


template <class DEST, class SRC>
inline const DEST *
cptr_cast( const SRC * i_pSrc, T2T<DEST> unused )
{
    if ( i_pSrc != 0 )
    {
        if ( is_type(*i_pSrc, unused) )
            return static_cast< const DEST* >(i_pSrc);
    }

    return 0;
}

template <class DEST, class SRC>
inline DEST *
ptr_cast( SRC * i_pSrc, T2T<DEST> unused )
{
    if ( i_pSrc != 0 )
    {
        if ( is_type(*i_pSrc, unused) )
            return static_cast< DEST* >(i_pSrc);
    }

    return 0;
}

template <class DEST, class SRC>
inline const DEST &
cref_cast( const SRC & i_rSrc, T2T<DEST> unused )
{
    if ( is_type(i_rSrc, unused) )
        return static_cast< const DEST& >(i_rSrc);
    throw X_Ary(X_Ary::x_InvalidCast);

    // NOT reached:
    return static_cast< const DEST& >(i_rSrc);
}

template <class DEST, class SRC>
inline DEST &
ref_cast( SRC & i_rSrc, T2T<DEST> unused )
{
    if ( is_type(i_rSrc, unused) )
        return static_cast< DEST& >(i_rSrc);
    throw X_Ary(X_Ary::x_InvalidCast);

    // NOT reached:
    return static_cast< DEST& >(i_rSrc);
}


//********** Assuming that works under VC++ and others *********//

template <class DEST>
inline const DEST &
ary_cast( const n22::RepositoryEntity & ce)
{
    if ( ce.ClassId() != DEST::class_id )
        throw X_Ary(X_Ary::x_InvalidCast);
    return static_cast< const DEST& >(ce);
}

template <class DEST>
inline DEST &
ary_cast( n22::RepositoryEntity & ce)
{    
    if ( ce.ClassId() != DEST::class_id )
        throw X_Ary(X_Ary::x_InvalidCast);
    return static_cast< DEST& >(ce);
}

template <class DEST>
inline const DEST *
ary_cast( const n22::RepositoryEntity * ce)
{
    if ( ce ? ce->ClassId() == DEST::class_id : false )
        return static_cast< const DEST* >(ce);
    return 0;
}

template <class DEST>
inline DEST *
ary_cast( n22::RepositoryEntity * ce)
{
    if ( ce ? ce->ClassId() == DEST::class_id : false )
        return static_cast< DEST* >(ce);
    return 0;
}


}   // namespace ary






#endif

