/*************************************************************************
 *
 *  $RCSfile: ipi_type.cxx,v $
 *
 *  $Revision: 1.1.12.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:00:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include "ipi_type.hxx"


// NOT FULLY DEFINED SERVICES
#include <ary/qualiname.hxx>
#include <ary/idl/i_module.hxx>
#include <ary/idl/i_type.hxx>
#include <ary/idl/ip_ce.hxx>
#include <store/st_access.hxx>
#include "is_type.hxx"
#include "it_builtin.hxx"
#include "it_ce.hxx"
#include "it_explicit.hxx"
#include "it_sequence.hxx"
#include "it_xnameroom.hxx"



namespace ary
{
namespace idl
{


inline const Type_Storage &
TypePilot_Inst::my_Storage() const
    { return *pStorage; }

inline Type_Storage &
TypePilot_Inst::my_Storage()
    { return *pStorage; }

inline CePilot &
TypePilot_Inst::my_Ces() const
    { return *pCes; }

inline void
TypePilot_Inst::lhf_Put2Storage_and_AssignId( DYN Type & pass_io_rType )
    { // This also assigns an ID to pass_io_rType:
      my_Storage().Container().Add(pass_io_rType); }

ExplicitNameRoom &
TypePilot_Inst::lhf_CheckIn_XNameRoom( const QualifiedName & i_rName )
{
    Type_id nRoot = i_rName.IsAbsolute()
                        ?   Type_id( predefined::type_GlobalXNameRoom )
                        :   Type_id( predefined::type_Root_ofXNameRooms );

    if ( i_rName.NamespaceDepth() == 0 )
        return store::find_access( my_Storage(), nRoot, T2T<ExplicitNameRoom>() );

    QualifiedName::namespace_iterator it = i_rName.first_namespace();
    ExplicitNameRoom *
        ret = &store::find_access( my_Storage(), nRoot, T2T<ExplicitNameRoom>() );
    for ( ; it != i_rName.end_namespace(); ++it )
    {
        Type_id found = ret->Search_Name(*it);
        if (found.IsValid())
        {
            ret = &store::find_access(my_Storage(), found, T2T<ExplicitNameRoom>());
        }
        else
        {
            ExplicitNameRoom &
                rNew = *new ExplicitNameRoom(*it, *ret);
            lhf_Put2Storage_and_AssignId(rNew);
            ret->Add_Name( rNew.Name(), rNew.TypeId() );
            ret = &rNew;
        }

    }   // end for
    return *ret;
}

Type_id
TypePilot_Inst::lhf_CheckIn_TypeName( const String &        i_sLocalName,
                                      ExplicitNameRoom &    io_rXNameRoom,
                                      Ce_id                 i_nModuleOfOccurrence )
{
    Type_id
        ret = io_rXNameRoom.Search_Name(i_sLocalName);
    if (NOT ret.IsValid())
    {
        DYN Type &
            rNewType = *new ExplicitType(  i_sLocalName,
                                            io_rXNameRoom.TypeId(),
                                            i_nModuleOfOccurrence );
        lhf_Put2Storage_and_AssignId(rNewType);
        ret = rNewType.TypeId();
        io_rXNameRoom.Add_Name( i_sLocalName, ret );
    }
    return ret;
}

Type_id
TypePilot_Inst::lhf_CheckIn_Sequence(Type_id i_nType)
{
    Type_id     ret = my_Storage().Indices().Search_SequenceOf(i_nType);

    if (NOT ret.IsValid())
    {
        DYN Type &
            rNewSeq = *new Sequence(i_nType);
        lhf_Put2Storage_and_AssignId(rNewSeq);
        ret = rNewSeq.Id();
        my_Storage().Indices().Add_Sequence(i_nType, ret);
    }
    return ret;
}

void
TypePilot_Inst::lhf_CheckIn_BuiltInType( const char *       i_sName,
                                         Rid                i_nId )
{
    DYN BuiltInType & rNewType = *new BuiltInType(i_sName);
    Type_id nId(i_nId);
    my_Storage().Container().Set_Reserved(nId,rNewType);

    // Put them into both roots, to catch the syntactically correct
    //   (though unlikely) ::Any, ::long etc.
    store::find_access( my_Storage(), nXNameRoom_Root, T2T<ExplicitNameRoom>() )
            .Add_Name(i_sName, nId);
    store::find_access( my_Storage(), nXNameRoom_Global, T2T<ExplicitNameRoom>() )
            .Add_Name(i_sName, nId);
}

TypePilot_Inst::TypePilot_Inst( Type_Storage & io_rStorage,
                                CePilot &      io_rCes )
    :   pStorage(&io_rStorage),
        pCes(&io_rCes),
        nXNameRoom_Root( static_cast<ary::Rid>(predefined::type_Root_ofXNameRooms) ),
        nXNameRoom_Global( static_cast<ary::Rid>(predefined::type_GlobalXNameRoom) )
{
    DYN ExplicitNameRoom &
        drRoot = *new ExplicitNameRoom;
    my_Storage().Container().Set_Reserved( nXNameRoom_Root, drRoot );

    DYN ExplicitNameRoom &
        drGlobal = *new ExplicitNameRoom(String::Null_(), drRoot);
    my_Storage().Container().Set_Reserved( nXNameRoom_Global, drGlobal );
    drRoot.Add_Name( drGlobal.Name(), nXNameRoom_Global );

    lhf_Setup_BuildInTypes();
}

TypePilot_Inst::~TypePilot_Inst()
{
}

void
TypePilot_Inst::lhf_Setup_BuildInTypes()
{
    lhf_CheckIn_BuiltInType("any", predefined::type_any);
    lhf_CheckIn_BuiltInType("boolean", predefined::type_boolean);
    lhf_CheckIn_BuiltInType("byte", predefined::type_byte);
    lhf_CheckIn_BuiltInType("char", predefined::type_char);
    lhf_CheckIn_BuiltInType("double", predefined::type_double);
    lhf_CheckIn_BuiltInType("float", predefined::type_float);
    lhf_CheckIn_BuiltInType("hyper", predefined::type_hyper);
    lhf_CheckIn_BuiltInType("long", predefined::type_long);
    lhf_CheckIn_BuiltInType("short", predefined::type_short);
    lhf_CheckIn_BuiltInType("string", predefined::type_string);
    lhf_CheckIn_BuiltInType("type", predefined::type_type);
    lhf_CheckIn_BuiltInType("void", predefined::type_void);
    lhf_CheckIn_BuiltInType("unsigned hyper", predefined::type_u_hyper);
    lhf_CheckIn_BuiltInType("unsigned long", predefined::type_u_long);
    lhf_CheckIn_BuiltInType("unsigned short", predefined::type_u_short);
}

const Type &
TypePilot_Inst::do_CheckIn_Type( QualifiedName &     i_rFullName,
                                 uintt               i_nSequenceCount,
                                Ce_id                i_nModuleOfOccurrence )
{
    ExplicitNameRoom &
        rNameRoom = lhf_CheckIn_XNameRoom(i_rFullName);
    Type_id
        nType = lhf_CheckIn_TypeName( i_rFullName.LocalName(),
                                      rNameRoom,
                                      i_nModuleOfOccurrence );

    for ( uintt s = 0; s < i_nSequenceCount; ++s )
    {
        nType = lhf_CheckIn_Sequence(nType);
    }

    return my_Storage()[nType].Entity();
}

const Type &
TypePilot_Inst::inq_Find_Type( Type_id i_nType ) const
{
    return my_Storage()[i_nType].Entity();
}

Ce_id
TypePilot_Inst::inq_Search_CeRelatedTo( Type_id i_nType ) const
{
    const Ce_Type *
        ret = store::search( my_Storage(), i_nType, T2T<Ce_Type>() );
    return ret != 0
            ?   ret->RelatedCe()
            :   Ce_id_Null();
}

const ExplicitNameRoom &
TypePilot_Inst::inq_Find_XNameRoom( Type_id i_nType ) const
{
    return store::find( my_Storage(), i_nType, T2T<ExplicitNameRoom>() );
}
 
bool                
TypePilot_Inst::inq_IsBuiltInOrRelated( const Type & i_rType ) const
{                                 
    if ( i_rType.ClassId() == BuiltInType::class_id )
        return true;
    else 
    {
        const Type * pType = &i_rType;
        while (pType->ClassId() == Sequence::class_id)
        {
            Type_id nt = static_cast< const Sequence* >(pType)->RelatedType();
            pType = my_Storage()[nt].EntityPtr();
            csv_assert(pType != 0);
        }
        return pType->ClassId() == BuiltInType::class_id;
    }
}

 

}   // namespace idl
}   // namespace ary
