/*************************************************************************
 *
 *  $RCSfile: intrface.hxx,v $
 *
 *  $Revision: 1.1.1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 17:00:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UIDL_INTRFACE_HXX
#define UIDL_INTRFACE_HXX



// USED SERVICES
	// BASE CLASSES
#include <csi/prl/tsk_type.hxx>
#include <csi/prl/tsk_nasp.hxx>
	// COMPONENTS
	// PARAMETERS
#include <ary_i/cei.hxx>


namespace csi
{
namespace uidl
{


class Attribute;
class Function;
class Interface;
class Service;

struct S_Interface_Data
{
	udmstri				sUik;
	udmstri				sName;
	prl::RefNamespace	pNamespace;
	udm::IRef< Interface >
						pBase;
	std::vector< udm::IRef< Function > >
						aFunctions;
	std::vector< udm::IRef< Attribute > >
						aAttributes;
	std::vector< udm::IRef< Service > >
						aUsingServices;

    void                Add_UsingService(
                            ary::Cei            i_nServiceId );
};



class Interface : public prl::TType,
				  private S_Interface_Data
{
  public:
	typedef std::vector< udm::IRef< Function > >	FunctionList;
	typedef std::vector< udm::IRef< Attribute > >	AttributeList;
	typedef std::vector< udm::IRef< Service > >	    ServiceList;

						~Interface();

	const udmstri &		Uik() const				{ return sUik; }
	virtual const udmstri &
						Name() const;
	virtual prl::RefNamespace
						Namespace() const;
	const udm::IRef< Interface >
						Base() const			{ return pBase; }
	const FunctionList &
						Operations() const		{ return aFunctions; }
	const AttributeList &
						Attributes() const		{ return aAttributes; }
    const ServiceList & UsingServices() const   { return aUsingServices; }

	S_Interface_Data &	Data()					{ return *this; }
};



// IMPLEMENTATION


}   // namespace uidl
}   // namespace csi


#endif

