/*************************************************************************
 *
 *  $RCSfile: htmlpiec.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CSI_HTML_HTMLPIEC_HXX
#define CSI_HTML_HTMLPIEC_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <cosv/template/swelist.hxx>
	// PARAMETERS

namespace csv
{
    class AnyWrite;
}



namespace csi
{
namespace html_old
{


class MultiPiece;



/// Html pieces of text interface.

class Piece
{
  public:
	virtual				~Piece() {}
	virtual void		WriteOut(
							csv::bostream &			io_aFile ) = 0;
};


typedef csv::SweList_dyn<Piece>	Vector;
typedef const char *			TagType;
typedef const char *			StyleType;



/// Html pieces diverse interfaces.


/**	Base class for pieces with <TAG <diverse style vars>> .
*/
class Styled : public Piece
{
  public:
	void				SetStyle(
							StyleType		i_pStyle );
	const udmstri &		Style() const;
  protected:
						Styled(
							StyleType		i_pStyle = 0 );
  private:
	udmstri 				sStyle;
};

/**	One well formed HTM-tag-pair with content.
*/
class Field : public Styled
{
  public:
						~Field();
	virtual void		WriteOut(
							csv::bostream &			io_aFile );

  protected:
						Field(
							DYN Piece &		let_drData,
							TagType			i_sTag,
							StyleType		i_pStyle = 0 );

	const Piece &	Data() const;

  private:
	virtual void	 	Write_BeginTag(         /// Default: "<"; sTag;  Write_SpecificStyle(); *pStyle; ">".
							csv::bostream &			io_aFile );
	virtual void	 	Write_SpecificStyle(    /// Default does nothing.
							csv::bostream &			io_aFile );

	// DATA
	udmstri				sTag;
	DYN Piece *		dpData;
};

/**	Base class for simple tags, like <H4> or <B>.
*/
class Tag  : public Field
{
  protected:
						Tag(
							DYN Piece &		let_drData,
							TagType			i_sTag,
							StyleType		i_pStyle = 0 );
};


/**	Base class for lists.
*/
class List : public Piece
{
  public:
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
	bool				IsEmpty() const 		{ return aRows.begin() != aRows.end(); }
  protected:
						List(
							TagType			i_sListTag,
							StyleType		i_sListStyle );
	void				Add_Elem(
							DYN Piece &		let_drElement,
							TagType			i_sTag,
							StyleType		i_sStyle = 0 );

  private:
	class Element : public Field
	{
	  public:
								Element(
									DYN Piece &		let_drElementsContent,
									TagType			i_sTag,
									StyleType		i_pStyle = 0 );
	};

	// DATA
	udmstri				sListTag;
	udmstri 			sListStyle;
	csv::SweList_dyn<Element>
						aRows;
};



/// Html pieces - concrete classes.

/**	One simple tag, like <H4> or <B>
*/
class AnyTag : public Tag
{
  public:
						AnyTag(
							DYN Piece &		let_drData,
							TagType			i_sTag,
							StyleType		i_pStyle = 0 );
};

/**	<BODY> tag
*/
class Body : public Field
{
  public:
						Body(
							StyleType		i_pStyle = 0 );
	MultiPiece &	Contents()				{ return *pData; }

  private:
	MultiPiece *	pData;
};

/**	<HR>
*/
class HorizontalLine : public Styled
{
  public:               HorizontalLine(
							StyleType		i_pStyle );

	virtual void		WriteOut(
							csv::bostream &			io_aFile );
};

/**	<IMG .... >
*/
class Image : public Piece
{
  public:
						Image(
							const udmstri &		 i_sSrc,
							const udmstri &      i_sWidth,
							const udmstri &      i_sHeight,
							const udmstri &      i_sAlign,
							const udmstri &      i_sBorder,
							const udmstri &      i_sAlt = "" );

	void				SetSrc(
							const char *		 i_sSrc )
												 { sSrc = i_sSrc; }

	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	udmstri 			 sSrc;
	udmstri              sWidth;
	udmstri              sHeight;
	udmstri              sAlign;
	udmstri              sBorder;
	udmstri              sAlt;
};

/**	<A name="">
*/
class Label : public Styled
{
  public:
						Label(
							DYN Piece &		let_drShowedData,
							const udmstri &		i_sName,
							StyleType		i_pStyle = 0 );
						~Label();

	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	DYN Piece *		dpShowedData;
	udmstri				sName;
};

/**	<BR>
*/
class LineBreak : public Piece
{
  public:
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
};

/**	<A href="">
*/
class Link : public Styled
{
  public:
						Link(
							DYN Piece &		    let_drShowedData,
							const udmstri &		i_sDestinaton,
							StyleType		    i_pStyle = 0 );
						~Link();

	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	DYN Piece *		dpShowedData;
	udmstri				sDestination;
};

/**	Several HTML-pieces to be lined up within one tag pair.
*/
class MultiPiece : public Piece
{
  public:
	void				AddData(
							DYN Piece &		let_drDatum );
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
	void				Empty()					{ aData.erase_all(); }

  private:
	Vector			aData;
};

class TableCell : public Field
{
  public:
						TableCell(
							DYN Piece &		let_drData,
							StyleType		i_pStyle = 0 );
};

class TableRow  : public Styled
{
  public:
	void				AddCell(
							DYN TableCell *	let_dpData );
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	csv::SweList_dyn<TableCell>
						aCells;
};

/**	<table ....>
*/
class Table : public Styled
{
  public:
						Table(
							const udmstri &		i_sBorder,
							const udmstri &		i_sWidth,
							const udmstri &		i_sCellPadding = "",
							const udmstri &		i_sCellSpacing = "",
							StyleType		i_pAdditionalStyle = "" );

	void				AddRow(
							DYN TableRow *	let_dpData );
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	csv::SweList_dyn<TableRow>
						aRows;
};


/**	Text where reserved HTML-chars will be replaced
*/
class Text : public Piece
{
  public:
						Text(
							const udmstri &		i_sText );
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	static char 		cReplacable[256];

	// DATA
	udmstri				sText;
};

/**	Text which will not be changed
*/
class TextWithHtml : public Piece
{
  public:
						TextWithHtml(
							const udmstri &		i_sText );
	virtual void		WriteOut(
							csv::bostream &			io_aFile );
  private:
	udmstri				sText;
};

/**	<DL>
*/
class DefList : public List
{
  public:
						DefList(
							StyleType		i_pStyle = 0 );

	void				AddTerm(
							DYN Piece &		let_drElement,
							StyleType		i_pStyle = 0 );
	void				AddDefinition(
							DYN Piece &		let_drElement,
							StyleType		i_pStyle = 0 );
};

/** <OL>
*/
class Enumeration : public List
{
  public:
						Enumeraton(
							char 				i_cType = '\0',
							const udmstri &		i_sStart = "",
							StyleType		i_pStyle = 0 );

	void				AddElement(
							DYN Piece &		let_drElement,
							StyleType		i_pStyle = 0 );
};

/**	<UL>
*/
class SimpleList : public List
{
  public:
						SimpleList(
							TagType			i_sDifferentTag = "",
							StyleType		i_pStyle = 0 );

	void				AddElement(
							DYN Piece &		let_drElement,
							StyleType		i_pStyle = 0 );
};


// Short hands:

inline DYN Text &
                    TextOH(
						const char *       	i_sText );
inline DYN TextWithHtml &
					TextWH(
						const char * 	    i_sText );
inline DYN Label &  Create_TextLabel(
						const char *		i_sText,
						const char *		i_sLink,
						StyleType		    i_pStyle = 0 );
inline DYN Link &   Create_TextLink(
						const char *		i_sText,
						const char *		i_sLink,
						StyleType		    i_pStyle = 0 );


inline void
Styled::SetStyle( StyleType i_pStyle )
	{ sStyle = i_pStyle ? i_pStyle : ""; }
inline const udmstri &
Styled::Style() const
	{ return sStyle; }
inline const Piece &
Field::Data() const
	{ return *dpData; }

inline DYN Text &
TextOH( const char * i_sText )
	{ return *new Text( i_sText); }
inline DYN TextWithHtml &
TextWH( const char * i_sText )
	{ return *new TextWithHtml( i_sText); }
inline DYN Label &
Create_TextLabel( const char *	i_sText,
				  const char *	i_sLink,
				  StyleType	i_pStyle )
	{ return *new Label( *new Text(i_sText), i_sLink, i_pStyle ); }
inline DYN Link &
Create_TextLink( const char *	i_sText,
				 const char *	i_sLink,
				 StyleType	i_pStyle )
	{ return *new Link( *new Text(i_sText), i_sLink, i_pStyle ); }



}   // namespace html_old
}   // namespace csi


#endif


