/*************************************************************************
 *
 *  $RCSfile: c_rwgate.hxx,v $
 *
 *  $Revision: 1.1.1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/01/27 16:59:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_C_RWGATE_HXX
#define ARY_CPP_C_RWGATE_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>
#include <ary/cpp/c_etypes.hxx>
#include <ary/cpp/c_vfflag.hxx>


namespace ary
{
    namespace loc
    {
        class RwGate;
    }

namespace cpp
{
    class InputContext;
    class Type;
    class UsedType;

    class Namespace;
    class Class;
    class Enum;
    class Typedef;
    class Function;
    class Variable;
    class EnumValue;

    class DisplayGate;
    class RwGate_Groups;
    class RwGate_Defines;

class RwGate
{
  public:
    // LIFECYCLE
	    virtual         RwGate::~RwGate() {}

	// OPERATIONS
	Namespace &         CheckIn_Namespace(
                            const InputContext& i_rContext,
                            const udmstri &     i_sLocalName );
    const Type &   		CheckIn_UsedType(
                            const InputContext& i_rContext,
                            DYN UsedType &    	let_drType );

	Class &             Store_Class(
                            const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            E_ClassKey          i_eClassKey );
	Enum &              Store_Enum(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName );
	Typedef &           Store_Typedef(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            Tid                 i_nReferedType );
	Function &          Store_Operation(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            Tid                 i_nReturnType,
                            const std::vector<S_Parameter> &
                                                i_aParameters,
                            E_Virtuality        i_eVirtuality,
                            E_ConVol            i_eConVol,
                            FunctionFlags       i_aFlags,
                            bool                i_bThrowExists,
                            const std::vector<Tid> &
                                                i_aExceptions );
	Variable &          Store_Variable(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            Tid                 i_nType,
                            VariableFlags       i_aFlags,
                            const udmstri &     i_sArraySize,
                            const udmstri &     i_sInitValue );
	EnumValue &         Store_EnumValue(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            const udmstri &     i_sInitValue );

    void                Connect_AllTypes_2_TheirRelated_CodeEntites();

    // INQUIRY
    const DisplayGate & RoGate() const;
    Tid                 Tid_Ellipse() const;

	// ACCESS
	Namespace &			GlobalNamespace();
    ary::cpp::RwGate_Defines &
                        Defines() const;
    ary::cpp::RwGate_Groups &
                        Groups() const;
    ary::loc::RwGate &  Locations() const;


  private:
	virtual Namespace & do_CheckIn_Namespace(
                            const InputContext& i_rContext,
                            const udmstri &     i_sLocalName ) = 0;
	virtual const Type &
						do_CheckIn_UsedType(
							const InputContext& i_rContext,
                            DYN UsedType &    	let_drType ) = 0;

	virtual Class &     do_Store_Class(
                            const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            E_ClassKey          i_eClassKey ) = 0;
	virtual Enum &      do_Store_Enum(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname ) = 0;
	virtual Typedef &   do_Store_Typedef(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            Tid                 i_nReferedType ) = 0;
	virtual Function &  do_Store_Operation(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            Tid                 i_nReturnType,
                            const std::vector<S_Parameter> &
                                                i_aParameters,
                            E_Virtuality        i_eVirtuality,
                            E_ConVol            i_eConVol,
                            FunctionFlags       i_aFlags,
                            bool                i_bThrowExists,
                            const std::vector<Tid> &
												i_aExceptions ) = 0;
	virtual Variable &  do_Store_Variable(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            Tid                 i_nType,
                            VariableFlags       i_aFlags,
                            const udmstri &     i_sArraySize,
                            const udmstri &     i_sInitValue ) = 0;
	virtual EnumValue & do_Store_EnumValue(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalname,
                            const udmstri &     i_sInitValue ) = 0;
    virtual void        do_Connect_AllTypes_2_TheirRelated_CodeEntites() = 0;
    virtual const DisplayGate &
                        inq_RoGate() const = 0;
    virtual Tid         inq_Tid_Ellipse() const = 0;
	virtual Namespace &	access_GlobalNamespace() = 0;
    virtual ary::cpp::RwGate_Defines &
                        access_Defines() const = 0;
    virtual ary::cpp::RwGate_Groups &
                        access_Groups() const = 0;
    virtual ary::loc::RwGate &
                        access_Locations() const = 0;
};




// IMPLEMENTATION


inline Namespace &
RwGate::CheckIn_Namespace( const InputContext& i_rContext,
						   const udmstri &     i_sLocalName )
	{ return do_CheckIn_Namespace( i_rContext, i_sLocalName ); }
inline const Type &
RwGate::CheckIn_UsedType( const InputContext& i_rContext,
						  DYN UsedType &      let_drType )
	{ return do_CheckIn_UsedType( i_rContext, let_drType ); }
inline Class &
RwGate::Store_Class( const InputContext& i_rContext,
					 const udmstri &     i_sLocalname,
					 E_ClassKey          i_eClassKey )
	{ return do_Store_Class( i_rContext, i_sLocalname, i_eClassKey ); }
inline Enum &
RwGate::Store_Enum( const InputContext& i_rContext,
					const udmstri &     i_sLocalname )
	{ return do_Store_Enum( i_rContext, i_sLocalname ); }
inline Typedef &
RwGate::Store_Typedef( const InputContext& i_rContext,
					   const udmstri &     i_sLocalname,
					   Tid                 i_nReferedType )
    { return do_Store_Typedef( i_rContext, i_sLocalname, i_nReferedType ); }
inline Function &
RwGate::Store_Operation( const InputContext &             i_rContext,
						 const udmstri &                  i_sLocalname,
                         Tid                              i_nReturnType,
                         const std::vector<S_Parameter> & i_aParameters,
                         E_Virtuality                     i_eVirtuality,
                         E_ConVol                         i_eConVol,
                         FunctionFlags                    i_aFlags,
                         bool                             i_bThrowExists,
                         const std::vector<Tid> &         i_aExceptions )
    { return do_Store_Operation( i_rContext, i_sLocalname, i_nReturnType,
                                 i_aParameters, i_eVirtuality, i_eConVol,
                                 i_aFlags, i_bThrowExists, i_aExceptions ); }
inline Variable &
RwGate::Store_Variable( const InputContext& i_rContext,
						const udmstri &     i_sLocalname,
                        Tid                 i_nType,
                        VariableFlags       i_aFlags,
                        const udmstri &     i_sArraySize,
                        const udmstri &     i_sInitValue )
    { return do_Store_Variable( i_rContext, i_sLocalname, i_nType,
                                i_aFlags, i_sArraySize, i_sInitValue ); }
inline EnumValue &
RwGate::Store_EnumValue( const InputContext& i_rContext,
						 const udmstri &     i_sLocalname,
                         const udmstri &     i_sInitValue )
    { return do_Store_EnumValue( i_rContext, i_sLocalname, i_sInitValue ); }
inline void
RwGate::Connect_AllTypes_2_TheirRelated_CodeEntites()
    { do_Connect_AllTypes_2_TheirRelated_CodeEntites(); }
inline const DisplayGate &
RwGate::RoGate() const
    { return inq_RoGate(); }
inline Tid
RwGate::Tid_Ellipse() const
    { return inq_Tid_Ellipse(); }
inline Namespace &
RwGate::GlobalNamespace()
    { return access_GlobalNamespace(); }
inline ary::cpp::RwGate_Defines &
RwGate::Defines() const
    { return access_Defines(); }
inline ary::cpp::RwGate_Groups &
RwGate::Groups() const
    { return access_Groups(); }
inline ary::loc::RwGate &
RwGate::Locations() const
    { return access_Locations(); }


}   // namespace cpp
}   // namespace ary



#endif

