
#include "bad_value.hh"
#include <pspell/error_messages.hh>
#include "app_string.hh"


namespace autil {
  BadValue::BadValue(const string & k, const string & v, const string & av)
    : key(k), value(v), accepted_value(av) 
  {
    AppString s(&message);
    PspellErrorExtraInfo * dummy = 0;
    bad_value(number, dummy, s, key.c_str(), value.c_str(), accepted_value.c_str());
  }

  BadValue::BadValue(const string & k, const string & v, const string & av,
		     const char * m)
    : Exception(m, PERROR_BAD_VALUE)
    , key(k), value(v), accepted_value(av) 
  {}
}
