
./configure --disable-shared --disable-debug \
  --enable-dict-dir=$PWD/install/dict \
  --enable-doc-dir=$PWD/install/doc --enable-pkgdata-dir=$PWD/install/data \
  --prefix=$PWD/install || exit 1

rm -rf install
(make clean && make LDFLAGS=-all-static && make install) || exit 1

DIR=aspell-VER-ARCH-OS

echo "Making binary archive"
cd install
mv bin/aspell bin/aspell.bin
strip --strip-debug bin/aspell.bin
rm bin/run-with-aspell
mkdir $DIR
tar cf $DIR/bin.tar bin/* data/* dict/* doc/*
gzip -9 $DIR/bin.tar
cp ../scripts/install-bin $DIR/install
chmod 755 $DIR/install
cp ../README-bin $DIR/README
tar cf ../$DIR.tar $DIR/* || exit 1
cd ..
rm -rf install
