// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "token.hh"
#include "language.hh"
#include "filter.hh"
#include "clone_ptr-t.hh"

namespace aspell {

  void TokenItr::start_over() {
    begin_.reset();
    end_  .reset();
    next  .reset();
    word_ = "";
  }

  void TokenItr::reset() 
  {
    afilter::reset(end_);
  }

  void TokenItr::restart(const FilterItrRoot & start) 
  {
    afilter::restart(end_, start);
    end_char = end_->first();
  }

  void TokenItr::backup()
  {
    end_ = begin_;
  }


  void TokenItr::scan(const FilterItrRoot & stop) 
  {
    afilter::scan(end_, stop);
    end_char = end_->first();
  }

  void TokenItr::add(FilterItrPart * to_add)
  {
    end_.reset(afilter::add(end_.release(), to_add));

    next.assign(end_);

    begin_.assign(end_);
  }

#define increment__  \
  do { \
  if (next_char == 0) { \
    word_ += cur_char; \
    end_char = 0; \
    end_->assign(next); \
    return; \
  } else { \
    word_ += cur_char; \
    prev_char = cur_char; \
    cur->assign(next); cur_char = next_char; \
    next_char = next->next(); \
  } \
  } while (false)

  void TokenItr::advance() {
    begin_.assign(end_);
    FilterItrPart * cur  = end_;
    char prev_char = 0;
    char cur_char;
    char next_char;
    word_="";

    // figure out what the current token is
    cur_char = end_char;
    if (cur_char == 0) {return;}
    next->assign(cur); 
    next_char = next->next();
    is_word_ = lang->is_alpha(cur_char);
    if (lang->special(cur_char).begin && lang->is_alpha(next_char)) 
      is_word_ = true;
  
    increment__;
  
    if (is_word_) {
      
      while (lang->is_alpha(cur_char) || 
	     (lang->special(cur_char).middle && 
	      lang->is_alpha(prev_char) &&
	      lang->is_alpha(next_char) )) 
	increment__;
      
      // cur is nonalpha
      if (lang->special(cur_char).end) {
	word_ += cur_char;
	end_char = next_char;
	end_->assign(next);
      } else {
	end_char = cur_char;
      }

    } else { // cur_token not is_word_
    
      while (!lang->is_alpha(cur_char) && 
	     !(lang->special(cur_char).begin && lang->is_alpha(next_char))
	     )
	increment__;
      
      // cur is alpha or begin
      end_char = cur_char;		
	
    }
  }

#undef increment__
}
