.\" $Id: nasd.man,v 1.1 2000/01/01 09:28:15 jon Exp $
.TH NASD 1 "" ""
.SH NAME
nasd \- Network Audio System server
.SH SYNOPSIS
.B nasd
[:listen port offset] [\-option ...]
.SH DESCRIPTION
.I nasd
is the generic name for the Network Audio System server.  It is frequently a link
or a copy of the appropriate server binary for driving the most frequently
used server on a given machine.
.SH "STARTING THE SERVER"
The server is usually started from /etc/rc or a user's startup script.
.PP
When the Network Audio System server starts up, it takes over /dev/audio.  Note
that applications that attempt to access /dev/audio themselves will
fail while it is running.
.SH "NETWORK CONNECTIONS"
The Network Audio System server supports connections made using the following reliable
byte-streams:
.TP 4
.I TCP\/IP
.br
The server listens on port 8000+\fIn\fP, where \fIn\fP is the listen 
port offset.
.TP 4
.I "Unix Domain"
The X server uses \fI/tmp/.sockets/audio\fBn\fR as the filename for 
the socket, where \fIn\fP is the display number.
.SH OPTIONS
All of the Network Audio System servers accept the following command line options:
.TP 8
.B \-aa
Allows clients on any host to connect.  By default, access is allowed
only to clients on the local host.
.SH SIGNALS
The Network Audio System server attaches special meaning to the following signals:
.TP 8
.I SIGHUP
This signal causes the server to close all existing connections, free all
resources, and restore all defaults.
.TP 8
.I SIGTERM
This signal causes the server to exit cleanly.
.TP 8
.I SIGUSR1
This signal is used quite differently from either of the above.  When the
server starts, it checks to see if it has inherited SIGUSR1 as SIG_IGN
instead of the usual SIG_DFL.  In this case, the server sends a SIGUSR1 to
its parent process after it has set up the various connection schemes.
.SH DIAGNOSTICS
Too numerous to list them all.
.SH FILES
.TP 30
/tmp/.sockets/audio*
Unix domain socket
.TP 30
/usr/adm/audio*msgs
.TP 30
/dev/audio
Audio device
.SH "SEE ALSO"
nas(1), auinfo(1), auplay(1), auctl(1), nasd.conf(1)
.SH BUGS
.PP
If
.I au
dies before its clients, new clients won't be able to connect until all
existing connections have their TCP TIME_WAIT timers expire.
.PP
The current access control support is weak at best.
.PP
.SH COPYRIGHT
Copyright 1993, Network Computing Devices, Inc.
.br
.SH AUTHORS
The Network Audio System server was originally written by Greg Renda
and Dave Lemke, with large amounts of code borrowed from the sample X
server.
.sp
The sample X server was originally written by Susan Angebranndt, Raymond
Drewry, Philip Karlton, and Todd Newman, from Digital Equipment
Corporation, with support from a large cast.  It has since been
extensively rewritten by Keith Packard and Bob Scheifler, from MIT.
