/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import org.apache.log4j.Priority;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PriorityRangeFilter
extends Filter {
    boolean acceptOnMatch = false;
    Priority priorityMin;
    Priority priorityMax;
    public static final String PRIORITY_MIN_OPTION = "PriorityMin";
    public static final String PRIORITY_MAX_OPTION = "PriorityMax";
    public static final String ACCEPT_ON_MATCH_OPTION = "AcceptOnMatch";

    public int decide(LoggingEvent event) {
        if (this.priorityMin != null && !event.priority.isGreaterOrEqual(this.priorityMin)) {
            return -1;
        }
        if (this.priorityMax != null && event.priority.toInt() > this.priorityMax.toInt()) {
            return -1;
        }
        if (this.acceptOnMatch) {
            return 1;
        }
        return 0;
    }

    public Priority getPriorityMax() {
        return this.priorityMax;
    }

    public Priority getPriorityMin() {
        return this.priorityMin;
    }

    public boolean getAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public void setPriorityMax(Priority priorityMax) {
        this.priorityMax = priorityMax;
    }

    public void setPriorityMin(Priority priorityMin) {
        this.priorityMin = priorityMin;
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public String[] getOptionStrings() {
        return new String[]{PRIORITY_MIN_OPTION, PRIORITY_MAX_OPTION, ACCEPT_ON_MATCH_OPTION};
    }

    public void setOption(String key, String value) {
        if (key.equalsIgnoreCase(PRIORITY_MIN_OPTION)) {
            this.priorityMin = OptionConverter.toPriority(value, null);
        } else if (key.equalsIgnoreCase(PRIORITY_MAX_OPTION)) {
            this.priorityMax = OptionConverter.toPriority(value, null);
        } else if (key.equalsIgnoreCase(ACCEPT_ON_MATCH_OPTION)) {
            this.acceptOnMatch = OptionConverter.toBoolean(value, this.acceptOnMatch);
        }
    }
}

