/*************************************************************************
 *
 *  $RCSfile: svtabbx.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVTABBX_HXX
#define _SVTABBX_HXX

#include <svtools/svtreebx.hxx>

enum SvTabJustify
{
	AdjustRight = SV_LBOXTAB_ADJUST_RIGHT,
	AdjustLeft = SV_LBOXTAB_ADJUST_LEFT,
	AdjustCenter = SV_LBOXTAB_ADJUST_CENTER,
	AdjustNumeric = SV_LBOXTAB_ADJUST_NUMERIC
};

class SvTabListBox : public SvTreeListBox
{
private:
	SvLBoxTab*					pTabList;
	USHORT						nTabCount;
	XubString					aCurEntry;
	ULONG						nDummy1;
	ULONG						nDummy2;

protected:
	static const xub_Unicode*	GetToken( const xub_Unicode* pPtr, USHORT& rLen );
	virtual void				SetTabs();
	virtual void				InitEntry( SvLBoxEntry*, const XubString&, const Image&, const Image& );
	SvLBoxEntry*				pViewParent;

public:
	SvTabListBox( Window* pParent, WinBits = WB_BORDER );
	SvTabListBox( Window* pParent, const ResId& );
	~SvTabListBox();
	void			SetTabs( long* pTabs, MapUnit = MAP_APPFONT );
	USHORT			TabCount() const { return (USHORT)nTabCount; }
	long 			GetTab( USHORT nTab ) const;
	void			SetTab( USHORT nTab, long nValue, MapUnit = MAP_APPFONT );
	long			GetLogicTab( USHORT nTab );

	SvLBoxEntry*	InsertEntry( const XubString&, ULONG nPos = LIST_APPEND,
								 USHORT nCol = 0xffff, void* pUserData = NULL );
	SvLBoxEntry*	InsertEntry( const XubString&, SvLBoxEntry* pParent,
								 ULONG nPos, USHORT nCol, void* pUserData = NULL );
	SvLBoxEntry*	InsertEntry( const XubString&, const Image& rExpandedEntryBmp,
								 const Image& rCollapsedEntryBmp, SvLBoxEntry* pParent = NULL,
								 ULONG nPos = LIST_APPEND, USHORT nCol = 0xffff, void* pUserData = NULL );

	XubString		GetEntryText( ULONG nPos, USHORT nCol = 0xffff ) const;
	XubString		GetEntryText( SvLBoxEntry*, USHORT nCol = 0xffff ) const;
	void			SetEntryText( const XubString&, ULONG, USHORT nCol=0xffff );
	void			SetEntryText(const XubString&,SvLBoxEntry*,USHORT nCol=0xffff);
	ULONG			GetEntryPos( const XubString&, USHORT nCol = 0xffff );

	virtual void	Resize();
	void			SetTabJustify( USHORT nTab, SvTabJustify );
	SvTabJustify	GetTabJustify( USHORT nTab ) const;
};

inline long SvTabListBox::GetTab( USHORT nTab ) const
{
	DBG_ASSERT( nTab < nTabCount, "GetTabPos:Invalid Tab" );
	return pTabList[nTab].GetPos();
}

// class SvHeaderTabListBox ---------------------------------------------------

class HeaderBar;

class SvHeaderTabListBox : public SvTabListBox
{
private:
	sal_Bool			mbFirstPaint;
	HeaderBar*			mpHeaderBar;

	DECL_LINK( ScrollHdl_Impl, SvTabListBox* );

public:
	SvHeaderTabListBox( Window* pParent, WinBits nBits );
	~SvHeaderTabListBox();

	virtual void	Paint( const Rectangle& );

	void			InitHeaderBar( HeaderBar* pHeaderBar );
};

#endif // #ifndef _SVTABBX_HXX

