/*************************************************************************
 *
 *  $RCSfile: agentdlg.hxx,v $
 *
 *  $Revision: 1.2.12.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:46:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _AGENTDLG_HXX
#define _AGENTDLG_HXX

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif

#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifndef _SVEDIT_HXX //autogen
#include <svtools/svmedit.hxx>
#endif

#ifndef _AGENTPG_HXX
#include <setup2/agentpg.hxx>
#endif

class Graphic;

#define LARGE_PAGE				TRUE
#define SMALL_PAGE				FALSE

#define BSTATE_SHOW_NEXT		0x0001
#define BSTATE_HIDE_NEXT    	0x0002
#define BSTATE_ENABLE_NEXT 		0x0004
#define BSTATE_DISABLE_NEXT		0x0008

#define BSTATE_SHOW_BACK    	0x0010
#define BSTATE_HIDE_BACK    	0x0020
#define BSTATE_ENABLE_BACK 		0x0040
#define BSTATE_DISABLE_BACK		0x0080

#define BSTATE_ENABLE_CANCEL	0x0100
#define BSTATE_DISABLE_CANCEL	0x0200

#define BSTATE_SHOW_ALL 	(BSTATE_SHOW_NEXT | BSTATE_ENABLE_NEXT |	\
							 BSTATE_SHOW_BACK | BSTATE_ENABLE_BACK |	\
							 BSTATE_ENABLE_CANCEL)

extern BOOL ImportGIF(SvStream& rStm, Graphic& rGraphic, void* pCallerData);

////////////////////////////////////////////////////////////////////////////////
// BinaryResLoader
//

class BinaryResLoader : public Resource
{
public:
	BinaryResLoader( SvMemoryStream& rStrm, const ResId& rId );
};

////////////////////////////////////////////////////////////////////////////////
// Model
//

struct Rule {
	USHORT m_nRetVal;
	USHORT m_nResId;
};

DECLARE_LIST(RuleList, Rule*)

class Model
{
	USHORT			m_nId;
	BOOL 			m_bIsSmallPage;
	ULONG			m_nProperty;
	CreateFnc	 	m_pCreateFnc;
	RuleList		m_aRules;

	Rule*			GetRuleFor( USHORT nRetVal );
public:
		Model( USHORT nId, CreateFnc pCreateFnc );
		~Model();

	BOOL			IsFinal() const
					{ return m_aRules.Count()? FALSE : TRUE; }

	USHORT			GetId() const						{ return m_nId; }
	CreateFnc		GetCreateFnc() const				{ return m_pCreateFnc; }
	USHORT			GetNext( USHORT nRetVal );
	void			InsertRule( USHORT nRetVal, USHORT nNextResId );

	ULONG			GetProperty() const 				{ return m_nProperty; }
	void			SetProperty(ULONG nNew)				{ m_nProperty = nNew; }

	void			SetSmallPage(BOOL bNew = SMALL_PAGE){ m_bIsSmallPage = bNew; }
	BOOL			IsSmallPage() const 				{ return m_bIsSmallPage; }
};

////////////////////////////////////////////////////////////////////////////////
// SvAgentDlg
//

DECLARE_LIST(ModelList, Model*)
DECLARE_LIST(UserList, long)

#define AGENT_STARTPAGE		TRUE

class SvAgentDlg : public ModelessDialog
{
private:
	ResMgr*				pResMgr;
	ResMgr*             m_pSecondResMgr;

	Graphic*			pAnimCD;
	BOOL 				bAnimCD;
	Timer				aStartAnimTimer;

	BOOL				bInEndDialog;
	BOOL				bInPerformNext;
	BOOL 				bInHelp;

	BOOL				bHelpAvailable;
	String 				aHelpText;
	MultiLineEdit		m_aHelpEdit;

	FixedLine			m_aFLDelim;

	PushButton			m_aPBBack;
	PushButton			m_aPBNext;
	PushButton			m_aPBHelp;
	CancelButton	   	m_aPBCancel;

	FixedBitmap*		m_pFBLogo;
	String 				m_aStrNext;
	String 				m_aStrBack;
	String				m_aStrFinal;
	String				m_aStrInstall;
	String				m_aStrUninstall;
	String				m_aStrRepair;
	String				m_aStrModify;

	Point				m_aDefBackPos;
	Point				m_aDefNextPos;
	Size				m_aDefBackSz;
	Size				m_aDefNextSz;

	USHORT				m_nStartId;
	USHORT				m_nButtonState;
	ModelList*			m_pModel;
	Model*				m_pActivModel;
	SvAgentPage*		m_pActivPage;
	UserList*			m_pUserPath;

	Link				m_aInitLink;

	void			UpdateButton();
	void			SetPage( USHORT nResId );
	DECL_LINK(ClickHdl, Control*);

	void 			StartAnimCD();
	void 			StopAnimCD();
	DECL_LINK(StartAnimHdl, void*);

	void			ShowHelp();
	void			HideHelp();
public:
		SvAgentDlg( Window* pParent, ResMgr* pMgr, USHORT nLogoResId, BOOL bAnim = FALSE );
		~SvAgentDlg();

	ResMgr*			GetResManager() const { return pResMgr; }
	SvAgentPage*	GetActivePage() const { return m_pActivPage; }
	Model*			GetModel( USHORT nResId );

	void			SetHelpAvailable(const String& rHelpText);

	void			StartAgentDlg();
	virtual BOOL	EndAgentDlg(BOOL bSucc) = 0;

	virtual void	AddAllPages();
	void			InsertPage( USHORT nResId, CreateFnc pCreateFnc,
								BOOL bIsSmall, BOOL bStartPage = FALSE );
	void	 		RuleIf( USHORT nResId, USHORT nRetVal, USHORT nNextResId );
	void	 		Rule( USHORT nResId, USHORT nNextResId );
	void			SetStartPageId( USHORT nId ) { m_nStartId = nId; }

	PushButton*		GetButtonBack() const { return (PushButton*) &m_aPBBack; }
	PushButton*		GetButtonNext() const { return (PushButton*) &m_aPBNext; }

	void			SetButtonState( USHORT nNewState = BSTATE_SHOW_ALL );
	USHORT			GetButtonState() const { return m_nButtonState; }

	String			GetInstallText() const { return m_aStrInstall; }
	String			GetUninstallText() const { return m_aStrUninstall; }
	String			GetRepairText() const { return m_aStrRepair; }
	String			GetModifyText() const { return m_aStrModify; }

	String			GetCancelText() const { return m_aPBCancel.GetText(); }
	String			GetNextText() const { return m_aPBNext.GetText(); }
	String			GetBackText() const { return m_aPBBack.GetText(); }
	void			SetNextText(const String& rText);
	void			SetBackText(const String& rText);

	void			SetInitHdl( const Link& rInitLink ) { m_aInitLink = rInitLink; }

	void			SetTitleStr( const String& rNew ) { SetText(rNew); }
	void			PerformNext();
	void			PerformBack();

	void SetSecondResMgr(ResMgr* _pResMgr) {m_pSecondResMgr = _pResMgr;}
	ResMgr* GetSecondResMgr() { return m_pSecondResMgr;}
};

#endif // _AGENTDLG_HXX

