/*************************************************************************
 *
 *  $RCSfile: ziplst.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: gh $ $Date: 2001/03/01 10:00:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ZIPLST_HXX
#define _ZIPLST_HXX

class GenericInformationList;
class GenericInformation;
class InformationClient;

/////////////////////////////////////////////////////////////////////

#define ZSTANDLIST				"r:\\b_server\\config\\stand.lst"
#define ZIPLIST					"r:\\b_server\\zip\\zip.lst"
#define ZIPROOT					"r:\\b_server\\zip"

#define ISERVER					"iserver.stardiv.de"

#define META_ENVIRONMENT		"{environment}"
#define META_SOLARPATH			"{solarpath}"
#define META_SOLARENVPATH	  	"{solarenvpath}"
#define META_PMISCPATH			"{pmiscpath}"
#define META_WORKSTAMP			"{workstamp}"
#define META_MINOR				"{minor}"
#define META_MINORSUB			"{minorsub}"
#define META_LANGUAGES			"{languages}"
#define META_LANGUAGES_ALPHA	"{languagesalpha}"
#define META_BUILDID			"{buildid}"
#define META_OS			   		"{os}"
#define META_OSDEF		   		"{osdef}"
#define META_OSALPHA 			"{osalpha}"

#define KEY_ACTIVE				"active"
#define KEY_PRIO				"prio"
#define KEY_LOG	 				"log"
#define KEY_SCRIPT				"script"
#define KEY_FATBINARY			"fatbinary"
#define KEY_SPLITSIZE			"splitsize"
#define KEY_COMPRESSION			"compression"
#define KEY_LANGUAGES			"languages"
#define KEY_DESTINATION			"destination"
#define KEY_INCLUDE				"include"
#define KEY_SUCCESS				"success"
#define KEY_FAIL				"fail"
#define KEY_WEB					"web"

struct MetaReplacement
{
	ByteString 				aMetaWorkstamp;
	ByteString 				aMetaEnvironment;
	ByteString 				aMetaMinor;
	ByteString 				aMetaMinorSub;
	ByteString 				aMetaOSDef;
	ByteString 				aMetaOS;
	ByteString				aMetaBuildID;
	ByteString				aMetaSolarPath;
	ByteString				aMetaSolarEnvPath;
};

extern ByteString GetProcessorType(const ByteString&);
extern BOOL GetMetaReplacement(MetaReplacement*, const ByteString&, GenericInformationList*, BOOL bUseEnv = TRUE);
extern ByteString DoMetaReplacement(MetaReplacement*, const ByteString&, const ByteString&);

/////////////////////////////////////////////////////////////////////

class IServerZipList
{
protected:
	GenericInformation*		m_pGenInfo;
public:

		IServerZipList();
		~IServerZipList();
	BOOL					InitZipList(InformationClient* pIClient);
	void					UnloadZipList();
	ByteString 				GetValue( GenericInformationList* pGenList, ByteString& rPath );
};

/////////////////////////////////////////////////////////////////////

class Project : public IServerZipList
{
	InformationClient*	m_pIClient;

public:
		Project( InformationClient* pIClient );
		~Project();

	void				Read( GenericInformationList* pGenList, GenericInformation* pGenInf );
	void 				ReadSettings( GenericInformationList* pGenList, const ByteString& rPath );

	Project*			GetNewOverloaded( ByteString aWorkstamp, ByteString aEnvironment, ByteString aMinor );

	ByteString				m_aName;
	BOOL					m_bActive;
	BOOL					m_bWeb;

	USHORT					m_nPrio;
	ByteString				m_aLogfile;
	ByteString				m_aScript;
	ByteString				m_aFatbinary;
	ULONG 					m_nSplitSize;
	USHORT 					m_aCompression;
	ByteString				m_aLanguages;
	ByteString				m_aDestination;
	ByteString				m_aInclude;

	ByteString				m_aSuccessRecipients;
	ByteString				m_aFailRecipients;
};

#endif // _ZIPLST_HXX
