/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsITreeBoxObject.idl
 */

#ifndef __gen_nsITreeBoxObject_h__
#define __gen_nsITreeBoxObject_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsITreeView; /* forward declaration */

class nsITreeSelection; /* forward declaration */

class nsIDOMEvent; /* forward declaration */


/* starting interface:    nsITreeBoxObject */
#define NS_ITREEBOXOBJECT_IID_STR "44481385-b1da-480a-9026-1f0232c4ee59"

#define NS_ITREEBOXOBJECT_IID \
  {0x44481385, 0xb1da, 0x480a, \
    { 0x90, 0x26, 0x1f, 0x02, 0x32, 0xc4, 0xee, 0x59 }}

class NS_NO_VTABLE nsITreeBoxObject : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITREEBOXOBJECT_IID)

  /**
   * The view that backs the tree and that supplies it with its data.
   * It is dynamically settable, either using a view attribute on the
   * tree tag or by setting this attribute to a new value.
   */
  /* attribute nsITreeView view; */
  NS_IMETHOD GetView(nsITreeView * *aView) = 0;
  NS_IMETHOD SetView(nsITreeView * aView) = 0;

  /**
   * Whether or not we are currently focused.
   */
  /* attribute boolean focused; */
  NS_IMETHOD GetFocused(PRBool *aFocused) = 0;
  NS_IMETHOD SetFocused(PRBool aFocused) = 0;

  /**
   * Obtain the treebody content node
   */
  /* readonly attribute nsIDOMElement treeBody; */
  NS_IMETHOD GetTreeBody(nsIDOMElement * *aTreeBody) = 0;

  /**
   * Obtains the selection from the view.
   */
  /* readonly attribute nsITreeSelection selection; */
  NS_IMETHOD GetSelection(nsITreeSelection * *aSelection) = 0;

  /**
   * Obtain the height of a row.
   */
  /* readonly attribute long rowHeight; */
  NS_IMETHOD GetRowHeight(PRInt32 *aRowHeight) = 0;

  /**
   * Get the index of the specified column.
   */
  /* long getColumnIndex (in wstring colID); */
  NS_IMETHOD GetColumnIndex(const PRUnichar *colID, PRInt32 *_retval) = 0;

  /**
   * Get the index of the first visible row.
   */
  /* long getFirstVisibleRow (); */
  NS_IMETHOD GetFirstVisibleRow(PRInt32 *_retval) = 0;

  /**
   * Get the index of the last visible row.
   */
  /* long getLastVisibleRow (); */
  NS_IMETHOD GetLastVisibleRow(PRInt32 *_retval) = 0;

  /**
   * Gets the number of possible visible rows.
   */
  /* long getPageCount (); */
  NS_IMETHOD GetPageCount(PRInt32 *_retval) = 0;

  /**
   * Ensures that a row at a given index is visible.
   */
  /* void ensureRowIsVisible (in long index); */
  NS_IMETHOD EnsureRowIsVisible(PRInt32 index) = 0;

  /**
   * Scrolls such that the row at index is at the top of the visible view.
   */
  /* void scrollToRow (in long index); */
  NS_IMETHOD ScrollToRow(PRInt32 index) = 0;

  /**
   * Scroll the tree up or down by numLines lines. Positive
   * values move down in the tree. Prevents scrolling off the
   * end of the tree. 
   */
  /* void scrollByLines (in long numLines); */
  NS_IMETHOD ScrollByLines(PRInt32 numLines) = 0;

  /**
   * Scroll the tree up or down by numPages pages. A page
   * is considered to be the amount displayed by the tree.
   * Positive values move down in the tree. Prevents scrolling
   * off the end of the tree.
   */
  /* void scrollByPages (in long numPages); */
  NS_IMETHOD ScrollByPages(PRInt32 numPages) = 0;

  /**
   * Invalidation methods for fine-grained painting control.
   */
  /* void invalidate (); */
  NS_IMETHOD Invalidate(void) = 0;

  /* void invalidateColumn (in wstring colID); */
  NS_IMETHOD InvalidateColumn(const PRUnichar *colID) = 0;

  /* void invalidateRow (in long index); */
  NS_IMETHOD InvalidateRow(PRInt32 index) = 0;

  /* void invalidateCell (in long row, in wstring colID); */
  NS_IMETHOD InvalidateCell(PRInt32 row, const PRUnichar *colID) = 0;

  /* void invalidatePrimaryCell (in long row); */
  NS_IMETHOD InvalidatePrimaryCell(PRInt32 row) = 0;

  /* void invalidateRange (in long startIndex, in long endIndex); */
  NS_IMETHOD InvalidateRange(PRInt32 startIndex, PRInt32 endIndex) = 0;

  /* void invalidateScrollbar (); */
  NS_IMETHOD InvalidateScrollbar(void) = 0;

  /**
   * A hit test that can tell you what cell the mouse is over.  Row is the row index
   * hit,  returns -1 for invalid mouse coordinates.  ColID is the column hit.
   * ChildElt is the pseudoelement hit: this can have values of
   * "cell", "twisty", "image", and "text".
   */
  /* void getCellAt (in long x, in long y, out long row, out wstring colID, out wstring childElt); */
  NS_IMETHOD GetCellAt(PRInt32 x, PRInt32 y, PRInt32 *row, PRUnichar **colID, PRUnichar **childElt) = 0;

  /** 
   * Find the coordinates of an element within a specific cell. 
   */
  /* void getCoordsForCellItem (in long row, in wstring colID, in wstring element, out long x, out long y, out long width, out long height); */
  NS_IMETHOD GetCoordsForCellItem(PRInt32 row, const PRUnichar *colID, const PRUnichar *element, PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) = 0;

  /** 
   * Determine if the text of a cell is being cropped or not.
   */
  /* boolean isCellCropped (in long row, in AString colID); */
  NS_IMETHOD IsCellCropped(PRInt32 row, const nsAString & colID, PRBool *_retval) = 0;

  /**
   * The view is responsible for calling these notification methods when
   * rows are added or removed.  Index is the position at which the new
   * rows were added or at which rows were removed.  For
   * non-contiguous additions/removals, this method should be called multiple times.
   */
  /* void rowCountChanged (in long index, in long count); */
  NS_IMETHOD RowCountChanged(PRInt32 index, PRInt32 count) = 0;

  /**
   * Drag handlers, installed from XBL, called when drags occur to handle painting
   */
  /* void onDragEnter (in nsIDOMEvent event); */
  NS_IMETHOD OnDragEnter(nsIDOMEvent *event) = 0;

  /* void onDragExit (in nsIDOMEvent event); */
  NS_IMETHOD OnDragExit(nsIDOMEvent *event) = 0;

  /* void onDragOver (in nsIDOMEvent event); */
  NS_IMETHOD OnDragOver(nsIDOMEvent *event) = 0;

  /* void onDragDrop (in nsIDOMEvent event); */
  NS_IMETHOD OnDragDrop(nsIDOMEvent *event) = 0;

  /**
   * Called on a theme switch to flush out the tree's style and image caches.
   */
  /* void clearStyleAndImageCaches (); */
  NS_IMETHOD ClearStyleAndImageCaches(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITREEBOXOBJECT \
  NS_IMETHOD GetView(nsITreeView * *aView); \
  NS_IMETHOD SetView(nsITreeView * aView); \
  NS_IMETHOD GetFocused(PRBool *aFocused); \
  NS_IMETHOD SetFocused(PRBool aFocused); \
  NS_IMETHOD GetTreeBody(nsIDOMElement * *aTreeBody); \
  NS_IMETHOD GetSelection(nsITreeSelection * *aSelection); \
  NS_IMETHOD GetRowHeight(PRInt32 *aRowHeight); \
  NS_IMETHOD GetColumnIndex(const PRUnichar *colID, PRInt32 *_retval); \
  NS_IMETHOD GetFirstVisibleRow(PRInt32 *_retval); \
  NS_IMETHOD GetLastVisibleRow(PRInt32 *_retval); \
  NS_IMETHOD GetPageCount(PRInt32 *_retval); \
  NS_IMETHOD EnsureRowIsVisible(PRInt32 index); \
  NS_IMETHOD ScrollToRow(PRInt32 index); \
  NS_IMETHOD ScrollByLines(PRInt32 numLines); \
  NS_IMETHOD ScrollByPages(PRInt32 numPages); \
  NS_IMETHOD Invalidate(void); \
  NS_IMETHOD InvalidateColumn(const PRUnichar *colID); \
  NS_IMETHOD InvalidateRow(PRInt32 index); \
  NS_IMETHOD InvalidateCell(PRInt32 row, const PRUnichar *colID); \
  NS_IMETHOD InvalidatePrimaryCell(PRInt32 row); \
  NS_IMETHOD InvalidateRange(PRInt32 startIndex, PRInt32 endIndex); \
  NS_IMETHOD InvalidateScrollbar(void); \
  NS_IMETHOD GetCellAt(PRInt32 x, PRInt32 y, PRInt32 *row, PRUnichar **colID, PRUnichar **childElt); \
  NS_IMETHOD GetCoordsForCellItem(PRInt32 row, const PRUnichar *colID, const PRUnichar *element, PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height); \
  NS_IMETHOD IsCellCropped(PRInt32 row, const nsAString & colID, PRBool *_retval); \
  NS_IMETHOD RowCountChanged(PRInt32 index, PRInt32 count); \
  NS_IMETHOD OnDragEnter(nsIDOMEvent *event); \
  NS_IMETHOD OnDragExit(nsIDOMEvent *event); \
  NS_IMETHOD OnDragOver(nsIDOMEvent *event); \
  NS_IMETHOD OnDragDrop(nsIDOMEvent *event); \
  NS_IMETHOD ClearStyleAndImageCaches(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITREEBOXOBJECT(_to) \
  NS_IMETHOD GetView(nsITreeView * *aView) { return _to GetView(aView); } \
  NS_IMETHOD SetView(nsITreeView * aView) { return _to SetView(aView); } \
  NS_IMETHOD GetFocused(PRBool *aFocused) { return _to GetFocused(aFocused); } \
  NS_IMETHOD SetFocused(PRBool aFocused) { return _to SetFocused(aFocused); } \
  NS_IMETHOD GetTreeBody(nsIDOMElement * *aTreeBody) { return _to GetTreeBody(aTreeBody); } \
  NS_IMETHOD GetSelection(nsITreeSelection * *aSelection) { return _to GetSelection(aSelection); } \
  NS_IMETHOD GetRowHeight(PRInt32 *aRowHeight) { return _to GetRowHeight(aRowHeight); } \
  NS_IMETHOD GetColumnIndex(const PRUnichar *colID, PRInt32 *_retval) { return _to GetColumnIndex(colID, _retval); } \
  NS_IMETHOD GetFirstVisibleRow(PRInt32 *_retval) { return _to GetFirstVisibleRow(_retval); } \
  NS_IMETHOD GetLastVisibleRow(PRInt32 *_retval) { return _to GetLastVisibleRow(_retval); } \
  NS_IMETHOD GetPageCount(PRInt32 *_retval) { return _to GetPageCount(_retval); } \
  NS_IMETHOD EnsureRowIsVisible(PRInt32 index) { return _to EnsureRowIsVisible(index); } \
  NS_IMETHOD ScrollToRow(PRInt32 index) { return _to ScrollToRow(index); } \
  NS_IMETHOD ScrollByLines(PRInt32 numLines) { return _to ScrollByLines(numLines); } \
  NS_IMETHOD ScrollByPages(PRInt32 numPages) { return _to ScrollByPages(numPages); } \
  NS_IMETHOD Invalidate(void) { return _to Invalidate(); } \
  NS_IMETHOD InvalidateColumn(const PRUnichar *colID) { return _to InvalidateColumn(colID); } \
  NS_IMETHOD InvalidateRow(PRInt32 index) { return _to InvalidateRow(index); } \
  NS_IMETHOD InvalidateCell(PRInt32 row, const PRUnichar *colID) { return _to InvalidateCell(row, colID); } \
  NS_IMETHOD InvalidatePrimaryCell(PRInt32 row) { return _to InvalidatePrimaryCell(row); } \
  NS_IMETHOD InvalidateRange(PRInt32 startIndex, PRInt32 endIndex) { return _to InvalidateRange(startIndex, endIndex); } \
  NS_IMETHOD InvalidateScrollbar(void) { return _to InvalidateScrollbar(); } \
  NS_IMETHOD GetCellAt(PRInt32 x, PRInt32 y, PRInt32 *row, PRUnichar **colID, PRUnichar **childElt) { return _to GetCellAt(x, y, row, colID, childElt); } \
  NS_IMETHOD GetCoordsForCellItem(PRInt32 row, const PRUnichar *colID, const PRUnichar *element, PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return _to GetCoordsForCellItem(row, colID, element, x, y, width, height); } \
  NS_IMETHOD IsCellCropped(PRInt32 row, const nsAString & colID, PRBool *_retval) { return _to IsCellCropped(row, colID, _retval); } \
  NS_IMETHOD RowCountChanged(PRInt32 index, PRInt32 count) { return _to RowCountChanged(index, count); } \
  NS_IMETHOD OnDragEnter(nsIDOMEvent *event) { return _to OnDragEnter(event); } \
  NS_IMETHOD OnDragExit(nsIDOMEvent *event) { return _to OnDragExit(event); } \
  NS_IMETHOD OnDragOver(nsIDOMEvent *event) { return _to OnDragOver(event); } \
  NS_IMETHOD OnDragDrop(nsIDOMEvent *event) { return _to OnDragDrop(event); } \
  NS_IMETHOD ClearStyleAndImageCaches(void) { return _to ClearStyleAndImageCaches(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITREEBOXOBJECT(_to) \
  NS_IMETHOD GetView(nsITreeView * *aView) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetView(aView); } \
  NS_IMETHOD SetView(nsITreeView * aView) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetView(aView); } \
  NS_IMETHOD GetFocused(PRBool *aFocused) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFocused(aFocused); } \
  NS_IMETHOD SetFocused(PRBool aFocused) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFocused(aFocused); } \
  NS_IMETHOD GetTreeBody(nsIDOMElement * *aTreeBody) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTreeBody(aTreeBody); } \
  NS_IMETHOD GetSelection(nsITreeSelection * *aSelection) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelection(aSelection); } \
  NS_IMETHOD GetRowHeight(PRInt32 *aRowHeight) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRowHeight(aRowHeight); } \
  NS_IMETHOD GetColumnIndex(const PRUnichar *colID, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetColumnIndex(colID, _retval); } \
  NS_IMETHOD GetFirstVisibleRow(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstVisibleRow(_retval); } \
  NS_IMETHOD GetLastVisibleRow(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastVisibleRow(_retval); } \
  NS_IMETHOD GetPageCount(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPageCount(_retval); } \
  NS_IMETHOD EnsureRowIsVisible(PRInt32 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->EnsureRowIsVisible(index); } \
  NS_IMETHOD ScrollToRow(PRInt32 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->ScrollToRow(index); } \
  NS_IMETHOD ScrollByLines(PRInt32 numLines) { return !_to ? NS_ERROR_NULL_POINTER : _to->ScrollByLines(numLines); } \
  NS_IMETHOD ScrollByPages(PRInt32 numPages) { return !_to ? NS_ERROR_NULL_POINTER : _to->ScrollByPages(numPages); } \
  NS_IMETHOD Invalidate(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Invalidate(); } \
  NS_IMETHOD InvalidateColumn(const PRUnichar *colID) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidateColumn(colID); } \
  NS_IMETHOD InvalidateRow(PRInt32 index) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidateRow(index); } \
  NS_IMETHOD InvalidateCell(PRInt32 row, const PRUnichar *colID) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidateCell(row, colID); } \
  NS_IMETHOD InvalidatePrimaryCell(PRInt32 row) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidatePrimaryCell(row); } \
  NS_IMETHOD InvalidateRange(PRInt32 startIndex, PRInt32 endIndex) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidateRange(startIndex, endIndex); } \
  NS_IMETHOD InvalidateScrollbar(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->InvalidateScrollbar(); } \
  NS_IMETHOD GetCellAt(PRInt32 x, PRInt32 y, PRInt32 *row, PRUnichar **colID, PRUnichar **childElt) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCellAt(x, y, row, colID, childElt); } \
  NS_IMETHOD GetCoordsForCellItem(PRInt32 row, const PRUnichar *colID, const PRUnichar *element, PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCoordsForCellItem(row, colID, element, x, y, width, height); } \
  NS_IMETHOD IsCellCropped(PRInt32 row, const nsAString & colID, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCellCropped(row, colID, _retval); } \
  NS_IMETHOD RowCountChanged(PRInt32 index, PRInt32 count) { return !_to ? NS_ERROR_NULL_POINTER : _to->RowCountChanged(index, count); } \
  NS_IMETHOD OnDragEnter(nsIDOMEvent *event) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDragEnter(event); } \
  NS_IMETHOD OnDragExit(nsIDOMEvent *event) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDragExit(event); } \
  NS_IMETHOD OnDragOver(nsIDOMEvent *event) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDragOver(event); } \
  NS_IMETHOD OnDragDrop(nsIDOMEvent *event) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDragDrop(event); } \
  NS_IMETHOD ClearStyleAndImageCaches(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearStyleAndImageCaches(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTreeBoxObject : public nsITreeBoxObject
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITREEBOXOBJECT

  nsTreeBoxObject();
  virtual ~nsTreeBoxObject();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTreeBoxObject, nsITreeBoxObject)

nsTreeBoxObject::nsTreeBoxObject()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsTreeBoxObject::~nsTreeBoxObject()
{
  /* destructor code */
}

/* attribute nsITreeView view; */
NS_IMETHODIMP nsTreeBoxObject::GetView(nsITreeView * *aView)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsTreeBoxObject::SetView(nsITreeView * aView)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean focused; */
NS_IMETHODIMP nsTreeBoxObject::GetFocused(PRBool *aFocused)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsTreeBoxObject::SetFocused(PRBool aFocused)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIDOMElement treeBody; */
NS_IMETHODIMP nsTreeBoxObject::GetTreeBody(nsIDOMElement * *aTreeBody)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsITreeSelection selection; */
NS_IMETHODIMP nsTreeBoxObject::GetSelection(nsITreeSelection * *aSelection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long rowHeight; */
NS_IMETHODIMP nsTreeBoxObject::GetRowHeight(PRInt32 *aRowHeight)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getColumnIndex (in wstring colID); */
NS_IMETHODIMP nsTreeBoxObject::GetColumnIndex(const PRUnichar *colID, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getFirstVisibleRow (); */
NS_IMETHODIMP nsTreeBoxObject::GetFirstVisibleRow(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getLastVisibleRow (); */
NS_IMETHODIMP nsTreeBoxObject::GetLastVisibleRow(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getPageCount (); */
NS_IMETHODIMP nsTreeBoxObject::GetPageCount(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ensureRowIsVisible (in long index); */
NS_IMETHODIMP nsTreeBoxObject::EnsureRowIsVisible(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void scrollToRow (in long index); */
NS_IMETHODIMP nsTreeBoxObject::ScrollToRow(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void scrollByLines (in long numLines); */
NS_IMETHODIMP nsTreeBoxObject::ScrollByLines(PRInt32 numLines)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void scrollByPages (in long numPages); */
NS_IMETHODIMP nsTreeBoxObject::ScrollByPages(PRInt32 numPages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidate (); */
NS_IMETHODIMP nsTreeBoxObject::Invalidate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidateColumn (in wstring colID); */
NS_IMETHODIMP nsTreeBoxObject::InvalidateColumn(const PRUnichar *colID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidateRow (in long index); */
NS_IMETHODIMP nsTreeBoxObject::InvalidateRow(PRInt32 index)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidateCell (in long row, in wstring colID); */
NS_IMETHODIMP nsTreeBoxObject::InvalidateCell(PRInt32 row, const PRUnichar *colID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidatePrimaryCell (in long row); */
NS_IMETHODIMP nsTreeBoxObject::InvalidatePrimaryCell(PRInt32 row)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidateRange (in long startIndex, in long endIndex); */
NS_IMETHODIMP nsTreeBoxObject::InvalidateRange(PRInt32 startIndex, PRInt32 endIndex)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void invalidateScrollbar (); */
NS_IMETHODIMP nsTreeBoxObject::InvalidateScrollbar()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCellAt (in long x, in long y, out long row, out wstring colID, out wstring childElt); */
NS_IMETHODIMP nsTreeBoxObject::GetCellAt(PRInt32 x, PRInt32 y, PRInt32 *row, PRUnichar **colID, PRUnichar **childElt)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCoordsForCellItem (in long row, in wstring colID, in wstring element, out long x, out long y, out long width, out long height); */
NS_IMETHODIMP nsTreeBoxObject::GetCoordsForCellItem(PRInt32 row, const PRUnichar *colID, const PRUnichar *element, PRInt32 *x, PRInt32 *y, PRInt32 *width, PRInt32 *height)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isCellCropped (in long row, in AString colID); */
NS_IMETHODIMP nsTreeBoxObject::IsCellCropped(PRInt32 row, const nsAString & colID, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void rowCountChanged (in long index, in long count); */
NS_IMETHODIMP nsTreeBoxObject::RowCountChanged(PRInt32 index, PRInt32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDragEnter (in nsIDOMEvent event); */
NS_IMETHODIMP nsTreeBoxObject::OnDragEnter(nsIDOMEvent *event)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDragExit (in nsIDOMEvent event); */
NS_IMETHODIMP nsTreeBoxObject::OnDragExit(nsIDOMEvent *event)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDragOver (in nsIDOMEvent event); */
NS_IMETHODIMP nsTreeBoxObject::OnDragOver(nsIDOMEvent *event)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void onDragDrop (in nsIDOMEvent event); */
NS_IMETHODIMP nsTreeBoxObject::OnDragDrop(nsIDOMEvent *event)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearStyleAndImageCaches (); */
NS_IMETHODIMP nsTreeBoxObject::ClearStyleAndImageCaches()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// Initializer,

#endif /* __gen_nsITreeBoxObject_h__ */
