/*************************************************************************
 *
 *  $RCSfile: inetftp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 12:38:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETFTP_HXX
#define _INETFTP_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

class List;
class SvLockBytes;
class SvOpenLockBytes;

/*======================================================================
 *
 * INetCoreFTPConnection interface.
 *
 * References:
 *   RFC  959 - File Transfer Protocol (STD 9)
 *   RFC 1123 - Requirements for Internet Hosts (STD 3)
 *   RFC 1579 - Firewall-Friendly FTP (Informational)
 *   RFC 1920 - Internet Official Protocol Standards (STD 1)
 *
 *====================================================================*/
#define INETCOREFTP_CMD_PORT 21

#define INETCOREFTP_FILEMODE_UNKNOWN 0x00
#define INETCOREFTP_FILEMODE_READ    0x01
#define INETCOREFTP_FILEMODE_WRITE   0x02
#define INETCOREFTP_FILEMODE_ISDIR   0x04
#define INETCOREFTP_FILEMODE_ISLINK  0x08

/*======================================================================
 *
 * INetFTPConnection interface.
 *
 *====================================================================*/
#ifdef _USE_NAMESPACE
namespace inet {
#endif

struct INetFTPDirentry
{
	rtl::OUString m_aName;
	DateTime      m_aDate;
	sal_uInt32    m_nMode;
	sal_uInt32    m_nSize;

	INetFTPDirentry (void)
		: m_aDate (Date(0), Time(0)),
		  m_nMode (INETCOREFTP_FILEMODE_UNKNOWN),
		  m_nSize ((sal_uInt32)(-1))
	{}
};

class INetFTPConnection;

typedef sal_Bool INetFTPCallback (
	INetFTPConnection *pConnection,
	sal_Int32          nReplyCode,
	const sal_Char    *pReplyText,
	void              *pData);

class INetFTPConnection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetFTPConnection, inet));

public:
	/** Reply.
	 */
	enum Reply
	{
		// Implementation defined reply (-x)
		REPLY_TRANSFER_WAIT      = -18,

		REPLY_RESPONSE_DONE      = -16,
		REPLY_RESPONSE_ERROR     = -15,
		REPLY_RESPONSE_WAIT      = -14,

		REPLY_REQUEST_DONE       = -12,
		REPLY_REQUEST_ERROR      = -11,
		REPLY_REQUEST_WAIT       = -10,

		REPLY_CONNECT_DONE       =  -8,
		REPLY_CONNECT_ERROR      =  -7,
		REPLY_CONNECT_WAIT       =  -6,

		REPLY_RESOLVER_DONE      =  -4,
		REPLY_RESOLVER_ERROR     =  -3,
		REPLY_RESOLVER_WAIT      =  -2,

		REPLY_NETWORK_ERROR      =  -1,

		// Positive preliminary reply (1xx)
		REPLY_SERVICE_DELAYED    = 120,
		REPLY_TRANSFER_STARTING  = 125,
		REPLY_OPENING_DCON       = 150,

		// Positive completion reply (2xx)
		REPLY_CMD_OK             = 200,
		REPLY_CMD_NOT_NECESSARY  = 202,
		REPLY_SERVICE_READY      = 220,
		REPLY_PASSIVE_MODE       = 227,
		REPLY_USER_LOGGED_IN     = 230,
		REPLY_FILE_ACTION_OK     = 250,
		REPLY_PATHNAME_CREATED   = 257,

		// Positive intermediate reply (3xx)
		REPLY_NEED_PASSWORD      = 331,
		REPLY_NEED_ACCOUNT       = 332,
		REPLY_NEED_XFERCMD       = 350,

		// Transient Negative Completion reply (4xx)
		REPLY_SERVICE_UNAVAIL    = 421,
		REPLY_OPEN_DCON_ERROR    = 425,
		REPLY_TRANSFER_ABORTED   = 426,

		// Permanent Negative Completion reply (5xx)
		REPLY_SYNTAX_ERROR       = 500,
		REPLY_PARAM_SYNTAX_ERROR = 501,
		REPLY_BAD_CMD_SEQUENCE   = 503,
		REPLY_NOT_LOGGED_IN      = 530
	};

	/** createInstance.
	 */
	static sal_Bool createInstance (
		NAMESPACE_VOS(ORef)<INetFTPConnection> &rxConnection);

	/** Open.
	 */
	virtual sal_Bool open (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool isOpen (void) const = 0;

	/** Login.
	 */
	virtual sal_Bool loginUsername (
		const rtl::OUString &rUsername,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool loginPassword (
		const rtl::OUString &rPassword,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool loginAccount (
		const rtl::OUString &rAccount,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool isLoggedIn (void) const = 0;

	/** Close.
	 */
	virtual sal_Bool close (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual void abort (void) = 0;

	/** Noop.
	 */
	virtual sal_Bool noop (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	/** Working Directory.
	 */
	virtual sal_Bool setCurDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	virtual sal_Bool getCurDir (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	virtual const rtl::OUString& getCurDir (void) const = 0;

	/** Directory.
	 */
	virtual sal_Bool makeDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool removeDir (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	/** Remove.
	 */
	virtual sal_Bool remove (
		const rtl::OUString &rPathname,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	/** Rename.
	 */
	virtual sal_Bool renameFrom (
		const rtl::OUString &rFromPath,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;
	virtual sal_Bool renameTo (
		const rtl::OUString &rToPath,
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	/** Data type.
	 */
	enum DataType
	{
		DATA_TYPE_UNKNOWN,
		DATA_TYPE_ASCII,
		DATA_TYPE_IMAGE
	};

	virtual sal_Bool setTypeAscii (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	virtual sal_Bool setTypeImage (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	virtual DataType getDataType (void) const = 0;

	/** Directory Listing.
	 */
	enum ListType
	{
		LIST_TYPE_UNDETERMINED = -1, // Not yet determined.
		LIST_TYPE_UNKNOWN      =  0, // NLST
		LIST_TYPE_DOS          =  1, // LIST (dir)
		LIST_TYPE_UNIX         =  2, // LIST (ls -l)
		LIST_TYPE_VMS          =  3  // LIST (directory/size/date)
	};

	virtual sal_Bool getNameList (
		const rtl::OUString &rPathname,
		List                &rNameList,
		INetFTPCallback     *pfnCB,
		void                *pDataCB) = 0;

	virtual ListType getListType (void) const = 0;

	/** Retrieve.
	 */
	virtual sal_Bool retrieve (
		const rtl::OUString &rFromPath,
		SvOpenLockBytes     *pToPath,
		sal_uInt32           nRestartOffset,
		INetFTPCallback     *pfnCB,
		void                *pDataCB) = 0;

	virtual sal_uInt32 getRetrieveCount (void) const = 0;

	/** Store.
	 */
	virtual sal_Bool store (
		SvLockBytes         *pFromPath,
		const rtl::OUString &rToPath,
		sal_uInt32           nRestartOffset,
		INetFTPCallback     *pfnCB,
		void                *pDataCB) = 0;

	virtual sal_uInt32 getStoreCount (void) const = 0;

	/** Abort transfer command (LIST|RETR|STOR).
	 */
	virtual sal_Bool abortTransfer (sal_Bool bSilent = sal_True) = 0;

	/** Callbacks.
	 */
	virtual sal_Bool setTransferCallback (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	virtual sal_Bool setTerminateCallback (
		INetFTPCallback *pfnCB, void *pDataCB) = 0;

	/** Socks.
	 */
	virtual const rtl::OUString& getSocksGatewayName (void) const = 0;
	virtual sal_uInt16           getSocksGatewayPort (void) const = 0;

	virtual sal_Bool hasSocksGateway (void) const = 0;
	virtual void     setSocksGateway (
		const rtl::OUString &rName, sal_uInt16 nPort) = 0;

protected:
	/** Construction, destruction.
	 */
	INetFTPConnection (void);
	virtual ~INetFTPConnection (void);

private:
	/** Not implemented.
	 */
	INetFTPConnection (const INetFTPConnection&);
	INetFTPConnection& operator= (const INetFTPConnection&);
};

/*======================================================================
 *
 * The End.
 *
 *====================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INETFTP_HXX */

