/*
 * Decompiled with CFR 0.152.
 */
package stardiv.net.protocol.appletresource;

import com.sun.star.lib.sandbox.ResourceProxy;
import com.sun.star.lib.sandbox.SandboxSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import sun.net.www.URLConnection;

public class AppletResourceConnection
extends URLConnection {
    private static boolean debug = false;
    private Object resource;
    private String base;
    private String member;
    private URL cachedURL;

    protected AppletResourceConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.debug("AppletResourceConnection(" + uRL + ")");
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.base = string.substring(0, string.indexOf("/+/"));
        this.member = string.substring(string.indexOf("/+/") + 3);
        this.cachedURL = new URL(this.base + this.member);
        this.debug(" base: " + this.base);
        this.debug(" member: " + this.member);
        this.debug(" cachedURL: " + this.cachedURL);
    }

    public static synchronized Object getContent(ResourceProxy resourceProxy, URL uRL) {
        Object object;
        block4: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            object = null;
            try {
                object = resourceProxy.getContent();
                if (object != null && object instanceof String) {
                    throw new SandboxSecurityException("getresource.noclassaccess", uRL.toString());
                }
            }
            catch (IOException iOException) {
                if (!debug) break block4;
                System.err.println("#### AppletResourceConnection.getContent - exception:" + iOException);
            }
        }
        return object;
    }

    public void connect() throws IOException {
        this.debug("Looking for " + this.cachedURL + " in AppletResourceLoader");
        ResourceProxy resourceProxy = ResourceProxy.load((URL)this.cachedURL, null);
        Object object = AppletResourceConnection.getContent(resourceProxy, this.cachedURL);
        if (object == null) {
            this.debug("Invalid resource name");
            this.resource = null;
            return;
        }
        this.debug("Found resource");
        this.resource = object;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return ResourceProxy.load((URL)this.cachedURL, null).getInputStream();
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

