/*
 * Decompiled with CFR 0.152.
 */
package stardiv.app;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import stardiv.app.AppletMessageHandler;
import stardiv.app.AppletViewer;
import stardiv.applet.AppletExecutionContext;
import sun.net.www.http.HttpClient;

public class AppletProps
extends Frame {
    TextField proxyHost;
    TextField proxyPort;
    Choice networkMode;
    Choice accessMode;
    Choice unsignedMode;
    AppletExecutionContext appletExecutionContext;
    private static AppletMessageHandler amh = new AppletMessageHandler("appletprops");

    AppletProps(AppletExecutionContext appletExecutionContext) {
        this.appletExecutionContext = appletExecutionContext;
        this.setTitle(amh.getMessage("title"));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(amh.getMessage("label.http.server", "Http proxy server:")));
        this.proxyHost = new TextField();
        panel.add(this.proxyHost);
        panel.add(new Label(amh.getMessage("label.http.proxy")));
        this.proxyPort = new TextField();
        panel.add(this.proxyPort);
        panel.add(new Label(amh.getMessage("label.network")));
        this.networkMode = new Choice();
        panel.add(this.networkMode);
        this.networkMode.addItem(amh.getMessage("choice.network.item.none"));
        this.networkMode.addItem(amh.getMessage("choice.network.item.applethost"));
        this.networkMode.addItem(amh.getMessage("choice.network.item.unrestricted"));
        String string = System.getProperty("appletviewer.security.mode");
        string = string == null ? "none" : string;
        string = string.equals("host") ? "applethost" : string;
        this.networkMode.select(amh.getMessage("choice.network.item." + string));
        panel.add(new Label(amh.getMessage("label.class")));
        this.accessMode = new Choice();
        panel.add(this.accessMode);
        this.accessMode.addItem(amh.getMessage("choice.class.item.restricted"));
        this.accessMode.addItem(amh.getMessage("choice.class.item.unrestricted"));
        this.accessMode.select(Boolean.getBoolean("package.restrict.access.sun") ? amh.getMessage("choice.class.item.restricted") : amh.getMessage("choice.class.item.unrestricted"));
        panel.add(new Label(amh.getMessage("label.unsignedapplet")));
        this.unsignedMode = new Choice();
        panel.add(this.unsignedMode);
        this.unsignedMode.addItem(amh.getMessage("choice.unsignedapplet.no"));
        this.unsignedMode.addItem(amh.getMessage("choice.unsignedapplet.yes"));
        this.add("Center", panel);
        panel = new Panel();
        panel.add(new Button(amh.getMessage("button.apply")));
        panel.add(new Button(amh.getMessage("button.reset")));
        panel.add(new Button(amh.getMessage("button.cancel")));
        this.add("South", panel);
        ((Component)this).setLocation(200, 150);
        this.pack();
        this.reset();
    }

    void reset() {
        if (System.getProperty("http.proxyHost") != null) {
            this.proxyHost.setText(System.getProperty("http.proxyHost"));
            this.proxyPort.setText(System.getProperty("http.proxyPort"));
            HttpClient.proxyPort = Integer.valueOf(System.getProperty("http.proxyPort"));
        } else {
            this.proxyHost.setText("");
            this.proxyPort.setText("");
        }
    }

    void apply() {
        Properties properties = System.getProperties();
        if (this.proxyHost.getText().length() > 0) {
            ((Hashtable)properties).put("http.proxyHost", this.proxyHost.getText().trim());
            ((Hashtable)properties).put("http.proxyPort", this.proxyPort.getText().trim());
        } else {
            ((Hashtable)properties).remove("http.proxyHost");
        }
        if ("None".equals(this.networkMode.getSelectedItem())) {
            ((Hashtable)properties).put("appletviewer.security.mode", "none");
        } else if ("Unrestricted".equals(this.networkMode.getSelectedItem())) {
            ((Hashtable)properties).put("appletviewer.security.mode", "unrestricted");
        } else {
            ((Hashtable)properties).put("appletviewer.security.mode", "host");
        }
        if ("Restricted".equals(this.accessMode.getSelectedItem())) {
            ((Hashtable)properties).put("package.restrict.access.sun", "true");
            ((Hashtable)properties).put("package.restrict.access.netscape", "true");
            ((Hashtable)properties).put("package.restrict.access.stardiv", "true");
        } else {
            ((Hashtable)properties).put("package.restrict.access.sun", "false");
            ((Hashtable)properties).put("package.restrict.access.netscape", "false");
            ((Hashtable)properties).put("package.restrict.access.stardiv", "false");
        }
        if ("Yes".equals(this.unsignedMode.getSelectedItem())) {
            ((Hashtable)properties).put("appletviewer.security.allowUnsigned", "true");
        } else {
            ((Hashtable)properties).put("appletviewer.security.allowUnsigned", "false");
        }
        try {
            this.reset();
            FileOutputStream fileOutputStream = new FileOutputStream(AppletViewer.theUserPropertiesFile);
            properties.save(fileOutputStream, "AppletViewer");
            fileOutputStream.close();
            ((Component)this).setVisible(false);
        }
        catch (IOException iOException) {
            System.out.println(amh.getMessage("apply.exception", iOException));
            iOException.printStackTrace();
            this.reset();
        }
    }

    public boolean action(Event event, Object object) {
        if (amh.getMessage("button.apply").equals(object)) {
            this.apply();
            return true;
        }
        if (amh.getMessage("button.reset").equals(object)) {
            this.reset();
            return true;
        }
        if (amh.getMessage("button.cancel").equals(object)) {
            ((Component)this).setVisible(false);
            return true;
        }
        return false;
    }
}

