/*************************************************************************
 *
 *  $RCSfile: access.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_ACCESS_HXX
#define _SV_ACCESS_HXX

#include <tools/ref.hxx>
#include <tools/rtti.hxx>
#include <tools/string.hxx>
#include <vcl/wintypes.hxx>

// ------------
// - Forwards -
// ------------

class Window;
class Menu;
class TabControl;

// --------
// - TYPE -
// --------

#define ACCESS_TYPE_NONE				0x00000000UL
#define ACCESS_TYPE_WND 				0x00000001UL
#define ACCESS_TYPE_TOOLBOX 			0x00000002UL
#define ACCESS_TYPE_TOOLBOXITEM 		0x00000004UL
#define ACCESS_TYPE_MENUBAR 			0x00000008UL
#define ACCESS_TYPE_MENU				0x00000010UL
#define ACCESS_TYPE_MENUITEM			0x00000020UL
#define ACCESS_TYPE_KEY 				0x00000040UL

// ----------
// - Events -
// ----------

#define ACCESS_EVENT_NONE				0x00000000UL
#define ACCESS_EVENT_MODALDIALOG_START	0x00000002UL
#define ACCESS_EVENT_MODALDIALOG_END	0x00000003UL
#define ACCESS_EVENT_MENU_START 		0x00000004UL
#define ACCESS_EVENT_MENU_END			0x00000005UL
#define ACCESS_EVENT_POPUPMENU_START	0x00000006UL
#define ACCESS_EVENT_POPUPMENU_END		0x00000007UL
#define ACCESS_EVENT_CAPTURE_START		0x00000008UL
#define ACCESS_EVENT_CAPTURE_END		0x00000009UL
#define ACCESS_EVENT_GETFOCUS			0x0000000aUL
#define ACCESS_EVENT_LOSEFOCUS			0x0000000bUL
#define ACCESS_EVENT_MENUBAR			0x00010000UL
#define ACCESS_EVENT_TOOLBOX			0x00020000UL
#define ACCESS_EVENT_DLGCONTROLS		0x00030000UL
#define ACCESS_EVENT_KEY				0x00040000UL

// --------------
// - Navigation -
// --------------

enum AccNavigate
{
	ACC_NAVIGATE_SELF = 0,
	ACC_NAVIGATE_PREV = 1,
	ACC_NAVIGATE_NEXT = 2,
	ACC_NAVIGATE_PARENT = 3,
	ACC_NAVIGATE_CHILD = 4,
	ACC_NAVIGATE_TOOLBOX = 5,
	ACC_NAVIGATE_MENUBAR = 6
};

// ----------------
// - AccessObject -
// ----------------

SV_DECL_REF( AccessObject );

class AccessObject : public SvRefBase
{
private:
#if 0 // _SOLAR__PRIVATE
#ifdef _SV_ACCESS_CXX
	AccessObjectRef ImplNavigateWnd( Window* pWin, AccNavigate eNavigate );
	AccessObjectRef ImplNavigateTabControl( TabControl* pWin, AccNavigate eNavigate );
	AccessObjectRef ImplNavigateMenu( Menu* pMenu, AccNavigate eNavigate );
	AccessObjectRef ImplNavigateMenuItem( Menu* pMenu, AccNavigate eNavigate );
#endif
#endif

protected:
	void*			mpType;
	ULONG			mnInternalType;
	long			mnData1;
	long			mnData2;
	long			mnData3;

public:

					AccessObject( void* pData = NULL, ULONG nType = ACCESS_TYPE_NONE,
								  long nData1 = 0L, long nData2 = 0L, long nData3 = 0L );
	virtual 		~AccessObject();

					TYPEINFO();

	AccessObjectRef Navigate( AccNavigate eNavigate );

	void			Execute( long nExternalData = 0L );

	XubString		GetDescription();
	XubString		GetText();
	XubString		GetQuickHelpText();
	XubString		GetHelpText();

	XubString		GetType();
	XubString		GetState();
	XubString		GetValue();
};

SV_IMPL_REF( AccessObject )

// ----------------------
// - AccessNotification -
// ----------------------

class Window;
class Menu;
class ToolBox;

class AccessNotification
{
private:
	AccessObjectRef maDummyAcc;
	ULONG			mnEvent;
	const Window*	mpWindow;
	const Menu* 	mpMenu;
	const ToolBox*	mpToolBox;
	long			mnData1;
	long			mnData2;
	long			mnData3;

					AccessNotification();

public:
					AccessNotification( ULONG nEvent, const Window* pWindow );
					AccessNotification( ULONG nEvent, const Menu* pMenu );
					AccessNotification( ULONG nEvent, const ToolBox* pToolBox );
					AccessNotification( ULONG nEvent, long nData1 = 0L, long nData2 = 0L, long nData3 = 0L );

					~AccessNotification();

	ULONG			GetEvent() const { return mnEvent; }

	const Window*	GetWindow() const { return mpWindow; }
	const Menu* 	GetMenu() const { return mpMenu; }
	const ToolBox*	GetToolBox() const { return mpToolBox; }

	long			GetData1() const { return mnData1; }
	long			GetData2() const { return mnData2; }
	long			GetData3() const { return mnData3; }

	AccessObjectRef GetAccessObject();
};

#endif

