/*************************************************************************
 *
 *  $RCSfile: transfrm.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dr $ $Date: 2001/06/14 16:07:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_TRANSFRM_HXX
#define _SVX_TRANSFRM_HXX

// include ---------------------------------------------------------------

#include <svx/dlgctrl.hxx>

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
class SdrView;

/*************************************************************************
|*
|* Transform-Tab-Dialog
|*
\************************************************************************/
class SvxTransformTabDialog : public SfxTabDialog
{
private:
	const SdrView*		pView;

	USHORT				nAnchorCtrls;

	virtual void		PageCreated( USHORT nId, SfxTabPage &rPage );

public:

			SvxTransformTabDialog( Window* pParent, const SfxItemSet* pAttr,
							const SdrView* pView,
							USHORT nAnchorTypes = 0);
			~SvxTransformTabDialog();
};

/*************************************************************************
|*
|* Position-Tab-Page
|*
\************************************************************************/
class SvxPositionTabPage : public SvxTabPage
{
private:
	FixedLine			aFlPosition;
	FixedText			aFtPosX;
	MetricField			aMtrPosX;
	FixedText			aFtPosY;
	MetricField			aMtrPosY;
	TriStateBox			aTsbProtect;
	FixedText			aFtReference;
	SvxRectCtl			aCtl;

	FixedLine			aAnchorBox;
	FixedText			aFtAnchor;
	ListBox				aDdLbAnchor;
	FixedText 			aFtOrient;
	ListBox				aDdLbOrient;
	const SfxItemSet&	rOutAttrs;

	const SdrView*		pView;
	Rectangle			aRect;
	Rectangle			aWorkArea;

	Point				aAnchorPos;
	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	BOOL				bPageDisabled;
	//------------------------------------
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( ChangePosXHdl, void * );
	DECL_LINK( ChangePosYHdl, void * );
	DECL_LINK( ClickProtectHdl, void * );
	DECL_LINK( SetAnchorHdl, ListBox * );
	DECL_LINK( SetOrientHdl, ListBox * );

	void SetMinMaxPosition();
	void GetTopLeftPosition( INT32& rX, INT32& rY, const Rectangle& rRect );
#endif
public:
		 SvxPositionTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }

	void		 ShowAnchorCtrls(USHORT nAnchorCtrls); // Writer-spezifische Controls anzeigen
};

/*************************************************************************
|*
|* Groesse-Tab-Page
|*
\************************************************************************/
class SvxSizeTabPage : public SvxTabPage
{
private:
	FixedLine			aFlSize;
	FixedText			aFtWidth;
	MetricField			aMtrWidth;
	FixedText			aFtHeight;
	MetricField			aMtrHeight;

	CheckBox   			aCbxScale;
	TriStateBox			aTsbProtect;
	FixedText			aFtReference;
	SvxRectCtl			aCtl;

	FixedLine			aFlAdjust;
	TriStateBox         aTsbAutoGrowWidth;
	TriStateBox         aTsbAutoGrowHeight;

	const SfxItemSet&	rOutAttrs;

	const SdrView*		pView;
	Rectangle			aRect;
	UINT32				lOldWidth;
	UINT32				lOldHeight;
	RECT_POINT			eRP;

	Rectangle			aWorkArea;
	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	//------------------------------------
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( ChangeWidthHdl, void * );
	DECL_LINK( ChangeHeightHdl, void * );
	DECL_LINK( ClickProtectHdl, void * );
	DECL_LINK( ClickAutoHdl, void * );

	void		SetMaxSize( Rectangle aRect );
	Rectangle	GetRect();
#endif
public:
		 SvxSizeTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }

	virtual void FillUserData();
};

/*************************************************************************
|*
|* Drehwinkel-Tab-Page
|*
\************************************************************************/
class SvxAngleTabPage : public SvxTabPage
{
private:
	FixedLine			aFlPosition;
	FixedText			aFtPosX;
	MetricField			aMtrPosX;
	FixedText			aFtPosY;
	MetricField			aMtrPosY;
	FixedText			aFtPosPresets;
	SvxRectCtl			aCtlRect;

	FixedLine			aFlAngle;
	FixedText			aFtAngle;
	MetricField			aMtrAngle;
	FixedText			aFtAnglePresets;
	SvxRectCtl			aCtlAngle;

	const SfxItemSet&	rOutAttrs;

	const SdrView*		pView;
	Rectangle			aRect;

	Point				aAnchorPos;
	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	//------------------------------------
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( ModifiedHdl, void * );
#endif
public:
		 SvxAngleTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }
};

/*************************************************************************
|*
|* Schraegstellen/Eckenradius-Tab-Page
|*
\************************************************************************/
class SvxSlantTabPage : public SvxTabPage
{
private:
	FixedLine			aFlRadius;
	FixedText			aFtRadius;
	MetricField			aMtrRadius;
	//TriStateBox			aTsbVertical;
	FixedLine			aFlAngle;
	FixedText			aFtAngle;
	MetricField			aMtrAngle;
	//SvxRectCtl			aCtlAngle;

	const SfxItemSet&	rOutAttrs;

	const SdrView*		pView;
	Rectangle			aRect;

	SfxMapUnit			ePoolUnit;
	FieldUnit			eDlgUnit;
	MapUnit				eMapUnit;
	//------------------------------------
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( ModifiedHdl, void * );
#endif
public:
		 SvxSlantTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	static SfxTabPage* Create( Window*, const SfxItemSet& );
	static USHORT*	   GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void 		 Construct();
	void		 SetView( const SdrView* pSdrView ) { pView = pSdrView; }
};

#endif // _SVX_TRANSFRM_HXX

