/*************************************************************************
 *
 *  $RCSfile: tbxctrl.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2001/07/26 11:49:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXTBXCTRL_HXX
#define _SFXTBXCTRL_HXX

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _FLOATWIN_HXX //autogen
#include <vcl/floatwin.hxx>
#endif
#include <sfx2/ctrlitem.hxx>

//------------------------------------------------------------------

class SfxUnoToolBoxControl;
class SfxToolBoxControl;
class SfxBindings;
class SfxModule;
class SfxUnoControllerItem;

typedef SfxToolBoxControl* (*SfxToolBoxControlCtor)( USHORT nId, ToolBox &rTbx, SfxBindings & );

struct SfxTbxCtrlFactory
{
	SfxToolBoxControlCtor	pCtor;
	TypeId					nTypeId;
	USHORT					nSlotId;

	SfxTbxCtrlFactory( SfxToolBoxControlCtor pTheCtor,
			TypeId nTheTypeId, USHORT nTheSlotId ):
		pCtor(pTheCtor),
		nTypeId(nTheTypeId),
		nSlotId(nTheSlotId)
	{}
};

//------------------------------------------------------------------

enum SfxPopupWindowType
{
	SFX_POPUPWINDOW_NONE,
	SFX_POPUPWINDOW_ONCLICK,
	SFX_POPUPWINDOW_ONTIMEOUT,
	SFX_POPUPWINDOW_ONCLICKANDMOVE,
	SFX_POPUPWINDOW_ONTIMEOUTANDMOVE,
	SFX_POPUPWINDOW_CONTEXTMENU
};

//------------------------------------------------------------------

/*	FloatingWindows, die aus ToolBoxen abgerissen werden k"onnen, sollten
	dieser Klasse abgeleitet werden. Da sie ebenfalls von SfxControllerItem
	abgeleitet ist, erhalten ihre Instanzen auch die StateChanged Aufrufe.
*/

class SfxPopupWindow: public FloatingWindow, public SfxControllerItem
{
friend class SfxToolBox_Impl;
	BOOL					bFloating;
	ULONG					nEventId;
	BOOL					bCascading;
	Link					aDeleteLink;

	private:
#if 0 // _SOLAR__PRIVATE
	DECL_LINK( Delete, void * );
#endif

protected:
	virtual void			PopupModeEnd();
	virtual BOOL			Close();
	virtual void			DeleteFloatingWindow();
	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState );

public:
							SfxPopupWindow( USHORT nId, WinBits nBits, SfxBindings & );
							SfxPopupWindow( USHORT nId, const ResId &rId, SfxBindings & );
	virtual SfxPopupWindow* Clone() const;
	virtual void			MouseMove( const MouseEvent& rMEvt );

#if 0 // _SOLAR__PRIVATE
	void					StartCascading_Impl();
	void					EndCascading_Impl();
	void					SetDeleteLink_Impl( const Link& rLink )
							{
								aDeleteLink = rLink;
							}
#endif
};

//------------------------------------------------------------------

#define SFX_DECL_TOOLBOX_CONTROL() \
		static SfxToolBoxControl* CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ); \
		static void RegisterControl(USHORT nSlotId = 0, SfxModule *pMod=NULL)

#define SFX_IMPL_TOOLBOX_CONTROL(Class, nItemClass) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

#define SFX_IMPL_TOOLBOX_CONTROL_ARG(Class, nItemClass, Arg) \
		SfxToolBoxControl* __EXPORT Class::CreateImpl( USHORT nId, ToolBox &rTbx, SfxBindings &rBindings ) \
			   { return new Class(nId, rTbx, rBindings, Arg); } \
		void Class::RegisterControl(USHORT nSlotId, SfxModule *pMod) \
			   { SFX_APP()->RegisterToolBoxControl( pMod, new SfxTbxCtrlFactory( \
					Class::CreateImpl, TYPE(nItemClass), nSlotId ) ); }

//------------------------------------------------------------------

/*	F"ur spezielle ToolBox-Controls, z.B. eine Font-Auswahl-Box oder
	aus ToolBoxen abrei"sbare FloatingWindows mu"s passend zur Item-Subclass
	eine Subclass von SfxTooBoxControl implementiert werden.

	Diese Klasse mu"s in SfxApplication::Init() mit der statischen Methode
	RegisterControl() registriert werden. Der SFx erzeugt dann automatisch
	diese Controls in ToolBoxen, wenn die dazugeh"origen Slots von dem
	angegebenen Typ sind.
 */

class SfxToolBoxControl: public SfxControllerItem
{
friend class SfxToolBoxManager;
friend class SfxToolbox;
friend class SfxToolBox_Impl;
friend class SfxToolboxCustomizer;
friend class SfxPopupWindow;
friend struct SfxTbxCtrlFactory;

	ToolBox*				pBox;
	BOOL					bShowString;
	USHORT                  nSelectModifier;
	SfxTbxCtrlFactory*		pFact;

protected:
	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState );
	virtual void			Select( BOOL bMod1 = FALSE );
	virtual void			Select( USHORT nModifier );

	virtual void			DoubleClick();
	virtual void			Click();
	virtual SfxPopupWindowType
							GetPopupWindowType() const;
	virtual SfxPopupWindow* CreatePopupWindow();
	virtual	SfxPopupWindow* CreatePopupWindowCascading();
	virtual Window*         CreateItemWindow( Window *pParent );

public:
							SFX_DECL_TOOLBOX_CONTROL();

							SfxToolBoxControl( USHORT nId, ToolBox& rBox,
											   SfxBindings &,
											   BOOL bShowStrings = FALSE );
	virtual 				~SfxToolBoxControl();

	ToolBox&				GetToolBox() const
							{ return *pBox; }

	static SfxToolBoxControl* CreateControl( USHORT nId, ToolBox *pBox,
											 SfxBindings&, SfxModule *pMod );

	static SfxUnoToolBoxControl* CreateControl( const String&, USHORT nId,
											 ToolBox *pBox,
											 SfxBindings& );
#if 0 // _SOLAR__PRIVATE
	SfxToolBoxControl*		ReInit_Impl();
#endif
};

class SfxUnoToolBoxControl : public SfxToolBoxControl
{
	SfxUnoControllerItem*	pUnoCtrl;
public:
							SfxUnoToolBoxControl( const String&, USHORT nId,
											 ToolBox *pBox,
											 SfxBindings& );
							~SfxUnoToolBoxControl();
	virtual void			Select( BOOL bMod1 = FALSE );
};

//=========================================================================

#if 0 // _SOLAR__PRIVATE

class SfxDragButton_Impl : public FixedImage
{
    SfxBindings*    pBindings;
public:

                    SfxDragButton_Impl( Window *pParent, SfxBindings& rBind );
	virtual void 	Command ( const CommandEvent& rCEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
};

class SfxDragToolBoxControl_Impl : public SfxToolBoxControl
/*  [Beschreibung]

*/

{
public:
							SFX_DECL_TOOLBOX_CONTROL();
							SfxDragToolBoxControl_Impl(
								USHORT nId, ToolBox& rBox, SfxBindings& );
	virtual Window*         CreateItemWindow( Window *pParent );
	virtual void			Select( BOOL bMod1 = FALSE );
};

//------------------------------------------------------------------------

class SfxAppToolBoxControl_Impl : public SfxToolBoxControl

/*  [Beschreibung]

	Interne Hilfsklasse f"ur um das Popup-Menu <AppMenu_Impl> unter Neu
	im SDT zu starten.
*/

{
    String                  aLastURL;
	Timer					aTimer;
	BOOL					bBigImages;

private:
							DECL_LINK( Timeout, Timer * );

protected:
	virtual void			Click( );
	virtual void			Select( BOOL );
	virtual void			StateChanged( USHORT nSID, SfxItemState eState,
										  const SfxPoolItem* pState );
public:
							SFX_DECL_TOOLBOX_CONTROL();
							SfxAppToolBoxControl_Impl(
								USHORT nId, ToolBox& rBox,  SfxBindings& );
	void					SetImage( const String& rFacName );
};

class SfxHistoryToolBoxControl_Impl : public SfxToolBoxControl
{
	Timer					aTimer;

private:
							DECL_LINK( Timeout, Timer * );

protected:
	virtual void			Click( );
	virtual void			Select( BOOL );

public:
							SFX_DECL_TOOLBOX_CONTROL();
							SfxHistoryToolBoxControl_Impl(
								USHORT nId, ToolBox& rBox,  SfxBindings& );
};

class SfxReloadToolBoxControl_Impl : public SfxToolBoxControl
{
protected:
	virtual void			Select( USHORT nSelectModifier );

public:
							SFX_DECL_TOOLBOX_CONTROL();
							SfxReloadToolBoxControl_Impl(
								USHORT nId, ToolBox& rBox,  SfxBindings& );
};

#endif

#endif

