/*************************************************************************
 *
 *  $RCSfile: mailbrw.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:20:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MAILBRW_HXX
#define _MAILBRW_HXX

// include ---------------------------------------------------------------

#include <goodies/mailsrv.hxx>

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SVX_BRWBOX_HXX //autogen
#include <svtools/brwbox.hxx>
#endif

// forward ---------------------------------------------------------------

class MailReadOnlyDialog;

// class MailBrowser -----------------------------------------------------

class MailBrowser : public BrowseBox
{
friend class MailBrowseDialog;

private:
	Link                aSelectHdlLink;
	Link                aDoubleClickHdlLink;

	AutoTimer			aTimer;
	MailServer*         pServer;    // aktueller Server
	Mail*               pMail;      // zuletzt hierher geseekt

#if 0 // _SOLAR__PRIVATE
	void				Init();

	DECL_LINK( TimeoutHdl, AutoTimer * );
#endif

protected:
						// software plug for database access
	virtual long        GetRowCount() const;
	virtual BOOL        SeekRow( long nRow );
	virtual void        PaintField( OutputDevice& rDev, const Rectangle& rRect,
							USHORT nColumnId ) const;

						// software plug for selections
	virtual void        Select();
	virtual void        DoubleClick();

public:
	MailBrowser( Window *pParent, const ResId& rResId );
	MailBrowser( Window *pParent, WinBits nBits = 0 );
	~MailBrowser();

	BOOL                Connect( MailServer& rServer );

	void                SetSelectHdl( const Link& rNewLink )
								{ aSelectHdlLink = rNewLink; }
	const Link&         GetSelectHdl() const { return aSelectHdlLink; }
	void                SetDoubleClickHdl( const Link& rNewLink )
								{ aDoubleClickHdlLink = rNewLink; }
	const Link&         GetDoubleClickHdl() const { return aDoubleClickHdlLink; }

	void				SetConfig( const String& rCfgStr );
	String				GetConfig() const;

	MailServer*         GetServer() const { return pServer; }
	IncomingMail*		GetCurMail( BOOL bAttach = TRUE ) const;
};

#ifdef _SALE_SOLAR
// diese Klasse brauchen wir f"ur eine Solar-Auslieferung,
// sonst ist sie als SfxMailInBox_Impl im sfx
// class MailBrowseDialog ------------------------------------------------

class MailBrowseDialog : public FloatingWindow
{
private:
	PushButton		 	aOpenButton;
	PushButton		 	aDeleteButton;
	PushButton		 	aCloseButton;

	MailBrowser			aMailBrowser;

	BOOL				bInbox;

#if 0 // _SOLAR__PRIVATE
	DECL_LINK( OpenHdl, Button * );
	DECL_LINK( DeleteHdl, Button * );
	DECL_LINK( CloseHdl, Button * );
	DECL_LINK( OpenAttachFileHdl, MailReadOnlyDialog * );
	DECL_LINK( SelectHdl, MailBrowser * );
	DECL_LINK( DoubleClickHdl, MailBrowser * );
#endif

protected:
	virtual	void		Open( Window* pParent, const String& rFile );
	virtual BOOL		Close();

public:
	MailBrowseDialog( Window* pParent, MailServer& rServ, BOOL bFlag = TRUE );

	void				SetConfig( const String& rCfgStr );
	String				GetConfig() const;

	virtual void		Resize();
	virtual void		Resizing( Size& rSize );
};

#endif // _SALE_SOLAR

#endif

