/*************************************************************************
 *
 *  $RCSfile: sstring.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SSTRING_HXX
#define _SSTRING_HXX

#include <tools/string.hxx>
#include <tools/list.hxx>

#define NOT_THERE		LIST_ENTRY_NOTFOUND

#define  SStringList SUniStringList 
#define  StringList UniStringList 

DECLARE_LIST( ByteStringList, ByteString* );
DECLARE_LIST( UniStringList, UniString* );

// ---------------------
// - class SStringList -
// ---------------------

class SByteStringList : public ByteStringList
{
public:
				SByteStringList();
				~SByteStringList();

				// neuen ByteString in Liste einfuegen
	ULONG		PutString( ByteString* );
	ByteString* 	RemoveString( const ByteString& rName );

				// Position des ByteString in Liste, wenn nicht enthalten, dann
				// return = NOT_THERE
	ULONG		IsString( ByteString* );

				// Vorgaenger ermitteln ( auch wenn selbst noch nicht in
				// Liste enthalten
	ULONG		GetPrevString( ByteString* );
};

// ---------------------
// - class SUniStringList -
// ---------------------

class SUniStringList : public UniStringList
{
public:
				SUniStringList();
				~SUniStringList();

				// neuen UniString in Liste einfuegen
	ULONG		PutString( UniString* );
	UniString* 	RemoveString( const UniString& rName );

				// Position des UniString in Liste, wenn nicht enthalten, dann
				// return = NOT_THERE
	ULONG		IsString( UniString* );

				// Vorgaenger ermitteln ( auch wenn selbst noch nicht in
				// Liste enthalten
	ULONG		GetPrevString( UniString* );
};

class Text
{
protected:
	String		aString;

public:
				Text( char* pChar );
				Text( String &rStr ) { aString = rStr; }
	void		Stderr();
};

#endif
